/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.nio.file.Path;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0004J \u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0014j\b\u0012\u0004\u0012\u00020\u0003`\u0015H\u0004\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/AbstractFileCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "path", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "f", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "isCommandParametersRight", "", "input", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "intellij.performanceTesting"})
public abstract class AbstractFileCommand
extends AbstractCallbackBasedCommand {
    public AbstractFileCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    protected final void execute(@NotNull Path path, @NotNull ActionCallback callback, @NotNull Function1<? super VirtualFile, ? extends Object> f) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(path);
        if (virtualFile == null) {
            callback.reject("Directory or file by " + path + " path from parameters was not found.");
            return;
        }
        WriteAction.runAndWait(() -> AbstractFileCommand.execute$lambda$0(f, virtualFile));
        callback.setDone();
    }

    protected final boolean isCommandParametersRight(@NotNull ArrayList<String> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return input.size() >= 2 && input.size() <= 2 && !Intrinsics.areEqual((Object)input.get(0), (Object)"") && !Intrinsics.areEqual((Object)input.get(1), (Object)"");
    }

    private static final void execute$lambda$0(Function1 $f, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$f, (String)"$f");
        $f.invoke((Object)$virtualFile);
    }
}

