/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general.navigation;

import com.intellij.find.FindBundle;
import com.intellij.find.SearchTextArea;
import com.intellij.find.impl.FindPopupItem;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.fixture.JTableFixture;
import org.assertj.swing.fixture.JTextComponentFixture;
import org.assertj.swing.timing.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LessonContext;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;
import training.learn.lesson.general.navigation.FindInFilesLesson;
import training.ui.IftTestContainerFixture;
import training.ui.LearningUiUtil;
import training.util.UtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\r*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\u001d2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0014\u0010$\u001a\u00020\r*\u00020\u001f2\u0006\u0010%\u001a\u00020\"H\u0002R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Ltraining/learn/lesson/general/navigation/FindInFilesLesson;", "Ltraining/learn/course/KLesson;", "sampleFilePath", "", "helpUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "getSampleFilePath", "()Ljava/lang/String;", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "findLastRowIndexOfItemWithText", "", "Ljavax/swing/JTable;", "textToFind", "getFindPopup", "Lcom/intellij/find/impl/FindPopupPanel;", "Ltraining/dsl/TaskRuntimeContext;", "highlightAndTriggerWhenButtonSelected", "Ltraining/dsl/TaskContext;", "buttonText", "isSelectedNeededItem", "", "neededText", "showWarningIfPopupClosed", "isReplacePopup", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nFindInFilesLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindInFilesLesson.kt\ntraining/learn/lesson/general/navigation/FindInFilesLesson\n+ 2 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n*L\n1#1,246:1\n19#2,2:247\n19#2,2:249\n*S KotlinDebug\n*F\n+ 1 FindInFilesLesson.kt\ntraining/learn/lesson/general/navigation/FindInFilesLesson\n*L\n204#1:247,2\n207#1:249,2\n*E\n"})
public final class FindInFilesLesson
extends KLesson {
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final String helpUrl;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties;

    public FindInFilesLesson(@NotNull String sampleFilePath, @NotNull String helpUrl) {
        Intrinsics.checkNotNullParameter((Object)sampleFilePath, (String)"sampleFilePath");
        Intrinsics.checkNotNullParameter((Object)helpUrl, (String)"helpUrl");
        super("Find in files", LessonsBundle.INSTANCE.message("find.in.files.lesson.name", new Object[0]));
        this.sampleFilePath = sampleFilePath;
        this.helpUrl = helpUrl;
        this.lessonContent = (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ FindInFilesLesson this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LessonContext $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                LessonUtilKt.sdkConfigurationTasks($this$null);
                LessonContext.prepareRuntimeTask$default($this$null, null, lessonContent.1.INSTANCE, 1, null);
                Ref.ObjectRef showPopupTaskId = new Ref.ObjectRef();
                $this$null.task("FindInPath", (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>((Ref.ObjectRef<TaskContext.TaskId>)showPopupTaskId){
                    final /* synthetic */ Ref.ObjectRef<TaskContext.TaskId> $showPopupTaskId;
                    {
                        this.$showPopupTaskId = $showPopupTaskId;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$showPopupTaskId.element = $this$task.getTaskId();
                        Object[] objectArray = new Object[]{$this$task.action(it), LessonUtil.INSTANCE.actionName(it)};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.show.find.popup", objectArray), null, 2, null);
                        HighlightingTriggerMethods this_$iv = TaskContext.triggerUI$default($this$task, null, 1, null);
                        boolean $i$f$component = false;
                        this_$iv.explicitComponentDetection(FindPopupPanel.class, null, (Function2)new Function2<TaskRuntimeContext, FindPopupPanel, Boolean>(){

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                                void popup;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                FindPopupPanel findPopupPanel = (FindPopupPanel)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u240 = $this$explicitComponentDetection;
                                boolean bl = false;
                                return !popup.getHelper().isReplaceState();
                            }
                        });
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                String[] stringArray = new String[]{this.$it};
                                $this$test.actions(stringArray);
                            }
                        }, 1, null);
                    }
                }));
                $this$null.task("apple", (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>(this.this$0){
                    final /* synthetic */ FindInFilesLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object[] objectArray = new Object[]{$this$task.code(it)};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.type.to.find", objectArray), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0, it){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                String string;
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                Object object = FindInFilesLesson.access$getFindPopup(this.this$0, $this$stateCheck);
                                if (object != null && (object = object.getStringToFind()) != null) {
                                    String string2 = ((String)object).toLowerCase();
                                    string = string2;
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                                } else {
                                    string = null;
                                }
                                return Intrinsics.areEqual((Object)string, (Object)this.$it);
                            }
                        }));
                        TaskContext.restoreByUi$default($this$task, null, 0, null, 7, null);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.type(this.$it);
                            }
                        }, 1, null);
                    }
                }));
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this.this$0){
                    final /* synthetic */ FindInFilesLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        String string = FindBundle.message((String)"find.whole.words", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"find.whole.words\")");
                        String wholeWordsButtonText = LessonUtilKt.dropMnemonic(string);
                        Object[] objectArray = new Object[4];
                        objectArray[0] = $this$task.code("apple");
                        objectArray[1] = $this$task.code("pineapple");
                        Icon icon = AllIcons.Actions.Words;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Words");
                        objectArray[2] = $this$task.icon(icon);
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(87, 512);
                        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(KeyEvent.VK\u2026InputEvent.ALT_DOWN_MASK)");
                        objectArray[3] = LessonUtil.INSTANCE.rawKeyStroke(keyStroke);
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.whole.words", objectArray), null, 2, null);
                        FindInFilesLesson.access$highlightAndTriggerWhenButtonSelected(this.this$0, $this$task, wholeWordsButtonText);
                        FindInFilesLesson.access$showWarningIfPopupClosed(this.this$0, $this$task, false);
                        $this$task.test(false, (Function1<? super TaskTestContext, Unit>)((Function1)new Function1<TaskTestContext, Unit>(wholeWordsButtonText){
                            final /* synthetic */ String $wholeWordsButtonText;
                            {
                                this.$wholeWordsButtonText = $wholeWordsButtonText;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test, this.$wholeWordsButtonText){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ String $wholeWordsButtonText;
                                    {
                                        this.$this_test = $this_test;
                                        this.$wholeWordsButtonText = $wholeWordsButtonText;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$this$ideFrame");
                                        TaskTestContext.actionButton$default(this.$this_test, $this$ideFrame, this.$wholeWordsButtonText, null, 2, null).click();
                                    }
                                }));
                            }
                        }));
                    }
                }));
                String neededText = "apple...";
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this.this$0, neededText){
                    final /* synthetic */ FindInFilesLesson this$0;
                    final /* synthetic */ String $neededText;
                    {
                        this.this$0 = $receiver;
                        this.$neededText = $neededText;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull TaskContext $this$task) {
                        void this_$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        HighlightingTriggerMethods highlightingTriggerMethods = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
                        FindInFilesLesson findInFilesLesson = this.this$0;
                        String string = this.$neededText;
                        boolean $i$f$componentPart = false;
                        this_$iv.explicitComponentPartDetection(JTable.class, (Function2)new Function2<TaskRuntimeContext, JTable, Rectangle>(findInFilesLesson, string){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $neededText$inlined;
                            {
                                this.this$0 = findInFilesLesson;
                                this.$neededText$inlined = string;
                                super(2);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Rectangle invoke(@NotNull TaskRuntimeContext $this$explicitComponentPartDetection, @NotNull Component it) {
                                void table;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentPartDetection, (String)"$this$explicitComponentPartDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                JTable jTable = (JTable)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u240 = $this$explicitComponentPartDetection;
                                boolean bl = false;
                                int rowIndex2 = FindInFilesLesson.access$findLastRowIndexOfItemWithText(this.this$0, (JTable)table, this.$neededText$inlined);
                                return rowIndex2 >= 0 ? table.getCellRect(rowIndex2, 0, false) : null;
                            }
                        });
                        TaskContext.restoreByTimer$default($this$task, 1000, null, 2, null);
                        $this$task.setTransparentRestore(true);
                    }
                }));
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>((Ref.ObjectRef<TaskContext.TaskId>)showPopupTaskId, this.this$0, neededText){
                    final /* synthetic */ Ref.ObjectRef<TaskContext.TaskId> $showPopupTaskId;
                    final /* synthetic */ FindInFilesLesson this$0;
                    final /* synthetic */ String $neededText;
                    {
                        this.$showPopupTaskId = $showPopupTaskId;
                        this.this$0 = $receiver;
                        this.$neededText = $neededText;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        TaskContext.TaskId taskId;
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Object[] objectArray = new Object[]{$this$task.action("EditorUp"), $this$task.action("EditorDown")};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.select.row", objectArray), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0, this.$neededText){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $neededText;
                            {
                                this.this$0 = $receiver;
                                this.$neededText = $neededText;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                return FindInFilesLesson.access$isSelectedNeededItem(this.this$0, $this$stateCheck, this.$neededText);
                            }
                        }));
                        if (this.$showPopupTaskId.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"showPopupTaskId");
                            taskId = null;
                        } else {
                            taskId = (TaskContext.TaskId)this.$showPopupTaskId.element;
                        }
                        TaskContext.restoreByUi$default($this$task, taskId, 0, null, 6, null);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(this.this$0, this.$neededText){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $neededText;
                            {
                                this.this$0 = $receiver;
                                this.$neededText = $neededText;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test, this.this$0, this.$neededText){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ FindInFilesLesson this$0;
                                    final /* synthetic */ String $neededText;
                                    {
                                        this.$this_test = $this_test;
                                        this.this$0 = $receiver;
                                        this.$neededText = $neededText;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$this$ideFrame");
                                        Component component2 = this.$this_test.getPrevious().getUi();
                                        JTable jTable = component2 instanceof JTable ? (JTable)component2 : null;
                                        if (jTable == null) {
                                            throw new IllegalStateException("No table".toString());
                                        }
                                        JTable table = jTable;
                                        JTableFixture tableFixture = new JTableFixture($this$ideFrame.robot(), table);
                                        Function0 rowIndex2 = (Function0)new Function0<Integer>(this.this$0, table, this.$neededText){
                                            final /* synthetic */ FindInFilesLesson this$0;
                                            final /* synthetic */ JTable $table;
                                            final /* synthetic */ String $neededText;
                                            {
                                                this.this$0 = $receiver;
                                                this.$table = $table;
                                                this.$neededText = $neededText;
                                                super(0);
                                            }

                                            @NotNull
                                            public final Integer invoke() {
                                                return FindInFilesLesson.access$findLastRowIndexOfItemWithText(this.this$0, this.$table, this.$neededText);
                                            }
                                        };
                                        tableFixture.pointAt(TableCell.row(((Number)rowIndex2.invoke()).intValue()).column(0));
                                        tableFixture.click(TableCell.row(((Number)rowIndex2.invoke()).intValue()).column(0), MouseClickInfo.leftButton());
                                    }
                                }));
                            }
                        }, 1, null);
                    }
                }));
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this.this$0, neededText){
                    final /* synthetic */ FindInFilesLesson this$0;
                    final /* synthetic */ String $neededText;
                    {
                        this.this$0 = $receiver;
                        this.$neededText = $neededText;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawEnter()};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.go.to.file", objectArray), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                            final /* synthetic */ FindInFilesLesson this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                return !Intrinsics.areEqual((Object)$this$stateCheck.getVirtualFile().getName(), (Object)StringsKt.substringAfterLast$default((String)this.this$0.getSampleFilePath(), (char)'/', null, (int)2, null));
                            }
                        }));
                        TaskContext.restoreState$default($this$task, null, LessonUtilKt.getDefaultRestoreDelay(), null, (Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0, this.$neededText){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $neededText;
                            {
                                this.this$0 = $receiver;
                                this.$neededText = $neededText;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$restoreState) {
                                Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
                                return !FindInFilesLesson.access$isSelectedNeededItem(this.this$0, $this$restoreState, this.$neededText);
                            }
                        }, 5, null);
                        TaskContext.test$default($this$task, false, lessonContent.3.INSTANCE, 1, null);
                    }
                }));
                $this$null.task("ReplaceInPath", (Function2<? super TaskContext, ? super String, Unit>)((Function2)lessonContent.8.INSTANCE));
                $this$null.task("orange", (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>(this.this$0){
                    final /* synthetic */ FindInFilesLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object[] objectArray = new Object[]{$this$task.code("apple"), $this$task.code(it)};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.type.to.replace", objectArray), null, 2, null);
                        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
                        boolean $i$f$component = false;
                        this_$iv.explicitComponentDetection(SearchTextArea.class, null, (Function2)new Function2<TaskRuntimeContext, SearchTextArea, Boolean>(it){
                            final /* synthetic */ String $it$inlined;
                            {
                                this.$it$inlined = string;
                                super(2);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                                void ui;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                SearchTextArea searchTextArea = (SearchTextArea)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u240 = $this$explicitComponentDetection;
                                boolean bl = false;
                                String string = ui.getTextArea().getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ui.textArea.text");
                                return StringsKt.startsWith$default((String)this.$it$inlined, (String)string, (boolean)false, (int)2, null) && UIUtil.getParentOfType(FindPopupPanel.class, (Component)((Component)ui)) != null;
                            }
                        });
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0, it){
                            final /* synthetic */ FindInFilesLesson this$0;
                            final /* synthetic */ String $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                FindPopupPanel findPopupPanel = FindInFilesLesson.access$getFindPopup(this.this$0, $this$stateCheck);
                                if (findPopupPanel != null && (findPopupPanel = findPopupPanel.getHelper()) != null && (findPopupPanel = findPopupPanel.getModel()) != null) {
                                    FindPopupPanel findPopupPanel2 = findPopupPanel;
                                    String string = this.$it;
                                    FindPopupPanel model = findPopupPanel2;
                                    boolean bl2 = false;
                                    bl = Intrinsics.areEqual((Object)model.getStringToReplace(), (Object)string) && Intrinsics.areEqual((Object)model.getStringToFind(), (Object)"apple");
                                } else {
                                    bl = false;
                                }
                                return bl;
                            }
                        }));
                        TaskContext.restoreByUi$default($this$task, null, 0, null, 7, null);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test, this.$it){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ String $it;
                                    {
                                        this.$this_test = $this_test;
                                        this.$it = $it;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        JTextArea jTextArea;
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$this$ideFrame");
                                        LearningUiUtil $this$iv = LearningUiUtil.INSTANCE;
                                        Timeout timeout = Timeout.timeout(10L, TimeUnit.SECONDS);
                                        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"timeout(10, TimeUnit.SECONDS)");
                                        Timeout timeout$iv = timeout;
                                        boolean $i$f$findComponentWithTimeout = false;
                                        try {
                                            jTextArea = $this$iv.waitUntilFound($this$iv.getRobot(), $this$iv.typeMatcher(JTextArea.class, (Function1)new Function1<JTextArea, Boolean>(){

                                                /*
                                                 * Ignored method signature, as it can't be verified against descriptor
                                                 */
                                                @NotNull
                                                public final Boolean invoke(@NotNull Component it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    JTextArea textArea = (JTextArea)it;
                                                    boolean bl = false;
                                                    return Intrinsics.areEqual((Object)textArea.getText(), (Object)"");
                                                }
                                            }), timeout$iv, (Function0<? extends Collection<? extends Container>>)((Function0)new Function0<Collection<? extends Container>>($this$ideFrame){
                                                final /* synthetic */ IftTestContainerFixture<ContainerComponentType> $this_findComponentWithTimeout;
                                                {
                                                    this.$this_findComponentWithTimeout = $receiver;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final Collection<Container> invoke() {
                                                    ContainerComponentType ContainerComponentType = this.$this_findComponentWithTimeout.target();
                                                    Intrinsics.checkNotNull(ContainerComponentType, (String)"null cannot be cast to non-null type java.awt.Container");
                                                    return CollectionsKt.listOf(ContainerComponentType);
                                                }
                                            }));
                                        }
                                        catch (WaitTimedOutError e$iv) {
                                            throw new ComponentLookupException("Unable to find " + JTextArea.class.getName() + " in container " + (Container)$this$ideFrame.target() + " in " + timeout$iv.duration());
                                        }
                                        JTextArea textArea = jTextArea;
                                        new JTextComponentFixture($this$ideFrame.robot(), textArea).click();
                                        this.$this_test.type(this.$it);
                                    }
                                }));
                            }
                        }, 1, null);
                    }
                }));
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this.this$0){
                    final /* synthetic */ FindInFilesLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        String string = FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"find.popup.scope.directory\")");
                        String directoryScopeText = LessonUtilKt.dropMnemonic(string);
                        Object[] objectArray = new Object[2];
                        objectArray[0] = $this$task.strong(directoryScopeText);
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 512);
                        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(KeyEvent.VK\u2026InputEvent.ALT_DOWN_MASK)");
                        objectArray[1] = LessonUtil.INSTANCE.rawKeyStroke(keyStroke);
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.select.directory", objectArray), null, 2, null);
                        FindInFilesLesson.access$highlightAndTriggerWhenButtonSelected(this.this$0, $this$task, directoryScopeText);
                        FindInFilesLesson.access$showWarningIfPopupClosed(this.this$0, $this$task, true);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(directoryScopeText){
                            final /* synthetic */ String $directoryScopeText;
                            {
                                this.$directoryScopeText = $directoryScopeText;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test, this.$directoryScopeText){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ String $directoryScopeText;
                                    {
                                        this.$this_test = $this_test;
                                        this.$directoryScopeText = $directoryScopeText;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$this$ideFrame");
                                        TaskTestContext.actionButton$default(this.$this_test, $this$ideFrame, this.$directoryScopeText, null, 2, null).click();
                                    }
                                }));
                            }
                        }, 1, null);
                    }
                }));
                String string = FindBundle.message((String)"find.replace.command", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"find.replace.command\")");
                String replaceButtonText = string;
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this.this$0, replaceButtonText){
                    final /* synthetic */ FindInFilesLesson this$0;
                    final /* synthetic */ String $replaceButtonText;
                    {
                        this.this$0 = $receiver;
                        this.$replaceButtonText = $replaceButtonText;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        String string = FindBundle.message((String)"find.popup.replace.all.button", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"find.popup.replace.all.button\")");
                        String replaceAllButtonText = LessonUtilKt.dropMnemonic(string);
                        Object[] objectArray = new Object[]{$this$task.strong(replaceAllButtonText)};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.press.replace.all", objectArray), null, 2, null);
                        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndFullHighlight$default($this$task, null, 1, null);
                        boolean $i$f$component = false;
                        this_$iv.explicitComponentDetection(JButton.class, null, (Function2)new Function2<TaskRuntimeContext, JButton, Boolean>(replaceAllButtonText){
                            final /* synthetic */ String $replaceAllButtonText$inlined;
                            {
                                this.$replaceAllButtonText$inlined = string;
                                super(2);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                                void button2;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                JButton jButton = (JButton)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u240 = $this$explicitComponentDetection;
                                boolean bl = false;
                                return UtilsKt.isToStringContains(button2.getText(), this.$replaceAllButtonText$inlined);
                            }
                        });
                        this_$iv = TaskContext.triggerAndFullHighlight$default($this$task, null, 1, null);
                        String string2 = this.$replaceButtonText;
                        boolean $i$f$component2 = false;
                        this_$iv.explicitComponentDetection(JButton.class, null, (Function2)new Function2<TaskRuntimeContext, JButton, Boolean>(string2){
                            final /* synthetic */ String $replaceButtonText$inlined;
                            {
                                this.$replaceButtonText$inlined = string;
                                super(2);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                                void button2;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                JButton jButton = (JButton)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u241 = $this$explicitComponentDetection;
                                boolean bl = false;
                                JDialog jDialog2 = (JDialog)UIUtil.getParentOfType(JDialog.class, (Component)((Component)button2));
                                return (jDialog2 != null ? jDialog2.isModal() : false) && UtilsKt.isToStringContains(button2.getText(), this.$replaceButtonText$inlined);
                            }
                        });
                        FindInFilesLesson.access$showWarningIfPopupClosed(this.this$0, $this$task, true);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(replaceAllButtonText){
                            final /* synthetic */ String $replaceAllButtonText;
                            {
                                this.$replaceAllButtonText = $replaceAllButtonText;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test, this.$replaceAllButtonText){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ String $replaceAllButtonText;
                                    {
                                        this.$this_test = $this_test;
                                        this.$replaceAllButtonText = $replaceAllButtonText;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$this$ideFrame");
                                        TaskTestContext.button$default(this.$this_test, $this$ideFrame, this.$replaceAllButtonText, null, 2, null).click();
                                    }
                                }));
                            }
                        }, 1, null);
                    }
                }));
                $this$null.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(replaceButtonText){
                    final /* synthetic */ String $replaceButtonText;
                    {
                        this.$replaceButtonText = $replaceButtonText;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        $this$task.addFutureStep((Function1<? super TaskContext.DoneStepContext, Unit>)((Function1)lessonContent.1.INSTANCE));
                        Object[] objectArray = new Object[]{$this$task.strong(this.$replaceButtonText)};
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("find.in.files.confirm.replace", objectArray), null, 2, null);
                        TaskContext.restoreByUi$default($this$task, null, 0, null, 7, null);
                        $this$task.test(false, (Function1<? super TaskTestContext, Unit>)((Function1)new Function1<TaskTestContext, Unit>(this.$replaceButtonText){
                            final /* synthetic */ String $replaceButtonText;
                            {
                                this.$replaceButtonText = $replaceButtonText;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                TaskTestContext.dialog$default($this$test, "Replace All", false, null, null, (Function1)new Function1<IftTestContainerFixture<JDialog>, Unit>($this$test, this.$replaceButtonText){
                                    final /* synthetic */ TaskTestContext $this_test;
                                    final /* synthetic */ String $replaceButtonText;
                                    {
                                        this.$this_test = $this_test;
                                        this.$replaceButtonText = $replaceButtonText;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull IftTestContainerFixture<JDialog> $this$dialog) {
                                        Intrinsics.checkNotNullParameter($this$dialog, (String)"$this$dialog");
                                        TaskTestContext.button$default(this.$this_test, $this$dialog, this.$replaceButtonText, null, 2, null).click();
                                    }
                                }, 14, null);
                            }
                        }));
                    }
                }));
            }
        };
        this.testScriptProperties = new TaskTestContext.TestScriptProperties(10, false, 2, null);
    }

    public /* synthetic */ FindInFilesLesson(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "finding-and-replacing-text-in-project.html";
        }
        this(string, string2);
    }

    @Override
    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @Override
    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final boolean isSelectedNeededItem(TaskRuntimeContext $this$isSelectedNeededItem, String neededText) {
        boolean bl;
        Component component2 = $this$isSelectedNeededItem.getPrevious().getUi();
        JTable jTable = component2 instanceof JTable ? (JTable)component2 : null;
        if (jTable != null) {
            JTable it = jTable;
            boolean bl2 = false;
            bl = it.isShowing() && it.getSelectedRow() != -1 && it.getSelectedRow() == this.findLastRowIndexOfItemWithText(it, neededText);
        } else {
            bl = false;
        }
        return bl;
    }

    private final FindPopupPanel getFindPopup(TaskRuntimeContext $this$getFindPopup) {
        return (FindPopupPanel)UIUtil.getParentOfType(FindPopupPanel.class, (Component)$this$getFindPopup.getFocusOwner());
    }

    private final void highlightAndTriggerWhenButtonSelected(TaskContext $this$highlightAndTriggerWhenButtonSelected, String buttonText) {
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndFullHighlight$default($this$highlightAndTriggerWhenButtonSelected, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(buttonText){
            final /* synthetic */ String $buttonText$inlined;
            {
                this.$buttonText$inlined = string;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                void button2;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$highlightAndTriggerWhenButtonSelected_u24lambda_u241 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)button2.getAction().getTemplateText(), (Object)this.$buttonText$inlined);
            }
        });
        this_$iv = TaskContext.triggerUI$default($this$highlightAndTriggerWhenButtonSelected, null, 1, null);
        $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(buttonText){
            final /* synthetic */ String $buttonText$inlined;
            {
                this.$buttonText$inlined = string;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                void button2;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$highlightAndTriggerWhenButtonSelected_u24lambda_u242 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)button2.getAction().getTemplateText(), (Object)this.$buttonText$inlined) && button2.isSelected();
            }
        });
    }

    private final int findLastRowIndexOfItemWithText(JTable $this$findLastRowIndexOfItemWithText, String textToFind) {
        for (int ind = $this$findLastRowIndexOfItemWithText.getRowCount() - 1; -1 < ind; --ind) {
            Object object = $this$findLastRowIndexOfItemWithText.getValueAt(ind, 0);
            FindPopupItem item = object instanceof FindPopupItem ? (FindPopupItem)object : null;
            Object object2 = item;
            boolean bl = object2 != null && (object2 = object2.getPresentableText()) != null ? StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)textToFind, (boolean)true) : false;
            if (!bl) continue;
            return ind;
        }
        return -1;
    }

    private final void showWarningIfPopupClosed(TaskContext $this$showWarningIfPopupClosed, boolean isReplacePopup) {
        String actionId = isReplacePopup ? "ReplaceInPath" : "FindInPath";
        Object[] objectArray = new Object[]{$this$showWarningIfPopupClosed.action(actionId), LessonUtil.INSTANCE.actionName(actionId)};
        TaskContext.showWarning$default($this$showWarningIfPopupClosed, LessonsBundle.INSTANCE.message("find.in.files.popup.closed.warning.message", objectArray), false, null, (Function1)new Function1<TaskRuntimeContext, Boolean>(this, isReplacePopup){
            final /* synthetic */ FindInFilesLesson this$0;
            final /* synthetic */ boolean $isReplacePopup;
            {
                this.this$0 = $receiver;
                this.$isReplacePopup = $isReplacePopup;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TaskRuntimeContext $this$showWarning) {
                Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
                FindPopupPanel findPopupPanel = FindInFilesLesson.access$getFindPopup(this.this$0, $this$showWarning);
                return !(findPopupPanel != null && (findPopupPanel = findPopupPanel.getHelper()) != null ? findPopupPanel.isReplaceState() == this.$isReplacePopup : false);
            }
        }, 6, null);
    }

    @Override
    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("find.in.files.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink(this.helpUrl)));
    }

    public static final /* synthetic */ FindPopupPanel access$getFindPopup(FindInFilesLesson $this, TaskRuntimeContext $receiver) {
        return $this.getFindPopup($receiver);
    }

    public static final /* synthetic */ void access$highlightAndTriggerWhenButtonSelected(FindInFilesLesson $this, TaskContext $receiver, String buttonText) {
        $this.highlightAndTriggerWhenButtonSelected($receiver, buttonText);
    }

    public static final /* synthetic */ void access$showWarningIfPopupClosed(FindInFilesLesson $this, TaskContext $receiver, boolean isReplacePopup) {
        $this.showWarningIfPopupClosed($receiver, isReplacePopup);
    }

    public static final /* synthetic */ int access$findLastRowIndexOfItemWithText(FindInFilesLesson $this, JTable $receiver, String textToFind) {
        return $this.findLastRowIndexOfItemWithText($receiver, textToFind);
    }

    public static final /* synthetic */ boolean access$isSelectedNeededItem(FindInFilesLesson $this, TaskRuntimeContext $receiver, String neededText) {
        return $this.isSelectedNeededItem($receiver, neededText);
    }
}

