/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.cell.JTableCellWriter;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnegative;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicJTableCellReader;
import org.assertj.swing.driver.BasicJTableCellWriter;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTableCellEditableQuery;
import org.assertj.swing.driver.JTableCellPreconditions;
import org.assertj.swing.driver.JTableColumnCountQuery;
import org.assertj.swing.driver.JTableContentsQuery;
import org.assertj.swing.driver.JTableHasSelectionQuery;
import org.assertj.swing.driver.JTableHeaderQuery;
import org.assertj.swing.driver.JTableLocation;
import org.assertj.swing.driver.JTableMatchingCellQuery;
import org.assertj.swing.driver.JTableRowCellSelectedQuery;
import org.assertj.swing.driver.JTableRowCountQuery;
import org.assertj.swing.driver.MultipleSelectionTemplate;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.query.JTableColumnByIdentifierQuery;
import org.assertj.swing.util.ArrayPreconditions;
import org.assertj.swing.util.Arrays;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.PatternTextMatcher;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.StringTextMatcher;

@InternalApi
public class JTableDriver
extends JComponentDriver {
    private static final String CONTENTS_PROPERTY = "contents";
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_ROWS_PROPERTY = "selectedRows";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String VALUE_PROPERTY = "value";
    private final JTableLocation location = new JTableLocation();
    private JTableCellReader cellReader;
    private JTableCellWriter cellWriter;

    public JTableDriver(@Nonnull Robot robot) {
        super(robot);
        this.replaceCellReader(new BasicJTableCellReader());
        this.replaceCellWriter(new BasicJTableCellWriter(robot));
    }

    @Nullable
    @RunsInEDT
    public JTableHeader tableHeaderOf(@Nonnull JTable table) {
        return JTableHeaderQuery.tableHeader(table);
    }

    @Nullable
    @RunsInEDT
    public String selectionValue(@Nonnull JTable table) {
        return JTableDriver.selectionValue(table, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String selectionValue(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            if (table.getSelectedRowCount() == 0) {
                return null;
            }
            return cellReader.valueAt(table, table.getSelectedRow(), table.getSelectedColumn());
        });
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull TableCellFinder cellFinder) {
        Preconditions.checkNotNull(cellFinder);
        TableCell cell = cellFinder.findCell(table, this.cellReader());
        this.checkCellIndicesInBounds(table, cell);
        return cell;
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nullable String value) {
        return JTableMatchingCellQuery.cellWithValue(table, new StringTextMatcher(value), this.cellReader());
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull Pattern pattern) {
        return JTableMatchingCellQuery.cellWithValue(table, new PatternTextMatcher(pattern), this.cellReader());
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        return JTableDriver.cellValue(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            return cellReader.valueAt(table, cell.row, cell.column);
        });
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, int row2, int column) {
        return JTableDriver.cellValue(table, row2, column, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(@Nonnull JTable table, int row2, int column, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, row2, column);
            return cellReader.valueAt(table, row2, column);
        });
    }

    @Nullable
    @RunsInEDT
    public Font font(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        return JTableDriver.cellFont(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Font cellFont(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            return cellReader.fontAt(table, cell.row, cell.column);
        });
    }

    @RunsInEDT
    public Color background(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        return JTableDriver.cellBackground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellBackground(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            return cellReader.backgroundAt(table, cell.row, cell.column);
        });
    }

    @Nullable
    @RunsInEDT
    public Color foreground(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        return JTableDriver.cellForeground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellForeground(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            return cellReader.foregroundAt(table, cell.row, cell.column);
        });
    }

    public void selectCells(final @Nonnull JTable table, final @Nonnull TableCell[] cells) {
        Preconditions.checkNotNullOrEmpty(cells);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return cells.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, Preconditions.checkNotNull(cells[index]));
            }
        }.multiSelect();
    }

    public void unselectCells(final @Nonnull JTable table, final @Nonnull TableCell[] cells) {
        Preconditions.checkNotNullOrEmpty(cells);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return cells.length;
            }

            @Override
            void unselectElement(int index) {
                TableCell cell = Preconditions.checkNotNull(cells[index]);
                JTableDriver.this.selectCell(table, cell.row, cell.column, false);
            }
        }.multiUnselect();
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTable table) {
        JTableDriver.assertNoSelection(table);
    }

    @RunsInEDT
    private static void assertNoSelection(@Nonnull JTable table) {
        GuiActionRunner.execute(() -> {
            if (!JTableHasSelectionQuery.hasSelection(table)) {
                return;
            }
            String format = "[%s] expected no selection but was:<rows=%s, columns=%s>";
            String msg = String.format(format, JTableDriver.propertyName(table, SELECTION_PROPERTY).value(), Arrays.format(JTableDriver.selectedRowsOf(table)), Arrays.format(table.getSelectedColumns()));
            Fail.fail(msg);
        });
    }

    @RunsInEDT
    public void selectCell(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        this.selectCell(table, cell.row, cell.column, true);
    }

    @RunsInEDT
    public void unselectCell(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> this.selectCell(table, cell.row, cell.column, false));
    }

    @RunsInEDT
    public void click(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull MouseButton mouseButton, @Nonnegative int times) {
        if (times <= 0) {
            throw new IllegalArgumentException("The number of times to click a cell should be greater than zero");
        }
        Point pointAtCell = this.scrollToPointAtCell(table, cell, this.location());
        this.robot.click(table, pointAtCell, mouseButton, times);
    }

    @RunsInEDT
    public void drag(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = this.scrollToPointAtCell(table, cell, this.location());
        this.drag((Component)table, pointAtCell);
    }

    @RunsInEDT
    public void drop(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = this.scrollToPointAtCell(table, cell, this.location());
        this.drop((Component)table, pointAtCell);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenuAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = this.scrollToPointAtCell(table, cell, this.location());
        return this.robot.showPopupMenu(table, pointAtCell);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollToPointAtCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableLocation location) {
        Preconditions.checkNotNull(cell);
        Point result2 = GuiActionRunner.execute(() -> {
            this.scrollToCell(table, cell, location);
            return location.pointAt(table, cell.row, cell.column);
        });
        return Preconditions.checkNotNull(result2);
    }

    @RunsInCurrentThread
    private void scrollToCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableLocation location) {
        this.checkClickAllowed(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
        table.scrollRectToVisible(location.cellBounds(table, cell));
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        return JTableDriver.pointAtCell(table, cell, this.location());
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableLocation location) {
        Point result2 = GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            return location.pointAt(table, cell.row, cell.column);
        });
        return Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    public void requireContents(@Nonnull JTable table, @Nonnull String[][] contents) {
        String[][] actual = this.contents(table);
        if (!Arrays.equal(actual, contents)) {
            JTableDriver.failNotEqual(actual, contents, JTableDriver.propertyName(table, CONTENTS_PROPERTY));
        }
    }

    private static void failNotEqual(@Nonnull String[][] actual, @Nonnull String[][] expected, @Nullable Description description) {
        String descriptionValue = description != null ? description.value() : null;
        String message = descriptionValue == null ? "" : String.format("[%s] ", descriptionValue);
        Fail.fail(message + String.format("expected:<%s> but was<%s>", Arrays.format(expected), Arrays.format(actual)));
    }

    @Nonnull
    @RunsInEDT
    public String[][] contents(@Nonnull JTable table) {
        return JTableContentsQuery.tableContents(table, this.cellReader());
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nullable String value) {
        ((TextAssert)TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell))).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell))).matches(pattern);
    }

    @Nonnull
    @RunsInEDT
    private Description cellValueProperty(@Nonnull JTable table, @Nonnull TableCell cell) {
        return JTableDriver.cellProperty(table, Strings.concat(VALUE_PROPERTY, " ", cell));
    }

    @RunsInEDT
    public void enterValueInCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull String value) {
        Preconditions.checkNotNull(cell);
        this.cellWriter.enterValue(table, cell.row, cell.column, value);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, false);
    }

    @RunsInEDT
    private static void requireEditableEqualTo(@Nonnull JTable table, @Nonnull TableCell cell, boolean editable) {
        Preconditions.checkNotNull(cell);
        boolean cellEditable = Preconditions.checkNotNull(GuiActionRunner.execute(() -> JTableCellEditableQuery.isCellEditable(table, cell)));
        ((AbstractBooleanAssert)Assertions.assertThat(cellEditable).as(JTableDriver.cellProperty(table, Strings.concat(EDITABLE_PROPERTY, " ", cell)))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description cellProperty(@Nonnull JTable table, @Nonnull String propertyName) {
        return JTableDriver.propertyName(table, propertyName);
    }

    @RunsInEDT
    public Component cellEditor(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        return this.cellWriter.editorForCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        this.cellWriter.startCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void stopCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        this.cellWriter.stopCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void cancelCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        this.cellWriter.cancelCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void checkCellIndicesInBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        GuiActionRunner.execute(() -> JTableCellPreconditions.checkCellIndicesInBounds(table, cell));
    }

    public void replaceCellReader(@Nonnull JTableCellReader newCellReader) {
        this.cellReader = Preconditions.checkNotNull(newCellReader);
    }

    public void replaceCellWriter(JTableCellWriter newCellWriter) {
        this.cellWriter = Preconditions.checkNotNull(newCellWriter);
    }

    @RunsInEDT
    public int rowCountOf(@Nonnull JTable table) {
        return JTableRowCountQuery.rowCountOf(table);
    }

    @RunsInEDT
    public int columnIndex(@Nonnull JTable table, @Nonnull Object columnId) {
        return JTableDriver.findColumnIndex(table, columnId);
    }

    @RunsInEDT
    private static int findColumnIndex(@Nonnull JTable table, @Nonnull Object columnId) {
        Integer result2 = GuiActionRunner.execute(() -> {
            int index = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
            if (index < 0) {
                JTableDriver.failColumnIndexNotFound(columnId);
            }
            return index;
        });
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    private static ActionFailedException failColumnIndexNotFound(@Nonnull Object columnId) {
        throw ActionFailedException.actionFailure(String.format("Unable to find a column with id '%s'", columnId.toString()));
    }

    @RunsInEDT
    public void requireRowCount(@Nonnull JTable table, int rowCount) {
        ((AbstractIntegerAssert)Assertions.assertThat(this.rowCountOf(table)).as(JTableDriver.propertyName(table, "rowCount"))).isEqualTo(rowCount);
    }

    @RunsInEDT
    public void requireColumnCount(@Nonnull JTable table, int columnCount) {
        ((AbstractIntegerAssert)Assertions.assertThat(JTableColumnCountQuery.columnCountOf(table)).as(JTableDriver.propertyName(table, "columnCount"))).isEqualTo(columnCount);
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTable table, final int ... rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, rows[index], 0, true);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void unselectRows(final @Nonnull JTable table, final int ... rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void unselectElement(int index) {
                JTableDriver.this.selectCell(table, rows[index], 0, false);
            }
        }.multiUnselect();
    }

    @RunsInEDT
    private void selectCell(@Nonnull JTable table, int row2, int column, boolean select2) {
        Pair<Boolean, Point> cellSelectionInfo = this.cellSelectionInfo(table, row2, column, this.location);
        if ((Boolean)cellSelectionInfo.first == select2) {
            return;
        }
        this.robot.click(table, (Point)Preconditions.checkNotNull(cellSelectionInfo.second), MouseButton.LEFT_BUTTON, 1);
    }

    @Nonnull
    @RunsInEDT
    private Pair<Boolean, Point> cellSelectionInfo(final @Nonnull JTable table, final int row2, final int column, final @Nonnull JTableLocation location) {
        Pair<Boolean, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                JTableDriver.this.scrollToCell(table, row2, column, location);
                Point pointAtCell = location.pointAt(table, row2, column);
                return Pair.of(JTableRowCellSelectedQuery.isCellSelected(table, row2, column), pointAtCell);
            }
        });
        return Preconditions.checkNotNull(result2);
    }

    @RunsInCurrentThread
    private void scrollToCell(@Nonnull JTable table, int row2, int column, @Nonnull JTableLocation location) {
        this.checkClickAllowed(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, row2, column);
        table.scrollRectToVisible(location.cellBounds(table, row2, column));
    }

    @RunsInEDT
    public void requireSelectedRows(@Nonnull JTable table, int ... rows) {
        int[] selectedRows = JTableDriver.selectedRowsOf(table);
        ((AbstractIntArrayAssert)Assertions.assertThat(selectedRows).as(JTableDriver.propertyName(table, SELECTED_ROWS_PROPERTY))).contains(rows);
    }

    @Nonnull
    @RunsInEDT
    private static int[] selectedRowsOf(@Nonnull JTable table) {
        int[] result2 = GuiActionRunner.execute(() -> table.getSelectedRows());
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @VisibleForTesting
    JTableCellReader cellReader() {
        return this.cellReader;
    }

    @Nonnull
    private JTableLocation location() {
        return this.location;
    }
}

