/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookCodeCellBackgroundLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookLineMarkerRenderer.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookCodeCellBackgroundLineMarkerRenderer\n+ 2 NotebookUtil.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookUtilKt\n*L\n1#1,145:1\n29#2,22:146\n*S KotlinDebug\n*F\n+ 1 NotebookLineMarkerRenderer.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookCodeCellBackgroundLineMarkerRenderer\n*L\n115#1:146,22\n*E\n"})
public final class NotebookCodeCellBackgroundLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public NotebookCodeCellBackgroundLineMarkerRenderer(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(null, 1, null);
        this.highlighter = highlighter;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
        int top = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineStartOffset((int)lines.getFirst())).y;
        int height = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineEndOffset((int)lines.getLast())).y + ((EditorImpl)editor).getLineHeight() - top;
        EditorImpl editor$iv = (EditorImpl)editor;
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        NotebookEditorAppearance appearance$iv = NotebookUtilKt.getNotebookAppearance((Editor)editor$iv);
        Color stripe$iv = appearance$iv.getCellStripeColor(editor$iv, lines);
        Color stripeHover$iv = appearance$iv.getCellStripeHoverColor(editor$iv, lines);
        int borderWidth$iv = appearance$iv.getLeftBorderWidth();
        int rectBorderCellX$iv = r.width - borderWidth$iv;
        EditorColorsScheme editorColorsScheme = editor$iv.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(appearance$iv.getCodeCellBackground(editorColorsScheme));
        if (editor$iv.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX$iv + 3, top, borderWidth$iv - 3, height);
        } else {
            g.fillRect(rectBorderCellX$iv, top, borderWidth$iv, height);
        }
        boolean bl = false;
        NotebookUtilKt.paintCaretRow((EditorImpl)editor, g, lines);
        if (editor$iv.getEditorKind() != EditorKind.DIFF) {
            if (stripe$iv != null) {
                NotebookUtilKt.paintCellStripe(appearance$iv, g, r, stripe$iv, top, height);
            }
            if (stripeHover$iv != null) {
                g.setColor(stripeHover$iv);
                g.fillRect(r.width - appearance$iv.getLeftBorderWidth(), top, appearance$iv.getCellLeftLineHoverWidth(), height);
            }
        }
    }
}

