/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/MarkdownCellGutterLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "inlayId", "", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;J)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
public final class MarkdownCellGutterLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public MarkdownCellGutterLineMarkerRenderer(@NotNull RangeHighlighter highlighter, long inlayId) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(inlayId);
        this.highlighter = highlighter;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
        Rectangle rectangle = this.getInlayBounds((EditorEx)editor, lines);
        if (rectangle == null) {
            return;
        }
        Rectangle inlayBounds = rectangle;
        NotebookUtilKt.paintCellGutter(inlayBounds, lines, (EditorImpl)editor, g, r);
    }
}

