/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassWriterImpl
extends ClassWriter {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private final ClassLoader myClassLoader;
    private final Map<ClassLoader, Map<String, ClassReader>> myClassReaders;

    ClassWriterImpl(int flags, ClassLoader classLoader, Map<ClassLoader, Map<String, ClassReader>> classReaders) {
        super(flags);
        this.myClassLoader = classLoader;
        this.myClassReaders = classReaders;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block5: {
                ClassReader info1 = this.getOrLoadClassReader(type1);
                ClassReader info2 = this.getOrLoadClassReader(type2);
                String superType = this.checkImplementInterface(type1, type2, info1, info2);
                if (superType != null) {
                    return superType;
                }
                superType = this.checkImplementInterface(type2, type1, info2, info1);
                if (superType != null) {
                    return superType;
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = JAVA_LANG_OBJECT;
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block5;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private String checkImplementInterface(String type1, String type2, ClassReader info1, ClassReader info2) throws IOException {
        if ((info1.getAccess() & 0x200) != 0) {
            if (this.typeImplements(type2, info2, type1)) {
                return type1;
            }
            return JAVA_LANG_OBJECT;
        }
        return null;
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        StringBuilder b = new StringBuilder();
        while (!JAVA_LANG_OBJECT.equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.getOrLoadClassReader(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader classReader, String interfaceName) throws IOException {
        while (!JAVA_LANG_OBJECT.equals(type)) {
            String[] interfaces;
            for (String itf1 : interfaces = classReader.getInterfaces()) {
                if (!itf1.equals(interfaceName)) continue;
                return true;
            }
            for (String itf : interfaces) {
                if (!this.typeImplements(itf, this.getOrLoadClassReader(itf), interfaceName)) continue;
                return true;
            }
            type = classReader.getSuperName();
            classReader = this.getOrLoadClassReader(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ClassReader getOrLoadClassReader(String className) throws IOException {
        ClassReader classReader;
        Map<String, ClassReader> loaderClassReaders = this.myClassReaders.get(this.myClassLoader);
        if (loaderClassReaders == null) {
            loaderClassReaders = new HashMap<String, ClassReader>();
            this.myClassReaders.put(this.myClassLoader, loaderClassReaders);
        }
        if ((classReader = loaderClassReaders.get(className)) == null) {
            InputStream is = null;
            try {
                String resource = className + ".class";
                InputStream inputStream = is = this.myClassLoader == null ? ClassLoader.getSystemResourceAsStream(resource) : this.myClassLoader.getResourceAsStream(resource);
                if (is == null) {
                    throw new IOException("Class " + className + " not found");
                }
                classReader = new ClassReader(is);
                loaderClassReaders.put(className, classReader);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return classReader;
    }
}

