/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.data.CachingGitLabProjectMergeRequestsStore;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabLazyProject;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestId;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabProjectVirtualFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabTimelineFileType;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem;
import org.jetbrains.plugins.gitlab.mergerequest.ui.GitLabProjectUIContext;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\r\u0010\u0017\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0018H\u0016J\r\u0010\u0019\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestTimelineFile;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabProjectVirtualFile;", "connectionId", "", "project", "Lcom/intellij/openapi/project/Project;", "glProject", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mergeRequestId", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId;)V", "getMergeRequestId", "()Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId;", "equals", "", "other", "", "findDetails", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDetails;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "Lcom/intellij/openapi/util/NlsSafe;", "hashCode", "", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestTimelineFile
extends GitLabProjectVirtualFile {
    @NotNull
    private final GitLabMergeRequestId mergeRequestId;

    public GitLabMergeRequestTimelineFile(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull GitLabMergeRequestId mergeRequestId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestId, (String)"mergeRequestId");
        super(connectionId, project, glProject);
        this.mergeRequestId = mergeRequestId;
    }

    @NotNull
    public final GitLabMergeRequestId getMergeRequestId() {
        return this.mergeRequestId;
    }

    @NotNull
    public String getName() {
        return "!" + this.mergeRequestId.getIid();
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.mergeRequestId.getIid()};
        return GitLabBundle.message("merge.request.timeline.file.name", objectArray);
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem");
        return GitLabVirtualFileSystem.getPath$default((GitLabVirtualFileSystem)complexPathVirtualFileSystem, this.getConnectionId(), this.getProject(), this.getGlProject(), new GitLabMergeRequestId.Simple(this.mergeRequestId), false, 16, null);
    }

    @NotNull
    public String getPresentablePath() {
        Object object = this.findDetails();
        if (object == null || (object = ((GitLabMergeRequestDetails)object).getWebUrl()) == null) {
            object = this.getGlProject() + "/mergerequests/" + this.mergeRequestId.getIid();
        }
        return object;
    }

    @NotNull
    public FileType getFileType() {
        return GitLabTimelineFileType.Companion.getInstance();
    }

    private final GitLabMergeRequestDetails findDetails() {
        Object object = this.findContext();
        return object != null && (object = ((GitLabProjectUIContext)object).getProjectData()) != null && (object = ((GitLabLazyProject)object).getMergeRequests()) != null ? ((CachingGitLabProjectMergeRequestsStore)object).findCachedDetails(this.mergeRequestId) : null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabMergeRequestTimelineFile)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mergeRequestId, (Object)((GitLabMergeRequestTimelineFile)other).mergeRequestId);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.mergeRequestId.hashCode();
        return result2;
    }
}

