/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api;

import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.openapi.util.NlsSafe;
import git4idea.remote.GitRemoteUrlCoordinates;
import git4idea.remote.hosting.HostedRepositoryCoordinates;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.project.GitLabProjectPath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "Lgit4idea/remote/hosting/HostedRepositoryCoordinates;", "serverPath", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "projectPath", "Lorg/jetbrains/plugins/gitlab/project/GitLabProjectPath;", "(Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;Lorg/jetbrains/plugins/gitlab/project/GitLabProjectPath;)V", "getProjectPath", "()Lorg/jetbrains/plugins/gitlab/project/GitLabProjectPath;", "getServerPath", "()Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "component1", "component2", "copy", "equals", "", "other", "", "getWebURI", "Ljava/net/URI;", "hashCode", "", "toString", "", "Companion", "intellij.vcs.gitlab"})
public final class GitLabProjectCoordinates
implements HostedRepositoryCoordinates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitLabServerPath serverPath;
    @NotNull
    private final GitLabProjectPath projectPath;

    public GitLabProjectCoordinates(@NotNull GitLabServerPath serverPath, @NotNull GitLabProjectPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.serverPath = serverPath;
        this.projectPath = projectPath;
    }

    @NotNull
    public GitLabServerPath getServerPath() {
        return this.serverPath;
    }

    @NotNull
    public final GitLabProjectPath getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public URI getWebURI() {
        return URIUtilKt.resolveRelative((URI)this.getServerPath().toURI(), (String)this.projectPath.fullPath());
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.getServerPath() + "/" + this.projectPath;
    }

    @NotNull
    public final GitLabServerPath component1() {
        return this.serverPath;
    }

    @NotNull
    public final GitLabProjectPath component2() {
        return this.projectPath;
    }

    @NotNull
    public final GitLabProjectCoordinates copy(@NotNull GitLabServerPath serverPath, @NotNull GitLabProjectPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new GitLabProjectCoordinates(serverPath, projectPath);
    }

    public static /* synthetic */ GitLabProjectCoordinates copy$default(GitLabProjectCoordinates gitLabProjectCoordinates, GitLabServerPath gitLabServerPath, GitLabProjectPath gitLabProjectPath, int n, Object object) {
        if ((n & 1) != 0) {
            gitLabServerPath = gitLabProjectCoordinates.serverPath;
        }
        if ((n & 2) != 0) {
            gitLabProjectPath = gitLabProjectCoordinates.projectPath;
        }
        return gitLabProjectCoordinates.copy(gitLabServerPath, gitLabProjectPath);
    }

    public int hashCode() {
        int result2 = this.serverPath.hashCode();
        result2 = result2 * 31 + this.projectPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabProjectCoordinates)) {
            return false;
        }
        GitLabProjectCoordinates gitLabProjectCoordinates = (GitLabProjectCoordinates)other;
        if (!Intrinsics.areEqual((Object)this.serverPath, (Object)gitLabProjectCoordinates.serverPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.projectPath, (Object)gitLabProjectCoordinates.projectPath);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates$Companion;", "", "()V", "create", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabProjectCoordinates create(@NotNull GitLabServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GitLabProjectPath gitLabProjectPath = GitLabProjectPath.Companion.create(server, remote);
            if (gitLabProjectPath == null) {
                return null;
            }
            GitLabProjectPath projectPath = gitLabProjectPath;
            return new GitLabProjectCoordinates(server, projectPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

