/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.SimilarityBase;

public class DFRSimilarity
extends SimilarityBase {
    protected final BasicModel basicModel;
    protected final AfterEffect afterEffect;
    protected final Normalization normalization;

    public DFRSimilarity(BasicModel basicModel, AfterEffect afterEffect, Normalization normalization) {
        if (basicModel == null || afterEffect == null || normalization == null) {
            throw new NullPointerException("null parameters not allowed.");
        }
        this.basicModel = basicModel;
        this.afterEffect = afterEffect;
        this.normalization = normalization;
    }

    @Override
    protected double score(BasicStats stats2, double freq, double docLen) {
        double tfn = this.normalization.tfn(stats2, freq, docLen);
        double aeTimes1pTfn = this.afterEffect.scoreTimes1pTfn(stats2);
        return stats2.getBoost() * this.basicModel.score(stats2, tfn, aeTimes1pTfn);
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats2, double freq, double docLen) {
        if (stats2.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats2.getBoost()), "boost, query boost", new Explanation[0]));
        }
        Explanation normExpl = this.normalization.explain(stats2, freq, docLen);
        double tfn = this.normalization.tfn(stats2, freq, docLen);
        double aeTimes1pTfn = this.afterEffect.scoreTimes1pTfn(stats2);
        subs.add(normExpl);
        subs.add(this.basicModel.explain(stats2, tfn, aeTimes1pTfn));
        subs.add(this.afterEffect.explain(stats2, tfn));
    }

    @Override
    protected Explanation explain(BasicStats stats2, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats2, freq.getValue().doubleValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats2, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed as boost * basicModel.score(stats, tfn) * afterEffect.score(stats, tfn) from:", subs);
    }

    @Override
    public String toString() {
        return "DFR " + this.basicModel.toString() + this.afterEffect.toString() + this.normalization.toString();
    }

    public BasicModel getBasicModel() {
        return this.basicModel;
    }

    public AfterEffect getAfterEffect() {
        return this.afterEffect;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }
}

