/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceControlPriority;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PDFCreationListener;
import com.openhtmltopdf.pdfboxout.PagePosition;
import com.openhtmltopdf.pdfboxout.PageSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxFontContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElementFactory;
import com.openhtmltopdf.pdfboxout.PdfBoxSlowOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxUserAgent;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilderState;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListPainter;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAExtensionSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PdfBoxRenderer
implements Closeable,
PageSupplier {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private static final int DEFAULT_PDF_POINTS_PER_INCH = 72;
    private final SharedContext _sharedContext;
    private final PdfBoxOutputDevice _outputDevice;
    private final List<FSDOMMutator> _domMutators;
    private Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;
    private PDDocument _pdfDoc;
    private PDEncryption _pdfEncryption;
    private String _producer;
    private float _pdfVersion;
    private PdfRendererBuilder.PdfAConformance _pdfAConformance;
    private boolean _pdfUaConformance;
    private byte[] _colorProfile;
    private boolean _testMode;
    private PDFCreationListener _listener;
    private OutputStream _os;
    private SVGDrawer _svgImpl;
    private SVGDrawer _mathmlImpl;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;
    private final boolean _useFastMode;
    private PageSupplier _pageSupplier;
    private final Closeable diagnosticConsumer;
    private final int _initialPageNumber;
    private final Comparator<PagePosition<?>> PAGE_POSITION_COMPARATOR = Comparator.comparingInt(PagePosition::getPageNo).thenComparing(Comparator.comparingDouble(PagePosition::getY).reversed());

    PdfBoxRenderer(BaseDocument doc, UnicodeImplementation unicode, PageDimensions pageSize, PdfRendererBuilderState state, Closeable diagnosticConsumer) {
        this.diagnosticConsumer = diagnosticConsumer;
        this._pdfDoc = state.pddocument != null ? state.pddocument : new PDDocument();
        this._pdfDoc.setVersion(state._pdfVersion);
        this._pdfVersion = state._pdfVersion;
        this._producer = state._producer;
        this._pageSupplier = state._pageSupplier != null ? state._pageSupplier : this;
        this._svgImpl = state._svgImpl;
        this._mathmlImpl = state._mathmlImpl;
        this._pdfAConformance = state._pdfAConformance;
        this._pdfUaConformance = state._pdfUaConform;
        this._colorProfile = state._colorProfile;
        this._dotsPerPoint = 26.666666f;
        this._testMode = state._testMode;
        this._useFastMode = state._useFastRenderer;
        this._outputDevice = state._useFastRenderer ? new PdfBoxFastOutputDevice(26.666666f, this._testMode, state._pdfUaConform || state._pdfAConformance.getConformanceValue().equals("A"), state._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) : new PdfBoxSlowOutputDevice(26.666666f, this._testMode);
        this._outputDevice.setWriter(this._pdfDoc);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        PdfBoxUserAgent userAgent = new PdfBoxUserAgent(this._outputDevice);
        if (this._svgImpl != null) {
            this._svgImpl.withUserAgent(userAgent);
        }
        userAgent.setProtocolsStreamFactory(state._streamFactoryMap);
        if (state._resolver != null) {
            userAgent.setUriResolver(state._resolver);
        }
        userAgent.setAccessController(ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI, state._beforeAccessController);
        userAgent.setAccessController(ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI, state._afterAccessController);
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext._preferredTransformerFactoryImplementationClass = state._preferredTransformerFactoryImplementationClass;
        this._sharedContext._preferredDocumentBuilderFactoryImplementationClass = state._preferredDocumentBuilderFactoryImplementationClass;
        this._sharedContext.setUserAgentCallback(userAgent);
        this._sharedContext.setCss(new StyleReference(userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc, state._caches.get((Object)PdfRendererBuilder.CacheStore.PDF_FONT_METRICS), state._pdfAConformance, state._pdfUaConform);
        this._sharedContext.setFontResolver(fontResolver);
        PdfBoxReplacedElementFactory replacedElementFactory = new PdfBoxReplacedElementFactory(this._outputDevice, state._svgImpl, state._objectDrawerFactory, state._mathmlImpl);
        this._sharedContext.setReplacedElementFactory(replacedElementFactory);
        this._sharedContext.setTextRenderer(new PdfBoxTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(20);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
        this.getSharedContext().setDefaultPageSize(pageSize.w, pageSize.h, pageSize.isSizeInches);
        if (state._replacementText != null) {
            this.getSharedContext().setReplacementText(state._replacementText);
        }
        if (unicode.splitterFactory != null) {
            this._splitterFactory = unicode.splitterFactory;
        }
        if (unicode.reorderer != null) {
            this._reorderer = unicode.reorderer;
            this._outputDevice.setBidiReorderer(this._reorderer);
        }
        if (unicode.lineBreaker != null) {
            this._sharedContext.setLineBreaker(unicode.lineBreaker);
        }
        if (unicode.charBreaker != null) {
            this._sharedContext.setCharacterBreaker(unicode.charBreaker);
        }
        if (unicode.toLowerTransformer != null) {
            this._sharedContext.setUnicodeToLowerTransformer(unicode.toLowerTransformer);
        }
        if (unicode.toUpperTransformer != null) {
            this._sharedContext.setUnicodeToUpperTransformer(unicode.toUpperTransformer);
        }
        if (unicode.toTitleTransformer != null) {
            this._sharedContext.setUnicodeToTitleTransformer(unicode.toTitleTransformer);
        }
        this._defaultTextDirection = unicode.textDirection ? (byte)1 : 0;
        this._domMutators = state._domMutators;
        if (doc.html != null) {
            this.setDocumentFromStringP(doc.html, doc.baseUri);
        } else if (doc.document != null) {
            this.setDocumentP(doc.document, doc.baseUri);
        } else if (doc.uri != null) {
            this.setDocumentP(doc.uri);
        } else if (doc.file != null) {
            try {
                this.setDocumentP(doc.file);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.EXCEPTION_PROBLEM_TRYING_TO_READ_INPUT_XHTML_FILE, e);
                throw new RuntimeException("File IO problem", e);
            }
        }
        this._os = state._os;
        this._initialPageNumber = state._initialPageNumber;
    }

    public Document getDocument() {
        return this._doc;
    }

    public PDDocument getPdfDocument() {
        return this._pdfDoc;
    }

    public PdfBoxFontResolver getFontResolver() {
        return (PdfBoxFontResolver)this._sharedContext.getFontResolver();
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUserAgentCallback().getXMLResource(uri, ExternalResourceType.XML_XHTML).getDocument();
    }

    private void setDocumentP(String uri) {
        this.setDocumentP(this.loadDocument(uri), uri);
    }

    private void setDocumentP(Document doc, String url) {
        this.setDocumentP(doc, url, new XhtmlNamespaceHandler());
    }

    private void setDocumentP(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocumentP(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    private void setDocumentFromStringP(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load(is).getDocument();
        this.setDocumentP(dom, baseUrl);
    }

    private void setDocumentP(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        for (FSDOMMutator domMutator : this._domMutators) {
            domMutator.mutateDocument(doc);
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
        if (this._svgImpl != null) {
            this._svgImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
        if (this._mathmlImpl != null) {
            this._mathmlImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
    }

    public float getPDFVersion() {
        return this._pdfVersion == 0.0f ? 1.7f : this._pdfVersion;
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox(c, this._doc);
        ViewportBox viewport = new ViewportBox(this.getInitialExtents(c));
        root.setContainingBlock(viewport);
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages(c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox(c, "first");
        return new Rectangle(0, 0, first.getContentWidth(c), first.getContentHeight(c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext(new PdfBoxFontContext());
        result.setOutputDevice(this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext(new PdfBoxFontContext());
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((PdfBoxTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), this._reorderer != null ? this._reorderer : new SimpleBidiReorderer());
        return result;
    }

    public void createPDF() throws IOException {
        this.createPDF(this._os);
    }

    public void createPDFWithoutClosing() throws IOException {
        this.createPDF(this._os, false, 0);
    }

    @Deprecated
    public void createPDF(OutputStream os) throws IOException {
        this.createPDF(os, true, 0);
    }

    @Deprecated
    public void writeNextDocument() throws IOException {
        this.writeNextDocument(0);
    }

    @Deprecated
    public void writeNextDocument(int initialPageNo) throws IOException {
        List<PageBox> pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth(c) / this._dotsPerPoint, (float)firstPage.getHeight(c) / this._dotsPerPoint);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
    }

    @Deprecated
    public void finishPDF() throws IOException {
        if (this._pdfDoc != null) {
            this.fireOnClose();
            this._pdfDoc.close();
        }
    }

    @Deprecated
    public void createPDF(OutputStream os, boolean finish) throws IOException {
        this.createPDF(os, finish, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void createPDF(OutputStream os, boolean finish, int initialPageNo) throws IOException {
        if (this._useFastMode) {
            this.createPdfFast(finish, initialPageNo);
            return;
        }
        boolean success = false;
        try {
            if (this._root == null) {
                this.layout();
            }
            List<PageBox> pages = this._root.getLayer().getPages();
            RenderingContext c = this.newRenderingContext();
            c.setInitialPageNo(initialPageNo);
            PageBox firstPage = pages.get(0);
            Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth(c) / this._dotsPerPoint, (float)firstPage.getHeight(c) / this._dotsPerPoint);
            if (this._pdfEncryption != null) {
                this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
            }
            this.firePreOpen();
            this.writePDF(pages, c, firstPageSize, this._pdfDoc);
            success = true;
        }
        finally {
            if (finish) {
                this.fireOnClose();
                if (success) {
                    this._pdfDoc.save(os);
                }
                this._pdfDoc.close();
                this._pdfDoc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPdfFast(boolean finish, int initialPageNo) throws IOException {
        boolean success = false;
        XRLog.log(Level.INFO, LogMessageId.LogMessageId0Param.GENERAL_PDF_USING_FAST_MODE);
        try {
            if (this._root == null) {
                this.layout();
            }
            List<PageBox> pages = this._root.getLayer().getPages();
            RenderingContext c = this.newRenderingContext();
            c.setInitialPageNo(initialPageNo != 0 ? initialPageNo : this._initialPageNumber);
            c.setFastRenderer(true);
            PageBox firstPage = pages.get(0);
            Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth(c) / this._dotsPerPoint, (float)firstPage.getHeight(c) / this._dotsPerPoint);
            if (this._pdfEncryption != null) {
                this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
            }
            this.firePreOpen();
            this.writePDFFast(pages, c, firstPageSize, this._pdfDoc);
            success = true;
        }
        finally {
            if (finish) {
                this.fireOnClose();
                if (success) {
                    this._pdfDoc.save(this._os);
                }
                this._pdfDoc.close();
                this._pdfDoc = null;
            }
        }
    }

    private void firePreOpen() {
        if (this._listener != null) {
            this._listener.preOpen(this);
        }
    }

    private void firePreWrite(int pageCount) {
        if (this._listener != null) {
            this._listener.preWrite(this, pageCount);
        }
    }

    private void fireOnClose() {
        if (this._listener != null) {
            this._listener.onClose(this);
        }
    }

    private void writePDFFast(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot(this._root);
        this._outputDevice.start(this._doc);
        PDPage page = this._pageSupplier.requestPage(doc, (float)firstPageSize.getWidth(), (float)firstPageSize.getHeight(), 0, -1);
        PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, !this._testMode);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions(c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        if (this._pdfUaConformance || this._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
            this.addPdfASchema(doc, this._pdfAConformance, this._pdfUaConformance);
        }
        DisplayListCollector dlCollector = new DisplayListCollector(this._root.getLayer().getPages());
        DisplayListContainer dlPages = dlCollector.collectRoot(c, this._root.getLayer());
        int pdfPageIndex = 0;
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            currentPage.setBasePagePdfPageIndex(pdfPageIndex);
            DisplayListContainer.DisplayListPageContainer pageOperations = dlPages.getPageInstructions(i);
            c.setPage(i, currentPage);
            c.setShadowPageNumber(-1);
            this.paintPageFast(c, currentPage, pageOperations, 0);
            this._outputDevice.finishPage();
            ++pdfPageIndex;
            if (!pageOperations.shadowPages().isEmpty()) {
                currentPage.setShadowPageCount(pageOperations.shadowPages().size());
                int shadowPageIndex = 0;
                int pageContentWidth = currentPage.getContentWidth(c);
                int translateX = pageContentWidth * (currentPage.getCutOffPageDirection() == IdentValue.LTR ? 1 : -1);
                for (DisplayListContainer.DisplayListPageContainer shadowPage : pageOperations.shadowPages()) {
                    PDPage shadowPdPage = this._pageSupplier.requestPage(doc, (float)currentPage.getWidth(c) / this._dotsPerPoint, (float)currentPage.getHeight(c) / this._dotsPerPoint, i, shadowPageIndex);
                    PDPageContentStream shadowCs = new PDPageContentStream(doc, shadowPdPage, PDPageContentStream.AppendMode.APPEND, !this._testMode);
                    this._outputDevice.initializePage(shadowCs, shadowPdPage, (float)currentPage.getHeight(c) / this._dotsPerPoint);
                    c.setShadowPageNumber(shadowPageIndex);
                    this.paintPageFast(c, currentPage, shadowPage, -translateX);
                    this._outputDevice.finishPage();
                    translateX += pageContentWidth * (currentPage.getCutOffPageDirection() == IdentValue.LTR ? 1 : -1);
                    ++pdfPageIndex;
                    ++shadowPageIndex;
                }
            }
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth(c) / this._dotsPerPoint, (float)nextPage.getHeight(c) / this._dotsPerPoint);
            PDPage pageNext = this._pageSupplier.requestPage(doc, (float)((RectangularShape)nextPageSize).getWidth(), (float)((RectangularShape)nextPageSize).getHeight(), i + 1, -1);
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, PDPageContentStream.AppendMode.APPEND, !this._testMode);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, this._root);
    }

    private void writePDF(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot(this._root);
        this._outputDevice.start(this._doc);
        PDPage page = this._pageSupplier.requestPage(doc, (float)firstPageSize.getWidth(), (float)firstPageSize.getHeight(), 0, -1);
        PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, !this._testMode);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions(c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        if (this._pdfUaConformance || this._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
            this.addPdfASchema(doc, this._pdfAConformance, this._pdfUaConformance);
        }
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._outputDevice.finishPage();
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth(c) / this._dotsPerPoint, (float)nextPage.getHeight(c) / this._dotsPerPoint);
            PDPage pageNext = this._pageSupplier.requestPage(doc, (float)((RectangularShape)nextPageSize).getWidth(), (float)((RectangularShape)nextPageSize).getHeight(), i + 1, -1);
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, PDPageContentStream.AppendMode.APPEND, !this._testMode);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, this._root);
    }

    private void addPdfASchema(PDDocument document, PdfRendererBuilder.PdfAConformance pdfAConformance, boolean isPdfUa) {
        PDDocumentInformation information = document.getDocumentInformation();
        XMPMetadata metadata = XMPMetadata.createXMPMetadata();
        try {
            String title = information.getTitle();
            String author = information.getAuthor();
            String subject = information.getSubject();
            String keywords = information.getKeywords();
            String creator = information.getCreator();
            String producer = information.getProducer();
            Calendar creationDate = information.getCreationDate();
            Calendar modDate = information.getModificationDate();
            if (isPdfUa && (title == null || title.isEmpty())) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.GENERAL_PDF_ACCESSIBILITY_NO_DOCUMENT_TITLE_PROVIDED);
            }
            if (pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
                PDFAIdentificationSchema pdfaid = metadata.createAndAddPFAIdentificationSchema();
                pdfaid.setConformance(pdfAConformance.getConformanceValue());
                pdfaid.setPart(pdfAConformance.getPart());
                AdobePDFSchema pdfSchema = metadata.createAndAddAdobePDFSchema();
                pdfSchema.setPDFVersion(String.valueOf(pdfAConformance.getPdfVersion()));
                if (keywords != null) {
                    pdfSchema.setKeywords(keywords);
                }
                if (producer != null) {
                    pdfSchema.setProducer(producer);
                }
                XMPBasicSchema xmpBasicSchema = metadata.createAndAddXMPBasicSchema();
                if (creator != null) {
                    xmpBasicSchema.setCreatorTool(creator);
                }
                if (creationDate != null) {
                    xmpBasicSchema.setCreateDate(creationDate);
                }
                if (modDate != null) {
                    xmpBasicSchema.setModifyDate(modDate);
                }
            }
            DublinCoreSchema dc = metadata.createAndAddDublinCoreSchema();
            dc.setFormat("application/pdf");
            if (author != null) {
                dc.addCreator(author);
            }
            if (title != null) {
                dc.setTitle(title);
            }
            if (subject != null) {
                dc.setDescription(subject);
            } else if (isPdfUa) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.GENERAL_PDF_ACCESSIBILITY_NO_DOCUMENT_DESCRIPTION_PROVIDED);
            }
            PDFAExtensionSchema pdfAExt = metadata.createAndAddPDFAExtensionSchemaWithDefaultNS();
            pdfAExt.addNamespace("http://www.aiim.org/pdfa/ns/extension/", "pdfaExtension");
            pdfAExt.addNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
            pdfAExt.addNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
            if (pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
                ArrayList<XMPSchema> pdfProperties = new ArrayList<XMPSchema>(3);
                pdfProperties.add(this.createPdfaProperty("internal", "The PDF file version.", "PDFVersion", "Text"));
                pdfProperties.add(this.createPdfaProperty("external", "Keywords.", "Keywords", "Text"));
                pdfProperties.add(this.createPdfaProperty("internal", "The name of the tool that created the PDF document.", "Producer", "AgentName"));
                pdfAExt.addBagValue("schemas", this.createPdfaSchema("Adobe PDF Schema", "http://ns.adobe.com/pdf/1.3/", "pdf", pdfProperties));
                ArrayList<XMPSchema> pdfaidProperties = new ArrayList<XMPSchema>(2);
                pdfaidProperties.add(this.createPdfaProperty("internal", "Part of PDF/A standard", "part", "Integer"));
                pdfaidProperties.add(this.createPdfaProperty("internal", "Conformance level of PDF/A standard", "conformance", "Text"));
                pdfAExt.addBagValue("schemas", this.createPdfaSchema("PDF/A ID Schema", "http://www.aiim.org/pdfa/ns/id/", "pdfaid", pdfaidProperties));
            }
            if (isPdfUa) {
                ArrayList<XMPSchema> pdfUaProperties = new ArrayList<XMPSchema>(1);
                pdfUaProperties.add(this.createPdfaProperty("internal", "Indicates, which part of ISO 14289 standard is followed", "part", "Integer"));
                XMPSchema pdfUa = this.createPdfaSchema("PDF/UA Universal Accessibility Schema", "http://www.aiim.org/pdfua/ns/id/", "pdfuaid", pdfUaProperties);
                pdfAExt.addBagValue("schemas", pdfUa);
                pdfAExt.addNamespace("http://www.aiim.org/pdfua/ns/id/", "pdfuaid");
                pdfAExt.setPrefix("pdfuaid");
                pdfAExt.setTextPropertyValue("part", "1");
            }
            PDMetadata metadataStream = new PDMetadata(document);
            PDMarkInfo markInfo = new PDMarkInfo();
            markInfo.setMarked(true);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            catalog.setMetadata(metadataStream);
            catalog.setMarkInfo(markInfo);
            String lang = this._doc.getDocumentElement().getAttribute("lang");
            catalog.setLanguage(!lang.isEmpty() ? lang : "EN-US");
            catalog.setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
            catalog.getViewerPreferences().setDisplayDocTitle(true);
            XmpSerializer serializer = new XmpSerializer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serialize(metadata, baos, true);
            String xmp = baos.toString("UTF-8");
            xmp = xmp.replace(" lang=\"x-default\"", " xml:lang=\"x-default\"");
            metadataStream.importXMPMetadata(xmp.getBytes(StandardCharsets.UTF_8));
            if (this._colorProfile != null) {
                ByteArrayInputStream colorProfile = new ByteArrayInputStream(this._colorProfile);
                PDOutputIntent oi = new PDOutputIntent(document, colorProfile);
                oi.setInfo("sRGB IEC61966-2.1");
                oi.setOutputCondition("sRGB IEC61966-2.1");
                oi.setOutputConditionIdentifier("sRGB IEC61966-2.1");
                oi.setRegistryName("http://www.color.org");
                catalog.addOutputIntent(oi);
            }
        }
        catch (IOException | TransformerException | BadFieldValueException e) {
            throw new RuntimeException(e);
        }
    }

    private XMPSchema createPdfaSchema(String schema, String namespace, String prefix, List<XMPSchema> properties) {
        XMPSchema xmpSchema = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaSchema", "pdfaSchema", "pdfaSchema");
        xmpSchema.setTextPropertyValue("schema", schema);
        xmpSchema.setTextPropertyValue("namespaceURI", namespace);
        xmpSchema.setTextPropertyValue("prefix", prefix);
        for (XMPSchema property : properties) {
            xmpSchema.addUnqualifiedSequenceValue("property", property);
        }
        return xmpSchema;
    }

    private XMPSchema createPdfaProperty(String category, String description, String name, String valueType) {
        XMPSchema xmpSchema = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaProperty", "pdfaProperty", "pdfaProperty");
        xmpSchema.setTextPropertyValue("name", name);
        xmpSchema.setTextPropertyValue("valueType", valueType);
        xmpSchema.setTextPropertyValue("category", category);
        xmpSchema.setTextPropertyValue("description", description);
        return xmpSchema;
    }

    private void setDidValues(PDDocument doc) {
        PDDocumentInformation info = new PDDocumentInformation();
        info.setCreationDate(Calendar.getInstance());
        if (this._producer == null) {
            info.setProducer("openhtmltopdf.com");
        } else {
            info.setProducer(this._producer);
        }
        for (PdfBoxSlowOutputDevice.Metadata metadata : this._outputDevice.getMetadata()) {
            String content;
            String name = metadata.getName();
            if (name.isEmpty() || (content = metadata.getContent()) == null) continue;
            if (name.equals("title")) {
                info.setTitle(content);
                continue;
            }
            if (name.equals("author")) {
                info.setAuthor(content);
                continue;
            }
            if (name.equals("subject")) {
                info.setSubject(content);
                continue;
            }
            if (name.equals("keywords")) {
                info.setKeywords(content);
                continue;
            }
            info.setCustomMetadataValue(name, content);
        }
        doc.setDocumentInformation(info);
    }

    private void paintPageFast(RenderingContext c, PageBox page, DisplayListContainer.DisplayListPageContainer pageOperations, int additionalTranslateX) {
        page.paintBackground(c, 0, (short)2);
        c.setInPageMargins(true);
        page.paintMarginAreas(c, 0, (short)2);
        c.setInPageMargins(false);
        page.paintBorder(c, 0, (short)2);
        Rectangle content = page.getPrintClippingBounds(c);
        this._outputDevice.pushClip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding(c, 3);
        int left = page.getMarginBorderPadding(c, 1);
        int translateX = left + additionalTranslateX;
        this._outputDevice.translate(translateX, top);
        DisplayListPainter painter = new DisplayListPainter();
        painter.paint(c, pageOperations);
        this._outputDevice.translate(-translateX, -top);
        this._outputDevice.popClip();
    }

    private void paintPage(RenderingContext c, PageBox page) {
        page.paintBackground(c, 0, (short)2);
        page.paintMarginAreas(c, 0, (short)2);
        page.paintBorder(c, 0, (short)2);
        Shape working = this._outputDevice.getClip();
        Rectangle content = page.getPrintClippingBounds(c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding(c, 3);
        int left = page.getMarginBorderPadding(c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
    }

    private String stringfyMetadata(Element element) {
        Element target = PdfBoxRenderer.getFirstChildElement(element);
        if (target == null) {
            return null;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter output2 = new StringWriter();
            transformer.transform(new DOMSource(target), new StreamResult(output2));
            return output2.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static Element getFirstChildElement(Element element) {
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    private String createXPacket(String metadata) {
        StringBuilder result = new StringBuilder(metadata.length() + 50);
        result.append("<?xpacket begin='\ufeff' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        result.append(metadata);
        result.append("\n<?xpacket end='r'?>");
        return result.toString();
    }

    public PdfBoxOutputDevice getOutputDevice() {
        return this._outputDevice;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    @Deprecated
    public void exportText(Writer writer) throws IOException {
        RenderingContext c = this.newRenderingContext();
        c.setPageCount(this._root.getLayer().getPages().size());
        this._root.exportText(c, writer);
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public List<PagePosition<Box>> findPagePositionsByID(Pattern pattern) {
        return this._outputDevice.findPagePositionsByID(this.newLayoutContext(), pattern);
    }

    public PDFCreationListener getListener() {
        return this._listener;
    }

    public void setListener(PDFCreationListener listener) {
        this._listener = listener;
    }

    @Deprecated
    public void cleanup() {
        this._outputDevice.close();
        this._sharedContext.removeFromThread();
        try {
            this.diagnosticConsumer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ThreadCtx.cleanup();
        ((PdfBoxFontResolver)this.getSharedContext().getFontResolver()).close();
        if (this._svgImpl != null) {
            try {
                this._svgImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._mathmlImpl != null) {
            try {
                this._mathmlImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public PDPage requestPage(PDDocument doc, float pageWidth, float pageHeight, int pageNumber, int shadowPageNumber) {
        PDPage page = new PDPage(new PDRectangle(pageWidth, pageHeight));
        doc.addPage(page);
        return page;
    }

    public float getLastContentBottom() {
        List<PagePosition<Layer>> positions = this.getLayersPositions();
        if (positions.isEmpty()) {
            return 0.0f;
        }
        return positions.get(positions.size() - 1).getY();
    }

    public List<PagePosition<Layer>> getLayersPositions() {
        if (this.getRootBox() == null) {
            this.layout();
        }
        Layer rootLayer = this.getRootBox().getLayer();
        int[] whiches = new int[]{3, 4, 2, 1};
        List layers = Arrays.stream(whiches).mapToObj(rootLayer::collectLayers).flatMap(Collection::stream).collect(Collectors.toList());
        RenderingContext ctx = this.newRenderingContext();
        List<PageBox> pages = rootLayer.getPages();
        ArrayList<PagePosition<Layer>> ret = new ArrayList<PagePosition<Layer>>();
        ret.addAll(this.getLayerPagePositions(rootLayer, pages, ctx));
        layers.stream().map(layer -> this.getLayerPagePositions((Layer)layer, pages, ctx)).forEach(ret::addAll);
        Collections.sort(ret, this.PAGE_POSITION_COMPARATOR);
        return ret;
    }

    public List<PagePosition<Layer>> getLayerPositions(Layer layer) {
        RenderingContext ctx = this.newRenderingContext();
        List<PageBox> pages = layer.getPages();
        List<PagePosition<Layer>> ret = this.getLayerPagePositions(layer, pages, ctx);
        Collections.sort(ret, this.PAGE_POSITION_COMPARATOR);
        return ret;
    }

    private List<PagePosition<Layer>> getLayerPagePositions(Layer layer, List<PageBox> pages, RenderingContext ctx) {
        Box box = layer.getMaster();
        int start = this.findStartPage(ctx, layer, pages);
        int end = this.findEndPage(ctx, layer, pages);
        if (box.getStyle().isFixed()) {
            PageBox page = pages.get(start);
            float x = box.getAbsX() + page.getMarginBorderPadding(ctx, 1);
            float w = box.getEffectiveWidth();
            float y = page.getMarginBorderPadding(ctx, 4) + (page.getPaintingBottom() - box.getAbsY() - box.getHeight());
            float h = box.getHeight();
            return IntStream.range(0, pages.size()).mapToObj(pageNo -> this.createPagePosition(null, layer, pageNo, x, y, w, h)).collect(Collectors.toList());
        }
        ArrayList<PagePosition<Layer>> ret = new ArrayList<PagePosition<Layer>>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            float h;
            float y;
            PageBox page = pages.get(i);
            float x = box.getAbsX() + page.getMarginBorderPadding(ctx, 1);
            float w = box.getEffectiveWidth();
            if (start != end) {
                if (i != start && i != end) {
                    y = page.getMarginBorderPadding(ctx, 4);
                    h = page.getContentHeight(ctx);
                } else if (i == end) {
                    h = box.getAbsY() + box.getHeight() - page.getPaintingTop();
                    y = (float)(page.getMarginBorderPadding(ctx, 4) + page.getContentHeight(ctx)) - h;
                } else {
                    assert (i == start);
                    y = page.getMarginBorderPadding(ctx, 4);
                    h = page.getPaintingBottom() - box.getAbsY();
                }
            } else {
                y = page.getMarginBorderPadding(ctx, 4) + (page.getPaintingBottom() - box.getAbsY() - box.getHeight());
                h = box.getHeight();
            }
            PagePosition<Layer> pos = this.createPagePosition(null, layer, i, x, y, w, h);
            ret.add(pos);
        }
        return ret;
    }

    private <T> PagePosition<T> createPagePosition(String id, T element, int pageNo, float x, float y, float w, float h) {
        return new PagePosition<T>(id, element, pageNo, x / this._dotsPerPoint, y / this._dotsPerPoint, w / this._dotsPerPoint, h / this._dotsPerPoint);
    }

    private int findStartPage(RenderingContext c, Layer layer, List<PageBox> pages) {
        int start = PagedBoxCollector.findStartPage(c, layer.getMaster(), pages);
        for (BlockBox floater : layer.getFloats()) {
            start = Math.min(start, PagedBoxCollector.findStartPage(c, floater, pages));
        }
        return start;
    }

    private int findEndPage(RenderingContext c, Layer layer, List<PageBox> pages) {
        int end = PagedBoxCollector.findEndPage(c, layer.getMaster(), pages);
        for (BlockBox floater : layer.getFloats()) {
            end = Math.max(end, PagedBoxCollector.findEndPage(c, floater, pages));
        }
        return end;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        @Override
        public boolean isHover(Element e) {
            return false;
        }

        @Override
        public boolean isActive(Element e) {
            return false;
        }

        @Override
        public boolean isFocus(Element e) {
            return false;
        }
    }
}

