/*
 * Decompiled with CFR 0.152.
 */
package runtime.x;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.collections.Stack;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.text.TextRange;
import runtime.x.SelectionVM;
import runtime.x.XTextHistory;
import runtime.x.XTextHistoryContinuationStrategy;
import runtime.x.XTextHistoryStrategy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u001e\u0010\u0019\u001a\u00020\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0002J&\u0010\u001a\u001a\u00020\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u00102\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lruntime/x/TextChangeHistory;", "Lruntime/x/XTextHistory;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "textState", "Lruntime/reactive/MutableProperty;", "", "selectionVM", "Lruntime/x/SelectionVM;", "strategy", "Lruntime/x/XTextHistoryStrategy;", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/MutableProperty;Lruntime/x/SelectionVM;Lruntime/x/XTextHistoryStrategy;)V", "inputJustHappened", "", "lastHandledText", "redoStack", "Llibraries/collections/Stack;", "Lkotlin/Pair;", "Lruntime/text/TextRange;", "getStrategy", "()Lruntime/x/XTextHistoryStrategy;", "undoStack", "redo", "", "undo", "popState", "pushState", "text", "platform-ui"})
public final class TextChangeHistory
implements XTextHistory {
    @NotNull
    private final MutableProperty<String> textState;
    @NotNull
    private final SelectionVM selectionVM;
    @NotNull
    private final XTextHistoryStrategy strategy;
    @NotNull
    private Stack<Pair<String, TextRange>> undoStack;
    @NotNull
    private Stack<Pair<String, TextRange>> redoStack;
    @Nullable
    private String lastHandledText;
    private boolean inputJustHappened;

    public TextChangeHistory(@NotNull Lifetime lifetime, @NotNull MutableProperty<String> textState, @NotNull SelectionVM selectionVM, @NotNull XTextHistoryStrategy strategy2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(textState, (String)"textState");
        Intrinsics.checkNotNullParameter((Object)selectionVM, (String)"selectionVM");
        Intrinsics.checkNotNullParameter((Object)strategy2, (String)"strategy");
        this.textState = textState;
        this.selectionVM = selectionVM;
        this.strategy = strategy2;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.textState.forEachWithPrevious(lifetime, (Function2<String, String, Unit>)((Function2)new Function2<String, String, Unit>(){

            public final void invoke(@Nullable String prev, @NotNull String curr) {
                Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
                inputJustHappened = true;
                if (prev == null || Intrinsics.areEqual((Object)curr, (Object)lastHandledText)) {
                    return;
                }
                redoStack.clear();
                int selectionLength = ((TextRange)selectionVM.getSelection().getValue()).getLength();
                boolean shouldCreateNewBatch = this.getStrategy().shouldStartNewBatch(prev.length() - selectionLength, curr.length());
                if (shouldCreateNewBatch) {
                    this.pushState(undoStack, prev);
                }
                lastHandledText = curr;
            }
        }));
        this.selectionVM.getSelection().forEach(lifetime, (Function1)new Function1<TextRange, Unit>(){

            public final void invoke(@NotNull TextRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!inputJustHappened || it.getLength() != 0) {
                    this.getStrategy().breakContinuation();
                }
                inputJustHappened = false;
            }
        });
    }

    public /* synthetic */ TextChangeHistory(Lifetime lifetime, MutableProperty mutableProperty2, SelectionVM selectionVM, XTextHistoryStrategy xTextHistoryStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            xTextHistoryStrategy = new XTextHistoryContinuationStrategy();
        }
        this(lifetime, mutableProperty2, selectionVM, xTextHistoryStrategy);
    }

    @NotNull
    public final XTextHistoryStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void redo() {
        if (this.redoStack.getSize() != 0) {
            this.pushState(this.undoStack, this.textState.getValue());
            this.popState(this.redoStack);
        }
    }

    @Override
    public void undo() {
        if (this.undoStack.getSize() > 0) {
            this.pushState(this.redoStack, this.textState.getValue());
            this.popState(this.undoStack);
        }
    }

    private final void pushState(Stack<Pair<String, TextRange>> $this$pushState, String text2) {
        $this$pushState.push((Pair<String, TextRange>)TuplesKt.to((Object)text2, this.selectionVM.getSelection().getValue()));
    }

    private final void popState(Stack<Pair<String, TextRange>> $this$popState) {
        Pair<String, TextRange> pair = $this$popState.pop();
        String prevText = (String)pair.component1();
        TextRange sel = (TextRange)pair.component2();
        this.lastHandledText = prevText;
        this.textState.setValue(prevText);
        this.selectionVM.setSelection(sel);
        this.strategy.breakContinuation();
    }
}

