/*
 * Decompiled with CFR 0.152.
 */
package runtime.matchers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.matchers.PatternBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH \u00a2\u0006\u0002\b\nJ\u000f\u0010\u000b\u001a\u00028\u0000H \u00a2\u0006\u0004\b\f\u0010\r\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lruntime/matchers/PatternHolder;", "SELF", "", "()V", "branchRegexMatcher", "Lkotlin/Pair;", "Lruntime/matchers/PatternBuilder$PatternMatcher;", "", "cache", "Lruntime/matchers/PatternBuilder$Cache;", "branchRegexMatcher$platform_runtime", "normalize", "normalize$platform_runtime", "()Lruntime/matchers/PatternHolder;", "BranchSpecLine", "Companion", "RegexObj", "RegexStr", "Wildcard", "WithRawString", "Lruntime/matchers/PatternHolder$RegexObj;", "Lruntime/matchers/PatternHolder$RegexStr;", "Lruntime/matchers/PatternHolder$Wildcard;", "platform-runtime"})
public abstract class PatternHolder<SELF extends PatternHolder<SELF>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex simpleWildcardPattern = new Regex("^[^\\?\\*]+\\*?$");

    private PatternHolder() {
    }

    @NotNull
    public abstract SELF normalize$platform_runtime();

    @NotNull
    public abstract Pair<PatternBuilder.PatternMatcher, Boolean> branchRegexMatcher$platform_runtime(@NotNull PatternBuilder.Cache var1);

    public /* synthetic */ PatternHolder(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lruntime/matchers/PatternHolder$BranchSpecLine;", "", "ref", "", "include", "", "(Ljava/lang/String;Z)V", "getInclude", "()Z", "getRef", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "platform-runtime"})
    private static final class BranchSpecLine {
        @Nullable
        private final String ref;
        private final boolean include;

        public BranchSpecLine(@Nullable String ref2, boolean include) {
            this.ref = ref2;
            this.include = include;
        }

        @Nullable
        public final String getRef() {
            return this.ref;
        }

        public final boolean getInclude() {
            return this.include;
        }

        @Nullable
        public final String component1() {
            return this.ref;
        }

        public final boolean component2() {
            return this.include;
        }

        @NotNull
        public final BranchSpecLine copy(@Nullable String ref2, boolean include) {
            return new BranchSpecLine(ref2, include);
        }

        public static /* synthetic */ BranchSpecLine copy$default(BranchSpecLine branchSpecLine, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = branchSpecLine.ref;
            }
            if ((n & 2) != 0) {
                bl = branchSpecLine.include;
            }
            return branchSpecLine.copy(string2, bl);
        }

        @NotNull
        public String toString() {
            return "BranchSpecLine(ref=" + this.ref + ", include=" + this.include + ")";
        }

        public int hashCode() {
            int result2 = this.ref == null ? 0 : this.ref.hashCode();
            int n = this.include ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchSpecLine)) {
                return false;
            }
            BranchSpecLine branchSpecLine = (BranchSpecLine)other;
            if (!Intrinsics.areEqual((Object)this.ref, (Object)branchSpecLine.ref)) {
                return false;
            }
            return this.include == branchSpecLine.include;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002J\"\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lruntime/matchers/PatternHolder$Companion;", "", "()V", "simpleWildcardPattern", "Lkotlin/text/Regex;", "parseBranchSpecLine", "Lruntime/matchers/PatternHolder$BranchSpecLine;", "", "wrapCompileErrors", "Lruntime/matchers/PatternBuilder$PatternMatcher;", "isRegex", "", "action", "Lkotlin/Function0;", "platform-runtime"})
    @SourceDebugExtension(value={"SMAP\nPatternBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternBuilder.kt\nruntime/matchers/PatternHolder$Companion\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,247:1\n56#2,5:248\n*S KotlinDebug\n*F\n+ 1 PatternBuilder.kt\nruntime/matchers/PatternHolder$Companion\n*L\n230#1:248,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PatternBuilder.PatternMatcher wrapCompileErrors(String $this$wrapCompileErrors, boolean isRegex, Function0<? extends PatternBuilder.PatternMatcher> action2) {
            PatternBuilder.PatternMatcher patternMatcher;
            try {
                patternMatcher = (PatternBuilder.PatternMatcher)action2.invoke();
            }
            catch (Throwable ex) {
                KLogger this_$iv = PatternBuilder.INSTANCE.getLog$platform_runtime();
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    boolean bl = false;
                    String msgStr$iv = "Cannot parse pattern '" + $this$wrapCompileErrors + "', isRegex=" + isRegex;
                    this_$iv.info(ex, msgStr$iv);
                }
                patternMatcher = PatternBuilder.INSTANCE.getFALSE$platform_runtime();
            }
            return patternMatcher;
        }

        private final BranchSpecLine parseBranchSpecLine(String $this$parseBranchSpecLine) {
            BranchSpecLine branchSpecLine;
            if (((CharSequence)$this$parseBranchSpecLine).length() == 0) {
                branchSpecLine = new BranchSpecLine(null, true);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"#", (boolean)false, (int)2, null)) {
                branchSpecLine = new BranchSpecLine(null, true);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"-:", (boolean)false, (int)2, null)) {
                String string2 = $this$parseBranchSpecLine.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                branchSpecLine = new BranchSpecLine(PatternBuilder.INSTANCE.trim(string2), false);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"^", (boolean)false, (int)2, null)) {
                String string3 = $this$parseBranchSpecLine.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                branchSpecLine = new BranchSpecLine(PatternBuilder.INSTANCE.trim(string3), false);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"-", (boolean)false, (int)2, null)) {
                String string4 = $this$parseBranchSpecLine.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                branchSpecLine = new BranchSpecLine(PatternBuilder.INSTANCE.trim(string4), false);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"+:", (boolean)false, (int)2, null)) {
                String string5 = $this$parseBranchSpecLine.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                branchSpecLine = new BranchSpecLine(PatternBuilder.INSTANCE.trim(string5), true);
            } else if (StringsKt.startsWith$default((String)$this$parseBranchSpecLine, (String)"+", (boolean)false, (int)2, null)) {
                String string6 = $this$parseBranchSpecLine.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                branchSpecLine = new BranchSpecLine(PatternBuilder.INSTANCE.trim(string6), true);
            } else {
                branchSpecLine = new BranchSpecLine($this$parseBranchSpecLine, true);
            }
            return branchSpecLine;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lruntime/matchers/PatternHolder$RegexObj;", "Lruntime/matchers/PatternHolder;", "value", "Lkotlin/text/Regex;", "include", "", "(Lkotlin/text/Regex;Z)V", "getInclude", "()Z", "getValue", "()Lkotlin/text/Regex;", "branchRegexMatcher", "Lkotlin/Pair;", "Lruntime/matchers/PatternBuilder$PatternMatcher;", "cache", "Lruntime/matchers/PatternBuilder$Cache;", "branchRegexMatcher$platform_runtime", "normalize", "normalize$platform_runtime", "platform-runtime"})
    public static final class RegexObj
    extends PatternHolder<RegexObj> {
        @NotNull
        private final Regex value;
        private final boolean include;

        public RegexObj(@NotNull Regex value2, boolean include) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(null);
            this.value = value2;
            this.include = include;
        }

        @NotNull
        public final Regex getValue() {
            return this.value;
        }

        public final boolean getInclude() {
            return this.include;
        }

        @Override
        @NotNull
        public RegexObj normalize$platform_runtime() {
            return this;
        }

        @Override
        @NotNull
        public Pair<PatternBuilder.PatternMatcher, Boolean> branchRegexMatcher$platform_runtime(@NotNull PatternBuilder.Cache cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            return TuplesKt.to((Object)new PatternBuilder.RegexPatternMatcher(this.value), (Object)this.include);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lruntime/matchers/PatternHolder$RegexStr;", "Lruntime/matchers/PatternHolder;", "Lruntime/matchers/PatternHolder$WithRawString;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "branchRegexMatcher", "Lkotlin/Pair;", "Lruntime/matchers/PatternBuilder$PatternMatcher;", "", "cache", "Lruntime/matchers/PatternBuilder$Cache;", "branchRegexMatcher$platform_runtime", "normalize", "normalize$platform_runtime", "platform-runtime"})
    public static final class RegexStr
    extends PatternHolder<RegexStr>
    implements WithRawString {
        @NotNull
        private final String value;

        public RegexStr(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(null);
            this.value = value2;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public RegexStr normalize$platform_runtime() {
            return new RegexStr(PatternBuilder.INSTANCE.trim(this.getValue()));
        }

        @Override
        @NotNull
        public Pair<PatternBuilder.PatternMatcher, Boolean> branchRegexMatcher$platform_runtime(@NotNull PatternBuilder.Cache cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            BranchSpecLine branchSpecLine = Companion.parseBranchSpecLine(this.getValue());
            String pattern2 = branchSpecLine.component1();
            boolean include = branchSpecLine.component2();
            if (pattern2 != null) {
                PatternBuilder.PatternMatcher matcher2 = Companion.wrapCompileErrors(pattern2, true, (Function0<? extends PatternBuilder.PatternMatcher>)((Function0)new Function0<PatternBuilder.PatternMatcher>(cache2, pattern2){
                    final /* synthetic */ PatternBuilder.Cache $cache;
                    final /* synthetic */ String $pattern;
                    {
                        this.$cache = $cache;
                        this.$pattern = $pattern;
                        super(0);
                    }

                    @NotNull
                    public final PatternBuilder.PatternMatcher invoke() {
                        return new PatternBuilder.RegexPatternMatcher(this.$cache.getOrCompute(this.$pattern));
                    }
                }));
                return TuplesKt.to((Object)matcher2, (Object)include);
            }
            return TuplesKt.to(null, (Object)include);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lruntime/matchers/PatternHolder$Wildcard;", "Lruntime/matchers/PatternHolder;", "Lruntime/matchers/PatternHolder$WithRawString;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "branchRegexMatcher", "Lkotlin/Pair;", "Lruntime/matchers/PatternBuilder$PatternMatcher;", "", "cache", "Lruntime/matchers/PatternBuilder$Cache;", "branchRegexMatcher$platform_runtime", "normalize", "normalize$platform_runtime", "Companion", "platform-runtime"})
    public static final class Wildcard
    extends PatternHolder<Wildcard>
    implements WithRawString {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;

        public Wildcard(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(null);
            this.value = value2;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public Wildcard normalize$platform_runtime() {
            return new Wildcard(PatternBuilder.INSTANCE.normalize$platform_runtime(this.getValue()));
        }

        @Override
        @NotNull
        public Pair<PatternBuilder.PatternMatcher, Boolean> branchRegexMatcher$platform_runtime(@NotNull PatternBuilder.Cache cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            BranchSpecLine branchSpecLine = Companion.parseBranchSpecLine(this.getValue());
            String pattern2 = branchSpecLine.component1();
            boolean include = branchSpecLine.component2();
            if (pattern2 != null) {
                if (Intrinsics.areEqual((Object)pattern2, (Object)"*")) {
                    return TuplesKt.to((Object)PatternBuilder.INSTANCE.getTRUE$platform_runtime(), (Object)include);
                }
                if (simpleWildcardPattern.matches((CharSequence)pattern2)) {
                    PatternBuilder.PatternMatcher patternMatcher;
                    if (StringsKt.endsWith$default((String)pattern2, (String)"*", (boolean)false, (int)2, null)) {
                        String prefix = StringsKt.substring((String)pattern2, (IntRange)new IntRange(0, pattern2.length() - 2));
                        patternMatcher = new PatternBuilder.PrefixPatterMatcher(prefix);
                    } else {
                        patternMatcher = new PatternBuilder.ExactPatternMatcher(pattern2);
                    }
                    return TuplesKt.to((Object)patternMatcher, (Object)include);
                }
                PatternBuilder.PatternMatcher matcher2 = Companion.wrapCompileErrors(pattern2, true, (Function0<? extends PatternBuilder.PatternMatcher>)((Function0)new Function0<PatternBuilder.PatternMatcher>(pattern2, cache2){
                    final /* synthetic */ String $pattern;
                    final /* synthetic */ PatternBuilder.Cache $cache;
                    {
                        this.$pattern = $pattern;
                        this.$cache = $cache;
                        super(0);
                    }

                    @NotNull
                    public final PatternBuilder.PatternMatcher invoke() {
                        return new PatternBuilder.RegexPatternMatcher(Wildcard.Companion.wildcardToRegex(this.$pattern, this.$cache));
                    }
                }));
                return TuplesKt.to((Object)matcher2, (Object)include);
            }
            return TuplesKt.to(null, (Object)include);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lruntime/matchers/PatternHolder$Wildcard$Companion;", "", "()V", "wildcardToRegex", "Lkotlin/text/Regex;", "wildcard", "", "cache", "Lruntime/matchers/PatternBuilder$Cache;", "platform-runtime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Regex wildcardToRegex(@NotNull String wildcard, @NotNull PatternBuilder.Cache cache2) {
                Intrinsics.checkNotNullParameter((Object)wildcard, (String)"wildcard");
                Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
                StringBuilder regex2 = new StringBuilder();
                char[] cArray = wildcard.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                for (char c : cArray) {
                    char c2 = c;
                    if (c2 == '.') {
                        regex2.append("\\.");
                        continue;
                    }
                    if (c2 == '*') {
                        regex2.append(".*");
                        continue;
                    }
                    if (c2 == '?') {
                        regex2.append(".");
                        continue;
                    }
                    regex2.append(Regex.Companion.escape(String.valueOf(c)));
                }
                return cache2.getOrCompute("^" + regex2 + "$");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lruntime/matchers/PatternHolder$WithRawString;", "", "value", "", "getValue", "()Ljava/lang/String;", "platform-runtime"})
    public static interface WithRawString {
        @NotNull
        public String getValue();
    }
}

