/*
 * Decompiled with CFR 0.152.
 */
package platform.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.Typography;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.EmojiCommon;
import platform.common.EmojiCommonKt;
import platform.common.EmojiFormat;
import platform.common.EmojiScale;
import platform.common.EmojiSize;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u001a\b\b\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u00102\u001e\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u0010H\u0086\b\u00f8\u0001\u0000JB\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u0010J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ7\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u0004J \u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u00160\u00112\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Lplatform/common/EmojiCommon;", "", "()V", "EMOJI_HTML_DATA", "", "MD_PATTERN", "Lkotlin/text/Regex;", "getMD_PATTERN", "()Lkotlin/text/Regex;", "NAME_PATTERN", "getNAME_PATTERN", "USER_INPUT_PATTERN", "getUSER_INPUT_PATTERN", "decorate", "text", "getVariations", "Lkotlin/Function1;", "", "filterExisting", "doDecorate", "matches", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "emojiFromMarkdown", "dropVariation", "", "emojiHref", "emoji", "format", "Lplatform/common/EmojiFormat;", "size", "Lplatform/common/EmojiSize;", "scale", "Lplatform/common/EmojiScale;", "version", "", "(Ljava/lang/String;Lplatform/common/EmojiFormat;Lplatform/common/EmojiSize;Lplatform/common/EmojiScale;Ljava/lang/Long;)Ljava/lang/String;", "emojiInMarkdown", "emojiUserInput", "emojis", "findMatches", "undecorate", "platform-common"})
@SourceDebugExtension(value={"SMAP\nEmojiCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmojiCommon.kt\nplatform/common/EmojiCommon\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1137#2,3:234\n288#3,2:237\n1549#3:239\n1620#3,3:240\n*S KotlinDebug\n*F\n+ 1 EmojiCommon.kt\nplatform/common/EmojiCommon\n*L\n141#1:234,3\n158#1:237,2\n186#1:239\n186#1:240,3\n*E\n"})
public final class EmojiCommon {
    @NotNull
    public static final EmojiCommon INSTANCE = new EmojiCommon();
    @NotNull
    private static final Regex NAME_PATTERN = new Regex("[a-z0-9+\\-_]+");
    @NotNull
    private static final Regex USER_INPUT_PATTERN = new Regex(":([a-z0-9+\\-_]{1,100}):");
    @NotNull
    private static final Regex MD_PATTERN = new Regex(":" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + "([a-z0-9+\\-_:]{1,100})" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ":");
    @NotNull
    public static final String EMOJI_HTML_DATA = "data-emoji";

    private EmojiCommon() {
    }

    @NotNull
    public final String emojiHref(@NotNull String emoji, @NotNull EmojiFormat format2, @NotNull EmojiSize size2, @NotNull EmojiScale scale, @Nullable Long version) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)((Object)format2), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)size2), (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        StringBuilder $this$emojiHref_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$emojiHref_u24lambda_u240.append("/emojis/");
        $this$emojiHref_u24lambda_u240.append(format2.getStringValue());
        $this$emojiHref_u24lambda_u240.append('/');
        $this$emojiHref_u24lambda_u240.append(size2.getStringValue());
        $this$emojiHref_u24lambda_u240.append('/');
        $this$emojiHref_u24lambda_u240.append(emoji);
        $this$emojiHref_u24lambda_u240.append(scale.suffix());
        if (version != null) {
            $this$emojiHref_u24lambda_u240.append("?version=");
            $this$emojiHref_u24lambda_u240.append(version);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String emojiHref$default(EmojiCommon emojiCommon, String string2, EmojiFormat emojiFormat, EmojiSize emojiSize, EmojiScale emojiScale, Long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = null;
        }
        return emojiCommon.emojiHref(string2, emojiFormat, emojiSize, emojiScale, l);
    }

    @NotNull
    public final List<String> emojis(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)MD_PATTERN, (CharSequence)text2, (int)0, (int)2, null), (Function1)emojis.1.INSTANCE));
    }

    @NotNull
    public final String emojiUserInput(@NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        return ":" + emoji + ":";
    }

    @NotNull
    public final String emojiInMarkdown(@NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        return ":" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + emoji + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ":";
    }

    @NotNull
    public final String emojiFromMarkdown(@NotNull String text2, boolean dropVariation) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{':', EmojiCommonKt.getZwsp(Typography.INSTANCE)};
        String result2 = StringsKt.trim((String)text2, (char[])cArray);
        return !dropVariation ? result2 : StringsKt.substringBefore$default((String)result2, (String)"::", null, (int)2, null);
    }

    public static /* synthetic */ String emojiFromMarkdown$default(EmojiCommon emojiCommon, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return emojiCommon.emojiFromMarkdown(string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, IntRange>> findMatches(@NotNull String text2) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                MatchResult it = (MatchResult)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRange().getFirst());
                it = (MatchResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getFirst()));
            }
        };
        comparator = SequencesKt.sortedWith((Sequence)Regex.findAll$default((Regex)USER_INPUT_PATTERN, (CharSequence)text2, (int)0, (int)2, null), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    MatchResult it = (MatchResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRange().getLast() - it.getRange().getFirst());
                    it = (MatchResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getLast() - it.getRange().getFirst()));
                }
                return n;
            }
        });
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void match2;
            MatchResult matchResult = (MatchResult)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            char[] cArray = new char[]{':'};
            collection.add(TuplesKt.to((Object)StringsKt.trim((String)match2.getValue(), (char[])cArray), (Object)match2.getRange()));
        }
        return (List)var3_3;
    }

    @NotNull
    public final String doDecorate(@NotNull String text2, @NotNull List<Pair<String, IntRange>> matches2, @NotNull Function1<? super String, ? extends List<String>> getVariations) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(matches2, (String)"matches");
        Intrinsics.checkNotNullParameter(getVariations, (String)"getVariations");
        int leftBorder = -1;
        Set rangesToRemove = new LinkedHashSet();
        int n = matches2.size();
        for (int i = 0; i < n; ++i) {
            Object v0;
            IntRange range3;
            String emoji;
            block6: {
                emoji = (String)matches2.get(i).getFirst();
                range3 = (IntRange)matches2.get(i).getSecond();
                if (range3.getFirst() <= leftBorder) {
                    ((Collection)rangesToRemove).add(matches2.get(i));
                    continue;
                }
                leftBorder = range3.getLast();
                List variations = CollectionsKt.sortedDescending((Iterable)((Iterable)getVariations.invoke((Object)emoji)));
                Iterable $this$firstOrNull$iv = variations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String variation = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)text2, (String)(":" + variation + ":"), (int)(range3.getLast() + 1), (boolean)false, (int)4, null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            String variation = v0;
            if (variation == null) continue;
            IntRange newRange = new IntRange(range3.getFirst(), range3.getLast() + variation.length() + 2);
            matches2.set(i, (Pair<String, IntRange>)TuplesKt.to((Object)(emoji + "::" + variation), (Object)newRange));
            leftBorder = newRange.getLast();
        }
        matches2.removeAll(rangesToRemove);
        StringBuilder out = new StringBuilder();
        int lastCut = -1;
        for (Pair<String, IntRange> pair : matches2) {
            String emoji = (String)pair.component1();
            IntRange range4 = (IntRange)pair.component2();
            IntRange r = RangesKt.until((int)(lastCut + 1), (int)range4.getFirst());
            if (!r.isEmpty()) {
                out.append(StringsKt.substring((String)text2, (IntRange)r));
            }
            out.append(this.emojiInMarkdown(emoji));
            lastCut = range4.getLast();
        }
        if (lastCut + 1 < text2.length()) {
            String string2 = text2.substring(lastCut + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            out.append(string2);
        }
        String string3 = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"out.toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String decorate(@NotNull String text2, @NotNull Function1<? super String, ? extends List<String>> getVariations, @NotNull Function1<? super List<String>, ? extends List<String>> filterExisting2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(getVariations, (String)"getVariations");
        Intrinsics.checkNotNullParameter(filterExisting2, (String)"filterExisting");
        boolean $i$f$decorate = false;
        List matches2 = CollectionsKt.toMutableList((Collection)this.findMatches(text2));
        Iterable iterable = matches2;
        Function1<? super List<String>, ? extends List<String>> function1 = filterExisting2;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        Set existing = CollectionsKt.toSet((Iterable)((Iterable)function1.invoke((Object)((List)destination$iv$iv))));
        CollectionsKt.removeAll((List)matches2, (Function1)((Function1)new Function1<Pair<? extends String, ? extends IntRange>, Boolean>((Set<String>)existing){
            final /* synthetic */ Set<String> $existing;
            {
                this.$existing = $existing;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, IntRange> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return !this.$existing.contains(it.getFirst());
            }
        }));
        return this.doDecorate(text2, matches2, getVariations);
    }

    @NotNull
    public final String undecorate(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.replace$default((String)text2, (String)String.valueOf(EmojiCommonKt.getZwsp(Typography.INSTANCE)), (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Regex getNAME_PATTERN() {
        return NAME_PATTERN;
    }

    @NotNull
    public final Regex getUSER_INPUT_PATTERN() {
        return USER_INPUT_PATTERN;
    }

    @NotNull
    public final Regex getMD_PATTERN() {
        return MD_PATTERN;
    }
}

