/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.version.MavenTimedSnapshotVersionMatcher;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IBiblioResolver
extends URLResolver {
    private static final String M2_PER_MODULE_PATTERN = "[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private static final String M2_PATTERN = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
    @Deprecated
    public static final String DEFAULT_PATTERN = "[module]/[type]s/[artifact]-[revision].[ext]";
    @Deprecated
    public static final String DEFAULT_ROOT = "https://www.ibiblio.org/maven/";
    public static final String DEFAULT_M2_ROOT = "https://repo1.maven.org/maven2/";
    private String root = null;
    private String pattern = null;
    private boolean usepoms = true;
    private boolean useMavenMetadata = true;

    public IBiblioResolver() {
        this.setChangingMatcher("regexp");
        this.setChangingPattern(".*-SNAPSHOT");
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data2) {
        ResolvedResource rres;
        if (!this.isM2compatible() || !this.isUsepoms()) {
            return null;
        }
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        mrid = this.convertM2IdForResourceSearch(mrid);
        String revision = dd.getDependencyRevisionId().getRevision();
        MavenTimedSnapshotVersionMatcher.MavenSnapshotRevision snapshotRevision = MavenTimedSnapshotVersionMatcher.computeIfSnapshot(revision);
        if (snapshotRevision != null && (rres = this.findSnapshotDescriptor(dd, data2, mrid, snapshotRevision)) != null) {
            return rres;
        }
        return this.findResourceUsingPatterns(mrid, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(mrid, data2.getDate()), this.getRMDParser(dd, data2), data2.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date2) {
        ResolvedResource rres;
        String revision;
        MavenTimedSnapshotVersionMatcher.MavenSnapshotRevision snapshotRevision;
        this.ensureConfigured(this.getSettings());
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        if ((snapshotRevision = MavenTimedSnapshotVersionMatcher.computeIfSnapshot(revision = artifact.getId().getRevision())) != null && (rres = this.findSnapshotArtifact(artifact, date2, mrid, snapshotRevision)) != null) {
            return rres;
        }
        return this.findResourceUsingPatterns(mrid, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date2);
    }

    private ResolvedResource findSnapshotArtifact(Artifact artifact, Date date2, ModuleRevisionId mrid, MavenTimedSnapshotVersionMatcher.MavenSnapshotRevision snapshotRevision) {
        String snapshotArtifactPattern;
        if (!this.isM2compatible()) {
            return null;
        }
        if (snapshotRevision.isTimestampedSnapshot()) {
            Message.debug(mrid + " has been identified as a (Maven) timestamped snapshot revision");
            String inferredSnapshotRevision = snapshotRevision.getBaseRevision() + "-SNAPSHOT";
            snapshotArtifactPattern = this.getWholePattern().replaceFirst("/\\[revision\\]", "/" + inferredSnapshotRevision);
        } else {
            String timestampedRev = this.findTimestampedSnapshotVersion(mrid);
            if (timestampedRev == null) {
                return null;
            }
            Message.verbose(mrid + " has been identified as a snapshot revision which has a timestamped snapshot revision " + timestampedRev);
            snapshotArtifactPattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + timestampedRev);
        }
        return this.findResourceUsingPattern(mrid, snapshotArtifactPattern, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date2);
    }

    private ResolvedResource findSnapshotDescriptor(DependencyDescriptor dd, ResolveData data2, ModuleRevisionId mrid, MavenTimedSnapshotVersionMatcher.MavenSnapshotRevision snapshotRevision) {
        String snapshotDescriptorPattern;
        if (!this.isM2compatible()) {
            return null;
        }
        if (snapshotRevision.isTimestampedSnapshot()) {
            Message.debug(mrid + " has been identified as a (Maven) timestamped snapshot revision");
            String inferredSnapshotRevision = snapshotRevision.getBaseRevision() + "-SNAPSHOT";
            snapshotDescriptorPattern = this.getWholePattern().replaceFirst("/\\[revision\\]", "/" + inferredSnapshotRevision);
        } else {
            String timestampedRev = this.findTimestampedSnapshotVersion(mrid);
            if (timestampedRev == null) {
                return null;
            }
            Message.verbose(mrid + " has been identified as a snapshot revision which has a timestamped snapshot revision " + timestampedRev);
            snapshotDescriptorPattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + timestampedRev);
        }
        return this.findResourceUsingPattern(mrid, snapshotDescriptorPattern, DefaultArtifact.newPomArtifact(mrid, data2.getDate()), this.getRMDParser(dd, data2), data2.getDate());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findTimestampedSnapshotVersion(ModuleRevisionId mrid) {
        if (!this.isM2compatible()) {
            return null;
        }
        if (!this.shouldUseMavenMetadata(this.getWholePattern())) {
            return null;
        }
        try {
            String metadataLocation = IvyPatternHelper.substitute(this.root + "[organisation]/[module]/[revision]/maven-metadata.xml", mrid);
            Resource metadata = this.getRepository().getResource(metadataLocation);
            if (!metadata.exists()) {
                Message.verbose("\tmaven-metadata not available for: " + mrid);
                return null;
            }
            try (InputStream metadataStream = metadata.openStream();){
                final StringBuilder timestamp = new StringBuilder();
                final StringBuilder buildNumber = new StringBuilder();
                XMLHelper.parse(metadataStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                            timestamp.append(this.getText());
                        }
                        if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                            buildNumber.append(this.getText());
                        }
                        super.endElement(uri, localName, qName);
                    }
                }, null);
                if (timestamp.length() <= 0) return null;
                String rev = mrid.getRevision();
                rev = rev.substring(0, rev.length() - "SNAPSHOT".length());
                String string2 = rev = rev + timestamp.toString() + "-" + buildNumber.toString();
                return string2;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Message.debug("impossible to access maven metadata file, ignored", e);
        }
        return null;
    }

    @Override
    public void setM2compatible(boolean m2compatible) {
        super.setM2compatible(m2compatible);
        if (m2compatible) {
            if (this.root == null) {
                this.root = DEFAULT_M2_ROOT;
            }
            if (this.pattern == null) {
                this.pattern = M2_PATTERN;
            }
            this.updateWholePattern();
        }
    }

    public void ensureConfigured(ResolverSettings settings2) {
        if (settings2 != null && (this.root == null || this.pattern == null)) {
            if (this.root == null) {
                String root2 = settings2.getVariable("ivy.ibiblio.default.artifact.root");
                if (root2 != null) {
                    this.root = root2;
                } else {
                    settings2.configureRepositories(true);
                    this.root = settings2.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this.pattern == null) {
                String pattern2 = settings2.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (pattern2 != null) {
                    this.pattern = pattern2;
                } else {
                    settings2.configureRepositories(false);
                    this.pattern = settings2.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    @Override
    protected String getModuleDescriptorExtension() {
        return "pom";
    }

    private String getWholePattern() {
        return this.root + this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern2) {
        if (pattern2 == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.pattern = pattern2;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root2) {
        if (root2 == null) {
            throw new NullPointerException("root must not be null");
        }
        this.root = !root2.endsWith("/") ? root2 + "/" : root2;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.isUsepoms()) {
            this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        } else {
            this.setIvyPatterns(Collections.emptyList());
        }
        this.setArtifactPatterns(Collections.singletonList(this.getWholePattern()));
    }

    public void publish(Artifact artifact, File src) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    @Override
    public String[] listTokenValues(String token2, Map<String, String> otherTokenValues) {
        if ("organisation".equals(token2)) {
            return new String[0];
        }
        if ("module".equals(token2) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        return super.listTokenValues(token2, otherTokenValues);
    }

    @Override
    protected String[] listTokenValues(String pattern2, String token2) {
        if ("organisation".equals(token2)) {
            return new String[0];
        }
        if ("module".equals(token2) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        if ("revision".equals(token2) && this.shouldUseMavenMetadata(this.getWholePattern())) {
            String partiallyResolvedM2PerModulePattern = IvyPatternHelper.substituteTokens(M2_PER_MODULE_PATTERN, Collections.singletonMap("ext", "pom"));
            if (pattern2.endsWith(partiallyResolvedM2PerModulePattern)) {
                String metadataLocation = pattern2.substring(0, pattern2.lastIndexOf(partiallyResolvedM2PerModulePattern)) + "maven-metadata.xml";
                List<String> revs = this.listRevisionsWithMavenMetadata(this.getRepository(), metadataLocation);
                if (revs != null) {
                    return revs.toArray(new String[revs.size()]);
                }
            } else {
                return new String[0];
            }
        }
        return super.listTokenValues(pattern2, token2);
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry org) {
        if (this.isM2compatible()) {
            this.ensureConfigured(this.getSettings());
            return super.listModules(org);
        }
        return new ModuleEntry[0];
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        this.ensureConfigured(this.getSettings());
        return super.listRevisions(mod);
    }

    @Override
    protected ResolvedResource[] listResources(Repository repository2, ModuleRevisionId mrid, String pattern2, Artifact artifact) {
        if (this.shouldUseMavenMetadata(pattern2)) {
            List<String> revs = this.listRevisionsWithMavenMetadata(repository2, mrid.getModuleId().getAttributes());
            if (revs != null) {
                Message.debug("\tfound revs: " + revs);
                ArrayList<ResolvedResource> rres = new ArrayList<ResolvedResource>();
                for (String rev : revs) {
                    String snapshotVersion;
                    ModuleRevisionId historicalMrid = ModuleRevisionId.newInstance(mrid, rev);
                    String patternForRev = pattern2;
                    if (rev.endsWith("SNAPSHOT") && (snapshotVersion = this.findTimestampedSnapshotVersion(historicalMrid)) != null) {
                        patternForRev = pattern2.replaceFirst("\\-\\[revision\\]", "-" + snapshotVersion);
                    }
                    String resolvedPattern = IvyPatternHelper.substitute(patternForRev, historicalMrid, artifact);
                    try {
                        Resource res = repository2.getResource(resolvedPattern);
                        if (res == null) continue;
                        rres.add(new ResolvedResource(res, rev));
                    }
                    catch (IOException e) {
                        Message.warn("impossible to get resource from name listed by maven-metadata.xml:" + rres, e);
                    }
                }
                return rres.toArray(new ResolvedResource[rres.size()]);
            }
            return super.listResources(repository2, mrid, pattern2, artifact);
        }
        return super.listResources(repository2, mrid, pattern2, artifact);
    }

    private List<String> listRevisionsWithMavenMetadata(Repository repository2, Map<String, String> tokenValues) {
        String metadataLocation = IvyPatternHelper.substituteTokens(this.root + "[organisation]/[module]/maven-metadata.xml", tokenValues);
        return this.listRevisionsWithMavenMetadata(repository2, metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listRevisionsWithMavenMetadata(Repository repository2, String metadataLocation) {
        ArrayList revs = null;
        InputStream metadataStream = null;
        try {
            Resource metadata = repository2.getResource(metadataLocation);
            if (metadata.exists()) {
                Message.verbose("\tlisting revisions from maven-metadata: " + metadata);
                final ArrayList metadataRevs = new ArrayList();
                metadataStream = metadata.openStream();
                XMLHelper.parse(metadataStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("metadata/versioning/versions/version".equals(this.getContext())) {
                            metadataRevs.add(this.getText().trim());
                        }
                        super.endElement(uri, localName, qName);
                    }
                }, null);
                revs = metadataRevs;
            } else {
                Message.verbose("\tmaven-metadata not available: " + metadata);
            }
        }
        catch (IOException e) {
            Message.verbose("impossible to access maven metadata file, ignored", e);
        }
        catch (ParserConfigurationException | SAXException e) {
            Message.verbose("impossible to parse maven metadata file, ignored", e);
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (IOException e) {}
            }
        }
        return revs;
    }

    @Override
    protected void findTokenValues(Collection<String> names2, List<String> patterns, Map<String, String> tokenValues, String token2) {
        List<String> revs;
        if ("revision".equals(token2) && this.shouldUseMavenMetadata(this.getWholePattern()) && (revs = this.listRevisionsWithMavenMetadata(this.getRepository(), tokenValues)) != null) {
            names2.addAll(this.filterNames(revs));
            return;
        }
        super.findTokenValues(names2, patterns, tokenValues, token2);
    }

    private boolean shouldUseMavenMetadata(String pattern2) {
        return this.isUseMavenMetadata() && this.isM2compatible() && pattern2.endsWith(M2_PATTERN);
    }

    @Override
    public String getTypeName() {
        return "ibiblio";
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data2) throws ParseException {
        this.ensureConfigured(data2.getSettings());
        return super.getDependency(dd, data2);
    }

    @Override
    public DownloadReport download(Artifact[] artifacts, DownloadOptions options2) {
        this.ensureConfigured(this.getSettings());
        return super.download(artifacts, options2);
    }

    @Override
    public boolean exists(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.exists(artifact);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.locate(artifact);
    }

    @Override
    public List<String> getArtifactPatterns() {
        this.ensureConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }

    public boolean isUsepoms() {
        return this.usepoms;
    }

    public void setUsepoms(boolean usepoms) {
        this.usepoms = usepoms;
        this.updateWholePattern();
    }

    public boolean isUseMavenMetadata() {
        return this.useMavenMetadata;
    }

    public void setUseMavenMetadata(boolean useMavenMetadata) {
        this.useMavenMetadata = useMavenMetadata;
    }

    @Override
    public void dumpSettings() {
        this.ensureConfigured(this.getSettings());
        super.dumpSettings();
        Message.debug("\t\troot: " + this.getRoot());
        Message.debug("\t\tpattern: " + this.getPattern());
        Message.debug("\t\tusepoms: " + this.usepoms);
        Message.debug("\t\tuseMavenMetadata: " + this.useMavenMetadata);
    }
}

