/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class SearchEngine {
    private IvySettings settings;

    public SearchEngine(IvySettings settings2) {
        this.settings = settings2;
    }

    public String[] listTokenValues(String token2, Map<String, Object> otherTokenValues) {
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] values2;
            for (Map<String, String> value2 : values2 = resolver2.listTokenValues(new String[]{token2}, otherTokenValues)) {
                entries.add(value2.get(token2));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        HashSet<OrganisationEntry> entries = new HashSet<OrganisationEntry>();
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] orgs;
            for (Map<String, String> oe : orgs = resolver2.listTokenValues(new String[]{"organisation"}, new HashMap<String, Object>())) {
                String org = oe.get("organisation");
                entries.add(new OrganisationEntry(resolver2, org));
            }
        }
        return entries.toArray(new OrganisationEntry[entries.size()]);
    }

    public String[] listOrganisations() {
        HashSet<String> entries = new HashSet<String>();
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] orgs;
            for (Map<String, String> org : orgs = resolver2.listTokenValues(new String[]{"organisation"}, new HashMap<String, Object>())) {
                entries.add(org.get("organisation"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry org) {
        HashSet<ModuleEntry> entries = new HashSet<ModuleEntry>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org.getOrganisation());
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] modules;
            for (Map<String, String> me2 : modules = resolver2.listTokenValues(new String[]{"module"}, tokenValues)) {
                String module2 = me2.get("module");
                entries.add(new ModuleEntry(org, module2));
            }
        }
        return entries.toArray(new ModuleEntry[entries.size()]);
    }

    public String[] listModules(String org) {
        HashSet<String> entries = new HashSet<String>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org);
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] modules;
            for (Map<String, String> module2 : modules = resolver2.listTokenValues(new String[]{"module"}, tokenValues)) {
                entries.add(module2.get("module"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry module2) {
        HashSet<RevisionEntry> entries = new HashSet<RevisionEntry>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", module2.getOrganisation());
        tokenValues.put("module", module2.getModule());
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] revisions;
            for (Map<String, String> revision : revisions = resolver2.listTokenValues(new String[]{"revision"}, tokenValues)) {
                entries.add(new RevisionEntry(module2, revision.get("revision")));
            }
        }
        return entries.toArray(new RevisionEntry[entries.size()]);
    }

    public String[] listRevisions(String org, String module2) {
        HashSet<String> entries = new HashSet<String>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org);
        tokenValues.put("module", module2);
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] revisions;
            for (Map<String, String> revision : revisions = resolver2.listTokenValues(new String[]{"revision"}, tokenValues)) {
                entries.add(revision.get("revision"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleId[] listModules(ModuleId moduleCrit, PatternMatcher matcher2) {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        this.addMatcher(matcher2, moduleCrit.getOrganisation(), criteria, "organisation");
        this.addMatcher(matcher2, moduleCrit.getName(), criteria, "module");
        String[] tokensToList = new String[]{"organisation", "module"};
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] moduleIdAsMap;
            for (Map<String, String> moduleId : moduleIdAsMap = resolver2.listTokenValues(tokensToList, criteria)) {
                String org = moduleId.get("organisation");
                String name2 = moduleId.get("module");
                ModuleId modId = ModuleId.newInstance(org, name2);
                ret.add(NameSpaceHelper.transform(modId, resolver2.getNamespace().getToSystemTransformer()));
            }
        }
        return ret.toArray(new ModuleId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId moduleCrit, PatternMatcher matcher2) {
        ArrayList<ModuleRevisionId> ret = new ArrayList<ModuleRevisionId>();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher2, entry.getValue(), criteria, entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        for (DependencyResolver resolver2 : this.settings.getResolvers()) {
            Map<String, String>[] moduleIdAsMap;
            for (Map<String, String> moduleId : moduleIdAsMap = resolver2.listTokenValues(tokensToList, criteria)) {
                String org = moduleId.get("organisation");
                String name2 = moduleId.get("module");
                String branch2 = moduleId.get("branch");
                String rev = moduleId.get("revision");
                HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
                for (String qualifiedKey : moduleCrit.getQualifiedExtraAttributes().keySet()) {
                    String value2 = null;
                    int colonIndex = qualifiedKey.indexOf(58);
                    value2 = colonIndex == -1 ? moduleId.get(qualifiedKey) : moduleId.get(qualifiedKey.substring(colonIndex + 1));
                    if (value2 == null) continue;
                    foundExtraAtts.put(qualifiedKey, value2);
                }
                ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name2, branch2, rev, foundExtraAtts);
                ret.add(resolver2.getNamespace().getToSystemTransformer().transform(modRevId));
            }
        }
        return ret.toArray(new ModuleRevisionId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(DependencyResolver resolver2, ModuleRevisionId moduleCrit, PatternMatcher matcher2) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher2, entry.getValue(), criteria, entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        Map<String, String>[] moduleIdAsMap = resolver2.listTokenValues(tokensToList, criteria);
        LinkedHashSet<ModuleRevisionId> result2 = new LinkedHashSet<ModuleRevisionId>();
        for (Map<String, String> moduleId : moduleIdAsMap) {
            String org = moduleId.get("organisation");
            String name2 = moduleId.get("module");
            String branch2 = moduleId.get("branch");
            String rev = moduleId.get("revision");
            HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
            for (String qualifiedKey : moduleCrit.getQualifiedExtraAttributes().keySet()) {
                String value2 = null;
                int colonIndex = qualifiedKey.indexOf(58);
                value2 = colonIndex == -1 ? moduleId.get(qualifiedKey) : moduleId.get(qualifiedKey.substring(colonIndex + 1));
                if (value2 == null) continue;
                foundExtraAtts.put(qualifiedKey, value2);
            }
            ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name2, branch2, rev, foundExtraAtts);
            result2.add(resolver2.getNamespace().getToSystemTransformer().transform(modRevId));
        }
        return result2.toArray(new ModuleRevisionId[result2.size()]);
    }

    private void addMatcher(PatternMatcher patternMatcher, String expression2, Map<String, Object> criteria, String key2) {
        if (expression2 == null) {
            return;
        }
        Matcher matcher2 = patternMatcher.getMatcher(expression2);
        if (matcher2.isExact()) {
            criteria.put(key2, expression2);
        } else {
            criteria.put(key2, matcher2);
        }
    }

    public Collection<ModuleRevisionId> findModuleRevisionIds(DependencyResolver resolver2, ModuleRevisionId pattern2, PatternMatcher matcher2) {
        ArrayList<ModuleRevisionId> mrids = new ArrayList<ModuleRevisionId>();
        String resolverName = resolver2.getName();
        Message.verbose("looking for modules matching " + pattern2 + " using " + matcher2.getName());
        Namespace fromNamespace = null;
        if (resolver2 instanceof AbstractResolver) {
            fromNamespace = resolver2.getNamespace();
        }
        ArrayList<ModuleEntry> modules = new ArrayList<ModuleEntry>();
        OrganisationEntry[] orgs = resolver2.listOrganisations();
        if (orgs == null || orgs.length == 0) {
            String org = pattern2.getOrganisation();
            if (fromNamespace != null) {
                org = NameSpaceHelper.transform(pattern2.getModuleId(), fromNamespace.getFromSystemTransformer()).getOrganisation();
            }
            modules.addAll(Arrays.asList(resolver2.listModules(new OrganisationEntry(resolver2, org))));
        } else {
            Matcher orgMatcher = matcher2.getMatcher(pattern2.getOrganisation());
            for (OrganisationEntry oe : orgs) {
                String systemOrg;
                String org = oe.getOrganisation();
                String string2 = systemOrg = fromNamespace == null ? org : NameSpaceHelper.transformOrganisation(org, fromNamespace.getToSystemTransformer());
                if (!orgMatcher.matches(systemOrg)) continue;
                modules.addAll(Arrays.asList(resolver2.listModules(new OrganisationEntry(resolver2, org))));
            }
        }
        Message.debug("found " + modules.size() + " modules for " + pattern2.getOrganisation() + " on " + resolverName);
        boolean foundModule = false;
        for (ModuleEntry mEntry : modules) {
            ModuleId foundMid;
            ModuleId systemMid = foundMid = new ModuleId(mEntry.getOrganisation(), mEntry.getModule());
            if (fromNamespace != null) {
                systemMid = NameSpaceHelper.transform(foundMid, fromNamespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(matcher2, pattern2.getModuleId(), systemMid)) continue;
            foundModule = true;
            RevisionEntry[] rEntries = resolver2.listRevisions(mEntry);
            Message.debug("found " + rEntries.length + " revisions for [" + mEntry.getOrganisation() + ", " + mEntry.getModule() + "] on " + resolverName);
            boolean foundRevision = false;
            for (RevisionEntry rEntry : rEntries) {
                ModuleRevisionId foundMrid;
                ModuleRevisionId systemMrid = foundMrid = ModuleRevisionId.newInstance(mEntry.getOrganisation(), mEntry.getModule(), rEntry.getRevision());
                if (fromNamespace != null) {
                    systemMrid = fromNamespace.getToSystemTransformer().transform(foundMrid);
                }
                if (!MatcherHelper.matches(matcher2, pattern2, systemMrid)) continue;
                foundRevision = true;
                mrids.add(systemMrid);
            }
            if (foundRevision) continue;
            Message.debug("no revision found matching " + pattern2 + " in [" + mEntry.getOrganisation() + "," + mEntry.getModule() + "] using " + resolverName);
        }
        if (!foundModule) {
            Message.debug("no module found matching " + pattern2 + " using " + resolverName);
        }
        return mrids;
    }
}

