/*
 * Decompiled with CFR 0.152.
 */
package libraries.klogging;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerFactory;
import libraries.klogging.KLoggerStaticFactoryKt;
import libraries.klogging.ShutdownListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0012j\u0002`\u0013H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llibraries/klogging/KLoggerStaticFactory;", "Llibraries/klogging/KLoggerFactory;", "()V", "customFactory", "getCustomFactory", "()Llibraries/klogging/KLoggerFactory;", "setCustomFactory", "(Llibraries/klogging/KLoggerFactory;)V", "shutdownListener", "Llibraries/klogging/ShutdownListener;", "logger", "Llibraries/klogging/KLogger;", "owner", "", "name", "", "Lkotlin/reflect/KClass;", "nameSource", "Lkotlin/Function0;", "Llibraries/klogging/LoggerNameSource;", "libraries-klogging"})
public final class KLoggerStaticFactory
implements KLoggerFactory {
    @NotNull
    public static final KLoggerStaticFactory INSTANCE = new KLoggerStaticFactory();
    @NotNull
    private static final ShutdownListener shutdownListener = ShutdownListener.INSTANCE;
    @Nullable
    private static KLoggerFactory customFactory;

    private KLoggerStaticFactory() {
    }

    @Nullable
    public final KLoggerFactory getCustomFactory() {
        return customFactory;
    }

    public final void setCustomFactory(@Nullable KLoggerFactory kLoggerFactory) {
        customFactory = kLoggerFactory;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = customFactory;
        if (object == null || (object = object.logger(name2)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(name2);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(owner);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        Object object = customFactory;
        if (object == null || (object = object.logger(nameSource)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(KLoggerStaticFactoryKt.loggerNameFromSource(nameSource));
        }
        return object;
    }
}

