/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.ui.header;

import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.chat.model.impl.SpaceChatReviewHeaderDetails;
import com.intellij.space.vcs.chat.ui.issues.IssueIdsProcessorKt;
import com.intellij.space.vcs.review.HtmlEditorPane;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\nH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/intellij/space/vcs/chat/ui/header/SpaceChatReviewHeaderComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "details", "Lcom/intellij/space/vcs/chat/model/impl/SpaceChatReviewHeaderDetails;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/space/vcs/chat/model/impl/SpaceChatReviewHeaderDetails;)V", "getHeaderHtml", "", "title", "reviewKey", "reviewUrl", "intellij.space.vcs"})
public final class SpaceChatReviewHeaderComponent
extends JPanel {
    /*
     * WARNING - void declaration
     */
    public SpaceChatReviewHeaderComponent(final @NotNull Project project2, @NotNull CoroutineScope cs, final @NotNull SpaceChatReviewHeaderDetails details) {
        void $this$_init__u24lambda_u240;
        MigLayout migLayout;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.setOpaque(false);
        MigLayout migLayout2 = migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
        SpaceChatReviewHeaderComponent spaceChatReviewHeaderComponent = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setColumnConstraints((Object)"[][]");
        spaceChatReviewHeaderComponent.setLayout((LayoutManager)migLayout);
        final HtmlEditorPane headerContent = new HtmlEditorPane();
        this.add((Component)((Object)headerContent), new CC().pushX().alignY("center"));
        details.getTitle().forEach(UtilitiesKt.nestedLifetime(cs), (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String newTitle) {
                Intrinsics.checkNotNullParameter((Object)newTitle, (String)"newTitle");
                HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)((JEditorPane)((Object)headerContent)), (String)this.getHeaderHtml(IssueIdsProcessorKt.processIssueIdsHtml(project2, newTitle), details.getReviewKey(), details.getReviewUrl()));
            }
        }));
    }

    @Nls
    private final String getHeaderHtml(@Nls String title2, @NlsSafe String reviewKey, @NlsSafe String reviewUrl) {
        HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.span((String)"font-size: 150%").addRaw(title2).addRaw(HtmlChunk.nbsp().toString()));
        if (reviewKey != null) {
            String string2 = reviewUrl != null ? HtmlChunk.link((String)reviewUrl, (String)reviewKey).toString() : reviewKey;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (reviewUrl != null) {\u2026        reviewKey\n      }");
            String link = string2;
            HtmlChunk.Element element = HtmlChunk.span((String)("color: " + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()) + ";font-size: 120%;")).addRaw(link);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"span(\n        \"color: ${\u2026ize: 120%;\").addRaw(link)");
            HtmlChunk.Element linkElement = element;
            builder.append((HtmlChunk)linkElement);
        }
        String string3 = builder.wrapWith("b").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"builder.wrapWith(\"b\").toString()");
        return string3;
    }
}

