/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.web.flow.neww;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.web.flow.neww.CallbackAction;
import com.intellij.space.gateway.web.flow.neww.ConnectionStage;
import com.intellij.space.gateway.web.flow.neww.SpaceOpenInIdeConnectionHandle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.gateway.api.CustomConnectionFrameContext;
import com.jetbrains.gateway.connectionFrame.TrayIconHelper;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerExJvmKt;
import libraries.klogging.KLoggers;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame;", "Lcom/intellij/openapi/Disposable;", "handle", "Lcom/intellij/space/gateway/web/flow/neww/SpaceOpenInIdeConnectionHandle;", "(Lcom/intellij/space/gateway/web/flow/neww/SpaceOpenInIdeConnectionHandle;)V", "dialog", "Lcom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame$SpaceConnectionDialog;", "handleTitle", "", "trayIcon", "Ljava/awt/TrayIcon;", "trayIconInstalled", "", "disconnect", "", "dispose", "hideToTray", "openGateway", "openGatewayOrDialog", "openGatewayOrHide", "removeTrayIcon", "setupTrayIcon", "Companion", "SpaceConnectionDialog", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceConnectionFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n+ 3 KLoggerEx.kt\nlibraries/klogging/KLoggerExKt\n+ 4 KLoggerExJvm.kt\nlibraries/klogging/KLoggerExJvmKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n18#2:202\n18#2:230\n17#3:203\n105#3,9:204\n114#3,3:214\n117#3,4:220\n18#3,6:224\n17#3:231\n105#3,9:232\n114#3,3:242\n117#3,4:248\n18#3,6:252\n7#4:213\n7#4:241\n1747#5,3:217\n1747#5,3:245\n*S KotlinDebug\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame\n*L\n93#1:202\n103#1:230\n93#1:203\n93#1:204,9\n93#1:214,3\n93#1:220,4\n93#1:224,6\n103#1:231\n103#1:232,9\n103#1:242,3\n103#1:248,4\n103#1:252,6\n93#1:213\n103#1:241\n93#1:217,3\n103#1:245,3\n*E\n"})
public final class SpaceConnectionFrame
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpaceOpenInIdeConnectionHandle handle;
    @NotNull
    private final String handleTitle;
    @Nullable
    private final TrayIcon trayIcon;
    private boolean trayIconInstalled;
    @Nullable
    private SpaceConnectionDialog dialog;

    public SpaceConnectionFrame(@NotNull SpaceOpenInIdeConnectionHandle handle) {
        Intrinsics.checkNotNullParameter((Object)((Object)handle), (String)"handle");
        this.handle = handle;
        this.handleTitle = this.handle.getTitle();
        this.trayIcon = TrayIconHelper.INSTANCE.create(this.handleTitle, (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                SpaceConnectionFrame.access$openGatewayOrDialog((SpaceConnectionFrame)this.receiver);
            }
        }, (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                SpaceConnectionFrame.access$disconnect((SpaceConnectionFrame)this.receiver);
            }
        });
        this.dialog = new SpaceConnectionDialog();
        Disposer.register((Disposable)((Disposable)ApplicationKt.getApplication()), (Disposable)this);
        this.handle.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                Disposer.dispose((Disposable)this);
            }
        });
    }

    private final void disconnect() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.removeTrayIcon();
        this.handle.terminate();
        SpaceConnectionDialog spaceConnectionDialog = this.dialog;
        if (spaceConnectionDialog != null) {
            spaceConnectionDialog.close(0);
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void openGatewayOrDialog() {
        this.removeTrayIcon();
        if (Intrinsics.areEqual((Object)this.handle.stage(), (Object)ConnectionStage.Connected.INSTANCE)) {
            this.openGateway();
        } else {
            this.dialog = new SpaceConnectionDialog();
        }
    }

    private final void openGatewayOrHide() {
        if (this.handle.stage() instanceof ConnectionStage.Failed) {
            this.openGateway();
        } else {
            this.hideToTray();
        }
    }

    private final void openGateway() {
        SpaceConnectionDialog spaceConnectionDialog = this.dialog;
        if (spaceConnectionDialog != null) {
            spaceConnectionDialog.close(0);
        }
        WelcomeFrame.Companion.showIfNoProjectOpened$default((WelcomeFrame.Companion)WelcomeFrame.Companion, null, (int)1, null);
    }

    private final void hideToTray() {
        block0: {
            this.setupTrayIcon();
            SpaceConnectionDialog spaceConnectionDialog = this.dialog;
            if (spaceConnectionDialog == null) break block0;
            spaceConnectionDialog.close(0);
        }
    }

    private final void setupTrayIcon() {
        if (this.trayIconInstalled) {
            return;
        }
        if (this.trayIcon == null) {
            return;
        }
        this.trayIconInstalled = true;
        ApplicationKt.getApplication().assertIsDispatchThread();
        SpaceConnectionFrame $this$logger$iv = this;
        boolean $i$f$logger = false;
        KLogger $this$catch$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceConnectionFrame.class));
        boolean $i$f$catch = false;
        KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
        List except$iv$iv = CollectionsKt.emptyList();
        boolean $i$f$internalCatch = false;
        try {
            boolean bl = false;
            SystemTray.getSystemTray().add(this.trayIcon);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable th$iv$iv) {
            boolean bl;
            block11: {
                boolean $i$f$isCancellationException = false;
                if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                    throw th$iv$iv;
                }
                Iterable $this$any$iv$iv$iv = except$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                        KClass it$iv$iv = (KClass)element$iv$iv$iv;
                        boolean bl2 = false;
                        if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw th$iv$iv;
            }
            Throwable throwable = th$iv$iv;
            KLogger $this$catch_u24lambda_u240$iv = $this$internalCatch_u24default$iv$iv;
            boolean bl3 = false;
            if (KLoggerExJvmKt.isShutdownInProgress()) {
                BaseLogger.DefaultImpls.warn$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
            } else {
                BaseLogger.DefaultImpls.error$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
            }
            Object var7_8 = null;
        }
    }

    private final void removeTrayIcon() {
        if (!this.trayIconInstalled) {
            return;
        }
        if (this.trayIcon == null) {
            return;
        }
        this.trayIconInstalled = false;
        ApplicationKt.getApplication().assertIsDispatchThread();
        SpaceConnectionFrame $this$logger$iv = this;
        boolean $i$f$logger = false;
        KLogger $this$catch$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceConnectionFrame.class));
        boolean $i$f$catch = false;
        KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
        List except$iv$iv = CollectionsKt.emptyList();
        boolean $i$f$internalCatch = false;
        try {
            boolean bl = false;
            SystemTray.getSystemTray().remove(this.trayIcon);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable th$iv$iv) {
            boolean bl;
            block11: {
                boolean $i$f$isCancellationException = false;
                if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                    throw th$iv$iv;
                }
                Iterable $this$any$iv$iv$iv = except$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                        KClass it$iv$iv = (KClass)element$iv$iv$iv;
                        boolean bl2 = false;
                        if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw th$iv$iv;
            }
            Throwable throwable = th$iv$iv;
            KLogger $this$catch_u24lambda_u240$iv = $this$internalCatch_u24default$iv$iv;
            boolean bl3 = false;
            if (KLoggerExJvmKt.isShutdownInProgress()) {
                BaseLogger.DefaultImpls.warn$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
            } else {
                BaseLogger.DefaultImpls.error$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
            }
            Object var7_8 = null;
        }
    }

    public static final /* synthetic */ void access$hideToTray(SpaceConnectionFrame $this) {
        $this.hideToTray();
    }

    public static final /* synthetic */ void access$disconnect(SpaceConnectionFrame $this) {
        $this.disconnect();
    }

    public static final /* synthetic */ void access$openGatewayOrDialog(SpaceConnectionFrame $this) {
        $this.openGatewayOrDialog();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame$Companion;", "Llibraries/klogging/KLogging;", "()V", "intellij.space.gateway"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010\u000f\u001a\u00020!H\u0016J\u000e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame$SpaceConnectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/jetbrains/gateway/api/CustomConnectionFrameContext;", "(Lcom/intellij/space/gateway/web/flow/neww/SpaceConnectionFrame;)V", "disconnectAction", "Lcom/intellij/space/gateway/web/flow/neww/CallbackAction;", "disposable", "Lcom/intellij/openapi/Disposable;", "hideToTrayAction", "hideToTrayPossibility", "Lcom/jetbrains/gateway/api/CustomConnectionFrameContext$HideToTrayPossibility$Possible;", "getHideToTrayPossibility", "()Lcom/jetbrains/gateway/api/CustomConnectionFrameContext$HideToTrayPossibility$Possible;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "openGateway", "retry", "button", "Ljavax/swing/JButton;", "getButton", "(Lcom/intellij/space/gateway/web/flow/neww/CallbackAction;)Ljavax/swing/JButton;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createButtonsPanel", "Ljavax/swing/JPanel;", "buttons", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "dispose", "", "hideToTray", "updateButtons", "stage", "Lcom/intellij/space/gateway/web/flow/neww/ConnectionStage;", "intellij.space.gateway"})
    private final class SpaceConnectionDialog
    extends DialogWrapper
    implements CustomConnectionFrameContext {
        @NotNull
        private final LifetimeDefinition lifetime;
        @NotNull
        private final CustomConnectionFrameContext.HideToTrayPossibility.Possible hideToTrayPossibility;
        @NotNull
        private final CallbackAction disconnectAction;
        @NotNull
        private final CallbackAction hideToTrayAction;
        @NotNull
        private final CallbackAction openGateway;
        @NotNull
        private final CallbackAction retry;
        @NotNull
        private final Disposable disposable;

        public SpaceConnectionDialog() {
            super(null, false);
            this.lifetime = SpaceConnectionFrame.this.handle.getLifetime().createNested();
            this.hideToTrayPossibility = new CustomConnectionFrameContext.HideToTrayPossibility.Possible((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$hideToTray((SpaceConnectionFrame)this.receiver);
                }
            });
            String string2 = SpaceGatewayBundle.message("open.in.ide.connection.dialog.exit.disconnect.and.close", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"open.in.ide.con\u2026it.disconnect.and.close\")");
            this.disconnectAction = new CallbackAction(string2, (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$disconnect((SpaceConnectionFrame)this.receiver);
                }
            }));
            String string3 = SpaceGatewayBundle.message("open.in.ide.connection.dialog.hide", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"open.in.ide.connection.dialog.hide\")");
            this.hideToTrayAction = new CallbackAction(string3, (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$hideToTray((SpaceConnectionFrame)this.receiver);
                }
            }));
            String string4 = SpaceGatewayBundle.message("open.in.ide.connection.dialog.open.gateway", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"open.in.ide.con\u2026ion.dialog.open.gateway\")");
            this.openGateway = new CallbackAction(string4, (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$openGateway((SpaceConnectionFrame)this.receiver);
                }
            }));
            String string5 = SpaceGatewayBundle.message("open.in.ide.connection.dialog.retry", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"open.in.ide.connection.dialog.retry\")");
            this.retry = new CallbackAction(string5, (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this.handle){

                public final void invoke() {
                    ((SpaceOpenInIdeConnectionHandle)((Object)this.receiver)).retry();
                }
            }));
            SpaceConnectionFrame.this.dialog = this;
            this.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(@Nullable WindowEvent e) {
                    SpaceConnectionFrame.this.openGatewayOrHide();
                    SpaceConnectionFrame.this.dialog = null;
                }
            });
            this.disposable = SpaceConnectionFrame.this.handle.stageUpdates((Function1<? super ConnectionStage, Unit>)((Function1)new Function1<ConnectionStage, Unit>((Object)this){

                public final void invoke(@NotNull ConnectionStage p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((SpaceConnectionDialog)((Object)this.receiver)).updateButtons(p0);
                }
            }));
            this.init();
            this.pack();
            this.setResizable(false);
            this.setAutoAdjustable(true);
            JButton jButton = this.getButton(this.openGateway);
            if (jButton != null) {
                jButton.setVisible(false);
            }
            JButton jButton2 = this.getButton(this.retry);
            if (jButton2 != null) {
                jButton2.setVisible(false);
            }
            this.show();
        }

        @NotNull
        public CustomConnectionFrameContext.HideToTrayPossibility.Possible getHideToTrayPossibility() {
            return this.hideToTrayPossibility;
        }

        private final JButton getButton(CallbackAction $this$button) {
            return this.getButton($this$button);
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return SpaceConnectionFrame.this.handle.customComponentProvider((Lifetime)this.lifetime).createComponent((CustomConnectionFrameContext)this);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.disconnectAction, this.hideToTrayAction, this.openGateway, this.retry};
            return actionArray;
        }

        @NotNull
        protected JComponent createSouthPanel() {
            JComponent jComponent;
            JComponent it = jComponent = super.createSouthPanel();
            boolean bl = false;
            it.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
            JComponent jComponent2 = jComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"super.createSouthPanel()\u2026rders.empty(8, 0)\n      }");
            return jComponent2;
        }

        @NotNull
        protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons2) {
            Intrinsics.checkNotNullParameter(buttons2, (String)"buttons");
            NonOpaquePanel buttonsPanel = new NonOpaquePanel();
            buttonsPanel.setLayout((LayoutManager)new BoxLayout((Container)buttonsPanel, 0));
            JBValue.Float baseGap = new JBValue.Float((float)(UIUtil.isUnderWin10LookAndFeel() ? 8 : 12));
            int n = buttons2.size();
            for (int i = 0; i < n; ++i) {
                JButton button = buttons2.get(i);
                Insets insets = button.getInsets();
                int gap = StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? baseGap.get() - insets.left - insets.right : JBUIScale.scale((int)8);
                Object[] objectArray = new CallbackAction[]{this.hideToTrayAction, this.retry};
                if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)button.getAction())) {
                    buttonsPanel.add(Box.createRigidArea(new Dimension(gap, 0)));
                }
                buttonsPanel.add((Component)button);
            }
            return (JPanel)buttonsPanel;
        }

        public void openGateway() {
            SpaceConnectionFrame.this.openGateway();
        }

        public void hideToTray() {
            this.hideToTrayAction.getPerform().invoke();
        }

        protected void dispose() {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetime, (boolean)false, (int)1, null);
            super.dispose();
            Disposer.dispose((Disposable)this.disposable);
        }

        public final void updateButtons(@NotNull ConnectionStage stage) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            boolean isFailed = stage instanceof ConnectionStage.Failed;
            JButton jButton = this.getButton(this.disconnectAction);
            if (jButton != null) {
                jButton.setVisible(!isFailed);
            }
            JButton jButton2 = this.getButton(this.hideToTrayAction);
            if (jButton2 != null) {
                jButton2.setVisible(!isFailed);
            }
            JButton jButton3 = this.getButton(this.hideToTrayAction);
            if (jButton3 != null) {
                jButton3.setVisible(!isFailed);
            }
            JButton jButton4 = this.getButton(this.openGateway);
            if (jButton4 != null) {
                jButton4.setVisible(isFailed);
            }
            JButton jButton5 = this.getButton(this.retry);
            if (jButton5 != null) {
                jButton5.setVisible(SpaceConnectionFrame.this.handle.isRetryAvailable());
            }
            JButton jButton6 = this.getButton(this.retry);
            JRootPane jRootPane = jButton6 != null ? jButton6.getRootPane() : null;
            if (jRootPane != null) {
                jRootPane.setDefaultButton(SpaceConnectionFrame.this.handle.isRetryAvailable() ? this.getButton(this.retry) : (isFailed ? this.getButton(this.openGateway) : this.getButton(this.hideToTrayAction)));
            }
        }
    }
}

