/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway;

import com.intellij.space.gateway.SpaceGatewayConnectionService;
import com.intellij.space.gateway.SpaceGatewayIcons;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.ui.PromoKt;
import com.intellij.space.gateway.ui.SpaceGatewayConnectorView;
import com.intellij.space.gateway.ui.SpaceGatewayExplorePlace;
import com.intellij.space.gateway.ui.SpaceGatewayWelcomeScreenTab;
import com.intellij.space.settings.SpaceSettings;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorAction;
import com.jetbrains.gateway.api.GatewayConnectorDocumentationPage;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.gateway.api.GatewayRecentConnections;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/space/gateway/SpaceGatewayConnector;", "Lcom/jetbrains/gateway/api/GatewayConnector;", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "createView", "Lcom/jetbrains/gateway/api/GatewayConnectorView;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getActionText", "", "getConnectorId", "getDescription", "getDocumentationAction", "Lcom/jetbrains/gateway/api/GatewayConnectorDocumentationPage;", "getRecentConnections", "Lcom/jetbrains/gateway/api/GatewayRecentConnections;", "setContentCallback", "Lkotlin/Function1;", "Ljava/awt/Component;", "", "getTitle", "getTitleAdornment", "Ljavax/swing/JComponent;", "isAvailable", "", "userWasConnectedToSpace", "OpenSpaceTabConnectorAction", "intellij.space.gateway"})
public final class SpaceGatewayConnector
implements GatewayConnector {
    public SpaceGatewayConnector() {
        SpaceGatewayConnectionService.Companion.getInstance();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = SpaceGatewayIcons.Icons.Main_64;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Main_64");
        return icon2;
    }

    @NotNull
    public String getTitle() {
        String string2 = SpaceGatewayBundle.message("connector.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"connector.title\")");
        return string2;
    }

    @NotNull
    public String getActionText() {
        String string2 = SpaceGatewayBundle.message("connector.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"connector.action.text\")");
        return string2;
    }

    @NotNull
    public String getDescription() {
        String string2 = SpaceGatewayBundle.message("connector.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"connector.description\")");
        return string2;
    }

    @Nullable
    public JComponent getTitleAdornment() {
        return null;
    }

    @NotNull
    public GatewayConnectorView createView(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        return this.userWasConnectedToSpace() ? (GatewayConnectorView)new OpenSpaceTabConnectorAction() : (GatewayConnectorView)new SpaceGatewayConnectorView(lifetime);
    }

    @NotNull
    public GatewayRecentConnections getRecentConnections(@NotNull Function1<? super Component, Unit> setContentCallback) {
        Intrinsics.checkNotNullParameter(setContentCallback, (String)"setContentCallback");
        return new SpaceGatewayWelcomeScreenTab(setContentCallback);
    }

    @NotNull
    public GatewayConnectorDocumentationPage getDocumentationAction() {
        return new GatewayConnectorDocumentationPage(PromoKt.getExploreUrl(SpaceGatewayExplorePlace.MAIN_GATEWAY));
    }

    @NotNull
    public String getConnectorId() {
        return "space.connector";
    }

    public boolean isAvailable() {
        return true;
    }

    private final boolean userWasConnectedToSpace() {
        return SpaceSettings.Companion.getInstance().getServerSettings().getEnabled();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/gateway/SpaceGatewayConnector$OpenSpaceTabConnectorAction;", "Lcom/jetbrains/gateway/api/GatewayConnectorAction;", "()V", "invoke", "", "intellij.space.gateway"})
    private static final class OpenSpaceTabConnectorAction
    implements GatewayConnectorAction {
        public void invoke() {
            SpaceGatewayWelcomeScreenTab.Companion.openSpaceTab();
        }
    }
}

