/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.auth;

import circlet.platform.workspaces.WorkspaceConfiguration;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.space.auth.SpaceOAuthCredentials;
import com.intellij.space.auth.SpaceOAuthCredentialsAcquirer;
import com.intellij.space.auth.SpaceOAuthService;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/space/auth/SpaceOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/space/auth/SpaceOAuthCredentials;", "wsConfig", "Lcirclet/platform/workspaces/WorkspaceConfiguration;", "(Lcirclet/platform/workspaces/WorkspaceConfiguration;)V", "authUrlWithParameters", "Lcom/intellij/util/Url;", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "credentialsAcquirer", "Lcom/intellij/space/auth/SpaceOAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/space/auth/SpaceOAuthCredentialsAcquirer;", "port", "", "redirectUriRaw", "", "server", "getServer", "()Ljava/lang/String;", "serviceName", "intellij.space"})
public final class SpaceOAuthRequest
implements OAuthRequest<SpaceOAuthCredentials> {
    private final int port;
    @NotNull
    private final String serviceName;
    @NotNull
    private final String server;
    @NotNull
    private final String redirectUriRaw;
    @NotNull
    private final Url authorizationCodeUrl;
    @NotNull
    private final SpaceOAuthCredentialsAcquirer credentialsAcquirer;
    @NotNull
    private final Url authUrlWithParameters;

    public SpaceOAuthRequest(@NotNull WorkspaceConfiguration wsConfig) {
        Intrinsics.checkNotNullParameter((Object)wsConfig, (String)"wsConfig");
        this.port = BuiltInServerManager.Companion.getInstance().getPort();
        this.serviceName = SpaceOAuthService.Companion.getInstance().getName();
        this.server = wsConfig.getServer();
        this.redirectUriRaw = "http://localhost:" + this.port + "/api/" + this.serviceName + "/authorization_code";
        this.authorizationCodeUrl = Urls.newFromEncoded((String)this.redirectUriRaw);
        this.credentialsAcquirer = new SpaceOAuthCredentialsAcquirer(wsConfig, this.redirectUriRaw);
        String string2 = this.getAuthorizationCodeUrl().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authorizationCodeUrl.toExternalForm()");
        this.authUrlWithParameters = Urls.newFromEncoded((String)wsConfig.codeFlowURL(string2));
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return this.authorizationCodeUrl;
    }

    @NotNull
    public SpaceOAuthCredentialsAcquirer getCredentialsAcquirer() {
        return this.credentialsAcquirer;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }
}

