/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.tree;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.popup.GitBranchesTreePopup;
import git4idea.ui.branch.tree.GitBranchesTreeModel;
import git4idea.ui.branch.tree.GitBranchesTreeRendererClipper;
import git4idea.ui.branch.tree.GitBranchesTreeSelectedRepoModel;
import icons.DvcsImplIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 I2\u00020\u0001:\u0002IJB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010!2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020%J \u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0006\u0012\u0004\u0018\u00010-0,2\u0006\u0010\"\u001a\u00020#H\u0002J3\u0010+\u001a#\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0017\u0012\u0015\u0018\u00010-\u00a2\u0006\u000e\b.\u0012\n\b/\u0012\u0006\b\n00810,2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0010\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205J\u001c\u00106\u001a\u0004\u0018\u00010!2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020%H\u0002J\u0019\u00107\u001a\t\u0018\u00010-\u00a2\u0006\u0002\b82\b\u0010(\u001a\u0004\u0018\u00010)H\u0002JB\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010)2\u0006\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020%H\u0016J\u0012\u0010D\u001a\u00020%2\b\u0010E\u001a\u0004\u0018\u00010)H&J\u001c\u0010F\u001a\u0004\u0018\u00010G*\u00020H2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "treeModel", "Lgit4idea/ui/branch/tree/GitBranchesTreeModel;", "selectedRepository", "Lgit4idea/repo/GitRepository;", "repositories", "", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/tree/GitBranchesTreeModel;Lgit4idea/repo/GitRepository;Ljava/util/List;)V", "affectedRepositories", "getAffectedRepositories", "()Ljava/util/List;", "arrowLabel", "Ljavax/swing/JLabel;", "branchInfoPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "kotlin.jvm.PlatformType", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "incomingOutgoingLabel", "mainIconComponent", "mainPanel", "Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer$MyMainPanel;", "mainTextComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "secondaryLabel", "textPanel", "Ljavax/swing/JPanel;", "updateScaleHelper", "Lcom/intellij/util/ui/UpdateScaleHelper;", "getBranchIcon", "Ljavax/swing/Icon;", "branch", "Lgit4idea/GitBranch;", "isSelected", "", "getBranchNameClipper", "Lcom/intellij/ui/SimpleColoredComponent$FragmentTextClipper;", "treeNode", "", "getIcon", "getIncomingOutgoingIconWithTooltip", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getLeftTreeIconRenderer", "Lcom/intellij/ui/tree/ui/Control;", "path", "Ljavax/swing/tree/TreePath;", "getNodeIcon", "getSecondaryText", "Lcom/intellij/openapi/util/NlsSafe;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "selected", "expanded", "leaf", "row", "", "hasFocus", "hasRightArrow", "nodeUserObject", "getCommonTrackedBranch", "Lgit4idea/GitRemoteBranch;", "Lgit4idea/GitLocalBranch;", "Companion", "MyMainPanel", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeRenderer.kt\ngit4idea/ui/branch/tree/GitBranchesTreeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,367:1\n1#2:368\n1726#3,3:369\n1726#3,3:375\n1747#3,3:381\n1747#3,3:384\n29#4,3:372\n29#4,3:378\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreeRenderer.kt\ngit4idea/ui/branch/tree/GitBranchesTreeRenderer\n*L\n83#1:369,3\n88#1:375,3\n149#1:381,3\n150#1:384,3\n85#1:372,3\n147#1:378,3\n*E\n"})
public abstract class GitBranchesTreeRenderer
implements TreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitBranchesTreeModel treeModel;
    @Nullable
    private final GitRepository selectedRepository;
    @NotNull
    private final List<GitRepository> repositories;
    @NotNull
    private final VcsLogColorManager colorManager;
    @NotNull
    private final UpdateScaleHelper updateScaleHelper;
    @NotNull
    private final JLabel mainIconComponent;
    @NotNull
    private final SimpleColoredComponent mainTextComponent;
    @NotNull
    private final JLabel secondaryLabel;
    @NotNull
    private final JLabel arrowLabel;
    @NotNull
    private final JLabel incomingOutgoingLabel;
    private final BorderLayoutPanel branchInfoPanel;
    @NotNull
    private final JPanel textPanel;
    @NotNull
    private final MyMainPanel mainPanel;
    @JvmField
    @NotNull
    public static final Key<Boolean> MAIN_ICON;

    /*
     * WARNING - void declaration
     */
    public GitBranchesTreeRenderer(@NotNull Project project, @NotNull GitBranchesTreeModel treeModel, @Nullable GitRepository selectedRepository, @NotNull List<? extends GitRepository> repositories2) {
        GridBagConstraints gridBagConstraints;
        void $this$textPanel_u24lambda_u2413;
        JComponent $this$incomingOutgoingLabel_u24lambda_u2410;
        JLabel $this$arrowLabel_u24lambda_u249;
        JLabel $this$secondaryLabel_u24lambda_u248;
        JLabel $this$mainTextComponent_u24lambda_u247;
        JLabel $this$mainIconComponent_u24lambda_u246;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        this.project = project;
        this.treeModel = treeModel;
        this.selectedRepository = selectedRepository;
        this.repositories = repositories2;
        this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(this.project);
        this.updateScaleHelper = new UpdateScaleHelper(null, 1, null);
        JLabel jLabel = jComponent = new JLabel();
        GitBranchesTreeRenderer gitBranchesTreeRenderer = this;
        boolean bl = false;
        ClientProperty.put((JComponent)$this$mainIconComponent_u24lambda_u246, MAIN_ICON, (Object)true);
        $this$mainIconComponent_u24lambda_u246.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        gitBranchesTreeRenderer.mainIconComponent = jComponent;
        $this$mainIconComponent_u24lambda_u246 = jComponent = new SimpleColoredComponent();
        gitBranchesTreeRenderer = this;
        boolean bl2 = false;
        $this$mainTextComponent_u24lambda_u247.setOpaque(false);
        $this$mainTextComponent_u24lambda_u247.setBorder((Border)JBUI.Borders.empty());
        gitBranchesTreeRenderer.mainTextComponent = jComponent;
        $this$mainTextComponent_u24lambda_u247 = jComponent = new JLabel();
        gitBranchesTreeRenderer = this;
        boolean bl3 = false;
        $this$secondaryLabel_u24lambda_u248.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        $this$secondaryLabel_u24lambda_u248.setHorizontalAlignment(4);
        gitBranchesTreeRenderer.secondaryLabel = jComponent;
        $this$secondaryLabel_u24lambda_u248 = jComponent = new JLabel();
        gitBranchesTreeRenderer = this;
        boolean bl4 = false;
        $this$arrowLabel_u24lambda_u249.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        gitBranchesTreeRenderer.arrowLabel = jComponent;
        $this$arrowLabel_u24lambda_u249 = jComponent = new JLabel();
        gitBranchesTreeRenderer = this;
        boolean bl5 = false;
        $this$incomingOutgoingLabel_u24lambda_u2410.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        gitBranchesTreeRenderer.incomingOutgoingLabel = jComponent;
        this.branchInfoPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)((Component)this.mainTextComponent)).addToLeft((Component)this.mainIconComponent).addToRight((Component)this.incomingOutgoingLabel).andTransparent();
        $this$incomingOutgoingLabel_u24lambda_u2410 = jComponent = new JPanel(new GridBagLayout());
        gitBranchesTreeRenderer = this;
        boolean bl6 = false;
        $this$textPanel_u24lambda_u2413.setOpaque(false);
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component2 = (Component)this.branchInfoPanel;
        void var11_12 = $this$textPanel_u24lambda_u2413;
        boolean bl7 = false;
        $this$textPanel_u24lambda_u2413_u24lambda_u2411.anchor = 21;
        $this$textPanel_u24lambda_u2413_u24lambda_u2411.weightx = 0.0;
        Unit unit = Unit.INSTANCE;
        var11_12.add(component2, gridBagConstraints);
        GridBagConstraints $this$textPanel_u24lambda_u2413_u24lambda_u2411 = gridBagConstraints = new GridBagConstraints();
        component2 = this.secondaryLabel;
        var11_12 = $this$textPanel_u24lambda_u2413;
        boolean bl8 = false;
        $this$textPanel_u24lambda_u2413_u24lambda_u2412.anchor = 22;
        $this$textPanel_u24lambda_u2413_u24lambda_u2412.weightx = 0.75;
        unit = Unit.INSTANCE;
        var11_12.add(component2, gridBagConstraints);
        gitBranchesTreeRenderer.textPanel = jComponent;
        this.mainPanel = new MyMainPanel();
    }

    private final List<GitRepository> getAffectedRepositories() {
        Object object;
        block3: {
            block2: {
                object = this.selectedRepository;
                if (object == null) break block2;
                GitRepository p0 = object;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)p0);
                object = list2;
                if (list2 != null) break block3;
            }
            object = this.repositories;
        }
        return object;
    }

    public abstract boolean hasRightArrow(@Nullable Object var1);

    private final SimpleColoredComponent.FragmentTextClipper getBranchNameClipper(Object treeNode) {
        return GitBranchesTreeRendererClipper.Companion.create(this.project, treeNode);
    }

    @Nullable
    public final Control getLeftTreeIconRenderer(@NotNull TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object lastComponent = path.getLastPathComponent();
        Icon icon = this.getNodeIcon(lastComponent, false);
        if (icon == null) {
            return null;
        }
        Icon defaultIcon = icon;
        Icon icon2 = this.getNodeIcon(lastComponent, true);
        if (icon2 == null) {
            return null;
        }
        Icon selectedIcon = icon2;
        return (Control)new DefaultControl(defaultIcon, defaultIcon, selectedIcon, selectedIcon);
    }

    @Nullable
    public final Icon getIcon(@Nullable Object treeNode, boolean isSelected) {
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        return object2 instanceof GitBranchesTreeModel.BranchesPrefixGroup ? PlatformIcons.FOLDER_ICON : (object2 instanceof GitBranchesTreeModel.BranchUnderRepository ? this.getBranchIcon(((GitBranchesTreeModel.BranchUnderRepository)value).getBranch(), CollectionsKt.listOf((Object)((GitBranchesTreeModel.BranchUnderRepository)value).getRepository()), isSelected) : (object2 instanceof GitBranch ? this.getBranchIcon((GitBranch)value, this.getAffectedRepositories(), isSelected) : null));
    }

    private final Icon getBranchIcon(GitBranch branch, List<? extends GitRepository> repositories2, boolean isSelected) {
        Icon icon;
        boolean bl;
        boolean isCurrent;
        block22: {
            boolean bl2;
            block21: {
                GitRepository gitRepository = this.selectedRepository;
                if (gitRepository != null) {
                    GitRepository it = gitRepository;
                    boolean bl3 = false;
                    bl2 = Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch);
                } else {
                    Iterable $this$all$iv = repositories2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            GitRepository it = (GitRepository)element$iv;
                            boolean bl4 = false;
                            if (Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch)) continue;
                            bl2 = false;
                            break block21;
                        }
                        bl2 = true;
                    }
                }
            }
            isCurrent = bl2;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Object bl3 = $this$service$iv.getService(serviceClass$iv);
            if (bl3 == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            GitBranchManager branchManager = (GitBranchManager)((Object)bl3);
            GitRepository gitRepository = this.selectedRepository;
            if (gitRepository != null) {
                GitRepository it = gitRepository;
                boolean bl5 = false;
                bl = branchManager.isFavorite(GitBranchType.Companion.of(branch), it, branch.getName());
            } else {
                Iterable $this$all$iv = repositories2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl6 = false;
                        if (branchManager.isFavorite(GitBranchType.Companion.of(branch), it, branch.getName())) continue;
                        bl = false;
                        break block22;
                    }
                    bl = true;
                }
            }
        }
        boolean isFavorite = bl;
        if (isSelected && isFavorite) {
            Icon icon2 = AllIcons.Nodes.Favorite;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Favorite");
        } else if (isSelected) {
            Icon icon3 = AllIcons.Nodes.NotFavoriteOnHover;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NotFavoriteOnHover");
        } else if (isCurrent && isFavorite) {
            Icon icon4 = DvcsImplIcons.CurrentBranchFavoriteLabel;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"CurrentBranchFavoriteLabel");
        } else if (isCurrent) {
            Icon icon5 = DvcsImplIcons.CurrentBranchLabel;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"CurrentBranchLabel");
        } else if (isFavorite) {
            Icon icon6 = AllIcons.Nodes.Favorite;
            icon = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Favorite");
        } else {
            Icon icon7 = AllIcons.Vcs.BranchNode;
            icon = icon7;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"BranchNode");
        }
        return icon;
    }

    private final String getSecondaryText(Object treeNode) {
        String string;
        Object object = treeNode;
        if (object instanceof PopupFactoryImpl.ActionItem) {
            string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)((PopupFactoryImpl.ActionItem)treeNode).getAction());
        } else if (object instanceof GitRepository) {
            string = GitBranchUtil.getDisplayableBranchText((GitRepository)treeNode);
        } else if (object instanceof GitLocalBranch) {
            GitRemoteBranch gitRemoteBranch = this.getCommonTrackedBranch((GitLocalBranch)treeNode, this.getAffectedRepositories());
            string = gitRemoteBranch != null ? gitRemoteBranch.getName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private final GitRemoteBranch getCommonTrackedBranch(GitLocalBranch $this$getCommonTrackedBranch, List<? extends GitRepository> repositories2) {
        GitRemoteBranch commonTrackedBranch = null;
        for (GitRepository gitRepository : repositories2) {
            GitRemoteBranch trackedBranch;
            if ($this$getCommonTrackedBranch.findTrackedBranch(gitRepository) == null) {
                return null;
            }
            if (commonTrackedBranch == null) {
                commonTrackedBranch = trackedBranch;
                continue;
            }
            if (Intrinsics.areEqual((Object)commonTrackedBranch.getName(), (Object)trackedBranch.getName())) continue;
            return null;
        }
        return commonTrackedBranch;
    }

    private final Icon getNodeIcon(Object treeNode, boolean isSelected) {
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        return object2 instanceof PopupFactoryImpl.ActionItem ? ((PopupFactoryImpl.ActionItem)value).getIcon(isSelected) : (object2 instanceof GitRepository ? (Icon)RepositoryChangesBrowserNode.Companion.getRepositoryIcon((Repository)value, this.colorManager) : null);
    }

    private final Pair<Icon, String> getIncomingOutgoingIconWithTooltip(Object treeNode) {
        Pair<Icon, String> empty = TuplesKt.to(null, null);
        Object object = treeNode;
        if (object == null) {
            return empty;
        }
        Object value = object;
        return value instanceof GitBranch ? this.getIncomingOutgoingIconWithTooltip((GitBranch)value) : empty;
    }

    private final Pair<Icon, String> getIncomingOutgoingIconWithTooltip(GitBranch branch) {
        Icon icon;
        String string;
        boolean hasOutgoing;
        boolean hasIncoming;
        block11: {
            boolean bl;
            GitBranchIncomingOutgoingManager incomingOutgoingManager;
            String branchName;
            block10: {
                String string2 = branch.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"branch.name");
                branchName = string2;
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<GitBranchIncomingOutgoingManager> serviceClass$iv = GitBranchIncomingOutgoingManager.class;
                Iterator iterator = $this$service$iv.getService(serviceClass$iv);
                if (iterator == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                incomingOutgoingManager = (GitBranchIncomingOutgoingManager)((Object)iterator);
                Iterable $this$any$iv = this.getAffectedRepositories();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        if (!incomingOutgoingManager.hasIncomingFor(it, branchName)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            hasIncoming = bl;
            Iterable $this$any$iv = this.getAffectedRepositories();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl3 = false;
                    if (!incomingOutgoingManager.hasOutgoingFor(it, branchName)) continue;
                    v2 = true;
                    break block11;
                }
                v2 = hasOutgoing = false;
            }
        }
        if ((string = GitBranchPopupActions.LocalBranchActions.constructIncomingOutgoingTooltip(hasIncoming, hasOutgoing)) == null) {
            string = "";
        }
        String tooltip = string;
        if (hasIncoming && hasOutgoing) {
            Icon[] iconArray = new Icon[]{DvcsImplIcons.Incoming, DvcsImplIcons.Outgoing};
            icon = (Icon)new RowIcon(iconArray);
        } else {
            icon = hasIncoming ? DvcsImplIcons.Incoming : (hasOutgoing ? DvcsImplIcons.Outgoing : null);
        }
        return TuplesKt.to((Object)icon, (Object)tooltip);
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel jLabel;
        String text;
        Pair<Icon, String> pair;
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Object userObject = TreeUtil.getUserObject((Object)value);
        if (userObject instanceof SeparatorWithText) {
            return (Component)userObject;
        }
        boolean disabledAction = userObject instanceof PopupFactoryImpl.ActionItem && !((PopupFactoryImpl.ActionItem)userObject).isEnabled();
        Pair<Icon, String> $this$getTreeCellRendererComponent_u24lambda_u2414 = pair = this.mainIconComponent;
        boolean bl = false;
        $this$getTreeCellRendererComponent_u24lambda_u2414.setIcon(this.getIcon(userObject, selected));
        $this$getTreeCellRendererComponent_u24lambda_u2414.setVisible($this$getTreeCellRendererComponent_u24lambda_u2414.getIcon() != null);
        Pair<Icon, String> $this$getTreeCellRendererComponent_u24lambda_u2415 = pair = this.mainTextComponent;
        boolean bl2 = false;
        $this$getTreeCellRendererComponent_u24lambda_u2415.setBackground(JBUI.CurrentTheme.Tree.background((boolean)selected, (boolean)true));
        $this$getTreeCellRendererComponent_u24lambda_u2415.setForeground(JBUI.CurrentTheme.Tree.foreground((boolean)selected, (boolean)true));
        $this$getTreeCellRendererComponent_u24lambda_u2415.clear();
        String string = Companion.getText$intellij_vcs_git(userObject, this.treeModel, this.getAffectedRepositories());
        if (string == null) {
            string = text = "";
        }
        if (disabledAction) {
            $this$getTreeCellRendererComponent_u24lambda_u2415.append(text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            $this$getTreeCellRendererComponent_u24lambda_u2415.appendWithClipping(text, this.getBranchNameClipper(userObject));
        }
        pair = this.getIncomingOutgoingIconWithTooltip(userObject);
        Icon inOutIcon = (Icon)pair.component1();
        String inOutTooltip = (String)pair.component2();
        tree2.setToolTipText(inOutTooltip);
        JLabel $this$getTreeCellRendererComponent_u24lambda_u2416 = jLabel = this.incomingOutgoingLabel;
        boolean bl3 = false;
        $this$getTreeCellRendererComponent_u24lambda_u2416.setIcon(inOutIcon);
        $this$getTreeCellRendererComponent_u24lambda_u2416.setVisible($this$getTreeCellRendererComponent_u24lambda_u2416.getIcon() != null);
        JLabel $this$getTreeCellRendererComponent_u24lambda_u2417 = jLabel = this.arrowLabel;
        boolean bl4 = false;
        $this$getTreeCellRendererComponent_u24lambda_u2417.setVisible(this.hasRightArrow(userObject));
        $this$getTreeCellRendererComponent_u24lambda_u2417.setIcon(selected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
        JLabel $this$getTreeCellRendererComponent_u24lambda_u2418 = jLabel = this.secondaryLabel;
        boolean bl5 = false;
        $this$getTreeCellRendererComponent_u24lambda_u2418.setText(this.getSecondaryText(userObject));
        $this$getTreeCellRendererComponent_u24lambda_u2418.setForeground(disabledAction ? NamedColorUtil.getInactiveTextColor() : (selected ? JBUI.CurrentTheme.Tree.foreground((boolean)true, (boolean)true) : (Color)JBColor.GRAY));
        $this$getTreeCellRendererComponent_u24lambda_u2418.setBorder(!this.arrowLabel.isVisible() && ExperimentalUI.isNewUI() ? (Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)JBUI.CurrentTheme.Popup.Selection.innerInsets().right) : (Border)JBUI.Borders.emptyLeft((int)10));
        if (value != null && !(userObject instanceof PopupFactoryImpl.ActionItem)) {
            SpeedSearchUtil.applySpeedSearchHighlightingFiltered((JTree)tree2, (Object)value, (SimpleColoredComponent)this.mainTextComponent, (boolean)true, (boolean)selected);
        }
        if (this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)((Object)this.mainPanel))) {
            tree2.setRowHeight(GitBranchesTreePopup.Companion.getTreeRowHeight$intellij_vcs_git());
        }
        return (Component)((Object)this.mainPanel);
    }

    static {
        Key key = Key.create((String)"MAIN_ICON");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<Boolean>(\"MAIN_ICON\")");
        MAIN_ICON = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a2\u0006\u0002\b\u0011R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer$Companion;", "", "()V", "MAIN_ICON", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getText", "", "Lcom/intellij/openapi/util/NlsSafe;", "treeNode", "model", "Lgit4idea/ui/branch/tree/GitBranchesTreeModel;", "repositories", "", "Lgit4idea/repo/GitRepository;", "getText$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getText$intellij_vcs_git(@Nullable Object treeNode, @NotNull GitBranchesTreeModel model, @NotNull List<? extends GitRepository> repositories2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Object object = treeNode;
            if (object == null) {
                return null;
            }
            Object value = object;
            Object object2 = value;
            if (Intrinsics.areEqual((Object)object2, (Object)GitBranchesTreeModel.RecentNode.INSTANCE)) {
                if (model instanceof GitBranchesTreeSelectedRepoModel) {
                    Object[] objectArray = new Object[]{DvcsUtil.getShortRepositoryName((Repository)((GitBranchesTreeSelectedRepoModel)model).getSelectedRepository())};
                    string = GitBundle.message("group.Git.Recent.Branch.in.repo.title", objectArray);
                } else {
                    string = GitBundle.message("group.Git.Recent.Branch.title", new Object[0]);
                }
            } else if (object2 == GitBranchType.LOCAL) {
                if (model instanceof GitBranchesTreeSelectedRepoModel) {
                    Object[] objectArray = new Object[]{DvcsUtil.getShortRepositoryName((Repository)((GitBranchesTreeSelectedRepoModel)model).getSelectedRepository())};
                    string = GitBundle.message("branches.local.branches.in.repo", objectArray);
                } else {
                    string = repositories2.size() > 1 ? GitBundle.message("common.local.branches", new Object[0]) : GitBundle.message("group.Git.Local.Branch.title", new Object[0]);
                }
            } else if (object2 == GitBranchType.REMOTE) {
                if (model instanceof GitBranchesTreeSelectedRepoModel) {
                    Object[] objectArray = new Object[]{DvcsUtil.getShortRepositoryName((Repository)((GitBranchesTreeSelectedRepoModel)model).getSelectedRepository())};
                    string = GitBundle.message("branches.remote.branches.in.repo", objectArray);
                } else {
                    string = repositories2.size() > 1 ? GitBundle.message("common.remote.branches", new Object[0]) : GitBundle.message("group.Git.Remote.Branch.title", new Object[0]);
                }
            } else if (object2 instanceof GitBranchesTreeModel.BranchesPrefixGroup) {
                string = (String)CollectionsKt.last(((GitBranchesTreeModel.BranchesPrefixGroup)value).getPrefix());
            } else if (object2 instanceof GitRepository) {
                string = DvcsUtil.getShortRepositoryName((Repository)((Repository)value));
            } else if (object2 instanceof GitBranchesTreeModel.BranchTypeUnderRepository) {
                BranchType branchType = ((GitBranchesTreeModel.BranchTypeUnderRepository)value).getType();
                string = Intrinsics.areEqual((Object)branchType, (Object)GitBranchesTreeModel.RecentNode.INSTANCE) ? GitBundle.message("group.Git.Recent.Branch.title", new Object[0]) : (branchType == GitBranchType.LOCAL ? GitBundle.message("group.Git.Local.Branch.title", new Object[0]) : (branchType == GitBranchType.REMOTE ? GitBundle.message("group.Git.Remote.Branch.title", new Object[0]) : null));
            } else if (object2 instanceof GitBranchesTreeModel.BranchUnderRepository) {
                string = this.getText$intellij_vcs_git(((GitBranchesTreeModel.BranchUnderRepository)value).getBranch(), model, repositories2);
            } else if (object2 instanceof GitBranch) {
                if (model.isPrefixGrouping()) {
                    String string2 = ((GitBranch)value).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.name");
                    char[] cArray = new char[]{'/'};
                    string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
                } else {
                    String string3 = ((GitBranch)value).getName();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.name");
                }
            } else {
                string = object2 instanceof PopupFactoryImpl.ActionItem ? ((PopupFactoryImpl.ActionItem)value).getText() : null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer$MyMainPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "(Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer;)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "intellij.vcs.git"})
    private final class MyMainPanel
    extends BorderLayoutPanel {
        public MyMainPanel() {
            this.addToCenter(GitBranchesTreeRenderer.this.textPanel);
            this.addToRight(GitBranchesTreeRenderer.this.arrowLabel);
            this.andTransparent();
            this.withBorder((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.cellPadding().right));
        }

        @NotNull
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                AccessibleContext accessibleContext = GitBranchesTreeRenderer.this.mainTextComponent.getAccessibleContext();
                this.accessibleContext = (AccessibleContext)new AccessibleContextDelegateWithContextMenu(this, accessibleContext){
                    final /* synthetic */ MyMainPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    @NotNull
                    protected Container getDelegateParent() {
                        Container container = this.this$0.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"parent");
                        return container;
                    }

                    protected void doShowContextMenu() {
                        ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
                    }
                };
            }
            AccessibleContext accessibleContext = this.accessibleContext;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
            return accessibleContext;
        }
    }
}

