/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.Color;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalHighlighter;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalPanel;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0003?@AB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\rJ\b\u0010(\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020\"J\u001a\u0010/\u001a\u00020$2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020$01J\u0010\u00103\u001a\u00020$2\u0006\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u00020$H\u0002J\b\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u00020$H\u0002J\u000e\u00109\u001a\u00020$2\u0006\u0010!\u001a\u00020\"J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u001eH\u0002J\b\u0010<\u001a\u00020$H\u0002J\f\u0010=\u001a\u00020>*\u00020-H\u0002R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/ui/ComponentContainer;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "eventsHandler", "Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalModel;Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler;)V", "charSize", "Ljava/awt/Dimension;", "getCharSize", "()Ljava/awt/Dimension;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "eventDispatcher", "Lorg/jetbrains/plugins/terminal/exp/TerminalPanel$TerminalEventDispatcher;", "keyEventsForwardingDisposable", "Lcom/intellij/openapi/Disposable;", "palette", "Lcom/jediterm/terminal/emulator/ColorPalette;", "getPalette", "()Lcom/jediterm/terminal/emulator/ColorPalette;", "runningDisposable", "computeTerminalContent", "Lorg/jetbrains/plugins/terminal/exp/TerminalPanel$TerminalContent;", "createBorder", "Ljavax/swing/border/Border;", "isFullScreen", "", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getContentSize", "getPreferredFocusableComponent", "getPreferredSize", "getStyleForeground", "Ljava/awt/Color;", "style", "Lcom/jediterm/terminal/TextStyle;", "isFocused", "makeReadOnly", "done", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Editor;", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "setupContentListener", "setupEventDispatcher", "setupMouseListener", "toggleFullScreen", "updateEditor", "content", "updateEditorContent", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Companion", "TerminalContent", "TerminalEventDispatcher", "intellij.terminal"})
public final class TerminalPanel
extends JPanel
implements ComponentContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalModel model;
    @NotNull
    private final TerminalEventsHandler eventsHandler;
    @NotNull
    private final Document document;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Disposable runningDisposable;
    @NotNull
    private final Disposable keyEventsForwardingDisposable;
    @NotNull
    private final TerminalEventDispatcher eventDispatcher;
    public static final int LEFT_INSET = 7;
    @NonNls
    @NotNull
    private static final List<String> ACTIONS_TO_SKIP;

    public TerminalPanel(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalModel model, @NotNull TerminalEventsHandler eventsHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        this.project = project;
        this.settings = settings;
        this.model = model;
        this.eventsHandler = eventsHandler;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        this.runningDisposable = disposable;
        this.keyEventsForwardingDisposable = () -> TerminalPanel.keyEventsForwardingDisposable$lambda$0(this);
        this.eventDispatcher = new TerminalEventDispatcher();
        this.document = (Document)new DocumentImpl((CharSequence)"", true);
        this.editor = TerminalUiUtils.INSTANCE.createEditor(this.document, this.project, this.settings);
        Disposer.register((Disposable)((Disposable)this), () -> TerminalPanel._init_$lambda$1(this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.runningDisposable);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.keyEventsForwardingDisposable);
        this.setupContentListener();
        this.setupEventDispatcher();
        this.setupMouseListener();
        this.setBorder(this.createBorder(false));
        this.setLayout(new BorderLayout());
        this.add((Component)this.editor.getComponent(), "Center");
        this.updateEditorContent();
    }

    private final ColorPalette getPalette() {
        ColorPalette colorPalette = this.settings.getTerminalColorPalette();
        Intrinsics.checkNotNullExpressionValue((Object)colorPalette, (String)"settings.terminalColorPalette");
        return colorPalette;
    }

    @NotNull
    public final Dimension getCharSize() {
        return new Dimension(this.editor.getCharHeight(), this.editor.getLineHeight());
    }

    public final void makeReadOnly(@NotNull Function1<? super Editor, Unit> done) {
        Intrinsics.checkNotNullParameter(done, (String)"done");
        Disposer.dispose((Disposable)this.runningDisposable);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, done){
            final /* synthetic */ TerminalPanel this$0;
            final /* synthetic */ Function1<Editor, Unit> $done;
            {
                this.this$0 = $receiver;
                this.$done = $done;
                super(0);
            }

            public final void invoke() {
                Disposer.dispose((Disposable)TerminalPanel.access$getKeyEventsForwardingDisposable$p(this.this$0));
                String string = TerminalPanel.access$getEditor$p(this.this$0).getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.text");
                String output = string;
                TerminalPanel.access$getEditor$p(this.this$0).getDocument().setText((CharSequence)((Object)StringsKt.trimEnd((CharSequence)output)).toString());
                TerminalPanel.access$getEditor$p(this.this$0).setCaretEnabled(false);
                TerminalPanel.access$getEditor$p(this.this$0).setViewer(true);
                this.$done.invoke((Object)TerminalPanel.access$getEditor$p(this.this$0));
            }
        }), (int)1, null);
    }

    public final void toggleFullScreen(boolean isFullScreen) {
        this.setBorder(this.createBorder(isFullScreen));
    }

    private final Border createBorder(boolean isFullScreen) {
        Border border;
        if (!isFullScreen) {
            Border border2 = JBUI.Borders.customLine((java.awt.Color)UIUtil.getTextFieldBackground(), (int)6, (int)0, (int)6, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)border2, (String)"customLine(UIUtil.getTex\u2026Background(), 6, 0, 6, 0)");
            Border innerBorder = border2;
            Border border3 = JBUI.Borders.customLineTop((java.awt.Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            Intrinsics.checkNotNullExpressionValue((Object)border3, (String)"customLineTop(JBUI.Curre\u2026ns.separatorForeground())");
            Border outerBorder = border3;
            Border border4 = JBUI.Borders.compound((Border)outerBorder, (Border)innerBorder);
            Intrinsics.checkNotNull((Object)border4);
            Border border5 = border4;
            Intrinsics.checkNotNullExpressionValue((Object)border5, (String)"{\n      val innerBorder \u2026der, innerBorder)!!\n    }");
            border = border5;
        } else {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty()");
            border = (Border)jBEmptyBorder;
        }
        return border;
    }

    private final void setupContentListener() {
        this.model.addContentListener(new TerminalModel.ContentListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onContentChanged() {
                TerminalPanel.access$updateEditorContent(this.this$0);
            }
        }, this.runningDisposable);
    }

    private final void updateEditorContent() {
        TerminalContent content = this.computeTerminalContent();
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, content){
            final /* synthetic */ TerminalPanel this$0;
            final /* synthetic */ TerminalContent $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                if (!TerminalPanel.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalPanel.access$updateEditor(this.this$0, this.$content);
                }
            }
        }));
    }

    private final TerminalContent computeTerminalContent() {
        StringBuilder builder = new StringBuilder();
        List highlightings = new ArrayList();
        StyledTextConsumer consumer2 = new StyledTextConsumer(builder, this, highlightings){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ TerminalPanel this$0;
            final /* synthetic */ List<HighlightingInfo> $highlightings;
            {
                this.$builder = $builder;
                this.this$0 = $receiver;
                this.$highlightings = $highlightings;
            }

            public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                this.$builder.append(characters.toString());
                TextAttributes attributes = TerminalPanel.access$toTextAttributes(this.this$0, style);
                this.$highlightings.add(new HighlightingInfo(startOffset, this.$builder.length(), attributes));
            }

            public void consumeNul(int x, int y, int nulIndex, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                int n = characters.getBuf().length;
                StringBuilder stringBuilder = this.$builder;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    stringBuilder.append(' ');
                }
                int n3 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(startOffset, n3, TerminalPanel.access$toTextAttributes(this.this$0, textStyle)));
            }

            public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                this.$builder.append("\n");
                int n = this.$builder.length() - 1;
                int n2 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(n, n2, TerminalPanel.access$toTextAttributes(this.this$0, textStyle)));
            }
        };
        if (this.model.getUseAlternateBuffer()) {
            this.model.processScreenLines(0, this.model.getScreenLinesCount(), consumer2);
        } else {
            this.model.processHistoryAndScreenLines(-this.model.getHistoryLinesCount(), this.model.getHistoryLinesCount() + this.model.getCursorY(), consumer2);
        }
        while (true) {
            Character c = StringsKt.lastOrNull((CharSequence)builder);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) break;
            builder.deleteCharAt(StringsKt.getLastIndex((CharSequence)builder));
            CollectionsKt.removeLast((List)highlightings);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return new TerminalContent(string, highlightings);
    }

    private final void updateEditor(TerminalContent content) {
        this.document.setText((CharSequence)content.getText());
        this.editor.setHighlighter((EditorHighlighter)new TerminalHighlighter(content.getHighlightings()));
        if (this.model.getUseAlternateBuffer()) {
            this.editor.setCaretEnabled(false);
        } else {
            this.editor.setCaretEnabled(this.model.isCursorVisible());
            int line = this.model.getHistoryLinesCount() + this.model.getCursorY() - 1;
            this.editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, this.model.getCursorX()));
            this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
        }
    }

    private final TextAttributes toTextAttributes(TextStyle $this$toTextAttributes) {
        TextAttributes textAttributes;
        TextAttributes attr = textAttributes = new TextAttributes();
        boolean bl = false;
        attr.setBackgroundColor(AwtTransformers.toAwtColor((Color)this.getPalette().getBackground(this.model.getStyleState().getBackground($this$toTextAttributes.getBackgroundForRun()))));
        attr.setForegroundColor(this.getStyleForeground($this$toTextAttributes));
        if ($this$toTextAttributes.hasOption(TextStyle.Option.BOLD)) {
            attr.setFontType(attr.getFontType() | 1);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.ITALIC)) {
            attr.setFontType(attr.getFontType() | 2);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.UNDERLINED)) {
            attr.withAdditionalEffect(EffectType.LINE_UNDERSCORE, attr.getForegroundColor());
        }
        return textAttributes;
    }

    private final java.awt.Color getStyleForeground(TextStyle style) {
        java.awt.Color color;
        Color color2 = this.getPalette().getForeground(this.model.getStyleState().getForeground(style.getForegroundForRun()));
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"palette.getForeground(mo\u2026(style.foregroundForRun))");
        Color foreground = color2;
        if (style.hasOption(TextStyle.Option.DIM)) {
            Color color3 = this.getPalette().getBackground(this.model.getStyleState().getBackground(style.getBackgroundForRun()));
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"palette.getBackground(mo\u2026(style.backgroundForRun))");
            Color background = color3;
            color = new java.awt.Color((foreground.getRed() + background.getRed()) / 2, (foreground.getGreen() + background.getGreen()) / 2, (foreground.getBlue() + background.getBlue()) / 2, foreground.getAlpha());
        } else {
            java.awt.Color color4 = AwtTransformers.toAwtColor((Color)foreground);
            color = color4;
            Intrinsics.checkNotNull((Object)color4);
        }
        return color;
    }

    private final void setupEventDispatcher() {
        this.editor.addFocusListener(new FocusChangeListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (TerminalPanel.access$getSettings$p(this.this$0).overrideIdeShortcuts()) {
                    List actionsToSkip = org.jetbrains.plugins.terminal.exp.TerminalPanel$Companion.access$setupActionsToSkip(TerminalPanel.Companion);
                    TerminalPanel.access$getEventDispatcher$p(this.this$0).register(actionsToSkip);
                } else {
                    TerminalPanel.access$getEventDispatcher$p(this.this$0).unregister();
                }
                if (GeneralSettings.Companion.getInstance().isSaveOnFrameDeactivation()) {
                    ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), (Function0)setupEventDispatcher.focusGained.1.INSTANCE);
                }
            }

            public void focusLost(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                TerminalPanel.access$getEventDispatcher$p(this.this$0).unregister();
                SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
            }
        }, this.runningDisposable);
    }

    @Override
    protected void processKeyEvent(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getID() == 400) {
            this.eventsHandler.handleKeyTyped(e);
        } else if (e.getID() == 401) {
            this.eventsHandler.handleKeyPressed(e);
        }
    }

    private final void setupMouseListener() {
        this.editor.addEditorMouseListener(new EditorMouseListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (TerminalPanel.access$getSettings$p(this.this$0).enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
                    if (TerminalPanel.access$setupMouseListener$isRemoteMouseAction(this.this$0, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.logicalPosition");
                        LogicalPosition p = logicalPosition;
                        TerminalEventsHandler terminalEventsHandler = TerminalPanel.access$getEventsHandler$p(this.this$0);
                        int n = p.column;
                        int n2 = p.line + TerminalPanel.access$setupMouseListener$historyLinesCount(this.this$0);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"event.mouseEvent");
                        terminalEventsHandler.handleMousePressed(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (TerminalPanel.access$getSettings$p(this.this$0).enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
                    if (TerminalPanel.access$setupMouseListener$isRemoteMouseAction(this.this$0, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.logicalPosition");
                        LogicalPosition p = logicalPosition;
                        TerminalEventsHandler terminalEventsHandler = TerminalPanel.access$getEventsHandler$p(this.this$0);
                        int n = p.column;
                        int n2 = p.line + TerminalPanel.access$setupMouseListener$historyLinesCount(this.this$0);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"event.mouseEvent");
                        terminalEventsHandler.handleMouseReleased(n, n2, mouseEvent2);
                    }
                }
            }
        }, this.runningDisposable);
        this.editor.addEditorMouseMotionListener(new EditorMouseMotionListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (TerminalPanel.access$getSettings$p(this.this$0).enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
                    if (TerminalPanel.access$setupMouseListener$isRemoteMouseAction(this.this$0, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.logicalPosition");
                        LogicalPosition p = logicalPosition;
                        TerminalEventsHandler terminalEventsHandler = TerminalPanel.access$getEventsHandler$p(this.this$0);
                        int n = p.column;
                        int n2 = p.line + TerminalPanel.access$setupMouseListener$historyLinesCount(this.this$0);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"event.mouseEvent");
                        terminalEventsHandler.handleMouseMoved(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseDragged(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (TerminalPanel.access$getSettings$p(this.this$0).enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
                    if (TerminalPanel.access$setupMouseListener$isRemoteMouseAction(this.this$0, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.logicalPosition");
                        LogicalPosition p = logicalPosition;
                        TerminalEventsHandler terminalEventsHandler = TerminalPanel.access$getEventsHandler$p(this.this$0);
                        int n = p.column;
                        int n2 = p.line + TerminalPanel.access$setupMouseListener$historyLinesCount(this.this$0);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"event.mouseEvent");
                        terminalEventsHandler.handleMouseDragged(n, n2, mouseEvent2);
                    }
                }
            }
        }, this.runningDisposable);
        MouseWheelListener mouseWheelListener = arg_0 -> TerminalPanel.setupMouseListener$lambda$3(this, arg_0);
        this.editor.getScrollPane().addMouseWheelListener(mouseWheelListener);
        Disposer.register((Disposable)this.runningDisposable, () -> TerminalPanel.setupMouseListener$lambda$4(this, mouseWheelListener));
    }

    public final boolean isFocused() {
        return this.editor.getContentComponent().hasFocus();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension baseSize = super.getPreferredSize();
        JBInsets.addTo((Dimension)baseSize, (Insets)this.getInsets());
        int lineCount = Math.max(this.editor.getDocument().getLineCount(), 1);
        return new Dimension(baseSize.width, lineCount * this.editor.getLineHeight() + this.getInsets().top + this.getInsets().bottom);
    }

    @NotNull
    public final Dimension getContentSize() {
        return new Dimension(this.getWidth() - JBUI.scale((int)7), this.getHeight());
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        return (JComponent)editorComponentImpl;
    }

    public void dispose() {
    }

    private static final void keyEventsForwardingDisposable$lambda$0(TerminalPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.eventDispatcher.unregister();
    }

    private static final void _init_$lambda$1(TerminalPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EditorFactory.getInstance().releaseEditor((Editor)this$0.editor);
    }

    private static final boolean setupMouseListener$isRemoteMouseAction(TerminalPanel this$0, MouseEvent e) {
        return this$0.model.getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !e.isShiftDown();
    }

    private static final int setupMouseListener$historyLinesCount(TerminalPanel this$0) {
        return this$0.model.getUseAlternateBuffer() ? 0 : this$0.model.getHistoryLinesCount();
    }

    private static final void setupMouseListener$lambda$3(TerminalPanel this$0, MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.settings.enableMouseReporting()) {
            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
            if (TerminalPanel.setupMouseListener$isRemoteMouseAction(this$0, event)) {
                this$0.editor.getSelectionModel().removeSelection();
                LogicalPosition logicalPosition = this$0.editor.xyToLogicalPosition(event.getPoint());
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.xyToLogicalPosition(event.point)");
                LogicalPosition p = logicalPosition;
                this$0.eventsHandler.handleMouseWheelMoved(p.column, p.line + TerminalPanel.setupMouseListener$historyLinesCount(this$0), event);
            }
        }
    }

    private static final void setupMouseListener$lambda$4(TerminalPanel this$0, MouseWheelListener $mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mouseWheelListener, (String)"$mouseWheelListener");
        this$0.editor.getScrollPane().removeMouseWheelListener($mouseWheelListener);
    }

    public static final /* synthetic */ Disposable access$getKeyEventsForwardingDisposable$p(TerminalPanel $this) {
        return $this.keyEventsForwardingDisposable;
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(TerminalPanel $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$updateEditorContent(TerminalPanel $this) {
        $this.updateEditorContent();
    }

    public static final /* synthetic */ void access$updateEditor(TerminalPanel $this, TerminalContent content) {
        $this.updateEditor(content);
    }

    public static final /* synthetic */ TextAttributes access$toTextAttributes(TerminalPanel $this, TextStyle $receiver) {
        return $this.toTextAttributes($receiver);
    }

    public static final /* synthetic */ JBTerminalSystemSettingsProviderBase access$getSettings$p(TerminalPanel $this) {
        return $this.settings;
    }

    public static final /* synthetic */ TerminalEventDispatcher access$getEventDispatcher$p(TerminalPanel $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ boolean access$setupMouseListener$isRemoteMouseAction(TerminalPanel this$0, MouseEvent e) {
        return TerminalPanel.setupMouseListener$isRemoteMouseAction(this$0, e);
    }

    public static final /* synthetic */ TerminalEventsHandler access$getEventsHandler$p(TerminalPanel $this) {
        return $this.eventsHandler;
    }

    public static final /* synthetic */ int access$setupMouseListener$historyLinesCount(TerminalPanel this$0) {
        return TerminalPanel.setupMouseListener$historyLinesCount(this$0);
    }

    static {
        Object[] objectArray = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateBookmarksToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "ShowTypeBookmarks", "FindInPath", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow", "MaintenanceAction", "TerminalIncreaseFontSize", "TerminalDecreaseFontSize", "TerminalResetFontSize"};
        ACTIONS_TO_SKIP = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPanel$Companion;", "", "()V", "ACTIONS_TO_SKIP", "", "", "LEFT_INSET", "", "setupActionsToSkip", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPanel.kt\norg/jetbrains/plugins/terminal/exp/TerminalPanel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,459:1\n1603#2,9:460\n1855#2:469\n1856#2:471\n1612#2:472\n1#3:470\n*S KotlinDebug\n*F\n+ 1 TerminalPanel.kt\norg/jetbrains/plugins/terminal/exp/TerminalPanel$Companion\n*L\n456#1:460,9\n456#1:469\n456#1:471\n456#1:472\n456#1:470\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<AnAction> setupActionsToSkip() {
            void $this$mapNotNullTo$iv$iv;
            ActionManager actionManager = ActionManager.getInstance();
            Iterable $this$mapNotNull$iv = ACTIONS_TO_SKIP;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AnAction it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String actionId = (String)element$iv$iv;
                boolean bl2 = false;
                if (actionManager.getAction(actionId) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ List access$setupActionsToSkip(Companion $this) {
            return $this.setupActionsToSkip();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPanel$TerminalContent;", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getHighlightings", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class TerminalContent {
        @NotNull
        private final String text;
        @NotNull
        private final List<HighlightingInfo> highlightings;

        public TerminalContent(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.text = text;
            this.highlightings = highlightings;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> getHighlightings() {
            return this.highlightings;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> component2() {
            return this.highlightings;
        }

        @NotNull
        public final TerminalContent copy(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            return new TerminalContent(text, highlightings);
        }

        public static /* synthetic */ TerminalContent copy$default(TerminalContent terminalContent, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = terminalContent.text;
            }
            if ((n & 2) != 0) {
                list = terminalContent.highlightings;
            }
            return terminalContent.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "TerminalContent(text=" + this.text + ", highlightings=" + this.highlightings + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalContent)) {
                return false;
            }
            TerminalContent terminalContent = (TerminalContent)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)terminalContent.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.highlightings, terminalContent.highlightings);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPanel$TerminalEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalPanel;)V", "actionsToSkip", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "myRegistered", "", "dispatch", "e", "Ljava/awt/AWTEvent;", "dispatchKeyEvent", "", "Ljava/awt/event/KeyEvent;", "register", "skipAction", "unregister", "intellij.terminal"})
    private final class TerminalEventDispatcher
    implements IdeEventQueue.EventDispatcher {
        private boolean myRegistered;
        @NotNull
        private List<? extends AnAction> actionsToSkip = CollectionsKt.emptyList();

        public boolean dispatch(@NotNull AWTEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e instanceof KeyEvent) {
                this.dispatchKeyEvent((KeyEvent)e);
            }
            return false;
        }

        private final void dispatchKeyEvent(KeyEvent e) {
            if (!this.skipAction(e)) {
                if (TerminalPanel.this.isFocused()) {
                    TerminalPanel.this.processKeyEvent(e);
                } else {
                    this.unregister();
                }
            }
        }

        public final void register(@NotNull List<? extends AnAction> actionsToSkip) {
            Intrinsics.checkNotNullParameter(actionsToSkip, (String)"actionsToSkip");
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.actionsToSkip = actionsToSkip;
            if (!this.myRegistered) {
                IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, (Disposable)TerminalPanel.this);
                this.myRegistered = true;
            }
        }

        public final void unregister() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myRegistered) {
                IdeEventQueue.Companion.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
                this.actionsToSkip = CollectionsKt.emptyList();
                this.myRegistered = false;
            }
        }

        private final boolean skipAction(KeyEvent e) {
            KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
            for (AnAction anAction : this.actionsToSkip) {
                Shortcut[] shortcutArray;
                Intrinsics.checkNotNullExpressionValue((Object)anAction.getShortcutSet().getShortcuts(), (String)"action.shortcutSet.shortcuts");
                for (Shortcut sc : shortcutArray) {
                    if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                    if (!Registry.is((String)"terminal.Ctrl-E.opens.RecentFiles.popup", (boolean)false) && Intrinsics.areEqual((Object)"RecentFiles", (Object)ActionManager.getInstance().getId(anAction))) {
                        return e.getModifiersEx() == 128 && e.getKeyCode() == 69;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

