/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010!\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J!\u0010+\u001a\u00020\b2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "ignoreNextKeyTypedEvent", "", "lastMotionReport", "Ljava/awt/Point;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "terminalStarter", "Lcom/jediterm/terminal/TerminalStarter;", "getTerminalStarter", "()Lcom/jediterm/terminal/TerminalStarter;", "applyModifierKeys", "", "event", "Ljava/awt/event/MouseEvent;", "cb", "createButtonCode", "handleKeyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "handleKeyTyped", "handleMouseDragged", "x", "y", "handleMouseMoved", "handleMousePressed", "handleMouseReleased", "handleMouseWheelMoved", "isAltPressedOnly", "mouseReport", "", "button", "processCharacter", "processTerminalKeyPressed", "shouldSendMouseData", "eligibleModes", "", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "([Lcom/jediterm/terminal/emulator/mouse/MouseMode;)Z", "simpleMapKeyCodeToChar", "", "Companion", "intellij.terminal"})
public final class TerminalEventsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    private boolean ignoreNextKeyTypedEvent;
    @Nullable
    private Point lastMotionReport;
    @NotNull
    private static final Logger LOG;

    public TerminalEventsHandler(@NotNull TerminalSession session, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.session = session;
        this.settings = settings;
    }

    private final TerminalStarter getTerminalStarter() {
        return this.session.getTerminalStarter();
    }

    private final TerminalModel getModel() {
        return this.session.getModel();
    }

    public final void handleKeyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.ignoreNextKeyTypedEvent) {
            e.consume();
            return;
        }
        if (!Character.isISOControl(e.getKeyChar())) {
            try {
                if (this.processCharacter(e)) {
                    e.consume();
                }
            }
            catch (Exception ex) {
                LOG.error("Error sending typed key to emulator", (Throwable)ex);
            }
        }
    }

    public final void handleKeyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ignoreNextKeyTypedEvent = false;
        if (this.processTerminalKeyPressed(e)) {
            e.consume();
            this.ignoreNextKeyTypedEvent = true;
        }
    }

    private final boolean processTerminalKeyPressed(KeyEvent e) {
        try {
            int keyCode = e.getKeyCode();
            char keyChar = e.getKeyChar();
            if (keyCode == 127 && keyChar == '.') {
                byte[] byArray = new byte[]{46};
                this.getTerminalStarter().sendBytes(byArray, true);
                return true;
            }
            if (keyChar == ' ' && (e.getModifiersEx() & 0x80) != 0) {
                byte[] byArray = new byte[]{0};
                this.getTerminalStarter().sendBytes(byArray, true);
                return true;
            }
            byte[] code = this.getTerminalStarter().getCode(keyCode, e.getModifiers());
            if (code != null) {
                this.getTerminalStarter().sendBytes(code, true);
                return true;
            }
            if (this.isAltPressedOnly(e) && Character.isDefined(keyChar) && this.settings.altSendsEscape()) {
                char[] cArray = new char[]{'\u001b', this.simpleMapKeyCodeToChar(e)};
                String string = new String(cArray);
                this.getTerminalStarter().sendString(string, true);
                return true;
            }
            if (Character.isISOControl(keyChar)) {
                return this.processCharacter(e);
            }
        }
        catch (Exception ex) {
            LOG.error("Error sending pressed key to emulator", (Throwable)ex);
        }
        return false;
    }

    private final boolean processCharacter(KeyEvent e) {
        if (this.isAltPressedOnly(e) && this.settings.altSendsEscape()) {
            return false;
        }
        char keyChar = e.getKeyChar();
        if (keyChar == '`' && (e.getModifiersEx() & 0x100) != 0) {
            return false;
        }
        this.getTerminalStarter().sendString(String.valueOf(keyChar), true);
        return true;
    }

    private final boolean isAltPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final char simpleMapKeyCodeToChar(KeyEvent e) {
        char keyChar = (char)e.getKeyCode();
        return (e.getModifiersEx() & 0x40) != 0 ? Character.toUpperCase(keyChar) : Character.toLowerCase(keyChar);
    }

    public final void handleMousePressed(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            switch (code) {
                case 4: 
                case 5: {
                    int offset = 4;
                    code -= offset;
                    code |= 0x40;
                }
            }
            code = this.applyModifierKeys(event, code);
            this.getTerminalStarter().sendBytes(this.mouseReport(code, x + 1, y + 1), true);
        }
    }

    public final void handleMouseReleased(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code = this.getModel().getMouseFormat() == MouseFormat.MOUSE_FORMAT_SGR ? code | 0x80 : 3;
            code = this.applyModifierKeys(event, code);
            this.getTerminalStarter().sendBytes(this.mouseReport(code, x + 1, y + 1), true);
        }
        this.lastMotionReport = null;
    }

    public final void handleMouseMoved(int x, int y, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_ALL_MOTION};
        if (this.shouldSendMouseData(mouseModeArray)) {
            this.getTerminalStarter().sendBytes(this.mouseReport(3, x + 1, y + 1), true);
        }
        this.lastMotionReport = new Point(x, y);
    }

    public final void handleMouseDragged(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code |= 0x20;
            code = this.applyModifierKeys(event, code);
            this.getTerminalStarter().sendBytes(this.mouseReport(code, x + 1, y + 1), true);
        }
        this.lastMotionReport = new Point(x, y);
    }

    public final void handleMouseWheelMoved(int x, int y, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleMousePressed(x, y, event);
    }

    private final boolean shouldSendMouseData(MouseMode ... eligibleModes) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getModel().getMouseMode().ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> ArraysKt.contains((Object[])eligibleModes, (Object)this.getModel().getMouseMode());
        };
    }

    private final int createButtonCode(MouseEvent event) {
        int n;
        if (SwingUtilities.isLeftMouseButton(event)) {
            n = 0;
        } else if (SwingUtilities.isMiddleMouseButton(event)) {
            n = 1;
        } else if (SwingUtilities.isRightMouseButton(event)) {
            n = -1;
        } else if (event instanceof MouseWheelEvent) {
            n = ((MouseWheelEvent)event).getWheelRotation() > 0 ? 5 : 4;
        } else {
            return -1;
        }
        return n;
    }

    private final int applyModifierKeys(MouseEvent event, int cb) {
        int code = cb;
        if (event.isControlDown()) {
            code |= 0x10;
        }
        if (event.isShiftDown()) {
            code |= 4;
        }
        if ((event.getModifiersEx() & 4) != 0) {
            code |= 8;
        }
        return code;
    }

    private final byte[] mouseReport(int button, int x, int y) {
        String string;
        String charset = "UTF-8";
        switch (WhenMappings.$EnumSwitchMapping$1[this.getModel().getMouseFormat().ordinal()]) {
            case 1: {
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                break;
            }
            case 2: {
                String string2 = "\u001b[%d;%d;%dM";
                Object[] objectArray = new Object[]{32 + button, x, y};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                break;
            }
            case 3: {
                Object[] objectArray;
                String string2;
                if ((button & 0x80) != 0) {
                    string2 = "\u001b[<%d;%d;%dm";
                    objectArray = new Object[]{button ^ 0x80, x, y};
                    String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                    break;
                }
                string2 = "\u001b[<%d;%d;%dM";
                objectArray = new Object[]{button, x, y};
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                break;
            }
            default: {
                charset = "ISO-8859-1";
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
            }
        }
        String command = string;
        LOG.debug(this.getModel().getMouseFormat() + " (" + charset + ") report : " + button + ", " + x + "x" + y + " = " + command);
        String string8 = command;
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
        byte[] byArray = string8.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    static {
        Logger logger = Logger.getInstance(TerminalEventsHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(TerminalEventsHandler::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MouseMode.values().length];
            try {
                nArray[MouseMode.MOUSE_REPORTING_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseMode.MOUSE_REPORTING_ALL_MOTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MouseFormat.values().length];
            try {
                nArray[MouseFormat.MOUSE_FORMAT_XTERM_EXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_URXVT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_SGR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

