/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.core.Color;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalCustomCommandListener;
import com.jediterm.terminal.TerminalKeyEncoder;
import com.jediterm.terminal.TerminalMode;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.charset.CharacterSet;
import com.jediterm.terminal.emulator.charset.GraphicSet;
import com.jediterm.terminal.emulator.charset.GraphicSetState;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.StoredCursor;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.Tabulator;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.util.CharUtils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URI;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u00b2\u00012\u00020\u0001:\u0004\u00b2\u0001\u00b3\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J \u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0002J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002J\b\u00101\u001a\u00020\u001eH\u0016J\b\u00102\u001a\u00020\u001eH\u0016J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u000fH\u0016J\u0010\u00107\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u000fH\u0016J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u000fH\u0016J\u0018\u0010:\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000fH\u0016J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000fH\u0016J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0018\u0010D\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u00020\u001e2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0012\u0010K\u001a\u00020\u001e2\b\u0010L\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010M\u001a\u00020\u001eH\u0016J\b\u0010N\u001a\u00020\u000fH\u0016J \u0010O\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u000fH\u0002J\u0010\u0010U\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020QH\u0002J\u0010\u0010W\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0010\u0010X\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020\u000fH\u0016J\u0010\u0010Z\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020\u000fH\u0016J\u0010\u0010[\u001a\u00020\u001e2\u0006\u0010\\\u001a\u00020GH\u0016J\u001a\u0010]\u001a\u0004\u0018\u00010J2\u0006\u0010^\u001a\u00020\u000f2\u0006\u0010_\u001a\u00020\u000fH\u0016J\b\u0010`\u001a\u00020\u000fH\u0016J\b\u0010a\u001a\u00020\u000fH\u0016J\b\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020\u000fH\u0016J\b\u0010e\u001a\u00020\u000fH\u0016J\b\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u00020gH\u0016J\b\u0010i\u001a\u00020\u001eH\u0016J\b\u0010j\u001a\u00020\u001eH\u0016J\b\u0010k\u001a\u00020\u001eH\u0002J\b\u0010l\u001a\u00020\u001eH\u0002J\u0010\u0010m\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0010\u0010n\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\b\u0010o\u001a\u00020\bH\u0002J\b\u0010p\u001a\u00020\bH\u0002J\b\u0010q\u001a\u00020\bH\u0002J\u0010\u0010r\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u000fH\u0016J\u0010\u0010s\u001a\u00020\u001e2\u0006\u0010t\u001a\u00020\u000fH\u0016J\u0010\u0010u\u001a\u00020\u001e2\u0006\u0010t\u001a\u00020\u000fH\u0016J\b\u0010v\u001a\u00020\u001eH\u0016J\b\u0010w\u001a\u00020\u001eH\u0016J\u0016\u0010x\u001a\u00020\u001e2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u001c0\nH\u0016J\u0010\u0010z\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010{\u001a\u00020\u001eH\u0016J\b\u0010|\u001a\u00020\u001eH\u0016J\u0018\u0010}\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020~2\u0006\u0010R\u001a\u00020SH\u0016J%\u0010}\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020~2\u0006\u0010R\u001a\u00020S2\u000b\u0010\u007f\u001a\u0007\u0012\u0002\b\u00030\u0080\u0001H\u0016J\t\u0010\u0081\u0001\u001a\u00020\u001eH\u0016J\u0011\u0010\u0081\u0001\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\t\u0010\u0082\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0083\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0084\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0085\u0001\u001a\u00020\u001eH\u0016J\u0011\u0010\u0086\u0001\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0011\u0010\u0087\u0001\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u000fH\u0016J\u0011\u0010\u0088\u0001\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0002J\t\u0010\u0089\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u008a\u0001\u001a\u00020\u000fH\u0002J\u0012\u0010\u008b\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u008d\u0001\u001a\u00020\u001e2\u0007\u0010\u008e\u0001\u001a\u00020\u000fH\u0016J\u0012\u0010\u008f\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0090\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0091\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0092\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0093\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0094\u0001\u001a\u00020\u001e2\u0007\u0010\u0095\u0001\u001a\u00020\bH\u0016J\t\u0010\u0096\u0001\u001a\u00020\u001eH\u0016J\u0012\u0010\u0097\u0001\u001a\u00020\u001e2\u0007\u0010\u0098\u0001\u001a\u00020\u001cH\u0016J\u001b\u0010\u0099\u0001\u001a\u00020\u001e2\u0007\u0010\u009a\u0001\u001a\u00020\u00192\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\u0013\u0010\u009b\u0001\u001a\u00020\u001e2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0013\u0010\u009e\u0001\u001a\u00020\u001e2\b\u0010\u009a\u0001\u001a\u00030\u009f\u0001H\u0016J\u001b\u0010\u00a0\u0001\u001a\u00020\u001e2\u0007\u0010\u00a1\u0001\u001a\u00020\u000f2\u0007\u0010\u00a2\u0001\u001a\u00020\u000fH\u0016J\t\u0010\u00a3\u0001\u001a\u00020\u001eH\u0016J\u0015\u0010\u00a4\u0001\u001a\u00020\u001e2\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u0001H\u0016J\u0012\u0010\u00a7\u0001\u001a\u00020\u001e2\u0007\u0010\u00a8\u0001\u001a\u00020\u001cH\u0016J\u0011\u0010\u00a9\u0001\u001a\u00020\u001e2\u0006\u0010t\u001a\u00020\u000fH\u0016J\u0012\u0010\u00aa\u0001\u001a\u00020\u001e2\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0016J\t\u0010\u00ab\u0001\u001a\u00020\u001eH\u0002J\u0012\u0010\u00ac\u0001\u001a\u00020\u001e2\u0007\u0010\u00ad\u0001\u001a\u00020\u001cH\u0016J\u0011\u0010\u00ae\u0001\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!H\u0002J\u0012\u0010\u00af\u0001\u001a\u00020\u001e2\u0007\u0010\u00b0\u0001\u001a\u00020!H\u0016J\u0012\u0010\u00b1\u0001\u001a\u00020\u001e2\u0007\u0010\u00ad\u0001\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b4\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalController;", "Lcom/jediterm/terminal/Terminal;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalModel;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "cursorYChanged", "", "customCommandListeners", "", "Lcom/jediterm/terminal/TerminalCustomCommandListener;", "graphicSetState", "Lcom/jediterm/terminal/emulator/charset/GraphicSetState;", "scrollRegionBottom", "", "scrollRegionTop", "storedCursor", "Lcom/jediterm/terminal/model/StoredCursor;", "tabulator", "Lcom/jediterm/terminal/model/Tabulator;", "terminalKeyEncoder", "Lcom/jediterm/terminal/TerminalKeyEncoder;", "terminalModes", "Ljava/util/EnumSet;", "Lcom/jediterm/terminal/TerminalMode;", "windowTitlesStack", "Ljava/util/Stack;", "", "addCustomCommandListener", "", "listener", "adjustCharBuffer", "", "chars", "adjustX", "cursorX", "cursorY", "dx", "backspace", "beep", "carriageReturn", "characterAttributes", "textStyle", "Lcom/jediterm/terminal/TextStyle;", "clearAllTabStops", "clearLines", "beginY", "endY", "clearScreen", "clearTabStopAtCursor", "cursorBackward", "dX", "cursorDown", "dY", "cursorForward", "cursorHorizontalAbsolute", "x", "cursorPosition", "y", "cursorShape", "shape", "Lcom/jediterm/terminal/CursorShape;", "cursorUp", "countY", "deleteCharacters", "count", "deleteLines", "designateCharacterSet", "tableNumber", "charset", "", "deviceAttributes", "response", "", "deviceStatusReport", "str", "disconnected", "distanceToLineEnd", "doResize", "newTermSize", "Ljava/awt/Dimension;", "origin", "Lcom/jediterm/terminal/RequestOrigin;", "oldHeight", "ensureTermMinimumSize", "termSize", "eraseCharacters", "eraseInDisplay", "arg", "eraseInLine", "fillScreen", "c", "getCodeForKey", "key", "modifiers", "getCursorX", "getCursorY", "getStyleState", "Lcom/jediterm/terminal/model/StyleState;", "getTerminalHeight", "getTerminalWidth", "getWindowBackground", "Lcom/jediterm/core/Color;", "getWindowForeground", "horizontalTab", "index", "initModes", "initMouseModes", "insertBlankCharacters", "insertLines", "isAutoNewLine", "isAutoWrap", "isOriginMode", "linePositionAbsolute", "mapCharsetToGL", "num", "mapCharsetToGR", "newLine", "nextLine", "processCustomCommand", "args", "removeCustomCommandListener", "reset", "resetScrollRegions", "resize", "Lcom/jediterm/core/util/TermSize;", "promptUpdated", "Ljava/util/concurrent/CompletableFuture;", "restoreCursor", "restoreWindowTitleFromStack", "reverseIndex", "saveCursor", "saveWindowTitleOnStack", "scrollDown", "scrollUp", "scrollY", "scrollingRegionBottom", "scrollingRegionTop", "setAltSendsEscape", "enabled", "setAnsiConformanceLevel", "level", "setApplicationArrowKeys", "setApplicationKeypad", "setAutoNewLine", "setBlinkingCursor", "setBracketedPasteMode", "setCursorVisible", "visible", "setLinkUriFinished", "setLinkUriStarted", "uri", "setModeEnabled", "mode", "setMouseFormat", "mouseFormat", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "setMouseMode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setScrollingRegion", "top", "bottom", "setTabStopAtCursor", "setTerminalOutput", "terminalOutput", "Lcom/jediterm/terminal/TerminalOutputStream;", "setWindowTitle", "name", "singleShiftSelect", "useAlternateBuffer", "wrapLines", "writeCharacters", "string", "writeDecodedCharacters", "writeDoubleByte", "bytesOfChar", "writeUnwrappedString", "Companion", "DefaultTabulator", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalController.kt\norg/jetbrains/plugins/terminal/exp/TerminalController\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,814:1\n251#2,7:815\n251#2,7:822\n251#2,7:829\n251#2,7:836\n251#2,7:843\n251#2,7:850\n251#2,7:857\n251#2,7:864\n251#2,7:871\n251#2,7:878\n251#2,7:885\n251#2,7:892\n251#2,7:899\n251#2,7:906\n251#2,7:913\n251#2,7:920\n251#2,7:927\n1#3:934\n*S KotlinDebug\n*F\n+ 1 TerminalController.kt\norg/jetbrains/plugins/terminal/exp/TerminalController\n*L\n144#1:815,7\n198#1:822,7\n255#1:829,7\n267#1:836,7\n280#1:843,7\n290#1:850,7\n374#1:857,7\n414#1:864,7\n423#1:871,7\n448#1:878,7\n468#1:885,7\n478#1:892,7\n510#1:899,7\n604#1:906,7\n610#1:913,7\n622#1:920,7\n628#1:927,7\n*E\n"})
public final class TerminalController
implements Terminal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalModel model;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final Tabulator tabulator;
    @NotNull
    private final TerminalKeyEncoder terminalKeyEncoder;
    @NotNull
    private final EnumSet<TerminalMode> terminalModes;
    @NotNull
    private final GraphicSetState graphicSetState;
    @NotNull
    private final Stack<String> windowTitlesStack;
    private boolean cursorYChanged;
    private int scrollRegionTop;
    private int scrollRegionBottom;
    @Nullable
    private StoredCursor storedCursor;
    @NotNull
    private final List<TerminalCustomCommandListener> customCommandListeners;
    @NotNull
    private static final Logger LOG;

    public TerminalController(@NotNull TerminalModel model, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.model = model;
        this.settings = settings;
        this.tabulator = new DefaultTabulator(this.model.getWidth(), 0, 2, null);
        this.terminalKeyEncoder = new TerminalKeyEncoder();
        EnumSet<TerminalMode> enumSet = EnumSet.noneOf(TerminalMode.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(TerminalMode::class.java)");
        this.terminalModes = enumSet;
        this.graphicSetState = new GraphicSetState();
        this.windowTitlesStack = new Stack();
        this.scrollRegionTop = 1;
        this.scrollRegionBottom = this.model.getHeight();
        this.reset();
        this.customCommandListeners = new CopyOnWriteArrayList();
    }

    public void resize(@NotNull TermSize newTermSize, @NotNull RequestOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)newTermSize, (String)"newTermSize");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
        this.resize(newTermSize, origin, completableFuture);
    }

    public void resize(@NotNull TermSize newTermSize, @NotNull RequestOrigin origin, @NotNull CompletableFuture<?> promptUpdated) {
        Intrinsics.checkNotNullParameter((Object)newTermSize, (String)"newTermSize");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(promptUpdated, (String)"promptUpdated");
        Dimension newSize = new Dimension(newTermSize.getColumns(), newTermSize.getRows());
        this.ensureTermMinimumSize(newSize);
        if (this.model.getWidth() == newSize.width && this.model.getHeight() == newSize.height) {
            return;
        }
        int oldHeight = this.model.getHeight();
        if (newSize.width == this.model.getWidth()) {
            this.doResize(newSize, origin, oldHeight);
        } else {
            promptUpdated.thenRun(() -> TerminalController.resize$lambda$0(this, newSize, origin, oldHeight));
        }
    }

    private final void doResize(Dimension newTermSize, RequestOrigin origin, int oldHeight) {
        this.model.resize(newTermSize, origin, this.model.getCursorX(), this.model.getCursorY(), null, (arg_0, arg_1, arg_2, arg_3) -> TerminalController.doResize$lambda$1(this, arg_0, arg_1, arg_2, arg_3));
        this.scrollRegionBottom += this.model.getHeight() - oldHeight;
    }

    private final void ensureTermMinimumSize(Dimension termSize) {
        termSize.setSize(Math.max(5, termSize.width), Math.max(2, termSize.height));
    }

    public void beep() {
        if (this.model.isCommandRunning() && this.settings.audibleBell()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void backspace() {
        int cursorX = this.model.getCursorX();
        int cursorY = this.model.getCursorY();
        if (--cursorX < 0) {
            --cursorY;
            cursorX = this.model.getWidth() - 1;
        }
        cursorX = this.adjustX(cursorX, cursorY, -1);
        this.model.setCursor(cursorX, cursorY);
    }

    private final int adjustX(int cursorX, int cursorY, int dx) {
        return cursorY > -this.model.getHistoryLinesCount() && Character.isLowSurrogate(this.model.charAt(cursorX, cursorY - 1)) ? (dx > 0 ? (cursorX == this.model.getWidth() ? cursorX - 1 : cursorX + 1) : cursorX - 1) : cursorX;
    }

    public void horizontalTab() {
        if (this.model.getCursorX() >= this.model.getWidth()) {
            return;
        }
        int length = this.model.getLine(this.model.getCursorY() - 1).getText().length();
        int stop = this.tabulator.nextTab(this.model.getCursorX());
        int newCursorX = Math.max(this.model.getCursorX(), length);
        if (newCursorX < stop) {
            int n = 0;
            int n2 = stop - newCursorX;
            char[] cArray = new char[n2];
            while (n < n2) {
                int n3 = n++;
                cArray[n3] = 32;
            }
            char[] chars = cArray;
            this.writeDecodedCharacters(chars);
        } else {
            newCursorX = stop;
        }
        newCursorX = this.adjustX(newCursorX, this.model.getCursorY(), 1);
        this.model.setCursor(newCursorX, this.model.getCursorY());
    }

    public void carriageReturn() {
        this.model.setCursor(0, this.model.getCursorY());
    }

    public void newLine() {
        this.cursorYChanged = true;
        int newCursorY = this.scrollY(this.model.getCursorY() + 1);
        if (this.isAutoNewLine()) {
            this.carriageReturn();
        }
        this.model.setCursor(this.model.getCursorX(), newCursorY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int scrollY(int cursorY) {
        int n;
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            int n2;
            boolean bl = false;
            if (cursorY > this.scrollRegionBottom) {
                this.model.scrollArea(this.scrollRegionTop, this.scrollRegionBottom, this.scrollRegionBottom - cursorY);
                n2 = this.scrollRegionBottom;
            } else {
                n2 = cursorY < this.scrollRegionTop ? this.scrollRegionTop : cursorY;
            }
            n = n2;
        }
        finally {
            this_$iv.unlockContent();
        }
        return n;
    }

    public void mapCharsetToGL(int num) {
        this.graphicSetState.setGL(num);
    }

    public void mapCharsetToGR(int num) {
        this.graphicSetState.setGR(num);
    }

    public void designateCharacterSet(int tableNumber, char charset) {
        GraphicSet graphicSet = this.graphicSetState.getGraphicSet(tableNumber);
        Intrinsics.checkNotNullExpressionValue((Object)graphicSet, (String)"graphicSetState.getGraphicSet(tableNumber)");
        GraphicSet gs = graphicSet;
        this.graphicSetState.designateGraphicSet(gs, charset);
    }

    public void setAnsiConformanceLevel(int level) {
        switch (level) {
            case 1: 
            case 2: {
                this.graphicSetState.designateGraphicSet(0, CharacterSet.ASCII);
                this.graphicSetState.designateGraphicSet(1, CharacterSet.DEC_SUPPLEMENTAL);
                this.mapCharsetToGL(0);
                this.mapCharsetToGR(1);
                break;
            }
            case 3: {
                this.designateCharacterSet(0, 'B');
                this.mapCharsetToGL(0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void writeDoubleByte(@NotNull char[] bytesOfChar) {
        Intrinsics.checkNotNullParameter((Object)bytesOfChar, (String)"bytesOfChar");
        this.writeCharacters(new String(bytesOfChar, 0, 2));
    }

    public void writeCharacters(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = 0;
        int n2 = string.length();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = this.graphicSetState.map(string.charAt(n3));
        }
        char[] decodedChars = cArray;
        this.writeDecodedCharacters(decodedChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDecodedCharacters(char[] chars) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            if (this.cursorYChanged && !(chars.length == 0)) {
                this.cursorYChanged = false;
                if (this.model.getCursorY() > 1) {
                    this.model.setLineWrapped(this.model.getCursorY() - 2, false);
                }
            }
            this.wrapLines();
            int newCursorY = this.scrollY(this.model.getCursorY());
            this.model.setCursor(this.model.getCursorX(), newCursorY);
            if (!(chars.length == 0)) {
                char[] characters = this.adjustCharBuffer(chars);
                this.model.writeString(this.model.getCursorX(), newCursorY, characters);
                this.model.setCursor(this.model.getCursorX() + characters.length, newCursorY);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    private final void wrapLines() {
        if (this.model.getCursorX() >= this.model.getWidth()) {
            this.model.eraseLine(this.model.getCursorY() - 1, this.model.getWidth());
            if (this.isAutoWrap()) {
                this.model.setLineWrapped(this.model.getCursorY() - 1, true);
                this.model.setCursor(0, this.model.getCursorY() + 1);
            } else {
                this.model.setCursor(0, this.model.getCursorY());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final char[] adjustCharBuffer(char[] chars) {
        char[] cArray;
        int dwcCount = CharUtils.countDoubleWidthCharacters((char[])chars, (int)0, (int)chars.length, (boolean)this.settings.ambiguousCharsAreDoubleWidth());
        if (dwcCount > 0) {
            void var3_3;
            char[] result2 = new char[chars.length + dwcCount];
            int j = 0;
            int n = chars.length;
            for (int i = 0; i < n; ++i) {
                result2[j] = chars[i];
                int codePoint = Character.codePointAt(chars, i);
                boolean doubleWidthCharacter = CharUtils.isDoubleWidthCharacter((int)codePoint, (boolean)this.settings.ambiguousCharsAreDoubleWidth());
                if (doubleWidthCharacter) {
                    result2[++j] = 57344;
                }
                ++j;
            }
            cArray = var3_3;
        } else {
            cArray = chars;
        }
        return cArray;
    }

    public int distanceToLineEnd() {
        return this.model.getWidth() - this.model.getCursorX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseIndex() {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            if (this.model.getCursorY() == this.scrollRegionTop) {
                this.model.scrollArea(this.scrollRegionTop, this.scrollRegionBottom, 1);
            } else {
                this.model.setCursor(this.model.getCursorX(), this.model.getCursorY() - 1);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            if (this.model.getCursorY() == this.scrollRegionBottom) {
                this.model.scrollArea(this.scrollRegionTop, this.scrollRegionBottom, -1);
            } else {
                int newCursorY = this.model.getCursorY() + 1;
                int newCursorX = this.adjustX(this.model.getCursorX(), newCursorY, -1);
                this.model.setCursor(newCursorX, newCursorY);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLine() {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            if (this.model.getCursorY() == this.scrollRegionBottom) {
                this.model.scrollArea(this.scrollRegionTop, this.scrollRegionBottom, -1);
                this.model.setCursor(0, this.model.getCursorY());
            } else {
                this.model.setCursor(0, this.model.getCursorY() + 1);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillScreen(char c) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            int n = 0;
            int n2 = this.model.getWidth();
            char[] cArray = new char[n2];
            TerminalController terminalController = this;
            while (n < n2) {
                int n3 = n++;
                cArray[n3] = c;
            }
            char[] chars = terminalController.adjustCharBuffer(cArray);
            int row = 1;
            n2 = this.model.getHeight();
            if (row <= n2) {
                while (true) {
                    this.model.writeString(0, row, chars);
                    if (row == n2) break;
                    ++row;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void saveCursor() {
        this.storedCursor = new StoredCursor(this.model.getCursorX(), this.model.getCursorY(), this.model.getStyleState().getCurrent(), this.isAutoWrap(), this.isOriginMode(), this.graphicSetState);
    }

    public void restoreCursor() {
        StoredCursor cursor = this.storedCursor;
        if (cursor != null) {
            this.restoreCursor(cursor);
        } else {
            this.setModeEnabled(TerminalMode.OriginMode, false);
            this.cursorPosition(1, 1);
            this.model.getStyleState().reset();
            this.graphicSetState.resetState();
        }
    }

    private final void restoreCursor(StoredCursor storedCursor) {
        int cursorX = this.adjustX(storedCursor.getCursorX(), storedCursor.getCursorY(), -1);
        this.model.setCursor(cursorX, storedCursor.getCursorY());
        this.model.getStyleState().setCurrent(storedCursor.getTextStyle());
        this.setModeEnabled(TerminalMode.AutoWrap, storedCursor.isAutoWrap());
        this.setModeEnabled(TerminalMode.OriginMode, storedCursor.isOriginMode());
        CharacterSet[] designations = storedCursor.getDesignations();
        int n = designations.length;
        for (int i = 0; i < n; ++i) {
            this.graphicSetState.designateGraphicSet(i, designations[i]);
        }
        this.graphicSetState.setGL(storedCursor.getGLMapping());
        this.graphicSetState.setGR(storedCursor.getGRMapping());
        if (storedCursor.getGLOverride() >= 0) {
            this.graphicSetState.overrideGL(storedCursor.getGLOverride());
        }
    }

    public void reset() {
        this.graphicSetState.resetState();
        this.model.getStyleState().reset();
        this.model.clearAll();
        this.model.setScrollingEnabled(true);
        this.initModes();
        this.initMouseModes();
        this.cursorPosition(1, 1);
    }

    private final void initMouseModes() {
        this.setMouseMode(MouseMode.MOUSE_REPORTING_NONE);
        this.setMouseFormat(MouseFormat.MOUSE_FORMAT_XTERM);
    }

    public void characterAttributes(@NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        this.model.getStyleState().setCurrent(textStyle);
    }

    public void setScrollingRegion(int top, int bottom) {
        if (top > bottom) {
            LOG.error("Top margin of scroll region can't be greater then bottom: " + top + ">" + bottom);
        }
        this.scrollRegionTop = Math.max(1, top);
        this.scrollRegionBottom = Math.min(this.model.getHeight(), bottom);
        this.cursorPosition(1, 1);
    }

    public void scrollUp(int count) {
        this.scrollDown(-count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollDown(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.scrollArea(this.scrollRegionTop, this.scrollRegionBottom, count);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void resetScrollRegions() {
        this.setScrollingRegion(1, this.model.getHeight());
    }

    public void cursorHorizontalAbsolute(int x) {
        this.cursorPosition(x, this.model.getCursorY());
    }

    public void linePositionAbsolute(int y) {
        int cursorX = this.adjustX(this.model.getCursorX(), y, -1);
        this.model.setCursor(cursorX, y);
    }

    public void cursorPosition(int x, int y) {
        int cursorY = this.isOriginMode() ? y + this.scrollRegionTop - 1 : y;
        cursorY = Math.min(cursorY, this.scrollingRegionBottom());
        cursorY = Math.max(0, cursorY);
        int cursorX = Math.max(0, x - 1);
        cursorX = Math.min(cursorX, this.model.getWidth() - 1);
        cursorX = this.adjustX(cursorX, cursorY, -1);
        this.model.setCursor(cursorX, cursorY);
    }

    private final int scrollingRegionTop() {
        return this.isOriginMode() ? this.scrollRegionTop : 1;
    }

    private final int scrollingRegionBottom() {
        return this.isOriginMode() ? this.scrollRegionBottom : this.model.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorUp(int countY) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.cursorYChanged = true;
            int cursorY = Math.max(this.model.getCursorY() - countY, this.scrollingRegionTop());
            int cursorX = this.adjustX(this.model.getCursorX(), cursorY, -1);
            this.model.setCursor(cursorX, cursorY);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorDown(int dY) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.cursorYChanged = true;
            int cursorY = Math.min(this.model.getCursorY() + dY, this.scrollingRegionBottom());
            int cursorX = this.adjustX(this.model.getCursorX(), cursorY, -1);
            this.model.setCursor(cursorX, cursorY);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void cursorForward(int dX) {
        int cursorX = Math.min(this.model.getCursorX() + dX, this.model.getWidth() - 1);
        cursorX = this.adjustX(cursorX, this.model.getCursorY(), 1);
        this.model.setCursor(cursorX, this.model.getCursorY());
    }

    public void cursorBackward(int dX) {
        int cursorX = Math.max(this.model.getCursorX() - dX, 0);
        cursorX = this.adjustX(cursorX, this.model.getCursorY(), -1);
        this.model.setCursor(cursorX, this.model.getCursorY());
    }

    public void cursorShape(@NotNull CursorShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.model.setCursorShape(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseInLine(int arg) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            switch (arg) {
                case 0: {
                    if (this.model.getCursorX() < this.model.getWidth()) {
                        this.model.eraseCharacters(this.model.getCursorX(), -1, this.model.getCursorY() - 1);
                    }
                    this.model.setLineWrapped(this.model.getCursorY() - 1, false);
                    break;
                }
                case 1: {
                    int extent = Math.min(this.model.getCursorX() + 1, this.model.getWidth());
                    this.model.eraseCharacters(0, extent, this.model.getCursorY() - 1);
                    break;
                }
                case 2: {
                    this.model.eraseCharacters(0, -1, this.model.getCursorY() - 1);
                    break;
                }
                default: {
                    LOG.warn("Unsupported erase in line mode: " + arg);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCharacters(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.deleteCharacters(this.model.getCursorX(), this.model.getCursorY() - 1, count);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public int getTerminalWidth() {
        return this.model.getWidth();
    }

    public int getTerminalHeight() {
        return this.model.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseInDisplay(int arg) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            Pair pair = switch (arg) {
                case 0 -> {
                    if (this.model.getCursorX() < this.model.getWidth()) {
                        this.model.eraseCharacters(this.model.getCursorX(), -1, this.model.getCursorY() - 1);
                    }
                    yield TuplesKt.to((Object)this.model.getCursorY(), (Object)(this.model.getHeight() - 1));
                }
                case 1 -> {
                    this.model.eraseCharacters(0, this.model.getCursorX() + 1, this.model.getCursorY() - 1);
                    yield TuplesKt.to((Object)0, (Object)(this.model.getCursorY() - 1));
                }
                case 2 -> {
                    this.model.moveScreenLinesToHistory();
                    yield TuplesKt.to((Object)0, (Object)(this.model.getHeight() - 1));
                }
                default -> {
                    LOG.warn("Unsupported erase in display mode: " + arg);
                    yield TuplesKt.to((Object)1, (Object)1);
                }
            };
            int beginY = ((Number)pair.component1()).intValue();
            int endY = ((Number)pair.component2()).intValue();
            if (beginY != endY) {
                this.clearLines(beginY, endY);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearLines(int beginY, int endY) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.clearLines(beginY, endY);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void setModeEnabled(@NotNull TerminalMode mode, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (enabled) {
            this.terminalModes.add(mode);
        } else {
            this.terminalModes.remove(mode);
        }
        mode.setEnabled((Terminal)this, enabled);
    }

    private final void initModes() {
        this.terminalModes.clear();
        this.setModeEnabled(TerminalMode.AutoWrap, true);
        this.setModeEnabled(TerminalMode.AutoNewLine, false);
        this.setModeEnabled(TerminalMode.CursorVisible, true);
        this.setModeEnabled(TerminalMode.CursorBlinking, true);
    }

    private final boolean isAutoNewLine() {
        return this.terminalModes.contains(TerminalMode.AutoNewLine);
    }

    private final boolean isOriginMode() {
        return this.terminalModes.contains(TerminalMode.OriginMode);
    }

    private final boolean isAutoWrap() {
        return this.terminalModes.contains(TerminalMode.AutoWrap);
    }

    public void disconnected() {
        this.model.setCursorVisible(false);
    }

    public int getCursorX() {
        return this.model.getCursorX() + 1;
    }

    public int getCursorY() {
        return this.model.getCursorY();
    }

    public void singleShiftSelect(int num) {
        this.graphicSetState.overrideGL(num);
    }

    public void setWindowTitle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.model.setWindowTitle(name);
    }

    public void saveWindowTitleOnStack() {
        this.windowTitlesStack.push(this.model.getWindowTitle());
    }

    public void restoreWindowTitleFromStack() {
        if (!this.windowTitlesStack.empty()) {
            String title = this.windowTitlesStack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
            this.model.setWindowTitle(title);
        }
    }

    public void clearScreen() {
        this.clearLines(0, this.model.getHeight() - 1);
    }

    public void setCursorVisible(boolean visible) {
        this.model.setCursorVisible(visible);
    }

    public void useAlternateBuffer(boolean enabled) {
        this.model.setUseAlternateBuffer(enabled);
        this.model.setScrollingEnabled(!enabled);
    }

    @Nullable
    public byte[] getCodeForKey(int key, int modifiers) {
        return this.terminalKeyEncoder.getCode(key, modifiers);
    }

    public void setApplicationArrowKeys(boolean enabled) {
        if (enabled) {
            this.terminalKeyEncoder.arrowKeysApplicationSequences();
        } else {
            this.terminalKeyEncoder.arrowKeysAnsiCursorSequences();
        }
    }

    public void setApplicationKeypad(boolean enabled) {
        if (enabled) {
            this.terminalKeyEncoder.keypadApplicationSequences();
        } else {
            this.terminalKeyEncoder.keypadAnsiSequences();
        }
    }

    public void setAutoNewLine(boolean enabled) {
        this.terminalKeyEncoder.setAutoNewLine(enabled);
    }

    @NotNull
    public StyleState getStyleState() {
        return this.model.getStyleState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLines(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.insertLines(this.model.getCursorY() - 1, count, this.scrollRegionBottom);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLines(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.deleteLines(this.model.getCursorY() - 1, count, this.scrollRegionBottom);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void setBlinkingCursor(boolean enabled) {
        this.model.setCursorBlinking(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseCharacters(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.model.eraseCharacters(this.model.getCursorX(), this.model.getCursorX() + count, this.model.getCursorY() - 1);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBlankCharacters(int count) {
        TerminalModel this_$iv = this.model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            int extent = Math.min(count, this.model.getWidth() - this.model.getCursorX());
            this.model.insertBlankCharacters(this.model.getCursorX(), this.model.getCursorY() - 1, extent);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    public void clearTabStopAtCursor() {
        this.tabulator.clearTabStop(this.model.getCursorX());
    }

    public void clearAllTabStops() {
        this.tabulator.clearAllTabStops();
    }

    public void setTabStopAtCursor() {
        this.tabulator.setTabStop(this.model.getCursorX());
    }

    public void writeUnwrappedString(@NotNull String string) {
        int amountInLine;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int length = string.length();
        for (int ind = 0; ind < length; ind += amountInLine) {
            amountInLine = Math.min(this.distanceToLineEnd(), length - ind);
            String string2 = string.substring(ind, ind + amountInLine);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.writeCharacters(string2);
            this.wrapLines();
            int cursorY = this.scrollY(this.model.getCursorY());
            this.model.setCursor(this.model.getCursorX(), cursorY);
        }
    }

    public void setMouseMode(@NotNull MouseMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.model.setMouseMode(mode);
    }

    public void setMouseFormat(@NotNull MouseFormat mouseFormat) {
        Intrinsics.checkNotNullParameter((Object)mouseFormat, (String)"mouseFormat");
        this.model.setMouseFormat(mouseFormat);
    }

    public void setAltSendsEscape(boolean enabled) {
        this.terminalKeyEncoder.setAltSendsEscape(enabled);
    }

    public void setTerminalOutput(@Nullable TerminalOutputStream terminalOutput) {
    }

    public void deviceStatusReport(@Nullable String str) {
    }

    public void deviceAttributes(@Nullable byte[] response) {
    }

    public void setLinkUriStarted(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        TextStyle textStyle = this.model.getStyleState().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"model.styleState.current");
        TextStyle style = textStyle;
        this.model.getStyleState().setCurrent((TextStyle)new HyperlinkStyle(style, new LinkInfo(() -> TerminalController.setLinkUriStarted$lambda$19(uri))));
    }

    public void setLinkUriFinished() {
        block1: {
            TextStyle textStyle = this.model.getStyleState().getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"model.styleState.current");
            TextStyle current = textStyle;
            if (!(current instanceof HyperlinkStyle)) break block1;
            TextStyle textStyle2 = ((HyperlinkStyle)current).getPrevTextStyle();
            if (textStyle2 != null) {
                TextStyle it = textStyle2;
                boolean bl = false;
                this.model.getStyleState().setCurrent(it);
            }
        }
    }

    public void setBracketedPasteMode(boolean enabled) {
        this.model.setBracketedPasteMode(enabled);
    }

    @NotNull
    public Color getWindowForeground() {
        Color color = this.settings.getTerminalColorPalette().getForeground(this.model.getStyleState().getForeground());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"settings.terminalColorPa\u2026el.styleState.foreground)");
        return color;
    }

    @NotNull
    public Color getWindowBackground() {
        Color color = this.settings.getTerminalColorPalette().getBackground(this.model.getStyleState().getBackground());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"settings.terminalColorPa\u2026el.styleState.background)");
        return color;
    }

    public void addCustomCommandListener(@NotNull TerminalCustomCommandListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.customCommandListeners.add(listener);
    }

    public void removeCustomCommandListener(@NotNull TerminalCustomCommandListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.customCommandListeners.remove(listener);
    }

    public void processCustomCommand(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        for (TerminalCustomCommandListener customCommandListener : this.customCommandListeners) {
            customCommandListener.process(args);
        }
    }

    private static final void resize$lambda$0(TerminalController this$0, Dimension $newSize, RequestOrigin $origin, int $oldHeight) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newSize, (String)"$newSize");
        Intrinsics.checkNotNullParameter((Object)$origin, (String)"$origin");
        this$0.doResize($newSize, $origin, $oldHeight);
    }

    private static final void doResize$lambda$1(TerminalController this$0, int n, int n2, int cursorX, int cursorY) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.model.setCursor(Math.min(cursorX, this$0.model.getWidth() - 1), cursorY);
        this$0.tabulator.resize(this$0.model.getWidth());
    }

    private static final void setLinkUriStarted$lambda$19(String $uri) {
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        try {
            Desktop.getDesktop().browse(new URI($uri));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Logger logger = Logger.getInstance(TerminalController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(TerminalController::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalController$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalController$DefaultTabulator;", "Lcom/jediterm/terminal/model/Tabulator;", "myWidth", "", "myTabLength", "(II)V", "myTabStops", "Ljava/util/SortedSet;", "clearAllTabStops", "", "clearTabStop", "position", "getNextTabWidth", "getPreviousTabWidth", "initTabStops", "columns", "tabLength", "nextTab", "previousTab", "resize", "setTabStop", "Companion", "intellij.terminal"})
    private static final class DefaultTabulator
    implements Tabulator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int myWidth;
        private final int myTabLength;
        @NotNull
        private final SortedSet<Integer> myTabStops;
        private static final int TAB_LENGTH = 8;

        public DefaultTabulator(int myWidth, int myTabLength) {
            this.myWidth = myWidth;
            this.myTabLength = myTabLength;
            this.myTabStops = new TreeSet();
            this.initTabStops(this.myWidth, this.myTabLength);
        }

        public /* synthetic */ DefaultTabulator(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = 8;
            }
            this(n, n2);
        }

        private final void initTabStops(int columns, int tabLength) {
            for (int i = tabLength; i < columns; i += tabLength) {
                this.myTabStops.add(i);
            }
        }

        public void resize(int columns) {
            if (columns > this.myWidth) {
                for (int i = this.myTabLength * (this.myWidth / this.myTabLength); i < columns; i += this.myTabLength) {
                    if (i < this.myWidth) continue;
                    this.myTabStops.add(i);
                }
            } else {
                Iterator it = this.myTabStops.iterator();
                while (it.hasNext()) {
                    Integer i = (Integer)it.next();
                    Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
                    if (i <= columns) continue;
                    it.remove();
                }
            }
            this.myWidth = columns;
        }

        public void clearTabStop(int position) {
            this.myTabStops.remove(position);
        }

        public void clearAllTabStops() {
            this.myTabStops.clear();
        }

        public int getNextTabWidth(int position) {
            return this.nextTab(position) - position;
        }

        public int getPreviousTabWidth(int position) {
            return position - this.previousTab(position);
        }

        public int nextTab(int position) {
            SortedSet<Integer> tailSet = this.myTabStops.tailSet(position + 1);
            Integer tabStop = !tailSet.isEmpty() ? tailSet.first() : Integer.valueOf(Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)tabStop, (String)"tabStop");
            return Math.min(tabStop, this.myWidth - 1);
        }

        public int previousTab(int position) {
            SortedSet<Integer> headSet = this.myTabStops.headSet(position);
            Integer tabStop = !headSet.isEmpty() ? headSet.last() : Integer.valueOf(0);
            Intrinsics.checkNotNullExpressionValue((Object)tabStop, (String)"tabStop");
            return Math.max(0, tabStop);
        }

        public void setTabStop(int position) {
            this.myTabStops.add(position);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalController$DefaultTabulator$Companion;", "", "()V", "TAB_LENGTH", "", "intellij.terminal"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

