/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.util.TermSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalPanel;
import org.jetbrains.plugins.terminal.exp.TerminalPromptPanel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001dJ\b\u0010 \u001a\u00020\u001bH\u0007J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001dH\u0007R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;Lcom/intellij/openapi/Disposable;)V", "blocksPanel", "promptPanel", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptPanel;", "runningPanel", "Lorg/jetbrains/plugins/terminal/exp/TerminalPanel;", "scrollPane", "Ljavax/swing/JScrollPane;", "getBackground", "Ljava/awt/Color;", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getTerminalSize", "Lcom/jediterm/core/util/TermSize;", "installRunningPanel", "", "isFocused", "", "makeCurrentBlockReadOnly", "removeIfEmpty", "resetPromptPanel", "stickScrollBarToBottom", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "toggleFullScreen", "isFullScreen", "intellij.terminal"})
public final class TerminalBlocksComponent
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final JPanel blocksPanel;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final TerminalPromptPanel promptPanel;
    @Nullable
    private TerminalPanel runningPanel;

    public TerminalBlocksComponent(@NotNull Project project, @NotNull TerminalSession session, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalCommandExecutor commandExecutor, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.session = session;
        this.settings = settings;
        this.parentDisposable = parentDisposable;
        this.promptPanel = new TerminalPromptPanel(this.project, this.settings, this.session, commandExecutor);
        Disposer.register((Disposable)this.parentDisposable, (Disposable)((Disposable)this.promptPanel));
        VerticalLayout verticalLayout = new VerticalLayout(0);
        this.blocksPanel = new JPanel(verticalLayout){

            @Override
            @NotNull
            public Color getBackground() {
                Color color = UIUtil.getTextFieldBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTextFieldBackground()");
                return color;
            }
        };
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.blocksPanel, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(blocksPanel, true)");
        this.scrollPane = jScrollPane;
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
        this.stickScrollBarToBottom(jScrollBar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.promptPanel, "South");
    }

    public final void makeCurrentBlockReadOnly(boolean removeIfEmpty) {
        TerminalPanel terminalPanel = this.runningPanel;
        if (terminalPanel == null) {
            throw new IllegalStateException("Running panel is null".toString());
        }
        TerminalPanel currentBlock = terminalPanel;
        currentBlock.makeReadOnly((Function1<? super Editor, Unit>)((Function1)new Function1<Editor, Unit>(removeIfEmpty, this, currentBlock){
            final /* synthetic */ boolean $removeIfEmpty;
            final /* synthetic */ TerminalBlocksComponent this$0;
            final /* synthetic */ TerminalPanel $currentBlock;
            {
                this.$removeIfEmpty = $removeIfEmpty;
                this.this$0 = $receiver;
                this.$currentBlock = $currentBlock;
                super(1);
            }

            public final void invoke(@NotNull Editor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$removeIfEmpty && it.getDocument().getTextLength() == 0) {
                    TerminalBlocksComponent.access$getBlocksPanel$p(this.this$0).remove(this.$currentBlock);
                    TerminalBlocksComponent.access$getBlocksPanel$p(this.this$0).revalidate();
                    Disposer.dispose((Disposable)((Disposable)this.$currentBlock));
                }
            }
        }));
    }

    @RequiresEdt
    public final void installRunningPanel() {
        TerminalPanel panel2;
        if (this.runningPanel != null) {
            throw new IllegalStateException("Running panel is not-null".toString());
        }
        TerminalEventsHandler eventsHandler = new TerminalEventsHandler(this.session, this.settings);
        this.runningPanel = panel2 = new TerminalPanel(this.project, this.settings, this.session.getModel(), eventsHandler);
        Disposer.register((Disposable)this.parentDisposable, (Disposable)((Disposable)panel2));
        this.promptPanel.setVisible(false);
        this.blocksPanel.add((Component)panel2, "BOTTOM");
        this.blocksPanel.revalidate();
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)panel2.getPreferredFocusableComponent(), true);
    }

    @RequiresEdt
    public final void resetPromptPanel() {
        this.runningPanel = null;
        this.promptPanel.reset();
        this.promptPanel.setVisible(true);
        this.revalidate();
        this.repaint();
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.promptPanel.getPreferredFocusableComponent(), true);
    }

    @RequiresEdt
    public final void toggleFullScreen(boolean isFullScreen) {
        TerminalPanel terminalPanel = this.runningPanel;
        if (terminalPanel == null) {
            throw new IllegalStateException("Running panel is null".toString());
        }
        TerminalPanel panel2 = terminalPanel;
        panel2.toggleFullScreen(isFullScreen);
        if (isFullScreen) {
            this.remove(this.scrollPane);
            this.add((Component)panel2, "Center");
        } else {
            this.remove(panel2);
            this.blocksPanel.add((Component)panel2, "BOTTOM");
            this.add((Component)this.scrollPane, "Center");
        }
        this.revalidate();
        this.repaint();
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)panel2.getPreferredFocusableComponent(), true);
    }

    @Nullable
    public final TermSize getTerminalSize() {
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        Dimension contentSize = new Dimension(bounds.width - JBUI.scale((int)7), bounds.height);
        return TerminalUiUtils.INSTANCE.calculateTerminalSize(contentSize, this.promptPanel.getCharSize());
    }

    public final boolean isFocused() {
        return this.promptPanel.isFocused();
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = UIUtil.getTextFieldBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTextFieldBackground()");
        return color;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        JComponent jComponent;
        if (this.runningPanel != null) {
            TerminalPanel terminalPanel = this.runningPanel;
            Intrinsics.checkNotNull((Object)terminalPanel);
            jComponent = terminalPanel.getPreferredFocusableComponent();
        } else {
            jComponent = this.promptPanel.getPreferredFocusableComponent();
        }
        return jComponent;
    }

    private final void stickScrollBarToBottom(JScrollBar verticalScrollBar) {
        verticalScrollBar.getModel().addChangeListener(new ChangeListener(verticalScrollBar){
            private boolean preventRecursion;
            private int prevValue;
            private int prevMaximum;
            private int prevExtent;
            final /* synthetic */ JScrollBar $verticalScrollBar;
            {
                this.$verticalScrollBar = $verticalScrollBar;
            }

            public final boolean getPreventRecursion() {
                return this.preventRecursion;
            }

            public final void setPreventRecursion(boolean bl) {
                this.preventRecursion = bl;
            }

            public final int getPrevValue() {
                return this.prevValue;
            }

            public final void setPrevValue(int n) {
                this.prevValue = n;
            }

            public final int getPrevMaximum() {
                return this.prevMaximum;
            }

            public final void setPrevMaximum(int n) {
                this.prevMaximum = n;
            }

            public final int getPrevExtent() {
                return this.prevExtent;
            }

            public final void setPrevExtent(int n) {
                this.prevExtent = n;
            }

            public void stateChanged(@Nullable ChangeEvent e) {
                if (this.preventRecursion) {
                    return;
                }
                BoundedRangeModel model = this.$verticalScrollBar.getModel();
                int maximum = model.getMaximum();
                int extent = model.getExtent();
                if ((extent != this.prevExtent || maximum != this.prevMaximum) && this.prevValue == this.prevMaximum - this.prevExtent) {
                    this.preventRecursion = true;
                    model.setValue(maximum - extent);
                    this.preventRecursion = false;
                }
                this.prevValue = model.getValue();
                this.prevMaximum = model.getMaximum();
                this.prevExtent = model.getExtent();
            }
        });
    }

    public static final /* synthetic */ JPanel access$getBlocksPanel$p(TerminalBlocksComponent $this) {
        return $this.blocksPanel;
    }
}

