/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.TerminalCompletionManager;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH$J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BaseShCompletionManager;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalSession;)V", "checkTerminalContent", "Ljava/util/concurrent/CompletableFuture;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "check", "Lkotlin/Function0;", "doResetPrompt", "", "invokeCompletion", "command", "", "resetPrompt", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBaseShCompletionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseShCompletionManager.kt\norg/jetbrains/plugins/terminal/exp/BaseShCompletionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n*L\n1#1,46:1\n8#2:47\n251#3,7:48\n*S KotlinDebug\n*F\n+ 1 BaseShCompletionManager.kt\norg/jetbrains/plugins/terminal/exp/BaseShCompletionManager\n*L\n26#1:47\n27#1:48,7\n*E\n"})
public abstract class BaseShCompletionManager
extends TerminalCompletionManager {
    public BaseShCompletionManager(@NotNull TerminalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
    }

    @Override
    public void invokeCompletion(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.getSession().getTerminalStarter().sendString(command + "\t", false);
    }

    protected abstract void doResetPrompt(@NotNull Disposable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void resetPrompt() {
        TerminalModel model = this.getSession().getModel();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable disposable2 = disposable;
        try {
            this.doResetPrompt(disposable2);
        }
        catch (Throwable t) {
            String string;
            void this_$iv;
            Object $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BaseShCompletionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            $this$thisLogger$iv = model;
            Logger logger2 = logger;
            boolean $i$f$withContentLock = false;
            this_$iv.lockContent();
            try {
                boolean bl = false;
                string = TerminalModel.getAllText$default(model, 0, 0, 3, null);
            }
            finally {
                this_$iv.unlockContent();
            }
            logger2.error("Prompt is broken after completion. Text buffer:\n" + string, t);
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
            model.getCommandExecutionSemaphore().up();
        }
    }

    @NotNull
    protected final CompletableFuture<Boolean> checkTerminalContent(@NotNull Disposable disposable, @NotNull Function0<Boolean> check) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getSession().getModel().addContentListener(new TerminalModel.ContentListener(check, future){
            final /* synthetic */ Function0<Boolean> $check;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$check = $check;
                this.$future = $future;
            }

            public void onContentChanged() {
                if (((Boolean)this.$check.invoke()).booleanValue()) {
                    this.$future.complete(true);
                }
            }
        }, disposable);
        return future;
    }
}

