/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.windows.WinPtyException;
import java.awt.Component;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProcessOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.exp.TerminalWidgetImpl;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance(AbstractTerminalRunner.class);
    @NotNull
    protected final Project myProject;
    private final JBTerminalSystemSettingsProvider mySettingsProvider;
    private final ThreadLocal<ShellStartupOptions> myStartupOptionsThreadLocal;

    public JBTerminalSystemSettingsProvider getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public AbstractTerminalRunner(@NotNull Project project) {
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(0);
        }
        this.myStartupOptionsThreadLocal = new ThreadLocal();
        this.myProject = project;
        this.mySettingsProvider = new JBTerminalSystemSettingsProvider();
    }

    @NotNull
    public ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions) {
        if (baseOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(1);
        }
        ShellStartupOptions shellStartupOptions2 = baseOptions;
        if (shellStartupOptions2 == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(2);
        }
        return shellStartupOptions2;
    }

    @NotNull
    public T createProcess(@NotNull ShellStartupOptions startupOptions) throws ExecutionException {
        if (startupOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(3);
        }
        T t = this.createProcess(new TerminalProcessOptions(startupOptions.getWorkingDirectory(), startupOptions.getInitialTermSize()), null);
        if (t == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(4);
        }
        return t;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(5);
        }
        JBTerminalWidget jBTerminalWidget = this.createTerminalWidget(parent, AbstractTerminalRunner.getParentDirectoryPath(currentWorkingDirectory), true);
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(6);
        }
        return jBTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory, boolean deferSessionStartUntilUiShown) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(7);
        }
        JBTerminalWidget jBTerminalWidget = this.createTerminalWidget(parent, AbstractTerminalRunner.getParentDirectoryPath(currentWorkingDirectory), deferSessionStartUntilUiShown);
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(8);
        }
        return jBTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable String currentWorkingDirectory, boolean deferSessionStartUntilUiShown) {
        ShellStartupOptions startupOptions;
        TerminalWidget terminalWidget;
        JBTerminalWidget jediTermWidget;
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(9);
        }
        if ((jediTermWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)(terminalWidget = this.createShellTerminalWidget(parent, startupOptions = this.getStartupOptions(currentWorkingDirectory))))) == null) {
            Disposer.dispose((Disposable)terminalWidget);
            throw new IncompatibleWidgetException();
        }
        this.scheduleOpenSessionInDirectory(terminalWidget, startupOptions, deferSessionStartUntilUiShown);
        JBTerminalWidget jBTerminalWidget = jediTermWidget;
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(10);
        }
        return jBTerminalWidget;
    }

    @NotNull
    private ShellStartupOptions getStartupOptions(@Nullable String workingDirectory) {
        ShellStartupOptions startupOptions = this.myStartupOptionsThreadLocal.get();
        if (startupOptions != null && Objects.equals(startupOptions.getWorkingDirectory(), workingDirectory)) {
            ShellStartupOptions shellStartupOptions2 = startupOptions;
            if (shellStartupOptions2 == null) {
                AbstractTerminalRunner.$$$reportNull$$$0(11);
            }
            return shellStartupOptions2;
        }
        ShellStartupOptions shellStartupOptions3 = ShellStartupOptionsKt.shellStartupOptions(workingDirectory);
        if (shellStartupOptions3 == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(12);
        }
        return shellStartupOptions3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TerminalWidget startShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions, boolean deferSessionStartUntilUiShown) {
        TerminalWidget terminalWidget;
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(13);
        }
        if (startupOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(14);
        }
        try {
            this.myStartupOptionsThreadLocal.set(startupOptions);
            TerminalWidget terminalWidget2 = this.createTerminalWidget(parent, startupOptions.getWorkingDirectory(), deferSessionStartUntilUiShown).asNewWidget();
            terminalWidget = terminalWidget2;
        }
        catch (IncompatibleWidgetException e) {
            TerminalWidget widget = this.createShellTerminalWidget(parent, startupOptions);
            this.scheduleOpenSessionInDirectory(widget, startupOptions, deferSessionStartUntilUiShown);
            TerminalWidget terminalWidget3 = widget;
            TerminalWidget terminalWidget4 = terminalWidget3;
            if (terminalWidget4 == null) {
                AbstractTerminalRunner.$$$reportNull$$$0(16);
            }
            return terminalWidget4;
        }
        finally {
            this.myStartupOptionsThreadLocal.remove();
        }
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(15);
        }
        return terminalWidget;
    }

    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(17);
        }
        if (startupOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(18);
        }
        TerminalWidget terminalWidget = new ShellTerminalWidget(this.myProject, this.mySettingsProvider, parent).asNewWidget();
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(19);
        }
        return terminalWidget;
    }

    private void scheduleOpenSessionInDirectory(@NotNull TerminalWidget terminalWidget, @NotNull ShellStartupOptions startupOptions, boolean deferSessionStartUntilUiShown) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(20);
        }
        if (startupOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(21);
        }
        if (deferSessionStartUntilUiShown) {
            UiNotifyConnector.doWhenFirstShown((JComponent)terminalWidget.getComponent(), () -> this.openSessionInDirectory(terminalWidget, startupOptions));
        } else {
            this.openSessionInDirectory(terminalWidget, startupOptions);
        }
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        return state != null ? state.myWorkingDirectory : null;
    }

    @Nullable
    @NlsContexts.TabTitle
    public String getDefaultTabTitle() {
        return null;
    }

    @Deprecated(forRemoval=true)
    protected String getTerminalConnectionName(T process) {
        return this.getDefaultTabTitle();
    }

    @NotNull
    public abstract TtyConnector createTtyConnector(@NotNull T var1);

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(22);
        }
        return project;
    }

    @Deprecated(forRemoval=true)
    public String runningTargetName() {
        return this.getDefaultTabTitle();
    }

    public boolean isTerminalSessionPersistent() {
        return true;
    }

    @Nullable
    private static String getParentDirectoryPath(@Nullable VirtualFile file) {
        VirtualFile dir = file != null && !file.isDirectory() ? file.getParent() : file;
        return dir != null ? dir.getPath() : null;
    }

    @RequiresEdt(generateAssertion=false)
    private void openSessionInDirectory(@NotNull TerminalWidget terminalWidget, @NotNull ShellStartupOptions startupOptions) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(23);
        }
        if (startupOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(24);
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)terminalWidget.getComponent());
        CheckedDisposable widgetDisposable = Disposer.newCheckedDisposable((Disposable)terminalWidget);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myProject.isDisposed() || widgetDisposable.isDisposed()) {
                return;
            }
            ShellStartupOptions baseOptions = startupOptions.builder().widget(terminalWidget).build();
            ShellStartupOptions configuredOptions = this.configureStartupOptions(baseOptions);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (widgetDisposable.isDisposed()) {
                    return;
                }
                CompletableFuture<TermSize> initialTermSizeFuture = AbstractTerminalRunner.awaitTermSize(terminalWidget, configuredOptions);
                initialTermSizeFuture.whenComplete((initialTermSize, initialTermSizeError) -> {
                    if (this.myProject.isDisposed() || widgetDisposable.isDisposed()) {
                        return;
                    }
                    if (initialTermSize == null) {
                        LOG.warn("Cannot get terminal size from component, defaulting to 80x24", initialTermSizeError);
                        initialTermSize = new TermSize(80, 24);
                    }
                    TermSize resultInitialTermSize = initialTermSize;
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (this.myProject.isDisposed() || widgetDisposable.isDisposed()) {
                            return;
                        }
                        try {
                            T process = this.createProcess(configuredOptions.builder().initialTermSize(resultInitialTermSize).build());
                            TtyConnector connector = this.createTtyConnector(process);
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (widgetDisposable.isDisposed()) {
                                    return;
                                }
                                try {
                                    terminalWidget.connectToTty(connector, resultInitialTermSize);
                                }
                                catch (Exception e) {
                                    this.printError(terminalWidget, "Cannot create terminal session for " + terminalWidget.getTerminalTitle().buildTitle(), e);
                                }
                            }, modalityState, this.myProject.getDisposed());
                        }
                        catch (Exception e) {
                            this.printError(terminalWidget, "Cannot open " + terminalWidget.getTerminalTitle().buildTitle(), e);
                        }
                    });
                });
            }, modalityState, this.myProject.getDisposed());
        });
    }

    @NotNull
    private static CompletableFuture<TermSize> awaitTermSize(@NotNull TerminalWidget terminalWidget, @NotNull ShellStartupOptions configuredOptions) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(25);
        }
        if (configuredOptions == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(26);
        }
        if (terminalWidget instanceof TerminalWidgetImpl) {
            TerminalWidgetImpl terminalWidgetImpl = (TerminalWidgetImpl)terminalWidget;
            CompletableFuture<TermSize> completableFuture = terminalWidgetImpl.initialize(configuredOptions);
            if (completableFuture == null) {
                AbstractTerminalRunner.$$$reportNull$$$0(27);
            }
            return completableFuture;
        }
        CompletionStage completionStage = TerminalUiUtils.INSTANCE.awaitComponentLayout(terminalWidget.getComponent(), (Disposable)terminalWidget).thenApply(v -> terminalWidget.getTermSize());
        if (completionStage == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(28);
        }
        return completionStage;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void openSessionInDirectory(@NotNull JBTerminalWidget terminalWidget, @Nullable String directory) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(29);
        }
        this.openSessionInDirectory(terminalWidget.asNewWidget(), this.getStartupOptions(directory));
    }

    private void printError(@NotNull TerminalWidget terminalWidget, @NotNull String errorMessage, @NotNull Exception e) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(30);
        }
        if (errorMessage == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(31);
        }
        if (e == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(32);
        }
        LOG.info(errorMessage, (Throwable)e);
        @Nls StringBuilder message = new StringBuilder();
        message.append("\n");
        message.append(errorMessage).append("\n").append(e.getMessage()).append("\n\n");
        WinPtyException winptyException = (WinPtyException)ExceptionUtil.findCause((Throwable)e, WinPtyException.class);
        if (winptyException != null) {
            message.append(winptyException.getMessage()).append("\n\n");
        }
        terminalWidget.writePlainMessage(message.toString());
        terminalWidget.writePlainMessage("\n" + TerminalBundle.message("see.ide.log.error.description", ShowLogAction.getActionName()) + "\n");
        ApplicationManager.getApplication().invokeLater(() -> terminalWidget.setCursorVisible(false), this.myProject.getDisposed());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public T createProcess(@NotNull TerminalProcessOptions options, @Nullable JBTerminalWidget widget) throws ExecutionException {
        if (options == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(33);
        }
        T t = this.createProcess(options.toStartupOptions());
        if (t == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(34);
        }
        return t;
    }

    @Deprecated(forRemoval=true)
    protected T createProcess(@Nullable String directory) throws ExecutionException {
        throw new AssertionError((Object)"Call createProcess(TerminalProcessOptions)");
    }

    @Deprecated(forRemoval=true)
    protected T createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        return this.createProcess(directory);
    }

    @Deprecated(forRemoval=true)
    public void run() {
        TerminalToolWindowManager.getInstance(this.myProject).createNewSession(this);
    }

    @Deprecated(forRemoval=true)
    protected void showConsole(@NotNull Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, Component ignoredToFocus) {
        if (defaultExecutor == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(35);
        }
        if (myDescriptor == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(36);
        }
        RunContentManager.getInstance((Project)this.myProject).showRunContent(defaultExecutor, myDescriptor);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected ProcessHandler createProcessHandler(T ignoredProcess) {
        return new NopProcessHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 11, 12, 15, 16, 19, 22, 27, 28, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 3: 
            case 14: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuredOptions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExecutor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "configureStartupOptions";
                break;
            }
            case 4: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalWidget";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupOptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "startShellTerminalWidget";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellTerminalWidget";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "awaitTermSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 28: 
            case 34: {
                break;
            }
            case 3: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalWidget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startShellTerminalWidget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createShellTerminalWidget";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scheduleOpenSessionInDirectory";
                break;
            }
            case 23: 
            case 24: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "openSessionInDirectory";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermSize";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "printError";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 11, 12, 15, 16, 19, 22, 27, 28, 34 -> new IllegalStateException(string);
        };
    }

    private static class IncompatibleWidgetException
    extends RuntimeException {
        private IncompatibleWidgetException() {
            super("Please migrate from AbstractTerminalRunner.createTerminalWidget(Disposable, String, boolean) to AbstractTerminalRunner.createShellTerminalWidget");
        }
    }
}

