/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTagInjection
extends BaseInjection {
    private static final Logger LOG = Logger.getInstance(AbstractTagInjection.class);
    @NotNull
    @NlsSafe
    private StringMatcher myTagName = StringMatcher.ANY;
    @NotNull
    @NlsSafe
    private Set<String> myTagNamespace = Collections.emptySet();
    @NotNull
    @NlsSafe
    private String myXPathCondition = "";
    private volatile Condition<XmlElement> myCompiledXPathCondition;
    private boolean myApplyToSubTags;

    public AbstractTagInjection() {
        super("xml");
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName.getPattern();
        if (string == null) {
            AbstractTagInjection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setTagName(@NotNull @NlsSafe String tagName) {
        if (tagName == null) {
            AbstractTagInjection.$$$reportNull$$$0(1);
        }
        this.myTagName = StringMatcher.create((String)tagName);
    }

    public boolean acceptsPsiElement(PsiElement element) {
        return super.acceptsPsiElement(element) && (!(element instanceof XmlElement) || this.matchXPath((XmlElement)element));
    }

    @NotNull
    @NlsSafe
    public String getTagNamespace() {
        String string = StringUtil.join(this.myTagNamespace, (String)"|");
        if (string == null) {
            AbstractTagInjection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setTagNamespace(@NotNull @NonNls String tagNamespace) {
        if (tagNamespace == null) {
            AbstractTagInjection.$$$reportNull$$$0(3);
        }
        this.myTagNamespace = new TreeSet<String>(StringUtil.split((String)tagNamespace, (String)"|"));
    }

    @NotNull
    public String getXPathCondition() {
        String string = this.myXPathCondition;
        if (string == null) {
            AbstractTagInjection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setXPathCondition(@Nullable String condition) {
        this.myXPathCondition = StringUtil.notNullize((String)condition);
        this.myCompiledXPathCondition = null;
    }

    private Condition<XmlElement> compileXPath() {
        if (StringUtil.isEmptyOrSpaces((String)this.myXPathCondition)) {
            return Conditions.alwaysTrue();
        }
        try {
            XPathSupportProxy xPathSupport = XPathSupportProxy.getInstance();
            if (xPathSupport != null) {
                XPath path = xPathSupport.createXPath(this.myXPathCondition);
                return context -> {
                    try {
                        return path.booleanValueOf(context);
                    }
                    catch (JaxenException e) {
                        LOG.warn((Throwable)e);
                        this.myCompiledXPathCondition = Conditions.alwaysFalse();
                        return false;
                    }
                };
            }
        }
        catch (JaxenException e) {
            LOG.warn("Invalid XPath expression", (Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    protected boolean matches(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        if (!this.myTagName.matches(tag.getLocalName())) {
            return false;
        }
        return this.myTagNamespace.contains(tag.getNamespace());
    }

    public abstract AbstractTagInjection copy();

    public AbstractTagInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            AbstractTagInjection.$$$reportNull$$$0(5);
        }
        super.copyFrom(o);
        if (o instanceof AbstractTagInjection) {
            AbstractTagInjection other = (AbstractTagInjection)o;
            this.myTagName = other.myTagName;
            this.myTagNamespace = other.myTagNamespace;
            this.setXPathCondition(other.getXPathCondition());
            this.setApplyToSubTags(other.isApplyToSubTags());
        }
        return this;
    }

    protected void readExternalImpl(Element e) {
        this.setXPathCondition(e.getChildText("xpath-condition"));
        this.myApplyToSubTags = e.getChild("apply-to-subtags") != null;
    }

    protected void writeExternalImpl(Element e) {
        if (StringUtil.isNotEmpty((String)this.myXPathCondition)) {
            e.addContent(new Element("xpath-condition").setText(this.myXPathCondition));
        }
        if (this.myApplyToSubTags) {
            e.addContent(new Element("apply-to-subtags"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTagInjection that = (AbstractTagInjection)((Object)o);
        if (!this.myTagName.equals((Object)that.myTagName)) {
            return false;
        }
        if (!this.myTagNamespace.equals(that.myTagNamespace)) {
            return false;
        }
        if (!this.myXPathCondition.equals(that.myXPathCondition)) {
            return false;
        }
        return this.myApplyToSubTags == that.myApplyToSubTags;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myTagName.hashCode();
        result = 31 * result + this.myTagNamespace.hashCode();
        result = 31 * result + this.myXPathCondition.hashCode();
        result = 31 * result + (this.myApplyToSubTags ? 1 : 0);
        return result;
    }

    boolean matchXPath(XmlElement context) {
        Condition<XmlElement> compiled = this.myCompiledXPathCondition;
        if (compiled == null) {
            this.myCompiledXPathCondition = compiled = this.compileXPath();
        }
        return compiled.value((Object)context);
    }

    public boolean isApplyToSubTags() {
        return this.myApplyToSubTags;
    }

    public void setApplyToSubTags(boolean applyToSubTagTexts) {
        this.myApplyToSubTags = applyToSubTagTexts;
    }

    public boolean acceptForReference(PsiElement element) {
        if (element instanceof XmlAttributeValue) {
            PsiElement parent = element.getParent();
            return parent instanceof XmlAttribute && this.acceptsPsiElement(parent);
        }
        return element instanceof XmlTag && this.acceptsPsiElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNamespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/config/AbstractTagInjection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXPathCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTagName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTagNamespace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

