/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.config.EventLogExternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.uploader.EventLogExternalSendConfig;
import com.intellij.internal.statistic.uploader.EventLogUploaderCliParser;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import com.intellij.internal.statistic.uploader.util.ExtraHTTPHeadersParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogUploader {
    private static final int WAIT_FOR_IDE_MS = 2000;

    public static void main(String[] args) {
        ExternalDataCollectorLogger logger = new ExternalDataCollectorLogger();
        ExternalEventsLogger eventsLogger = new ExternalEventsLogger();
        try {
            EventLogUploader.execute(args, logger, eventsLogger);
        }
        catch (Throwable e) {
            logger.warn("Failed uploading logs", e);
            eventsLogger.logSendingLogsFinished("EXCEPTION_OCCURRED");
        }
    }

    private static void execute(String[] args, DataCollectorDebugLogger logger, ExternalEventsLogger eventsLogger) {
        logger.info("Process started with '" + String.join((CharSequence)" ", args) + "'");
        logger.info("Classpath:" + System.getProperty("java.class.path"));
        eventsLogger.logSendingLogsStarted();
        if (args.length == 0) {
            logger.warn("No arguments were found");
            eventsLogger.logSendingLogsFinished("NO_ARGUMENTS");
            return;
        }
        Map<String, String> options = EventLogUploaderCliParser.parseOptions(args);
        EventLogApplicationInfo appInfo = EventLogUploader.newApplicationInfo(options, logger, eventsLogger);
        if (appInfo == null) {
            logger.warn("Failed creating application info from arguments");
            eventsLogger.logSendingLogsFinished("NO_APPLICATION_CONFIG");
            return;
        }
        List<EventLogExternalSendConfig> configs = EventLogExternalSendConfig.parseSendConfigurations(options, (recorder, error) -> {
            logger.warn("[" + recorder + "] Failed creating send config from arguments because " + error.getType().name());
            eventsLogger.logSendingLogsFinished(recorder, error.getType().name());
        });
        if (!EventLogUploader.waitForIde(logger, options, 20)) {
            logger.warn("Cannot send logs because IDE didn't close during 40000ms");
            eventsLogger.logSendingLogsFinished("IDE_NOT_CLOSING");
            return;
        }
        ExecutorService service = Executors.newFixedThreadPool(configs.size());
        for (EventLogExternalSendConfig config : configs) {
            service.execute(() -> EventLogUploader.sendLogsByRecorder(appInfo, config, logger, eventsLogger));
        }
        service.shutdown();
        try {
            service.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sendLogsByRecorder(@NotNull EventLogApplicationInfo appInfo, @NotNull EventLogSendConfig config, @NotNull DataCollectorDebugLogger logger, final @NotNull ExternalEventsLogger eventsLogger) {
        if (appInfo == null) {
            EventLogUploader.$$$reportNull$$$0(0);
        }
        if (config == null) {
            EventLogUploader.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            EventLogUploader.$$$reportNull$$$0(2);
        }
        if (eventsLogger == null) {
            EventLogUploader.$$$reportNull$$$0(3);
        }
        final String recorderId = config.getRecorderId();
        logger.info("[" + recorderId + "] Start uploading...");
        EventLogConnectionSettings connectionSettings = appInfo.getConnectionSettings();
        logger.info("[" + recorderId + "] {product:" + appInfo.getProductCode() + ", productVersion:" + appInfo.getProductVersion() + ", userAgent:" + connectionSettings.getUserAgent() + ", url: " + appInfo.getTemplateUrl() + ", internal:" + appInfo.isInternal() + ", isTest:" + appInfo.isTest() + "}");
        String logs = config.getFilesToSendProvider().getFilesToSend().stream().map(file -> file.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        logger.info("[" + recorderId + "] {recorder:" + config.getRecorderId() + ", files:" + logs + "}");
        logger.info("[" + recorderId + "] {device:" + config.getDeviceId() + ", bucket:" + config.getBucket() + "}");
        try {
            EventLogStatisticsService service = new EventLogStatisticsService(config, appInfo, new EventLogSendListener(){

                @Override
                public void onLogsSend(@NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int totalLocalFiles) {
                    if (successfullySentFiles == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errors == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    eventsLogger.logSendingLogsSucceed(recorderId, successfullySentFiles, errors, totalLocalFiles);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "successfullySentFiles";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "errors";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/internal/statistic/uploader/EventLogUploader$1";
                    objectArray[2] = "onLogsSend";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            StatisticsResult result = service.send();
            eventsLogger.logSendingLogsFinished(recorderId, result.getCode());
            if (logger.isTraceEnabled()) {
                logger.trace("[" + recorderId + "] Uploading finished with " + result.getCode().name());
                logger.trace("[" + recorderId + "] " + result.getDescription());
            }
        }
        catch (Exception e) {
            logger.warn("[" + recorderId + "] Failed sending files: " + e.getMessage());
            eventsLogger.logSendingLogsFinished(recorderId, "ERROR_ON_SEND");
        }
    }

    @Nullable
    private static EventLogApplicationInfo newApplicationInfo(Map<String, String> options, DataCollectorDebugLogger logger, DataCollectorSystemEventLogger eventLogger) {
        String productCode = options.get("--product");
        String productVersion = options.get("--product-version");
        String url = options.get("--url");
        String userAgent = options.get("--user-agent");
        String headersString = options.get("--extra-headers");
        Map<String, String> extraHeaders = ExtraHTTPHeadersParser.parse(headersString);
        if (url != null && productCode != null) {
            boolean isInternal = options.containsKey("--internal");
            boolean isTest = options.containsKey("--test");
            boolean isEAP = options.containsKey("--eap");
            return new EventLogExternalApplicationInfo(url, productCode, productVersion, userAgent, isInternal, isTest, isEAP, extraHeaders, logger, eventLogger);
        }
        return null;
    }

    private static boolean waitForIde(DataCollectorDebugLogger logger, Map<String, String> options, int maxAttempts) {
        String ideToken = options.get("--ide-token");
        if (ideToken == null) {
            return true;
        }
        logger.info("IDE token file: " + ideToken);
        File token = new File(ideToken);
        try {
            for (int attempt = 0; attempt < maxAttempts && token.exists(); ++attempt) {
                logger.info("Waiting for 2000ms for IDE to close. Attempt #" + attempt);
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !token.exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "appInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "eventsLogger";
                break;
            }
        }
        objectArray[1] = "com/intellij/internal/statistic/uploader/EventLogUploader";
        objectArray[2] = "sendLogsByRecorder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

