/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.collectors.fus.ActionPlaceHolder;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataKt;
import com.intellij.internal.statistic.eventLog.ShortcutDataProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 R2\u00020\u0001:\u0001RB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0010\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u0004J\u0012\u0010\u000e\u001a\u00020\u00002\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\u0010\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0004J&\u0010\u0010\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0014J\u0018\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u001eJ\u0018\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u001fJ\u0018\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020 J\u001a\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\b\b\u0001\u0010\u0012\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040!J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0001H\u0002J$\u0010#\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010$\u001a\u00020 2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0014J\u0010\u0010'\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010)J\u001c\u0010'\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010*2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u0004J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020,J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010.\u001a\u00020\u00002\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u0004J\u001a\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J%\u00101\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020 0!H\u0000\u00a2\u0006\u0002\b2J%\u00103\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002040!H\u0000\u00a2\u0006\u0002\b5J1\u00106\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001070!H\u0000\u00a2\u0006\u0002\b8J+\u00109\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000107H\u0000\u00a2\u0006\u0002\b:J\u0012\u0010;\u001a\u00020\u00002\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u0004J\u0010\u0010<\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u00010>J\u0010\u0010?\u001a\u00020\u00002\b\u0010@\u001a\u0004\u0018\u00010AJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001J\u0012\u0010C\u001a\u00020\u00002\n\b\u0001\u0010D\u001a\u0004\u0018\u00010EJ\u0012\u0010F\u001a\u00020\u00002\n\b\u0001\u0010D\u001a\u0004\u0018\u00010\u0004J\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000107J\u0006\u0010H\u001a\u00020\u0000J\u0013\u0010I\u001a\u00020\u00142\b\u0010J\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010K\u001a\u00020\u0019H\u0016J\u0010\u0010L\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0018\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u00002\b\b\u0001\u0010O\u001a\u00020\u0004J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010Q\u001a\u00020\u0004H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006S"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "", "()V", "recorderId", "", "(Ljava/lang/String;)V", "data", "", "getRecorderId", "()Ljava/lang/String;", "addAll", "from", "addAnonymizedId", "id", "addAnonymizedPath", "path", "addAnonymizedValue", "key", "value", "short", "", "addClientId", "clientId", "addCount", "count", "", "addCurrentFile", "language", "Lcom/intellij/lang/Language;", "addData", "", "", "", "", "addDataInternal", "addDatedShortAnonymizedValue", "timestamp", "addEnabled", "enabled", "addInputEvent", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Ljava/awt/event/InputEvent;", "place", "Ljava/awt/event/KeyEvent;", "Ljava/awt/event/MouseEvent;", "addLanguage", "addLanguageInternal", "fieldName", "addListLongData", "addListLongData$intellij_platform_statistics", "addListNumberData", "", "addListNumberData$intellij_platform_statistics", "addListObjectData", "", "addListObjectData$intellij_platform_statistics", "addObjectData", "addObjectData$intellij_platform_statistics", "addPlace", "addPluginInfo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "addProject", "project", "Lcom/intellij/openapi/project/Project;", "addValue", "addVersion", "version", "Lcom/intellij/openapi/util/Version;", "addVersionByString", "build", "copy", "equals", "other", "hashCode", "isCommonPlace", "merge", "next", "prefix", "parsePermanentClientId", "toString", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFeatureUsageData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureUsageData.kt\ncom/intellij/internal/statistic/eventLog/FeatureUsageData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1#2:369\n*E\n"})
public final class FeatureUsageData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private Map<String, Object> data;
    @NotNull
    private static final List<String> platformDataKeys;

    public FeatureUsageData(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderId = recorderId;
        this.data = new HashMap();
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        if (clientId != null && !Intrinsics.areEqual((Object)clientId, (Object)ClientId.Companion.getDefaultLocalId())) {
            this.addClientId(clientId.getValue());
        }
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    @Deprecated(message="Recorder ID should be explicitly provided", replaceWith=@ReplaceWith(expression="FeatureUsageData(recorderId)", imports={}), level=DeprecationLevel.WARNING)
    @TestOnly
    public FeatureUsageData() {
        this("FUS");
    }

    @NotNull
    public final FeatureUsageData addClientId(@Nullable String clientId) {
        block0: {
            String string = clientId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            String permanentClientId = this.parsePermanentClientId(clientId);
            this.data.put("client_id", EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(permanentClientId));
        }
        return this;
    }

    private final String parsePermanentClientId(String clientId) {
        int separator = StringsKt.indexOf$default((CharSequence)clientId, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (separator > 0) {
            String string = clientId.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return clientId;
    }

    @NotNull
    public final FeatureUsageData addProject(@Nullable Project project) {
        if (project != null) {
            this.data.put("project", EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, null, (int)7, null)));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersionByString(@NonNls @Nullable String version) {
        if (version == null) {
            this.data.put("version", "unknown");
        } else {
            this.addVersion(Version.parseVersion((String)version));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersion(@NonNls @Nullable Version version) {
        Version version2 = version;
        this.data.put("version", version2 != null ? version2.major + "." + version.minor : "unknown.format");
        return this;
    }

    @NotNull
    public final FeatureUsageData addPluginInfo(@Nullable PluginInfo info) {
        block0: {
            PluginInfo pluginInfo = info;
            if (pluginInfo == null) break block0;
            PluginInfo it = pluginInfo;
            boolean bl = false;
            StatisticsUtil.addPluginInfoTo(info, this.data);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@NonNls @Nullable String id) {
        block0: {
            String string = id;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.addLanguage(Language.findLanguageByID((String)id));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@Nullable Language language) {
        return this.addLanguageInternal("lang", language);
    }

    @NotNull
    public final FeatureUsageData addCurrentFile(@Nullable Language language) {
        return this.addLanguageInternal("current_file", language);
    }

    private final FeatureUsageData addLanguageInternal(String fieldName, Language language) {
        block2: {
            Language language2 = language;
            if (language2 == null) break block2;
            Language it = language2;
            boolean bl = false;
            PluginInfo type = PluginInfoDetectorKt.getPluginInfo(language.getClass());
            if (type.isSafeToReport()) {
                Map<String, Object> map = this.data;
                String string = language.getID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
                String string2 = string;
                map.put(fieldName, string2);
            } else {
                this.data.put(fieldName, "third.party");
            }
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable InputEvent event, @NonNls @Nullable String place) {
        String inputEvent = ShortcutDataProvider.getInputEventText(event, place);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable AnActionEvent event) {
        String inputEvent = ShortcutDataProvider.getActionEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getKeyEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getMouseEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addPlace(@NonNls @Nullable String place) {
        if (place == null) {
            return this;
        }
        String reported = "unknown";
        if (this.isCommonPlace(place) || ActionPlaceHolder.isCustomActionPlace(place)) {
            reported = place;
        } else if (ActionPlaces.isPopupPlace((String)place)) {
            reported = "popup";
        }
        this.data.put("place", reported);
        return this;
    }

    private final boolean isCommonPlace(String place) {
        return ActionPlaces.isCommonPlace((String)place);
    }

    @NotNull
    public final FeatureUsageData addAnonymizedPath(@NonNls @Nullable String path) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                map = this.data;
                string2 = "file_path";
                string = path;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string3 = EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(path);
                string = string3;
                if (string3 != null) break block3;
            }
            string = "undefined";
        }
        String string4 = string;
        map.put(string2, string4);
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedId(@NonNls @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.data.put("anonymous_id", EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(id));
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addAnonymizedValue(key, value, false);
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @Nullable String value, boolean bl) {
        String string;
        Map<String, Object> map;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                map = this.data;
                string = value;
                if (string == null) break block2;
                String it = string;
                boolean bl2 = false;
                String string2 = EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(value, bl);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "undefined";
        }
        String string3 = string;
        map.put(key, string3);
        return this;
    }

    public static /* synthetic */ FeatureUsageData addAnonymizedValue$default(FeatureUsageData featureUsageData, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return featureUsageData.addAnonymizedValue(string, string2, bl);
    }

    @NotNull
    public final FeatureUsageData addDatedShortAnonymizedValue(@NonNls @NotNull String key, long timestamp, @NonNls @Nullable String value) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                map = this.data;
                string2 = StatisticsUtil.getTimestampDateInUTC$default(StatisticsUtil.INSTANCE, timestamp, null, 2, null);
                string = value;
                if (string == null) break block2;
                String string3 = string;
                String string4 = string2;
                boolean bl = false;
                String string5 = EventLogConfiguration.Companion.getInstance().getOrCreate(this.recorderId).anonymize(value, true);
                string2 = string4;
                string = string5;
                if (string5 != null) break block3;
            }
            string = "undefined";
        }
        String string6 = string2 + "-" + string;
        map.put(key, string6);
        return this;
    }

    @NotNull
    public final FeatureUsageData addValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return this.addDataInternal("value", value);
        }
        return this.addData("value", value.toString());
    }

    @NotNull
    public final FeatureUsageData addEnabled(boolean enabled) {
        return this.addData("enabled", enabled);
    }

    @NotNull
    public final FeatureUsageData addCount(int count) {
        return this.addData("count", count);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, Float.valueOf(value));
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NonNls @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListNumberData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<? extends Number> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListLongData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<Long> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addListNumberData$intellij_platform_statistics(key, value);
    }

    @NotNull
    public final FeatureUsageData addObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<? extends Map<String, ? extends Object>> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    private final FeatureUsageData addDataInternal(String key, Object value) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && platformDataKeys.contains(key)) {
            FeatureUsageDataKt.access$getLOG$p().warn("Collectors should not reuse platform keys: " + key);
            return this;
        }
        String escapedKey = StatisticsEventEscaper.escapeFieldName((String)key);
        if (!Intrinsics.areEqual((Object)escapedKey, (Object)key)) {
            FeatureUsageDataKt.access$getLOG$p().warn("Key contains invalid symbols, they will be escaped: '" + key + "' -> '" + escapedKey + "'");
        }
        this.data.put(escapedKey, value);
        return this;
    }

    @NotNull
    public final Map<String, Object> build() {
        if (this.data.isEmpty()) {
            Map<String, Object> map = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap()");
            return map;
        }
        return this.data;
    }

    @NotNull
    public final FeatureUsageData addAll(@NotNull FeatureUsageData from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.data.putAll(from.data);
        return this;
    }

    @NotNull
    public final FeatureUsageData merge(@NotNull FeatureUsageData next, @NonNls @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        for (Map.Entry<String, Object> entry : next.build().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newKey = StringsKt.startsWith$default((String)key, (String)"data_", (boolean)false, (int)2, null) ? prefix + key : key;
            this.data.put(newKey, value);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData copy() {
        FeatureUsageData result = new FeatureUsageData(this.recorderId);
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            result.data.put(key, value);
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.FeatureUsageData");
        FeatureUsageData cfr_ignored_0 = (FeatureUsageData)other;
        return Intrinsics.areEqual(this.data, ((FeatureUsageData)other).data);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @NotNull
    public String toString() {
        return this.data.toString();
    }

    static {
        Object[] objectArray = new String[]{"plugin", "project", "os", "plugin_type", "lang", "current_file", "input_event", "place", "file_path", "anonymous_id", "client_id"};
        platformDataKeys = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData$Companion;", "", "()V", "platformDataKeys", "", "", "getPlatformDataKeys", "()Ljava/util/List;", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPlatformDataKeys() {
            return platformDataKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

