/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.targetWithVfs.TargetWithMappedLocalVfs;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/project/Project;)V", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "RootInfo", "StateFile", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyTargetsRemoteSourcesRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTargetsRemoteSourcesRefresher.kt\ncom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n1#2:188\n1#2:205\n1#2:224\n10242#3:189\n10664#3,5:190\n1603#4,9:195\n1855#4:204\n1856#4:206\n1612#4:207\n1855#4,2:208\n1855#4,2:210\n1603#4,9:214\n1855#4:223\n1856#4:225\n1612#4:226\n1855#4,2:227\n215#5,2:212\n10#6:229\n*S KotlinDebug\n*F\n+ 1 PyTargetsRemoteSourcesRefresher.kt\ncom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher\n*L\n85#1:205\n161#1:224\n85#1:189\n85#1:190,5\n85#1:195,9\n85#1:204\n85#1:206\n85#1:207\n101#1:208,2\n107#1:210,2\n161#1:214,9\n161#1:223\n161#1:225\n161#1:226\n161#1:227,2\n129#1:212,2\n183#1:229\n*E\n"})
public final class PyTargetsRemoteSourcesRefresher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final Project project;
    @NotNull
    private final HelpersAwareTargetEnvironmentRequest pyRequest;
    @NotNull
    private static final Logger LOG;

    public PyTargetsRemoteSourcesRefresher(@NotNull Sdk sdk2, @NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.sdk = sdk2;
        this.project = project;
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(this.sdk, this.project);
        if (helpersAwareTargetEnvironmentRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        boolean bl2 = bl = !(this.sdk instanceof Disposable) || !Disposer.isDisposed((Disposable)((Disposable)this.sdk));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run(@NotNull ProgressIndicator indicator) throws ExecutionException {
        void $this$mapNotNullTo$iv$iv;
        SdkAdditionalData sdkAdditionalData;
        Object $this$forEach$iv2;
        Object it2;
        TargetWithMappedLocalVfs targetWithVfs;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path localRemoteSourcesRoot = Files.createDirectories(PySdkExtKt.getRemoteSourcesLocalPath(this.sdk), new FileAttribute[0]);
        Path localUploadDir = Files.createTempDirectory("remote_sync", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)localUploadDir, (String)"localUploadDir");
        TargetEnvironment.UploadRoot uploadVolume = new TargetEnvironment.UploadRoot(localUploadDir, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
        ((Collection)this.getTargetEnvRequest().getUploadVolumes()).add(uploadVolume);
        TargetEnvironment.DownloadRoot downloadVolume = new TargetEnvironment.DownloadRoot(localRemoteSourcesRoot, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
        ((Collection)this.getTargetEnvRequest().getDownloadVolumes()).add(downloadVolume);
        PythonScripts.ensureProjectSdkAndModuleDirsAreOnTarget(this.pyRequest.getTargetEnvironmentRequest(), this.project, new Module[0]);
        PythonScriptExecution execution = PythonScripts.prepareHelperScriptExecution(PythonHelper.REMOTE_SYNC, this.pyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)localRemoteSourcesRoot, (String)"localRemoteSourcesRoot");
        Path path2 = localRemoteSourcesRoot.resolve(".state.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        Path stateFilePath = path2;
        FileTime stateFilePrevTimestamp = null;
        if (Files.exists(stateFilePath, new LinkOption[0])) {
            FileTime fileTime = Files.getLastModifiedTime(stateFilePath, new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(stateFilePath)");
            stateFilePrevTimestamp = fileTime;
            Path path3 = localUploadDir.resolve(".state.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
            Files.copy(stateFilePath, path3, new CopyOption[0]);
            execution.addParameter("--state-file");
            execution.addParameter(TargetEnvironmentFunctions.getRelativeTargetPath((Function)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume), (String)".state.json"));
        } else {
            FileTime fileTime = FileTime.from(Instant.MIN);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(Instant.MIN)");
            stateFilePrevTimestamp = fileTime;
        }
        execution.addParameter(TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)downloadVolume));
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = PySdkExtKt.getTargetEnvConfiguration(this.sdk);
        if (targetEnvironmentConfiguration != null) {
            TargetEnvironmentConfiguration it3 = targetEnvironmentConfiguration;
            boolean bl = false;
            v5 = PythonInterpreterTargetEnvironmentFactory.Companion.getTargetWithMappedLocalVfs(it3);
        } else {
            v5 = targetWithVfs = null;
        }
        if (targetWithVfs != null) {
            void $this$mapNotNullTo$iv$iv2;
            Iterator $this$mapNotNull$iv;
            Iterator element$iv$iv22;
            void $this$flatMapTo$iv$iv;
            Object $this$flatMap$iv = ProjectUtil.getModules((Project)this.project);
            boolean $i$f$flatMap = false;
            Module[] bl = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean bl2 = false;
            for (Iterator element$iv$iv22 : $this$flatMapTo$iv$iv) {
                void it4 = element$iv$iv22;
                boolean bl22 = false;
                VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)it4).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"it.rootManager.contentRoots");
                Iterable list$iv$iv = ArraysKt.asList((Object[])virtualFileArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean bl3 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            element$iv$iv22 = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv22.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv22.next();
                boolean bl32 = false;
                it2 = (VirtualFile)element$iv$iv3;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                if (targetWithVfs.getTargetPathFromVfs((VirtualFile)it2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleRoots = (List)destination$iv$iv;
            if (!((Collection)moduleRoots).isEmpty()) {
                execution.addParameter("--project-roots");
                for (String root : moduleRoots) {
                    execution.addParameter(root);
                }
            }
        }
        TargetProgressIndicatorAdapter targetIndicator = new TargetProgressIndicatorAdapter(indicator);
        TargetEnvironment environment = this.getTargetEnvRequest().prepareEnvironment((TargetProgressIndicator)targetIndicator);
        try {
            Iterable $this$forEach$iv3 = environment.getUploadVolumes().values();
            boolean $i$f$forEach = false;
            for (Object e : $this$forEach$iv3) {
                TargetEnvironment.UploadableVolume it5 = (TargetEnvironment.UploadableVolume)e;
                boolean bl = false;
                it5.upload(".", (TargetProgressIndicator)targetIndicator);
            }
            TargetedCommandLine cmd = PythonScripts.buildTargetedCommandLine$default(execution, environment, this.sdk, CollectionsKt.emptyList(), false, 8, null);
            PythonScripts.execute(cmd, environment, indicator);
            $this$forEach$iv2 = environment.getDownloadVolumes().values();
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv2 = iterator.next();
                TargetEnvironment.DownloadableVolume it6 = (TargetEnvironment.DownloadableVolume)element$iv2;
                boolean bl = false;
                it6.download(".", indicator);
            }
        }
        finally {
            environment.shutdown();
        }
        if (!Files.exists(stateFilePath, new LinkOption[0])) {
            throw new IllegalStateException(stateFilePath + " is missing");
        }
        if (Files.getLastModifiedTime(stateFilePath, new LinkOption[0]).compareTo(stateFilePrevTimestamp) <= 0) {
            throw new IllegalStateException(stateFilePath + " has not been updated");
        }
        Object stateFile = null;
        $this$forEach$iv2 = Files.newBufferedReader(stateFilePath);
        Iterator<String> $i$f$forEach2 = null;
        try {
            BufferedReader bufferedReader = (BufferedReader)$this$forEach$iv2;
            boolean bl = false;
            Object object = new Gson().fromJson((Reader)bufferedReader, StateFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(it, StateFile::class.java)");
            stateFile = object;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            $i$f$forEach2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$forEach$iv2, (Throwable)((Object)$i$f$forEach2));
        }
        PathMappingSettings pathMappings = new PathMappingSettings();
        SdkAdditionalData sdkAdditionalData2 = this.sdk.getSdkAdditionalData();
        PyTargetAwareAdditionalData pyTargetAwareAdditionalData = sdkAdditionalData2 instanceof PyTargetAwareAdditionalData ? (PyTargetAwareAdditionalData)sdkAdditionalData2 : null;
        if (pyTargetAwareAdditionalData != null) {
            PyTargetAwareAdditionalData pyData = pyTargetAwareAdditionalData;
            boolean bl = false;
            Map $this$forEach$iv4 = MapsKt.plus(PyTargetAwareAdditionalData.Companion.getPathsAddedByUser(pyData), PyTargetAwareAdditionalData.Companion.getPathsRemovedByUser(pyData));
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv4.entrySet()) {
                it2 = element$iv;
                boolean bl6 = false;
                Path localPath = (Path)it2.getKey();
                String remotePath = (String)it2.getValue();
                pathMappings.add(new PathMappingSettings.PathMapping(((Object)localPath).toString(), remotePath));
            }
        }
        for (RootInfo rootInfo : ((StateFile)stateFile).getRoots()) {
            Path rootZip;
            String remoteRootPath = rootInfo.getPath();
            String localRootName = String.valueOf(remoteRootPath.hashCode());
            Path path4 = localRemoteSourcesRoot.resolve(localRootName);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
            Path localRoot = Files.createDirectories(path4, new FileAttribute[0]);
            pathMappings.addMappingCheckUnique(((Object)localRoot).toString(), remoteRootPath);
            Intrinsics.checkNotNullExpressionValue((Object)localRemoteSourcesRoot.resolve(rootInfo.getZipName()), (String)"this.resolve(other)");
            ZipUtil.extract((Path)rootZip, (Path)localRoot, null, (boolean)true);
            for (String invalidEntryRelPath : rootInfo.getInvalidEntries()) {
                Path localInvalidEntry;
                Intrinsics.checkNotNullExpressionValue((Object)localRoot, (String)"localRoot");
                Path bl6 = localRoot;
                String string = PathUtil.toSystemDependentName((String)invalidEntryRelPath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(invalidEntryRelPath)");
                Intrinsics.checkNotNullExpressionValue((Object)bl6.resolve(string), (String)"this.resolve(other)");
                LOG.debug("Removing the mapped file " + invalidEntryRelPath + " from " + remoteRootPath);
                PathKt.deleteWithParentsIfEmpty$default((Path)localInvalidEntry, (Path)localRemoteSourcesRoot, (boolean)false, (int)2, null);
            }
            Files.delete(rootZip);
        }
        if (targetWithVfs != null) {
            for (String string : ((StateFile)stateFile).getSkippedRoots()) {
                Object object = targetWithVfs.getVfsFromTargetPath(string);
                if (object == null || (object = object.getPath()) == null) continue;
                Object localPath = object;
                pathMappings.add(new PathMappingSettings.PathMapping((String)localPath, string));
            }
        }
        RemoteSdkProperties remoteSdkProperties = (sdkAdditionalData = this.sdk.getSdkAdditionalData()) instanceof RemoteSdkProperties ? (RemoteSdkProperties)sdkAdditionalData : null;
        if (remoteSdkProperties != null) {
            remoteSdkProperties.setPathMappings(pathMappings);
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        List list = pathMappings.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathMappings.pathMappings");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        Iterable localRootName = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PathMappingSettings.PathMapping it8 = (PathMappingSettings.PathMapping)element$iv$iv;
            boolean bl7 = false;
            if (fs.findFileByPath(it8.getLocalRoot()) == null) continue;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : iterable2) {
            VirtualFile it9 = (VirtualFile)element$iv;
            boolean bl = false;
            it9.refresh(false, true);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyTargetsRemoteSourcesRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "", "()V", "invalidEntries", "", "", "getInvalidEntries", "()Ljava/util/List;", "setInvalidEntries", "(Ljava/util/List;)V", "path", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "zipName", "getZipName", "setZipName", "toString", "intellij.python.community.impl"})
    private static final class RootInfo {
        @NotNull
        private String path = "";
        @SerializedName(value="zip_name")
        @NotNull
        private String zipName = "";
        @SerializedName(value="invalid_entries")
        @NotNull
        private List<String> invalidEntries = CollectionsKt.emptyList();

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String getZipName() {
            return this.zipName;
        }

        public final void setZipName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.zipName = string;
        }

        @NotNull
        public final List<String> getInvalidEntries() {
            return this.invalidEntries;
        }

        public final void setInvalidEntries(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.invalidEntries = list;
        }

        @NotNull
        public String toString() {
            return this.path;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$StateFile;", "", "()V", "roots", "", "Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "getRoots", "()Ljava/util/List;", "setRoots", "(Ljava/util/List;)V", "skippedRoots", "", "getSkippedRoots", "setSkippedRoots", "intellij.python.community.impl"})
    private static final class StateFile {
        @NotNull
        private List<RootInfo> roots = CollectionsKt.emptyList();
        @SerializedName(value="skipped_roots")
        @NotNull
        private List<String> skippedRoots = CollectionsKt.emptyList();

        @NotNull
        public final List<RootInfo> getRoots() {
            return this.roots;
        }

        public final void setRoots(@NotNull List<RootInfo> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.roots = list;
        }

        @NotNull
        public final List<String> getSkippedRoots() {
            return this.skippedRoots;
        }

        public final void setSkippedRoots(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.skippedRoots = list;
        }
    }
}

