/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallOnWindows;
import com.jetbrains.python.sdk.PySdkToInstallViaXCodeSelect;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a,\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u001a4\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getPy310ToInstallOnWindows", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows;", "getPy39ToInstallOnWindows", "getSdksToInstall", "", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "installSdkIfNeeded", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkToInstall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkToInstall.kt\ncom/jetbrains/python/sdk/PySdkToInstallKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1#2:450\n*E\n"})
public final class PySdkToInstallKt {
    @NotNull
    private static final Logger LOGGER;

    @NotNull
    public static final List<PySdkToInstall> getSdksToInstall() {
        List list;
        if (SystemInfo.isWindows) {
            PySdkToInstallOnWindows[] pySdkToInstallOnWindowsArray = new PySdkToInstallOnWindows[]{PySdkToInstallKt.getPy39ToInstallOnWindows(), PySdkToInstallKt.getPy310ToInstallOnWindows()};
            list = CollectionsKt.listOf((Object[])pySdkToInstallOnWindowsArray);
        } else {
            list = SystemInfo.isMac ? CollectionsKt.listOf((Object)((Object)new PySdkToInstallViaXCodeSelect())) : CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    public static final Sdk installSdkIfNeeded(@Nullable Sdk sdk2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks) {
        void var3_3;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Sdk it = sdk2;
        boolean bl = false;
        return it instanceof PySdkToInstall ? (Sdk)((PySdkToInstall)it).install(module, (Function0<? extends List<? extends PyDetectedSdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(module, existingSdks){
            final /* synthetic */ Module $module;
            final /* synthetic */ List<Sdk> $existingSdks;
            {
                this.$module = $module;
                this.$existingSdks = $existingSdks;
                super(0);
            }

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectSystemWideSdks$default(this.$module, this.$existingSdks, null, 4, null);
            }
        })) : var3_3;
    }

    @RequiresEdt
    @Nullable
    public static final Sdk installSdkIfNeeded(@Nullable Sdk sdk2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Sdk it = sdk2;
        boolean bl = false;
        return it instanceof PySdkToInstall ? (Sdk)((PySdkToInstall)it).install(module, (Function0<? extends List<? extends PyDetectedSdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(module, existingSdks, context){
            final /* synthetic */ Module $module;
            final /* synthetic */ List<Sdk> $existingSdks;
            final /* synthetic */ UserDataHolder $context;
            {
                this.$module = $module;
                this.$existingSdks = $existingSdks;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectSystemWideSdks(this.$module, this.$existingSdks, this.$context);
            }
        })) : it;
    }

    private static final PySdkToInstallOnWindows getPy39ToInstallOnWindows() {
        String version2 = "3.9";
        String name2 = "Python " + version2;
        HashFunction hashFunction = Hashing.md5();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"hashFunction");
        return new PySdkToInstallOnWindows(name2, version2, "https://www.python.org/ftp/python/3.9.13/python-3.9.13-amd64.exe", 29235432L, "e7062b85c3624af82079794729618eca", hashFunction, "python-3.9.13-amd64.exe");
    }

    private static final PySdkToInstallOnWindows getPy310ToInstallOnWindows() {
        String version2 = "3.10";
        String name2 = "Python " + version2;
        HashFunction hashFunction = Hashing.md5();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"hashFunction");
        return new PySdkToInstallOnWindows(name2, version2, "https://www.python.org/ftp/python/3.10.4/python-3.10.4-amd64.exe", 28488112L, "53fea6cfcce86fb87253364990f22109", hashFunction, "python-3.10.4-amd64.exe");
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }

    static {
        Logger logger = Logger.getInstance(PySdkToInstall.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(PySdkToInstall::class.java)");
        LOGGER = logger;
    }
}

