/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PropertiesManager
extends MembersManager<PyElement> {
    PropertiesManager() {
        super(PyElement.class);
    }

    @Override
    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<PyElement> elements) {
        if (elements == null) {
            PropertiesManager.$$$reportNull$$$0(0);
        }
        ArrayList<PyStatement> result2 = new ArrayList<PyStatement>();
        for (PyElement element : elements) {
            PyClass pyClass;
            PyPossibleClassMember classMember = PyUtil.as(element, PyPossibleClassMember.class);
            if (classMember == null || (pyClass = classMember.getContainingClass()) == null) continue;
            Property property = PropertiesManager.getProperty(pyClass, element);
            result2.addAll(PropertiesManager.getAllFunctions(property));
            PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)property.getDefinitionSite(), PyAssignmentStatement.class);
            if (assignment == null) continue;
            result2.add(assignment);
        }
        return result2;
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PropertiesManager.$$$reportNull$$$0(1);
        }
        ArrayList<PyElement> elements = new ArrayList<PyElement>(pyClass.getProperties().size());
        for (Property property : pyClass.getProperties().values()) {
            elements.add(PropertiesManager.getElement(property));
        }
        ArrayList<PyElement> arrayList = elements;
        if (arrayList == null) {
            PropertiesManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static PyElement getElement(@NotNull Property property) {
        if (property == null) {
            PropertiesManager.$$$reportNull$$$0(3);
        }
        PyCallable getter = property.getGetter().valueOrNull();
        PyCallable setter = property.getSetter().valueOrNull();
        PyCallable deleter = property.getDeleter().valueOrNull();
        if (getter != null) {
            PyCallable pyCallable = getter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(4);
            }
            return pyCallable;
        }
        if (setter != null) {
            PyCallable pyCallable = setter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(5);
            }
            return pyCallable;
        }
        if (deleter != null) {
            PyCallable pyCallable = deleter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(6);
            }
            return pyCallable;
        }
        PyTargetExpression site = property.getDefinitionSite();
        assert (site != null) : "Property has no methods nor declaration. That is not property";
        PyTargetExpression pyTargetExpression = site;
        if (pyTargetExpression == null) {
            PropertiesManager.$$$reportNull$$$0(7);
        }
        return pyTargetExpression;
    }

    @NotNull
    private static Property getProperty(@NotNull PyClass pyClass, @NotNull PyElement element) {
        if (pyClass == null) {
            PropertiesManager.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PropertiesManager.$$$reportNull$$$0(9);
        }
        Collection<Property> properties = pyClass.getProperties().values();
        if (element instanceof PyTargetExpression) {
            return PropertiesManager.getPropertyByTargetExpression(properties, (PyTargetExpression)element);
        }
        if (element instanceof PyFunction) {
            return PropertiesManager.getPropertyByFunction(properties, (PyFunction)element);
        }
        throw new IllegalArgumentException("Not function nor target");
    }

    @NotNull
    private static Property getPropertyByFunction(@NotNull Collection<Property> properties, @NotNull PyFunction functionToSearch) {
        if (properties == null) {
            PropertiesManager.$$$reportNull$$$0(10);
        }
        if (functionToSearch == null) {
            PropertiesManager.$$$reportNull$$$0(11);
        }
        for (Property property : properties) {
            for (PyFunction function : PropertiesManager.getAllFunctions(property)) {
                if (!function.equals(functionToSearch)) continue;
                Property property2 = property;
                if (property2 == null) {
                    PropertiesManager.$$$reportNull$$$0(12);
                }
                return property2;
            }
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Property getPropertyByTargetExpression(@NotNull Iterable<Property> properties, @NotNull PyTargetExpression element) {
        if (properties == null) {
            PropertiesManager.$$$reportNull$$$0(13);
        }
        if (element == null) {
            PropertiesManager.$$$reportNull$$$0(14);
        }
        for (Property property : properties) {
            if (!element.equals(property.getDefinitionSite())) continue;
            Property property2 = property;
            if (property2 == null) {
                PropertiesManager.$$$reportNull$$$0(15);
            }
            return property2;
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Collection<PyFunction> getAllFunctions(@NotNull Property property) {
        if (property == null) {
            PropertiesManager.$$$reportNull$$$0(16);
        }
        ArrayList<PyFunction> result2 = new ArrayList<PyFunction>(3);
        PyCallable getter = property.getGetter().valueOrNull();
        PyCallable setter = property.getSetter().valueOrNull();
        PyCallable deleter = property.getDeleter().valueOrNull();
        if (getter instanceof PyFunction) {
            result2.add((PyFunction)getter);
        }
        if (setter instanceof PyFunction) {
            result2.add((PyFunction)setter);
        }
        if (deleter instanceof PyFunction) {
            result2.add((PyFunction)deleter);
        }
        ArrayList<PyFunction> arrayList = result2;
        if (arrayList == null) {
            PropertiesManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyElement>> members2, PyClass ... to) {
        if (from == null) {
            PropertiesManager.$$$reportNull$$$0(18);
        }
        if (members2 == null) {
            PropertiesManager.$$$reportNull$$$0(19);
        }
        if (to == null) {
            PropertiesManager.$$$reportNull$$$0(20);
        }
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        Collection<PyElement> elements = PropertiesManager.fetchElements(members2);
        for (PyElement element : elements) {
            Property property = PropertiesManager.getProperty(from, element);
            Collection<PyFunction> functions = PropertiesManager.getAllFunctions(property);
            result2.addAll(MethodsManager.moveMethods(from, functions, false, to));
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite == null) continue;
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyAssignmentStatement.class);
            result2.addAll(ClassFieldsManager.moveAssignmentsImpl(from, Collections.singleton(assignmentStatement), to));
        }
        return result2;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyElement> apply(@NotNull PyElement input) {
        if (input == null) {
            PropertiesManager.$$$reportNull$$$0(21);
        }
        return new PyMemberInfo<PyElement>(input, false, PropertiesManager.getName(input), false, this, false);
    }

    private static String getName(@NotNull PyElement input) {
        if (input == null) {
            PropertiesManager.$$$reportNull$$$0(22);
        }
        PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)input, PyClass.class);
        assert (clazz != null) : "Element not declared in class";
        Property property = PropertiesManager.getProperty(clazz, input);
        return property.getName();
    }

    @Override
    public boolean hasConflict(@NotNull PyElement member, @NotNull PyClass aClass) {
        if (member == null) {
            PropertiesManager.$$$reportNull$$$0(23);
        }
        if (aClass == null) {
            PropertiesManager.$$$reportNull$$$0(24);
        }
        return false;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            PropertiesManager.$$$reportNull$$$0(25);
        }
        PyReferenceVisitor visitor2 = new PyReferenceVisitor();
        member.accept(visitor2);
        MultiMap<PyClass, PyElement> multiMap = visitor2.myResult;
        if (multiMap == null) {
            PropertiesManager.$$$reportNull$$$0(26);
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            PropertiesManager.$$$reportNull$$$0(27);
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            PropertiesManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 12, 15, 17, 26, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionToSearch";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByFunction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByTargetExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFunctions";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToStoreReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 26: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByFunction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByTargetExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllFunctions";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 12, 15, 17, 26, 28 -> new IllegalStateException(string);
        };
    }

    private static class PyReferenceVisitor
    extends PyRecursiveElementVisitorWithResult {
        private PyReferenceVisitor() {
        }

        @Override
        public void visitPyExpression(@NotNull PyExpression node) {
            PyClass pyClass;
            PsiReference reference;
            if (node == null) {
                PyReferenceVisitor.$$$reportNull$$$0(0);
            }
            if ((reference = node.getReference()) == null) {
                return;
            }
            PsiElement declaration = reference.resolve();
            if (!(declaration instanceof PyFunction)) {
                return;
            }
            PyFunction function = (PyFunction)declaration;
            Property property = function.getProperty();
            if (property == null) {
                return;
            }
            PyClass aClass = function.getContainingClass();
            if (aClass == null) {
                return;
            }
            Collection<PyFunction> functions = PropertiesManager.getAllFunctions(property);
            for (PyFunction pyFunction : functions) {
                PyClass functionClass = pyFunction.getContainingClass();
                if (functionClass == null) continue;
                this.myResult.putValue((Object)functionClass, (Object)pyFunction);
            }
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite != null && (pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyClass.class)) != null) {
                this.myResult.putValue((Object)pyClass, (Object)definitionSite);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager$PyReferenceVisitor", "visitPyExpression"));
        }
    }
}

