/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyElementGeneratorImpl;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListImpl
extends PyElementImpl
implements PyArgumentList {
    private static final NoKeyArguments NO_KEY_ARGUMENTS = new NoKeyArguments();

    public PyArgumentListImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyArgumentList(this);
    }

    @Override
    @NotNull
    public Collection<PyExpression> getArgumentExpressions() {
        PyExpression[] arguments = this.getArguments();
        ArrayList<PyExpression> result2 = new ArrayList<PyExpression>(arguments.length);
        for (PyExpression expression : arguments) {
            if (expression instanceof PyKeywordArgument) {
                PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
                result2.add(valueExpression);
            }
            if (!(expression instanceof PyReferenceExpression)) continue;
            result2.add(expression);
        }
        ArrayList<PyExpression> arrayList = result2;
        if (arrayList == null) {
            PyArgumentListImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    public PyExpression @NotNull [] getArguments() {
        PyExpression[] pyExpressionArray = (PyExpression[])this.childrenToPsi(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens(), PyExpression.EMPTY_ARRAY);
        if (pyExpressionArray == null) {
            PyArgumentListImpl.$$$reportNull$$$0(1);
        }
        return pyExpressionArray;
    }

    @Override
    @Nullable
    public PyKeywordArgument getKeywordArgument(String name2) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            PyKeywordArgument arg;
            String keyword;
            if (node.getElementType() != PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION || (keyword = (arg = (PyKeywordArgument)node.getPsi()).getKeyword()) == null || !keyword.equals(name2)) continue;
            return arg;
        }
        return null;
    }

    @Override
    public void addArgument(@NotNull PyExpression arg) {
        if (arg == null) {
            PyArgumentListImpl.$$$reportNull$$$0(2);
        }
        PyElementGeneratorImpl generator = new PyElementGeneratorImpl(this.getProject());
        Deque<PyKeywordArgument> keywordArguments = this.getKeyWordArguments();
        Deque<PyExpression> parameters = this.getParameters();
        if (keywordArguments.isEmpty() && parameters.isEmpty()) {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, null, arg);
            return;
        }
        if (arg instanceof PyKeywordArgument) {
            if (parameters.isEmpty()) {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, keywordArguments.getLast(), arg);
            } else if (keywordArguments.isEmpty()) {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
            } else {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, keywordArguments.getLast(), arg);
            }
        } else if (parameters.isEmpty()) {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, null, arg);
        } else {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
        }
    }

    @NotNull
    private Deque<PyExpression> getParameters() {
        PyExpression[] childrenOfType = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class);
        if (childrenOfType == null) {
            return new ArrayDeque<PyExpression>(0);
        }
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(childrenOfType), (Predicate)NO_KEY_ARGUMENTS));
        if (arrayDeque == null) {
            PyArgumentListImpl.$$$reportNull$$$0(3);
        }
        return arrayDeque;
    }

    @NotNull
    private Deque<PyKeywordArgument> getKeyWordArguments() {
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)this, PyKeywordArgument.class));
        if (arrayDeque == null) {
            PyArgumentListImpl.$$$reportNull$$$0(4);
        }
        return arrayDeque;
    }

    @Override
    public void addArgumentFirst(PyExpression arg) {
        ASTNode node = this.getNode();
        ASTNode[] pars = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LPAR}));
        if (pars.length == 0) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            ASTNode anchorBefore;
            ASTNode before = PyPsiUtils.getNextNonWhitespaceSibling(pars[0]);
            if (before != null && PyArgumentListImpl.elementPrecedesElementsOfType(before, PythonDialectsTokenSetProvider.getInstance().getExpressionTokens())) {
                ASTNode comma = this.createComma();
                node.addChild(comma, before);
                node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), before);
                anchorBefore = comma;
            } else {
                anchorBefore = before;
            }
            ASTNode argNode = arg.getNode();
            if (anchorBefore == null) {
                node.addChild(argNode);
            } else {
                node.addChild(argNode, anchorBefore);
            }
        }
    }

    @NotNull
    private ASTNode createComma() {
        ASTNode aSTNode = PyElementGenerator.getInstance(this.getProject()).createComma();
        if (aSTNode == null) {
            PyArgumentListImpl.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    private static boolean elementPrecedesElementsOfType(ASTNode before, TokenSet expressions) {
        for (ASTNode node = before; node != null; node = node.getTreeNext()) {
            if (!expressions.contains(node.getElementType())) continue;
            return true;
        }
        return false;
    }

    private void addArgumentLastWithoutComma(PyExpression arg) {
        ASTNode par = this.getClosingParen();
        if (par == null) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            this.getNode().addChild(arg.getNode(), par);
        }
    }

    @Override
    @Nullable
    public ASTNode getClosingParen() {
        ASTNode node = this.getNode();
        ASTNode[] children2 = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RPAR}));
        return children2.length == 0 ? null : children2[children2.length - 1];
    }

    private void addArgumentNode(PyExpression arg, ASTNode beforeThis, boolean commaFirst) {
        ASTNode comma = PyElementGenerator.getInstance(this.getProject()).createComma();
        ASTNode node = this.getNode();
        ASTNode argNode = arg.getNode();
        if (commaFirst) {
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
            node.addChild(argNode, beforeThis);
        } else {
            node.addChild(argNode, beforeThis);
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
        }
    }

    @Override
    public void addArgumentAfter(PyExpression argument, @Nullable PyExpression afterThis) {
        if (afterThis == null) {
            this.addArgumentFirst(argument);
            return;
        }
        boolean good = false;
        for (PyExpression expression : this.getArguments()) {
            if (expression != afterThis) continue;
            good = true;
            break;
        }
        if (!good) {
            throw new IllegalArgumentException("Expression " + afterThis + " is not an argument (" + Arrays.toString(this.getArguments()) + ")");
        }
        for (ASTNode node = afterThis.getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type2 = node.getElementType();
            if (type2 == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (PythonDialectsTokenSetProvider.getInstance().getExpressionTokens().contains(type2)) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (type2 != PyTokenTypes.COMMA) continue;
            ASTNode next = PyPsiUtils.getNextNonWhitespaceSibling(node);
            if (next == null) {
                this.addArgumentLastWithoutComma(argument);
                break;
            }
            if (next.getElementType() == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, next, false);
                break;
            }
            this.addArgumentNode(argument, next, false);
            break;
        }
    }

    @Override
    @Nullable
    public PyCallExpression getCallExpression() {
        return (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, PyCallExpression.class);
    }

    public void deleteChildInternal(@NotNull ASTNode node) {
        if (node == null) {
            PyArgumentListImpl.$$$reportNull$$$0(6);
        }
        if (ArrayUtil.contains((Object)node.getPsi(), (Object[])this.getArguments())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, node.getPsi());
        }
        super.deleteChildInternal(node);
    }

    @Override
    @Nullable
    public PyExpression getValueExpressionForParam(@NotNull FunctionParameter parameter) {
        PyKeywordArgument kwarg;
        String parameterName;
        if (parameter == null) {
            PyArgumentListImpl.$$$reportNull$$$0(7);
        }
        if ((parameterName = parameter.getName()) != null && (kwarg = this.getKeywordArgument(parameterName)) != null) {
            return kwarg.getValueExpression();
        }
        PyExpression[] arguments = this.getArguments();
        int position = parameter.getPosition();
        if (position != -1 && arguments.length > position) {
            PyExpression result2 = arguments[position];
            if (result2 instanceof PyKeywordArgument) {
                ((PyKeywordArgument)result2).getValueExpression();
            } else {
                return result2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyArgumentListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentExpressions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyArgumentListImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyWordArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueExpressionForParam";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class NoKeyArguments
    extends NotNullPredicate<PyExpression> {
        private NoKeyArguments() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyExpression input) {
            if (input == null) {
                NoKeyArguments.$$$reportNull$$$0(0);
            }
            return PsiTreeUtil.getParentOfType((PsiElement)input, PyKeywordArgument.class) == null && !(input instanceof PyKeywordArgument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyArgumentListImpl$NoKeyArguments", "applyNotNull"));
        }
    }
}

