/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolverKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J \u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider;", "Lcom/intellij/util/textCompletion/TextCompletionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "addClassesFromPyFile", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "file", "Lcom/jetbrains/python/psi/PyFile;", "added", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "addClassesVariants", "addVariantsFromModuleComponents", "moduleComponents", "", "applyPrefixMatcher", "prefix", "fillCompletionVariants", "getAdvertisement", "getPrefix", "text", "offset", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nTypeNameCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeNameCompletionProvider.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n800#2,11:103\n766#2:114\n857#2,2:115\n766#2:117\n857#2,2:118\n*S KotlinDebug\n*F\n+ 1 TypeNameCompletionProvider.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider\n*L\n54#1:103,11\n55#1:114\n55#1:115,2\n56#1:117\n56#1:118,2\n*E\n"})
public final class TypeNameCompletionProvider
implements TextCompletionProvider {
    @NotNull
    private final Project project;

    public TypeNameCompletionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public String getAdvertisement() {
        return null;
    }

    @NotNull
    public String getPrefix(@NotNull String text, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.substringAfterLast$default((String)text, (char)'.', null, (int)2, null);
    }

    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"result.withPrefixMatcher\u2026ainPrefixMatcher(prefix))");
        return completionResultSet;
    }

    @NotNull
    public CharFilter.Result acceptChar(char c) {
        return CharFilter.Result.ADD_TO_PREFIX;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        result2.restartCompletionOnAnyPrefixChange();
        String text = parameters.getOriginalFile().getText();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        if (!StringsKt.contains$default((CharSequence)text, (char)'.', (boolean)false, (int)2, null)) {
            this.addClassesVariants(parameters, result2);
        }
        char[] cArray = new char[]{'.'};
        List components = UtilKt.init((List)StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        this.addVariantsFromModuleComponents(parameters, result2, components);
    }

    /*
     * WARNING - void declaration
     */
    private final void addClassesFromPyFile(CompletionParameters parameters, CompletionResultSet result2, PyFile file, HashSet<String> added) {
        LookupElementBuilder it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        PyModuleType moduleType = new PyModuleType(file);
        ProcessingContext ctx = new ProcessingContext();
        ctx.put(PyType.CTX_NAMES, added);
        Object[] completionVariants = moduleType.getCompletionVariants("", parameters.getPosition().getParent(), ctx);
        Intrinsics.checkNotNullExpressionValue((Object)completionVariants, (String)"completionVariants");
        Object object = completionVariants;
        object = CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((Object[])object).length));
        boolean $i$f$filterIsInstance = false;
        void var11_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LookupElementBuilder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LookupElementBuilder)element$iv$iv;
            boolean bl = false;
            if (!(it.getPsiElement() instanceof PyClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LookupElementBuilder)element$iv$iv;
            boolean bl = false;
            if (!result2.getPrefixMatcher().isStartMatch((LookupElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List variantsList = (List)destination$iv$iv;
        result2.addAllElements((Iterable)variantsList);
    }

    private final void addVariantsFromModuleComponents(CompletionParameters parameters, CompletionResultSet result2, List<String> moduleComponents) {
        HashSet alreadyAddedModulesNames = new HashSet();
        HashSet<String> alreadyAddedClsNames = new HashSet<String>();
        for (PsiElement element : PyTypeNameResolverKt.getElementsFromModule(moduleComponents, this.project)) {
            PsiElement psiElement = element;
            if (psiElement instanceof PsiDirectory) {
                List<LookupElement> modules;
                Intrinsics.checkNotNullExpressionValue(PyModuleType.getSubModuleVariants((PsiDirectory)element, parameters.getPosition().getParent(), alreadyAddedModulesNames), (String)"getSubModuleVariants(ele\u2026alreadyAddedModulesNames)");
                result2.addAllElements((Iterable)modules);
                continue;
            }
            if (!(psiElement instanceof PyFile)) continue;
            this.addClassesFromPyFile(parameters, result2, (PyFile)element, alreadyAddedClsNames);
        }
    }

    private final void addClassesVariants(CompletionParameters parameters, CompletionResultSet result2) {
        StubIndex stubIndex = StubIndex.getInstance();
        Collection<String> clsKeys = PyClassNameIndex.allKeys(this.project);
        GlobalSearchScope globalSearchScope = PySearchUtilBase.defaultSuggestionScope((PsiElement)parameters.getOriginalFile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"defaultSuggestionScope(parameters.originalFile)");
        GlobalSearchScope scope = globalSearchScope;
        Set alreadySuggested = new LinkedHashSet();
        for (String elementName : result2.getPrefixMatcher().sortMatching(clsKeys)) {
            stubIndex.processElements(PyClassNameIndex.KEY, (Object)elementName, this.project, scope, PyClass.class, arg_0 -> TypeNameCompletionProvider.addClassesVariants$lambda$2((Function1)new Function1<PyClass, Boolean>((Set<String>)alreadySuggested, result2){
                final /* synthetic */ Set<String> $alreadySuggested;
                final /* synthetic */ CompletionResultSet $result;
                {
                    this.$alreadySuggested = $alreadySuggested;
                    this.$result = $result;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(PyClass element) {
                    ProgressManager.checkCanceled();
                    String string = element.getName();
                    if (string == null) {
                        return true;
                    }
                    String name2 = string;
                    if (element.getQualifiedName() == null) {
                        return true;
                    }
                    QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, null);
                    if (qualifiedName == null) {
                        return true;
                    }
                    QualifiedName importPath = qualifiedName;
                    String pathName = importPath + "." + name2;
                    if (this.$alreadySuggested.add(pathName)) {
                        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)pathName).withIcon(AllIcons.Nodes.Class).withTypeText(importPath.toString()).withPresentableText(name2);
                        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(pathName)\n       \u2026withPresentableText(name)");
                        LookupElementBuilder builder = lookupElementBuilder;
                        this.$result.addElement((LookupElement)builder);
                    }
                    return true;
                }
            }, arg_0));
        }
    }

    private static final boolean addClassesVariants$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

