/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.testing.PythonUnitTestDetectorsBasedOnSettings;
import com.jetbrains.python.testing.doctest.PythonDocTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyTestFinder
implements TestFinder {
    public PyDocStringOwner findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(0);
        }
        return (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyClass.class, PyFunction.class});
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PyDocStringOwner source;
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(1);
        }
        if ((source = this.findSourceElement(element)) == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                PyTestFinder.$$$reportNull$$$0(2);
            }
            return set;
        }
        String sourceName = source.getName();
        if (sourceName == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                PyTestFinder.$$$reportNull$$$0(3);
            }
            return set;
        }
        ArrayList<Pair> classesWithProximities = new ArrayList<Pair>();
        if (source instanceof PyClass) {
            Collection<String> names2 = PyClassNameIndex.allKeys(element.getProject());
            for (String eachName : names2) {
                if (!eachName.contains(sourceName)) continue;
                for (PyClass eachClass : PyClassNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestDetectorsBasedOnSettings.isTestClass(eachClass, ThreeState.UNSURE, null) && !PythonDocTestUtil.isDocTestClass(eachClass)) continue;
                    classesWithProximities.add(new Pair((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity((String)sourceName, (String)eachName)));
                }
            }
        } else {
            Collection<String> names3 = PyFunctionNameIndex.allKeys(element.getProject());
            for (String eachName : names3) {
                if (!eachName.contains(sourceName)) continue;
                for (PyFunction eachFunction : PyFunctionNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestDetectorsBasedOnSettings.isTestFunction(eachFunction, ThreeState.UNSURE, null) && !PythonDocTestUtil.isDocTestFunction(eachFunction)) continue;
                    classesWithProximities.add(new Pair((Object)eachFunction, (Object)TestFinderHelper.calcTestNameProximity((String)sourceName, (String)eachName)));
                }
            }
        }
        List list = TestFinderHelper.getSortedElements(classesWithProximities, (boolean)true);
        if (list == null) {
            PyTestFinder.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(5);
        }
        PyFunction sourceFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        PyClass source = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (sourceFunction == null && source == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                PyTestFinder.$$$reportNull$$$0(6);
            }
            return set;
        }
        ArrayList<Pair> testsWithWeights = new ArrayList<Pair>();
        ArrayList possibleNames = new ArrayList();
        if (source != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights((String)source.getName()));
        }
        if (sourceFunction != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights((String)sourceFunction.getName()));
        }
        for (Pair eachNameWithWeight : possibleNames) {
            for (PyClass eachClass : PyClassNameIndex.find((String)eachNameWithWeight.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PythonUnitTestDetectorsBasedOnSettings.isTestClass(eachClass, ThreeState.NO, null)) continue;
                testsWithWeights.add(new Pair((Object)eachClass, (Object)((Integer)eachNameWithWeight.second)));
            }
            for (PyFunction function : PyFunctionNameIndex.find((String)eachNameWithWeight.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PythonUnitTestDetectorsBasedOnSettings.isTestFunction(function, ThreeState.UNSURE, null)) continue;
                testsWithWeights.add(new Pair((Object)function, (Object)((Integer)eachNameWithWeight.second)));
            }
        }
        List list = TestFinderHelper.getSortedElements(testsWithWeights, (boolean)false);
        if (list == null) {
            PyTestFinder.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(8);
        }
        return PythonUnitTestDetectorsBasedOnSettings.isTestElement(element, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

