/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyExtendedCompletionContributorKt;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyExtendedCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "functionInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getFunctionInsertHandler", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "importingInsertHandler", "getImportingInsertHandler", "stringLiteralInsertHandler", "getStringLiteralInsertHandler", "doFillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillCompletionVariants", "insertStringLiteralPrefix", "qualifiedName", "", "name", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "shouldDoCompletion", "", "intellij.python.psi.impl"})
public abstract class PyExtendedCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    private final InsertHandler<LookupElement> importingInsertHandler = PyExtendedCompletionContributor::importingInsertHandler$lambda$0;
    @NotNull
    private final InsertHandler<LookupElement> functionInsertHandler = (InsertHandler)new PyFunctionInsertHandler(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            int tailOffset = context.getTailOffset() - 1;
            super.handleInsert(context, item);
            context.commitDocument();
            PyExtendedCompletionContributorKt.access$addImportForLookupElement(context, item, tailOffset);
        }
    };
    @NotNull
    private final InsertHandler<LookupElement> stringLiteralInsertHandler = (arg_0, arg_1) -> PyExtendedCompletionContributor.stringLiteralInsertHandler$lambda$1(this, arg_0, arg_1);

    @NotNull
    protected final InsertHandler<LookupElement> getImportingInsertHandler() {
        return this.importingInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getFunctionInsertHandler() {
        return this.functionInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getStringLiteralInsertHandler() {
        return this.stringLiteralInsertHandler;
    }

    private final void insertStringLiteralPrefix(String qualifiedName, String name2, InsertionContext context) {
        if (qualifiedName != null && name2 != null) {
            String string = qualifiedName.substring(0, qualifiedName.length() - name2.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String qualifiedNamePrefix = string;
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)qualifiedNamePrefix);
        }
    }

    public final void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!this.shouldDoCompletion(parameters, result2)) {
            return;
        }
        this.doFillCompletionVariants(parameters, result2);
    }

    protected abstract void doFillCompletionVariants(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2);

    private final boolean shouldDoCompletion(CompletionParameters parameters, CompletionResultSet result2) {
        if (!parameters.isExtendedCompletion()) {
            return false;
        }
        String string = result2.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.prefixMatcher.prefix");
        if (((CharSequence)string).length() == 0) {
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            return false;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiElement element = psiElement;
        PsiElement parent = element.getParent();
        if (parent instanceof PyReferenceExpression && ((PyReferenceExpression)parent).isQualified()) {
            return false;
        }
        if (parent instanceof PyStringLiteralExpression) {
            String string2 = ((PyStringLiteralExpression)parent).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.text");
            String string3 = string2;
            int n = 0;
            int n2 = parameters.getOffset() - ((PyStringLiteralExpression)parent).getTextRange().getStartOffset();
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string4;
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)".", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null;
    }

    private static final void importingInsertHandler$lambda$0(InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PyExtendedCompletionContributorKt.access$addImportForLookupElement(context, item, context.getTailOffset() - 1);
    }

    private static final void stringLiteralInsertHandler$lambda$1(PyExtendedCompletionContributor this$0, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiElement element = item.getPsiElement();
        if (element == null) {
            return;
        }
        if (element instanceof PyQualifiedNameOwner) {
            this$0.insertStringLiteralPrefix(((PyQualifiedNameOwner)element).getQualifiedName(), ((PyQualifiedNameOwner)element).getName(), context);
        } else {
            QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath(element, null);
            if (importPath != null) {
                this$0.insertStringLiteralPrefix(importPath.toString(), String.valueOf(importPath.getLastComponent()), context);
            }
        }
    }
}

