/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CollapseTagIntention
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string2 = XmlAnalysisBundle.message("xml.intention.replace.tag.empty.body.with.empty.end", new Object[0]);
        if (string2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls
    @NotNull
    public String getText() {
        String string2 = this.getName();
        if (string2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CollapseTagIntention.$$$reportNull$$$0(3);
        }
        CollapseTagIntention.applyFix(project2, descriptor.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        XmlTag tag;
        if (project2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(4);
        }
        return (tag = CollapseTagIntention.getTag(editor, file)) != null && !tag.isEmpty() && tag.getValue().getChildren().length == tag.getValue().getTextElements().length && tag.getValue().getTrimmedText().isEmpty() && CheckTagEmptyBodyInspection.isCollapsibleTag(tag);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlTag tag;
        if (project2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(5);
        }
        if ((tag = CollapseTagIntention.getTag(editor, file)) != null) {
            CollapseTagIntention.applyFix(project2, tag);
        }
    }

    private static XmlTag getTag(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider provider = file.getViewProvider();
        for (Language language : provider.getLanguages()) {
            PsiElement element = provider.findElementAt(offset, language);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null || XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode()) == null) continue;
            return tag;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected static void applyFix(@NotNull Project project2, @NotNull PsiElement tag) {
        ASTNode child;
        if (project2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            CollapseTagIntention.$$$reportNull$$$0(7);
        }
        if ((child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) == null) {
            return;
        }
        int offset = child.getTextRange().getStartOffset();
        Document document2 = tag.getContainingFile().getViewProvider().getDocument();
        assert (document2 != null);
        document2.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(tag);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiElement restored = pointer.getElement();
        if (restored != null) {
            CodeStyleManager.getInstance((Project)project2).reformat(restored);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/CollapseTagIntention";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/CollapseTagIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

