/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.inspections;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.webSymbols.inspections.WebSymbolsInspectionsPass;
import com.intellij.webSymbols.inspections.impl.WebSymbolsHighlightInLanguageEP;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/webSymbols/inspections/WebSymbolsPassFactory;", "Lcom/intellij/codeHighlighting/DirtyScopeTrackingHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "passId", "", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPassId", "Registrar", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsPassFactory.kt\ncom/intellij/webSymbols/inspections/WebSymbolsPassFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1747#2,3:27\n*S KotlinDebug\n*F\n+ 1 WebSymbolsPassFactory.kt\ncom/intellij/webSymbols/inspections/WebSymbolsPassFactory\n*L\n20#1:27,3\n*E\n"})
public final class WebSymbolsPassFactory
implements DirtyScopeTrackingHighlightingPassFactory {
    private final int passId;

    public WebSymbolsPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        int[] nArray = new int[]{7};
        this.passId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, nArray, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextEditorHighlightingPass textEditorHighlightingPass;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            List list = file.getViewProvider().getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"file.viewProvider.allFiles");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl2 = false;
                    Language language = it.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it.language");
                    if (!WebSymbolsHighlightInLanguageEP.Companion.shouldHighlight(language)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
            textEditorHighlightingPass = new WebSymbolsInspectionsPass(file, document2);
        } else {
            textEditorHighlightingPass = null;
        }
        return textEditorHighlightingPass;
    }

    public int getPassId() {
        return this.passId;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/webSymbols/inspections/WebSymbolsPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.webSymbols"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            new WebSymbolsPassFactory(registrar);
        }
    }
}

