/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.vcs.log.ui.frame.ProgressStripeIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgressStripe
extends JBPanel {
    private final JComponent myTargetComponent;
    private final Disposable myDisposable;
    private final int myStartDelayMs;
    @NotNull
    private final JBPanel myPanel;
    protected MyLoadingDecorator myDecorator;

    public ProgressStripe(@NotNull JComponent targetComponent, @NotNull Disposable parent, int startDelayMs) {
        if (targetComponent == null) {
            ProgressStripe.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ProgressStripe.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.add((Component)targetComponent);
        this.myTargetComponent = targetComponent;
        this.myDisposable = parent;
        this.myStartDelayMs = startDelayMs;
        this.createLoadingDecorator();
    }

    public void updateUI() {
        super.updateUI();
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            this.createLoadingDecorator();
        }
    }

    private void createLoadingDecorator() {
        if (this.myDecorator != null) {
            this.remove(this.myDecorator.getComponent());
            Disposer.dispose((Disposable)this.myDecorator.getDisposable());
        }
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myDisposable, (Disposable)disposable);
        this.myDecorator = new MyLoadingDecorator(this.myTargetComponent, (JPanel)this.myPanel, disposable, this.myStartDelayMs);
        this.add(this.myDecorator.getComponent(), "Center");
        this.myDecorator.setLoadingText("");
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
    }

    public void startLoadingImmediately() {
        this.myDecorator.startLoadingImmediately();
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/frame/ProgressStripe";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLoadingDecorator
    extends LoadingDecorator {
        @NotNull
        private final Disposable myDisposable;

        MyLoadingDecorator(@NotNull JComponent component2, @NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
            if (component2 == null) {
                MyLoadingDecorator.$$$reportNull$$$0(0);
            }
            if (contentPanel == null) {
                MyLoadingDecorator.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                MyLoadingDecorator.$$$reportNull$$$0(2);
            }
            super((JComponent)contentPanel, disposable, startDelayMs, false, ProgressStripeIcon.generateIcon(component2));
            this.myDisposable = disposable;
        }

        public void startLoadingImmediately() {
            this.doStartLoading(false);
        }

        @NotNull
        protected NonOpaquePanel customizeLoadingLayer(JPanel parent, @NotNull JLabel text2, @NotNull AnimatedIcon icon2) {
            if (text2 == null) {
                MyLoadingDecorator.$$$reportNull$$$0(3);
            }
            if (icon2 == null) {
                MyLoadingDecorator.$$$reportNull$$$0(4);
            }
            parent.setLayout(new BorderLayout());
            NonOpaquePanel result2 = new NonOpaquePanel();
            result2.setLayout((LayoutManager)new BoxLayout((Container)result2, 1));
            result2.add((Component)icon2);
            parent.add((Component)result2, "North");
            NonOpaquePanel nonOpaquePanel = result2;
            if (nonOpaquePanel == null) {
                MyLoadingDecorator.$$$reportNull$$$0(5);
            }
            return nonOpaquePanel;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                MyLoadingDecorator.$$$reportNull$$$0(6);
            }
            return disposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/ProgressStripe$MyLoadingDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/ProgressStripe$MyLoadingDecorator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "customizeLoadingLayer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeLoadingLayer";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

