/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.collapsing.TreeSetNodeIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Condition<? super Integer> myRedNodes;

    public FragmentGenerator(@NotNull LiteLinearGraph graph, @NotNull Condition<? super Integer> redNodes) {
        if (graph == null) {
            FragmentGenerator.$$$reportNull$$$0(0);
        }
        if (redNodes == null) {
            FragmentGenerator.$$$reportNull$$$0(1);
        }
        this.myGraph = graph;
        this.myRedNodes = redNodes;
    }

    @NotNull
    public Set<Integer> getMiddleNodes(int upNode, int downNode, boolean strict) {
        Set<Integer> downWalk = this.getWalkNodes(upNode, false, (Condition<? super Integer>)((Condition)integer -> integer > downNode));
        Set<Integer> upWalk = this.getWalkNodes(downNode, true, (Condition<? super Integer>)((Condition)integer -> integer < upNode));
        downWalk.retainAll(upWalk);
        if (strict) {
            downWalk.remove(upNode);
            downWalk.remove(downNode);
        }
        Set<Integer> set = downWalk;
        if (set == null) {
            FragmentGenerator.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    public Integer getNearRedNode(int startNode, int maxWalkSize, boolean isUp) {
        if (this.myRedNodes.value((Object)startNode)) {
            return startNode;
        }
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (this.myRedNodes.value((Object)next)) {
                return next;
            }
            if (maxWalkSize < 0) {
                return null;
            }
            --maxWalkSize;
            walker.addAll(this.getNodes(next, isUp));
        }
        return null;
    }

    @NotNull
    public GreenFragment getGreenFragmentForCollapse(int startNode, int maxWalkSize) {
        if (this.myRedNodes.value((Object)startNode)) {
            return new GreenFragment(null, null, Collections.emptySet());
        }
        Integer upRedNode = this.getNearRedNode(startNode, maxWalkSize, true);
        Integer downRedNode = this.getNearRedNode(startNode, maxWalkSize, false);
        Set<Integer> upPart = upRedNode != null ? this.getMiddleNodes(upRedNode, startNode, false) : this.getWalkNodes(startNode, true, FragmentGenerator.createStopFunction(maxWalkSize));
        Set<Integer> downPart = downRedNode != null ? this.getMiddleNodes(startNode, downRedNode, false) : this.getWalkNodes(startNode, false, FragmentGenerator.createStopFunction(maxWalkSize));
        Set middleNodes = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.union(upPart, downPart), i -> i.equals(upRedNode) || i.equals(downRedNode) ? null : i);
        return new GreenFragment(upRedNode, downRedNode, middleNodes);
    }

    @NotNull
    private Set<Integer> getWalkNodes(int startNode, boolean isUp, Condition<? super Integer> stopFunction) {
        HashSet<Integer> walkNodes = new HashSet<Integer>();
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (stopFunction.value((Object)next)) continue;
            walkNodes.add(next);
            walker.addAll(this.getNodes(next, isUp));
        }
        HashSet<Integer> hashSet = walkNodes;
        if (hashSet == null) {
            FragmentGenerator.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private List<Integer> getNodes(int nodeIndex, boolean isUp) {
        List<Integer> list = this.myGraph.getNodes(nodeIndex, LiteLinearGraph.NodeFilter.filter(isUp));
        if (list == null) {
            FragmentGenerator.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static Condition<Integer> createStopFunction(final int maxNodeCount) {
        return new Condition<Integer>(){
            private int count;
            {
                this.count = maxNodeCount;
            }

            public boolean value(Integer integer) {
                --this.count;
                return this.count < 0;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redNodes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWalkNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }

    public static final class GreenFragment {
        @Nullable
        private final Integer myUpRedNode;
        @Nullable
        private final Integer myDownRedNode;
        @NotNull
        private final Set<Integer> myMiddleGreenNodes;

        private GreenFragment(@Nullable Integer upRedNode, @Nullable Integer downRedNode, @NotNull Set<Integer> middleGreenNodes) {
            if (middleGreenNodes == null) {
                GreenFragment.$$$reportNull$$$0(0);
            }
            this.myUpRedNode = upRedNode;
            this.myDownRedNode = downRedNode;
            this.myMiddleGreenNodes = middleGreenNodes;
        }

        @Nullable
        public Integer getUpRedNode() {
            return this.myUpRedNode;
        }

        @Nullable
        public Integer getDownRedNode() {
            return this.myDownRedNode;
        }

        @NotNull
        public Set<Integer> getMiddleGreenNodes() {
            Set<Integer> set = this.myMiddleGreenNodes;
            if (set == null) {
                GreenFragment.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "middleGreenNodes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator$GreenFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator$GreenFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMiddleGreenNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

