/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomCreator {
    DomCreator() {
    }

    @Nullable
    static DomInvocationHandler createTagHandler(@NotNull XmlTag tag) {
        PsiElement candidate;
        if (tag == null) {
            DomCreator.$$$reportNull$$$0(0);
        }
        if (!((candidate = PhysicalDomParentStrategy.getParentTagCandidate(tag)) instanceof XmlTag)) {
            return DomCreator.createRootHandler(tag);
        }
        XmlTag parentTag = (XmlTag)candidate;
        DomInvocationHandler parent = DomCreator.getParentDom(parentTag);
        if (parent == null) {
            return null;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isEmpty((String)localName)) {
            return null;
        }
        DomGenericInfoEx info = parent.getGenericInfo();
        DomFixedChildDescription fixedDescription = DomCreator.findChildrenDescription(info.getFixedChildrenDescriptions(), tag, parent);
        if (fixedDescription != null) {
            return DomCreator.createIndexedHandler(parent, localName, tag.getNamespace(), fixedDescription, tag);
        }
        DomCollectionChildDescription collectionDescription = DomCreator.findChildrenDescription(info.getCollectionChildrenDescriptions(), tag, parent);
        if (collectionDescription != null) {
            return DomCreator.createCollectionHandler(tag, collectionDescription, parent, parentTag);
        }
        return DomCreator.createCustomHandler(tag, parent, localName, info);
    }

    @Nullable
    private static DomInvocationHandler createRootHandler(XmlTag xmlTag) {
        DomRootInvocationHandler handler2;
        DomFileElement element;
        PsiFile file = xmlTag.getContainingFile();
        DomFileElement domFileElement = element = file instanceof XmlFile ? DomManagerImpl.getDomManager(file.getProject()).getFileElement((XmlFile)file) : null;
        if (element != null && (handler2 = ((DomFileElementImpl)element).getRootHandler()).getXmlTag() == xmlTag) {
            return handler2;
        }
        return null;
    }

    @Nullable
    private static DomInvocationHandler createIndexedHandler(DomInvocationHandler parent, String localName, String namespace, DomFixedChildDescription description2, XmlTag tag) {
        int totalCount = description2.getCount();
        int index = 0;
        XmlTag current = tag;
        while ((current = current.getPrevSibling()) != null) {
            XmlTag xmlTag;
            if (!(current instanceof XmlTag) || !localName.equals((xmlTag = current).getLocalName()) || !namespace.equals(xmlTag.getNamespace()) || ++index < totalCount) continue;
            return null;
        }
        DomManagerImpl myDomManager = parent.getManager();
        return new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description2.getXmlName()), (FixedChildDescriptionImpl)description2, index, new PhysicalDomParentStrategy(tag, myDomManager), myDomManager, null);
    }

    @NotNull
    private static CollectionElementInvocationHandler createCollectionHandler(XmlTag tag, DomCollectionChildDescription description2, DomInvocationHandler parent, XmlTag parentTag) {
        DomStub parentStub = parent.getStub();
        if (parentStub != null) {
            int index = JBIterable.of((Object[])DomCreator.findSubTagsWithoutIncludes(parentTag, tag.getLocalName(), tag.getNamespace())).filter(t -> !(t instanceof IncludedXmlTag)).indexOf(t -> t == tag);
            ElementStub stub = parentStub.getElementStub(tag.getName(), index);
            if (stub != null) {
                XmlName name = description2.getXmlName();
                EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName(name, name.getNamespaceKey(), true);
                return new CollectionElementInvocationHandler(evaluatedXmlName, (AbstractDomChildDescriptionImpl)((Object)description2), parent.getManager(), stub);
            }
        }
        return new CollectionElementInvocationHandler(description2.getType(), tag, (AbstractCollectionChildDescription)((Object)description2), parent, null);
    }

    private static XmlTag @NotNull [] findSubTagsWithoutIncludes(@NotNull XmlTag parentTag, @NlsSafe String localName, @Nullable @NlsSafe String namespace) {
        if (parentTag == null) {
            DomCreator.$$$reportNull$$$0(1);
        }
        XmlTag[] xmlTagArray = XmlTagDelegate.findSubTags(localName, namespace, parentTag instanceof XmlTagImpl ? ((XmlTagImpl)parentTag).getSubTags(false) : parentTag.getSubTags());
        if (xmlTagArray == null) {
            DomCreator.$$$reportNull$$$0(2);
        }
        return xmlTagArray;
    }

    @Nullable
    private static DomInvocationHandler createCustomHandler(XmlTag tag, DomInvocationHandler parent, String localName, DomGenericInfoEx info) {
        List<? extends CustomDomChildrenDescription> customs = info.getCustomNameChildrenDescription();
        if (customs.isEmpty()) {
            return null;
        }
        XmlFile file = parent.getFile();
        for (DomFixedChildDescription domFixedChildDescription : info.getFixedChildrenDescriptions()) {
            XmlName xmlName = domFixedChildDescription.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(xmlName, tag, parent, file)) continue;
            return null;
        }
        for (CustomDomChildrenDescription customDomChildrenDescription : customs) {
            if (customDomChildrenDescription.getTagNameDescriptor() == null) continue;
            AbstractCollectionChildDescription desc = (AbstractCollectionChildDescription)((Object)customDomChildrenDescription);
            Type type2 = customDomChildrenDescription.getType();
            return new CollectionElementInvocationHandler(type2, tag, desc, parent, null);
        }
        return null;
    }

    @Nullable
    static DomFileElementImpl<?> createFileElement(XmlFile xmlFile) {
        ObjectStubTree stubTree;
        VirtualFile file = xmlFile.getVirtualFile();
        if (!(xmlFile.getFileType() instanceof DomSupportEnabled) || file != null && ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            IdempotenceChecker.logTrace((String)"DOM unsupported");
            return null;
        }
        DomFileDescription<?> description2 = DomCreator.findFileDescription(xmlFile);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace((String)("DOM file description: " + description2));
        }
        if (description2 == null) {
            return null;
        }
        XmlName xmlName = DomImplUtil.createXmlName(description2.getRootTagName(), description2.getRootElementClass(), null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl rootTagName1 = EvaluatedXmlNameImpl.createEvaluatedXmlName(xmlName, xmlName.getNamespaceKey(), false);
        FileStub stub = null;
        DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(description2);
        if (meta != null && meta.hasStubs() && file instanceof VirtualFileWithId && !DomCreator.isFileParsed(xmlFile) && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && !XmlUtil.isStubBuilding() && (stubTree = StubTreeLoader.getInstance().readFromVFile(xmlFile.getProject(), file)) != null) {
            stub = (FileStub)stubTree.getRoot();
        }
        DomFileElementImpl element = new DomFileElementImpl(xmlFile, rootTagName1, description2, stub);
        xmlFile.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, new WeakReference(element));
        return element;
    }

    private static boolean isFileParsed(XmlFile myXmlFile) {
        return myXmlFile instanceof PsiFileEx && ((PsiFileEx)myXmlFile).isContentsLoaded();
    }

    @Nullable
    static DomFileDescription<?> findFileDescription(XmlFile file) {
        DomFileDescription mockDescription = (DomFileDescription)file.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (mockDescription != null) {
            return mockDescription;
        }
        Project project2 = file.getProject();
        XmlFile originalFile = (XmlFile)file.getOriginalFile();
        DomManagerImpl domManager = DomManagerImpl.getDomManager(project2);
        if (!originalFile.equals(file)) {
            DomFileElement element = domManager.getFileElement(originalFile);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace((String)("Copy DOM from original file: " + (DomFileElementImpl)element));
            }
            return element == null ? null : ((DomFileElementImpl)element).getFileDescription();
        }
        return DomApplicationComponent.getInstance().findDescription(file);
    }

    @Nullable
    static DomInvocationHandler getParentDom(@NotNull XmlTag tag) {
        if (tag == null) {
            DomCreator.$$$reportNull$$$0(3);
        }
        LinkedHashSet<XmlTag> allParents = new LinkedHashSet<XmlTag>();
        XmlTag each = tag;
        while (each instanceof XmlTag && allParents.add(each)) {
            each = PhysicalDomParentStrategy.getParentTagCandidate(each);
        }
        ArrayList list = new ArrayList(allParents);
        Collections.reverse(list);
        DomManagerImpl manager = DomManagerImpl.getDomManager(tag.getProject());
        for (XmlTag xmlTag : list) {
            manager.getDomHandler(xmlTag);
        }
        return manager.getDomHandler(tag);
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(List<T> descriptions, XmlTag tag, DomInvocationHandler parent) {
        XmlFile file = parent.getFile();
        int size = descriptions.size();
        for (int i = 0; i < size; ++i) {
            DomChildrenDescription description2 = (DomChildrenDescription)descriptions.get(i);
            if (!DomImplUtil.isNameSuitable(description2.getXmlName(), tag, parent, file)) continue;
            return (T)description2;
        }
        return null;
    }

    @Nullable
    static AttributeChildInvocationHandler createAttributeHandler(@NotNull XmlAttribute attribute) {
        XmlTag tag;
        DomInvocationHandler handler2;
        if (attribute == null) {
            DomCreator.$$$reportNull$$$0(4);
        }
        DomInvocationHandler domInvocationHandler = handler2 = (tag = PhysicalDomParentStrategy.getParentTag(attribute)) == null ? null : DomCreator.getParentDom(tag);
        if (handler2 == null) {
            return null;
        }
        String localName = attribute.getLocalName();
        Ref result2 = Ref.create(null);
        handler2.getGenericInfo().processAttributeChildrenDescriptions((Processor<? super AttributeChildDescriptionImpl>)((Processor)description2 -> {
            EvaluatedXmlName evaluatedXmlName;
            String ns;
            if (description2.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler2.createEvaluatedXmlName(description2.getXmlName())).getNamespace(tag, handler2.getFile())).equals(tag.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                DomManagerImpl manager = handler2.getManager();
                result2.set((Object)new AttributeChildInvocationHandler(evaluatedXmlName, (AttributeChildDescriptionImpl)description2, manager, new PhysicalDomParentStrategy(attribute, manager), null));
                return false;
            }
            return true;
        }));
        return (AttributeChildInvocationHandler)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTagsWithoutIncludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTagHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSubTagsWithoutIncludes";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentDom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeHandler";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

