/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolderImpl;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.DomHighlightingHelperImpl;
import com.intellij.util.xml.highlighting.MockAnnotatingDomInspection;
import com.intellij.util.xml.highlighting.MockDomInspection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationsManagerImpl
extends DomElementAnnotationsManager {
    static final Object LOCK = new Object();
    private final EventDispatcher<DomElementAnnotationsManager.DomHighlightingListener> myDispatcher;
    private static final DomElementsProblemsHolder EMPTY_PROBLEMS_HOLDER = new DomElementsProblemsHolder(){

        @Override
        @NotNull
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
            List<DomElementProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
            return Collections.emptyList();
        }

        @Override
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        @Override
        public List<DomElementProblemDescriptor> getAllProblems() {
            return Collections.emptyList();
        }

        @Override
        public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
            if (inspection == null) {
                1.$$$reportNull$$$0(1);
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isInspectionCompleted(@NotNull DomElementsInspection inspectionClass) {
            if (inspectionClass == null) {
                1.$$$reportNull$$$0(2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblems";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllProblems";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isInspectionCompleted";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    };
    private final Map<XmlTag, DomElementsProblemsHolderImpl> myHolders;

    public DomElementAnnotationsManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(DomElementAnnotationsManager.DomHighlightingListener.class);
        this.myHolders = new WeakHashMap<XmlTag, DomElementsProblemsHolderImpl>();
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    2.$$$reportNull$$$0(0);
                }
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$2", "profileChanged"));
            }
        });
        connection.subscribe(PsiModificationTracker.TOPIC, this::dropAnnotationsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropAnnotationsCache() {
        Object object = LOCK;
        synchronized (object) {
            this.myHolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends DomElement> List<DomElementProblemDescriptor> appendProblems(@NotNull DomFileElement<T> element, @NotNull DomElementAnnotationHolder annotationHolder, Class<? extends DomElementsInspection<?>> inspectionClass) {
        if (element == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(1);
        }
        if (annotationHolder == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(2);
        }
        DomElementAnnotationHolderImpl holderImpl = (DomElementAnnotationHolderImpl)annotationHolder;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolderImpl holder = this._getOrCreateProblemsHolder(element);
            holder.appendProblems(holderImpl, inspectionClass);
        }
        ((DomElementAnnotationsManager.DomHighlightingListener)this.myDispatcher.getMulticaster()).highlightingFinished(element);
        return Collections.unmodifiableList(holderImpl);
    }

    @NotNull
    private DomElementsProblemsHolderImpl _getOrCreateProblemsHolder(DomFileElement<?> element) {
        XmlTag rootTag = element.getRootElement().getXmlTag();
        if (rootTag == null) {
            return new DomElementsProblemsHolderImpl(element);
        }
        DomElementsProblemsHolderImpl domElementsProblemsHolderImpl = this.myHolders.computeIfAbsent(rootTag, __ -> new DomElementsProblemsHolderImpl(element));
        if (domElementsProblemsHolderImpl == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(3);
        }
        return domElementsProblemsHolderImpl;
    }

    public boolean isHolderUpToDate(DomElement element) {
        return !this.isHolderOutdated(DomUtil.getFile(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outdateProblemHolder(DomElement element) {
        XmlTag rootTag = DomElementAnnotationsManagerImpl.getRootTagIfParsed(DomUtil.getFile(element));
        Object object = LOCK;
        synchronized (object) {
            if (rootTag != null) {
                this.myHolders.remove(rootTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHolderOutdated(XmlFile file) {
        Object object = LOCK;
        synchronized (object) {
            XmlTag rootTag = DomElementAnnotationsManagerImpl.getRootTagIfParsed(file);
            return rootTag == null || !this.myHolders.containsKey(rootTag);
        }
    }

    @Nullable
    private static XmlTag getRootTagIfParsed(@NotNull XmlFile file) {
        if (file == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(4);
        }
        return ((XmlFileImpl)file).isContentsLoaded() ? file.getRootTag() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public DomElementsProblemsHolder getProblemHolder(DomElement element) {
        DomElementsProblemsHolder readyHolder;
        if (element == null || !element.isValid()) {
            DomElementsProblemsHolder domElementsProblemsHolder = EMPTY_PROBLEMS_HOLDER;
            if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(5);
            return domElementsProblemsHolder;
        }
        DomFileElement fileElement = DomUtil.getFileElement(element);
        Object object = LOCK;
        // MONITORENTER : object
        XmlTag tag = fileElement.getRootElement().getXmlTag();
        if (tag != null && (readyHolder = (DomElementsProblemsHolder)this.myHolders.get(tag)) != null) {
            DomElementsProblemsHolder domElementsProblemsHolder = readyHolder;
            // MONITOREXIT : object
            if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(6);
            return domElementsProblemsHolder;
        }
        DomElementsProblemsHolder domElementsProblemsHolder = EMPTY_PROBLEMS_HOLDER;
        // MONITOREXIT : object
        if (domElementsProblemsHolder != null) return domElementsProblemsHolder;
        DomElementAnnotationsManagerImpl.$$$reportNull$$$0(7);
        return domElementsProblemsHolder;
    }

    @Override
    @NotNull
    public DomElementsProblemsHolder getCachedProblemHolder(DomElement element) {
        DomElementsProblemsHolder domElementsProblemsHolder = this.getProblemHolder(element);
        if (domElementsProblemsHolder == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(8);
        }
        return domElementsProblemsHolder;
    }

    @Override
    public List<ProblemDescriptor> createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        return ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createProblemDescriptors(manager, problemDescriptor));
    }

    @Override
    public boolean isHighlightingFinished(DomElement[] domElements) {
        for (DomElement domElement : domElements) {
            if (this.getHighlightStatus(domElement) == DomHighlightStatus.INSPECTIONS_FINISHED) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addHighlightingListener(DomElementAnnotationsManager.DomHighlightingListener listener2, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public DomHighlightingHelper getHighlightingHelper() {
        return DomHighlightingHelperImpl.INSTANCE;
    }

    @Override
    @NotNull
    public <T extends DomElement> List<DomElementProblemDescriptor> checkFileElement(@NotNull DomFileElement<T> domFileElement, @NotNull DomElementsInspection<T> inspection, boolean onTheFly) {
        if (domFileElement == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(9);
        }
        if (inspection == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(10);
        }
        DomElementsProblemsHolder problemHolder = this.getProblemHolder(domFileElement);
        if (this.isHolderUpToDate(domFileElement) && problemHolder.isInspectionCompleted(inspection)) {
            List<DomElementProblemDescriptor> list = problemHolder.getAllProblems(inspection);
            if (list == null) {
                DomElementAnnotationsManagerImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        DomElementAnnotationHolderImpl holder = new DomElementAnnotationHolderImpl(onTheFly, domFileElement, (AnnotationHolder)new AnnotationHolderImpl(new AnnotationSession((PsiFile)domFileElement.getFile()), false));
        inspection.checkFileElement(domFileElement, holder);
        List<DomElementProblemDescriptor> list = this.appendProblems(domFileElement, holder, ((Object)inspection).getClass());
        if (list == null) {
            DomElementAnnotationsManagerImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    public List<DomElementsInspection<?>> getSuitableDomInspections(DomFileElement<?> fileElement, boolean enabledOnly) {
        Class<?> rootType = fileElement.getRootElementClass();
        InspectionProfile profile = this.getInspectionProfile(fileElement);
        SmartList inspections = new SmartList();
        for (InspectionToolWrapper toolWrapper : profile.getInspectionTools((PsiElement)fileElement.getFile())) {
            InspectionProfileEntry entry2;
            if (enabledOnly && !profile.isToolEnabled(HighlightDisplayKey.find((String)toolWrapper.getShortName()), (PsiElement)fileElement.getFile()) || !((entry2 = toolWrapper.getTool()) instanceof DomElementsInspection) || !ContainerUtil.exists(((DomElementsInspection)entry2).getDomClasses(), cls -> cls.isAssignableFrom(rootType))) continue;
            inspections.add((DomElementsInspection)entry2);
        }
        return inspections;
    }

    protected InspectionProfile getInspectionProfile(DomFileElement<?> fileElement) {
        return InspectionProjectProfileManager.getInstance((Project)fileElement.getManager().getProject()).getCurrentProfile();
    }

    @Nullable
    public <T extends DomElement> DomElementsInspection<T> getMockInspection(DomFileElement<? extends T> root) {
        if (root.getFileDescription().isAutomaticHighlightingEnabled()) {
            return new MockAnnotatingDomInspection<T>(root.getRootElementClass());
        }
        if (this.getSuitableDomInspections(root, false).isEmpty()) {
            return new MockDomInspection<T>(root.getRootElementClass());
        }
        return null;
    }

    private static boolean areInspectionsFinished(DomElementsProblemsHolderImpl holder, List<? extends DomElementsInspection<?>> suitableInspections) {
        for (DomElementsInspection<?> inspection : suitableInspections) {
            if (holder.isInspectionCompleted(inspection)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DomHighlightStatus getHighlightStatus(DomElement element) {
        DomElementsProblemsHolder holder;
        Object object = LOCK;
        // MONITORENTER : object
        DomFileElement root = DomUtil.getFileElement(element);
        if (!this.isHolderOutdated(root.getFile()) && (holder = this.getProblemHolder(element)) instanceof DomElementsProblemsHolderImpl) {
            DomElementsProblemsHolderImpl holderImpl = (DomElementsProblemsHolderImpl)holder;
            List<DomElementsInspection<?>> suitableInspections = this.getSuitableDomInspections(root, true);
            DomElementsInspection mockInspection = this.getMockInspection(root);
            boolean annotatorsFinished = mockInspection == null || holderImpl.isInspectionCompleted(mockInspection);
            boolean inspectionsFinished = DomElementAnnotationsManagerImpl.areInspectionsFinished(holderImpl, suitableInspections);
            if (annotatorsFinished) {
                if (!suitableInspections.isEmpty() && !inspectionsFinished) {
                    DomHighlightStatus domHighlightStatus = DomHighlightStatus.ANNOTATORS_FINISHED;
                    // MONITOREXIT : object
                    if (domHighlightStatus != null) return domHighlightStatus;
                    DomElementAnnotationsManagerImpl.$$$reportNull$$$0(14);
                    return domHighlightStatus;
                }
                DomHighlightStatus domHighlightStatus = DomHighlightStatus.INSPECTIONS_FINISHED;
                // MONITOREXIT : object
                if (domHighlightStatus != null) return domHighlightStatus;
                DomElementAnnotationsManagerImpl.$$$reportNull$$$0(13);
                return domHighlightStatus;
            }
        }
        DomHighlightStatus domHighlightStatus = DomHighlightStatus.NONE;
        // MONITOREXIT : object
        if (domHighlightStatus != null) return domHighlightStatus;
        DomElementAnnotationsManagerImpl.$$$reportNull$$$0(15);
        return domHighlightStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationHolder";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_getOrCreateProblemsHolder";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedProblemHolder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendProblems";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootTagIfParsed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkFileElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 6, 7, 8, 11, 12, 13, 14, 15 -> new IllegalStateException(string2);
        };
    }
}

