/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.DictionaryLevel;
import com.intellij.spellchecker.settings.CustomDictionaryPathListener;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.util.Consumer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="SpellCheckerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class SpellCheckerSettings
implements PersistentStateComponent<Element> {
    private static final String SPELLCHECKER_MANAGER_SETTINGS_TAG = "SpellCheckerSettings";
    private static final String FOLDERS_ATTR_NAME = "Folders";
    private static final String FOLDER_ATTR_NAME = "Folder";
    private static final String CUSTOM_DICTIONARIES_ATTR_NAME = "CustomDictionaries";
    private static final String CUSTOM_DICTIONARY_ATTR_NAME = "CustomDictionary";
    private static final String RUNTIME_DICTIONARIES_ATTR_NAME = "RuntimeDictionaries";
    private static final String RUNTIME_DICTIONARY_ATTR_NAME = "RuntimeDictionary";
    private static final String DICTIONARY_TO_SAVE_ATTR_NAME = "DefaultDictionary";
    private static final String DEFAULT_DICTIONARY_TO_SAVE = DictionaryLevel.PROJECT.getName();
    private static final String USE_SINGLE_DICT_ATTR_NAME = "UseSingleDictionary";
    private static final boolean DEFAULT_USE_SINGLE_DICT = true;
    private static final String SETTINGS_TRANSFERRED = "transferred";
    private final List<String> myOldDictionaryFoldersPaths = new ArrayList<String>();
    private List<String> myCustomDictionariesPaths = new ArrayList<String>();
    private Set<String> myRuntimeDisabledDictionariesNames = new HashSet<String>();
    private String myDictionaryToSave = DEFAULT_DICTIONARY_TO_SAVE;
    private boolean myUseSingleDictionaryToSave = true;
    private boolean mySettingsTransferred;

    @NlsSafe
    public String getDictionaryToSave() {
        return this.myDictionaryToSave;
    }

    public void setDictionaryToSave(String dictionaryToSave) {
        this.myDictionaryToSave = dictionaryToSave;
    }

    public boolean isUseSingleDictionaryToSave() {
        return this.myUseSingleDictionaryToSave;
    }

    public void setUseSingleDictionaryToSave(boolean useSingleDictionaryToSave) {
        this.myUseSingleDictionaryToSave = useSingleDictionaryToSave;
    }

    public boolean isSettingsTransferred() {
        return this.mySettingsTransferred;
    }

    public void setSettingsTransferred(boolean settingsTransferred) {
        this.mySettingsTransferred = settingsTransferred;
    }

    @NotNull
    public static SpellCheckerSettings getInstance(Project project2) {
        SpellCheckerSettings spellCheckerSettings = (SpellCheckerSettings)project2.getService(SpellCheckerSettings.class);
        if (spellCheckerSettings == null) {
            SpellCheckerSettings.$$$reportNull$$$0(0);
        }
        return spellCheckerSettings;
    }

    public List<String> getCustomDictionariesPaths() {
        return this.myCustomDictionariesPaths;
    }

    public void setCustomDictionariesPaths(List<String> customDictionariesPaths) {
        this.myCustomDictionariesPaths = customDictionariesPaths;
        ((CustomDictionaryPathListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CustomDictionaryPathListener.Companion.getTOPIC())).dictionariesChanged(customDictionariesPaths);
    }

    public Set<String> getRuntimeDisabledDictionariesNames() {
        return this.myRuntimeDisabledDictionariesNames;
    }

    public void setRuntimeDisabledDictionariesNames(Set<String> runtimeDisabledDictionariesNames) {
        this.myRuntimeDisabledDictionariesNames = runtimeDisabledDictionariesNames;
    }

    public Element getState() {
        int j;
        if (this.myRuntimeDisabledDictionariesNames.isEmpty() && this.myOldDictionaryFoldersPaths.isEmpty() && this.myCustomDictionariesPaths.isEmpty() && this.myUseSingleDictionaryToSave && this.myDictionaryToSave.equals(DEFAULT_DICTIONARY_TO_SAVE) && !this.mySettingsTransferred) {
            return null;
        }
        Element element = new Element(SPELLCHECKER_MANAGER_SETTINGS_TAG);
        element.setAttribute(RUNTIME_DICTIONARIES_ATTR_NAME, String.valueOf(this.myRuntimeDisabledDictionariesNames.size()));
        Iterator<String> iterator = this.myRuntimeDisabledDictionariesNames.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(RUNTIME_DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        element.setAttribute(FOLDERS_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element.setAttribute(FOLDER_ATTR_NAME + j, Paths.get(this.myCustomDictionariesPaths.get(j), new String[0]).getParent().toString());
        }
        element.setAttribute(CUSTOM_DICTIONARIES_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element.setAttribute(CUSTOM_DICTIONARY_ATTR_NAME + j, this.myCustomDictionariesPaths.get(j));
        }
        element.setAttribute(DICTIONARY_TO_SAVE_ATTR_NAME, this.myDictionaryToSave);
        element.setAttribute(USE_SINGLE_DICT_ATTR_NAME, String.valueOf(this.myUseSingleDictionaryToSave));
        element.setAttribute(SETTINGS_TRANSFERRED, String.valueOf(this.mySettingsTransferred));
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            SpellCheckerSettings.$$$reportNull$$$0(1);
        }
        this.myRuntimeDisabledDictionariesNames.clear();
        this.myCustomDictionariesPaths.clear();
        this.myOldDictionaryFoldersPaths.clear();
        try {
            int i;
            int runtimeDictionariesSize = StringUtil.parseInt((String)element.getAttributeValue(RUNTIME_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i2 = 0; i2 < runtimeDictionariesSize; ++i2) {
                this.myRuntimeDisabledDictionariesNames.add(element.getAttributeValue(RUNTIME_DICTIONARY_ATTR_NAME + i2));
            }
            if (element.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME) == null) {
                int foldersSize = StringUtil.parseInt((String)element.getAttributeValue(FOLDERS_ATTR_NAME), (int)0);
                for (i = 0; i < foldersSize; ++i) {
                    this.myOldDictionaryFoldersPaths.add(element.getAttributeValue(FOLDER_ATTR_NAME + i));
                }
                this.myOldDictionaryFoldersPaths.forEach(folder -> SPFileUtil.processFilesRecursively(folder, (Consumer<? super String>)((Consumer)file -> {
                    if (FileUtilRt.extensionEquals((String)file, (String)"dic")) {
                        this.myCustomDictionariesPaths.add((String)file);
                    }
                })));
            }
            int customDictSize = StringUtil.parseInt((String)element.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME), (int)0);
            for (i = 0; i < customDictSize; ++i) {
                this.myCustomDictionariesPaths.add(element.getAttributeValue(CUSTOM_DICTIONARY_ATTR_NAME + i));
            }
            this.myDictionaryToSave = StringUtil.notNullize((String)element.getAttributeValue(DICTIONARY_TO_SAVE_ATTR_NAME), (String)DEFAULT_DICTIONARY_TO_SAVE);
            this.myUseSingleDictionaryToSave = Boolean.parseBoolean(StringUtil.notNullize((String)element.getAttributeValue(USE_SINGLE_DICT_ATTR_NAME), (String)String.valueOf(true)));
            this.mySettingsTransferred = Boolean.parseBoolean(StringUtil.notNullize((String)element.getAttributeValue(SETTINGS_TRANSFERRED), (String)"false"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/settings/SpellCheckerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/settings/SpellCheckerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

