/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.hunspell;

import ai.grazie.spell.lists.hunspell.HunspellWordList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.hunspell.HunspellBundle;
import com.intellij.spellchecker.hunspell.HunspellDictionary;
import com.intellij.util.Consumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary;", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "path", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "alphabet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "dict", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "consumeSuggestions", "", "word", "consumer", "Lcom/intellij/util/Consumer;", "contains", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getName", "getWords", "", "language", "Companion", "intellij.spellchecker"})
public final class HunspellDictionary
implements Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final HunspellWordList dict;
    @NotNull
    private final HashSet<Integer> alphabet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HunspellDictionary(@NotNull String path2, @Nullable String name) {
        HunspellBundle bundle;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.alphabet = new HashSet();
        String string2 = name;
        if (string2 == null) {
            string2 = this.name = path2;
        }
        if ((bundle = HunspellDictionary.Companion.loadHunspellBundle(path2)) != null) {
            Object object;
            Closeable closeable = new FileInputStream(bundle.getAff());
            HunspellDictionary hunspellDictionary = this;
            Object object2 = null;
            try {
                HunspellWordList hunspellWordList;
                FileInputStream affix = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileInputStream(bundle.getDic());
                Throwable throwable = null;
                try {
                    FileInputStream dictionary = (FileInputStream)closeable2;
                    boolean bl2 = false;
                    hunspellWordList = new HunspellWordList(affix, dictionary, HunspellDictionary::lambda$2$lambda$1$lambda$0, 0L, 8, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                object = hunspellWordList;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            hunspellDictionary.dict = object;
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)bundle.getDic(), (boolean)true);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile;
            object2 = new InputStreamReader(file.getInputStream(), file.getCharset());
            object = null;
            try {
                InputStreamReader reader = (InputStreamReader)object2;
                boolean bl = false;
                TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ HunspellDictionary this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull String line) {
                        String string2;
                        block1: {
                            void var2_2;
                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                            String $this$takeWhile$iv = line;
                            boolean $i$f$takeWhile = false;
                            int n = $this$takeWhile$iv.length();
                            for (int index$iv = 0; index$iv < n; ++index$iv) {
                                char it = $this$takeWhile$iv.charAt(index$iv);
                                boolean bl = false;
                                if (it != ' ' && it != '/') continue;
                                String string3 = $this$takeWhile$iv;
                                int n2 = 0;
                                String string4 = string3.substring(n2, index$iv);
                                string2 = string4;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                break block1;
                            }
                            string2 = var2_2;
                        }
                        String string5 = string2.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        string5.chars().forEach(arg_0 -> 2.1.invoke$lambda$1(this.this$0, arg_0));
                    }

                    private static final void invoke$lambda$1(HunspellDictionary this$0, int it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        HunspellDictionary.access$getAlphabet$p(this$0).add(it);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        throw new FileNotFoundException("File '" + path2 + "' not found");
    }

    public /* synthetic */ HunspellDictionary(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        this(string2, string3);
    }

    @Nullable
    public final String language() {
        return this.dict.language();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.dict.contains(word, false)) {
            return true;
        }
        String string2 = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (string2.chars().anyMatch(arg_0 -> HunspellDictionary.contains$lambda$4(this, arg_0))) {
            return null;
        }
        return false;
    }

    @Override
    public void consumeSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        for (String suggestion : this.dict.suggest(word)) {
            consumer.consume((Object)suggestion);
        }
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        throw new UnsupportedOperationException();
    }

    private static final void lambda$2$lambda$1$lambda$0() {
        ProgressManager.checkCanceled();
    }

    private static final boolean contains$lambda$4(HunspellDictionary this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return !this$0.alphabet.contains(it);
    }

    public static final /* synthetic */ HashSet access$getAlphabet$p(HunspellDictionary $this) {
        return $this.alphabet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary$Companion;", "", "()V", "isHunspell", "", "path", "", "loadHunspellBundle", "Lcom/intellij/spellchecker/hunspell/HunspellBundle;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        private final HunspellBundle loadHunspellBundle(String path2) {
            if (!Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)path2), (Object)"dic")) {
                return null;
            }
            String string2 = FileUtilRt.getNameWithoutExtension((String)path2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(path)");
            String pathWithoutExtension = string2;
            File dic = new File(pathWithoutExtension + ".dic");
            File aff = new File(pathWithoutExtension + ".aff");
            return dic.exists() && aff.exists() ? new HunspellBundle(dic, aff) : null;
        }

        public final boolean isHunspell(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.loadHunspellBundle(path2) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

