/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependentNSReference
extends BasicAttributeValueReference {
    @NotNull
    private final URLReference myReference;
    private final boolean myForceFetchResultValid;

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref) {
        if (ref == null) {
            DependentNSReference.$$$reportNull$$$0(0);
        }
        this(element, range, ref, false);
    }

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref, boolean valid) {
        if (ref == null) {
            DependentNSReference.$$$reportNull$$$0(1);
        }
        super(element, range);
        this.myReference = ref;
        this.myForceFetchResultValid = valid;
    }

    @Nullable
    public PsiElement resolve() {
        String canonicalText = this.getCanonicalText();
        PsiFile file = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getContainingFile(), null);
        if (file != null) {
            return file;
        }
        PsiElement element = this.myReference.resolve();
        if (element == null && !this.myForceFetchResultValid && !XmlUtil.isUrlText(canonicalText, this.myElement.getProject())) {
            return this.myElement;
        }
        return element;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean isForceFetchResultValid() {
        return this.myForceFetchResultValid;
    }

    @NotNull
    public URLReference getNamespaceReference() {
        URLReference uRLReference = this.myReference;
        if (uRLReference == null) {
            DependentNSReference.$$$reportNull$$$0(2);
        }
        return uRLReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

