/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntheticBlock
implements Block {
    protected final Indent myIndent;
    @NotNull
    protected XmlFormattingPolicy myXmlFormattingPolicy;
    protected final ASTNode myEndTreeNode;
    protected final ASTNode myStartTreeNode;
    private final XmlTag myTag;
    private static final Logger LOG = Logger.getInstance(AbstractSyntheticBlock.class);

    public AbstractSyntheticBlock(@NotNull @NotNull List<@NotNull Block> subBlocks, @NotNull Block parent, @NotNull XmlFormattingPolicy policy, @Nullable Indent indent) {
        if (subBlocks == null) {
            AbstractSyntheticBlock.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AbstractSyntheticBlock.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            AbstractSyntheticBlock.$$$reportNull$$$0(2);
        }
        this.myEndTreeNode = this.getLastNode(subBlocks);
        this.myStartTreeNode = this.getFirstNode(subBlocks);
        this.myIndent = indent;
        this.myXmlFormattingPolicy = policy;
        if (parent instanceof AbstractXmlBlock) {
            this.myTag = ((AbstractXmlBlock)parent).getTag();
        } else if (parent instanceof AbstractSyntheticBlock) {
            this.myTag = ((AbstractSyntheticBlock)parent).getTag();
        } else {
            throw new IllegalStateException("Parent should be AbstractXmlBlock or AbstractSyntheticBlock, but it is " + parent.getClass());
        }
    }

    public boolean shouldKeepWhiteSpacesInside() {
        return this.myTag != null && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.myTag);
    }

    private ASTNode getFirstNode(List<? extends Block> subBlocks) {
        LOG.assertTrue(!subBlocks.isEmpty());
        Block firstBlock = subBlocks.get(0);
        if (firstBlock instanceof AbstractBlock) {
            return ((AbstractBlock)firstBlock).getNode();
        }
        return this.getFirstNode(firstBlock.getSubBlocks());
    }

    private ASTNode getLastNode(List<? extends Block> subBlocks) {
        LOG.assertTrue(!subBlocks.isEmpty());
        Block lastBlock = subBlocks.get(subBlocks.size() - 1);
        if (lastBlock instanceof AbstractBlock) {
            return ((AbstractBlock)lastBlock).getNode();
        }
        return this.getLastNode(lastBlock.getSubBlocks());
    }

    private boolean isEndOfTag() {
        return this.myEndTreeNode.getElementType() == XmlTokenType.XML_TAG_END;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    protected boolean isXmlTagName(IElementType type1, IElementType type2) {
        if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && type2 == XmlTokenType.XML_TAG_END) {
            return true;
        }
        if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        if (this.isAttributeElementType(type1) && type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        return this.isAttributeElementType(type1) && type2 == XmlTokenType.XML_TAG_END;
    }

    protected boolean isTextNode(IElementType nodeType) {
        return nodeType == XmlElementType.XML_TEXT || nodeType == XmlElementType.HTML_RAW_TEXT;
    }

    public boolean endsWithText() {
        return this.isTextNode(this.myEndTreeNode.getElementType()) || this.myEndTreeNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myEndTreeNode.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF || this.myEndTreeNode.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    public boolean isTagDescription() {
        return AbstractSyntheticBlock.isTagDescription(this.myStartTreeNode);
    }

    private static boolean isTagDescription(ASTNode startTreeNode) {
        return startTreeNode.getElementType() == XmlTokenType.XML_START_TAG_START || startTreeNode.getElementType() == XmlTokenType.XML_END_TAG_START;
    }

    public boolean startsWithText() {
        return this.isTextNode(this.myStartTreeNode.getElementType()) || this.myStartTreeNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myStartTreeNode.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF || this.myStartTreeNode.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    public boolean endsWithTextElement() {
        if (this.endsWithText()) {
            return true;
        }
        if (this.isEndOfTag() && this.myXmlFormattingPolicy.isTextElement(this.getTag())) {
            return true;
        }
        return this.isTextTag(this.myEndTreeNode);
    }

    protected XmlTag getTag() {
        return this.myTag;
    }

    public boolean startsWithTextElement() {
        if (this.startsWithText()) {
            return true;
        }
        if (this.isStartOfTag() && this.myXmlFormattingPolicy.isTextElement(this.getTag())) {
            return true;
        }
        return this.isTextTag(this.myStartTreeNode);
    }

    private boolean isTextTag(ASTNode treeNode) {
        return this.isXmlTag(treeNode) && this.myXmlFormattingPolicy.isTextElement((XmlTag)SourceTreeToPsiMap.treeElementToPsi((ASTNode)treeNode));
    }

    private boolean isXmlTag(ASTNode treeNode) {
        return treeNode.getPsi() instanceof XmlTag;
    }

    private boolean isStartOfTag() {
        return AbstractSyntheticBlock.isTagDescription(this.myStartTreeNode);
    }

    protected static TextRange calculateTextRange(List<? extends Block> subBlocks) {
        return new TextRange(subBlocks.get(0).getTextRange().getStartOffset(), subBlocks.get(subBlocks.size() - 1).getTextRange().getEndOffset());
    }

    public boolean isIncomplete() {
        return ((Block)this.getSubBlocks().get(this.getSubBlocks().size() - 1)).isIncomplete();
    }

    public boolean startsWithTag() {
        return this.isXmlTag(this.myStartTreeNode);
    }

    public XmlTag getStartTag() {
        return (XmlTag)this.myStartTreeNode.getPsi();
    }

    public boolean endsWithTag() {
        return this.isXmlTag(this.myEndTreeNode);
    }

    public boolean isJspTextBlock() {
        return false;
    }

    public boolean isJspxTextBlock() {
        return false;
    }

    public boolean isOuterLanguageBlock() {
        return this.myStartTreeNode == this.myEndTreeNode && this.myStartTreeNode instanceof OuterLanguageElement;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean startsWithCDATA() {
        return this.isCDATA(this.myStartTreeNode.getFirstChildNode());
    }

    private boolean isCDATA(ASTNode node) {
        return node != null && node.getElementType() == XmlElementType.XML_CDATA;
    }

    public boolean containsCDATA() {
        return this.myStartTreeNode.getElementType() == XmlTokenType.XML_CDATA_START && this.myEndTreeNode.getElementType() == XmlTokenType.XML_CDATA_END;
    }

    public boolean endsWithCDATA() {
        return this.isCDATA(this.myStartTreeNode.getLastChildNode());
    }

    public boolean insertLineFeedAfter() {
        List subBlocks = this.getSubBlocks();
        Block lastBlock = (Block)subBlocks.get(subBlocks.size() - 1);
        if (lastBlock instanceof XmlTagBlock) {
            return this.insertLineFeedAfter(((XmlTagBlock)lastBlock).getTag());
        }
        if (this.endsWithText()) {
            return this.insertLineFeedAfter(this.myTag);
        }
        return false;
    }

    protected boolean insertLineFeedAfter(XmlTag tag) {
        return this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag) == WrapType.ALWAYS;
    }

    protected boolean isAttributeElementType(IElementType elementType) {
        return elementType instanceof IXmlAttributeElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "subBlocks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "policy";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/formatter/xml/AbstractSyntheticBlock";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

