/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeCheckoutListener
implements CheckoutProvider.Listener {
    private static final Logger LOG = Logger.getInstance(CompositeCheckoutListener.class);
    private final Project myProject;
    private boolean myFoundProject;
    private Path myFirstDirectory;

    public CompositeCheckoutListener(@NotNull Project project2) {
        if (project2 == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(0);
        }
        this.myFoundProject = false;
        this.myProject = project2;
    }

    @Override
    public void directoryCheckedOut(@NotNull File file, VcsKey vcs) {
        Project project2;
        if (file == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(1);
        }
        if (this.myFoundProject) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        Path directory = file.toPath();
        if (this.myFirstDirectory == null) {
            this.myFirstDirectory = directory;
        }
        for (Object listener2 : CheckoutListener.EP_NAME.getExtensionList()) {
            try {
                this.myFoundProject = listener2.processCheckedOutDirectory(this.myProject, directory);
                if (!this.myFoundProject) continue;
                LOG.debug(String.format("Cloned dir '%s' processed by %s", directory, listener2));
                break;
            }
            catch (ProcessCanceledException ignore) {
                LOG.info("Checkout listener " + (CheckoutListener)listener2 + " has been canceled");
            }
            catch (Exception e) {
                LOG.warn("Error in checkout listener: " + (CheckoutListener)listener2, (Throwable)e);
            }
        }
        for (Object listener2 : VcsAwareCheckoutListener.EP_NAME.getExtensionList()) {
            try {
                boolean processingCompleted = listener2.processCheckedOutDirectory(this.myProject, directory, vcs);
                if (!processingCompleted) continue;
                LOG.debug(String.format("Cloned dir '%s' processed by %s", directory, listener2));
                break;
            }
            catch (ProcessCanceledException ignore) {
                LOG.info("Checkout listener " + (VcsAwareCheckoutListener)listener2 + " has been canceled");
            }
            catch (Exception e) {
                LOG.warn("Error in checkout listener: " + (VcsAwareCheckoutListener)listener2, (Throwable)e);
            }
        }
        if ((project2 = CompositeCheckoutListener.findProjectByBaseDirLocation(directory)) != null) {
            VcsStatisticsCollector.CLONED_PROJECT_OPENED.log(project2);
        }
    }

    @Override
    public void checkoutCompleted() {
        Project project2;
        if (this.myFoundProject) {
            return;
        }
        Path directory = this.myFirstDirectory;
        if (directory == null) {
            return;
        }
        for (CheckoutListener listener2 : CheckoutListener.COMPLETED_EP_NAME.getExtensionList()) {
            try {
                boolean foundProject = listener2.processCheckedOutDirectory(this.myProject, directory);
                if (!foundProject) continue;
                LOG.debug(String.format("Cloned dir '%s' processed by %s", directory, listener2));
                break;
            }
            catch (ProcessCanceledException ignore) {
                LOG.info("Checkout listener " + listener2 + " has been canceled");
            }
            catch (Exception e) {
                LOG.warn("Error in checkout listener: " + listener2, (Throwable)e);
            }
        }
        if ((project2 = CompositeCheckoutListener.findProjectByBaseDirLocation(directory)) != null) {
            VcsStatisticsCollector.CLONED_PROJECT_OPENED.log(project2);
        }
    }

    @Nullable
    static Project findProjectByBaseDirLocation(@NotNull Path directory) {
        if (directory == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(2);
        }
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project2 -> {
            String baseDir2 = project2.getBasePath();
            return baseDir2 != null && FileUtil.pathsEqual((String)baseDir2, (String)directory.toString());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/checkout/CompositeCheckoutListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "directoryCheckedOut";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectByBaseDirLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

