/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchFactory;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathsVerifier {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<? extends FilePatch> myPatches;
    private final Map<VirtualFile, MovedFileData> myMovedFiles;
    private final List<FilePath> myBeforePaths;
    private final List<VirtualFile> myCreatedDirectories;
    private final List<PatchAndFile> myTextPatches;
    private final List<PatchAndFile> myBinaryPatches;
    @NotNull
    private final List<VirtualFile> myWritableFiles;
    private final ProjectLevelVcsManager myVcsManager;
    private final List<FilePatch> mySkipped;
    private DelayedPrecheckContext myDelayedPrecheckContext;
    private final List<FilePath> myAddedPaths;
    private final List<FilePath> myDeletedPaths;
    private boolean myIgnoreContentRootsCheck;

    public PathsVerifier(@NotNull Project project2, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches) {
        if (project2 == null) {
            PathsVerifier.$$$reportNull$$$0(0);
        }
        if (baseDirectory == null) {
            PathsVerifier.$$$reportNull$$$0(1);
        }
        if (patches == null) {
            PathsVerifier.$$$reportNull$$$0(2);
        }
        this.myMovedFiles = new HashMap<VirtualFile, MovedFileData>();
        this.myBeforePaths = new ArrayList<FilePath>();
        this.myCreatedDirectories = new ArrayList<VirtualFile>();
        this.myTextPatches = new ArrayList<PatchAndFile>();
        this.myBinaryPatches = new ArrayList<PatchAndFile>();
        this.myWritableFiles = new ArrayList<VirtualFile>();
        this.mySkipped = new ArrayList<FilePatch>();
        this.myAddedPaths = new ArrayList<FilePath>();
        this.myDeletedPaths = new ArrayList<FilePath>();
        this.myProject = project2;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myVcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
    }

    public List<FilePath> getDirectlyAffected() {
        ArrayList<FilePath> affected = new ArrayList<FilePath>();
        PathsVerifier.addAllFilePath(this.myCreatedDirectories, affected);
        PathsVerifier.addAllFilePath(this.myWritableFiles, affected);
        affected.addAll(this.myBeforePaths);
        return affected;
    }

    public List<VirtualFile> getAllAffected() {
        VirtualFile parent;
        ArrayList<VirtualFile> affected = new ArrayList<VirtualFile>();
        affected.addAll(this.myCreatedDirectories);
        affected.addAll(this.myWritableFiles);
        for (VirtualFile file : this.myMovedFiles.keySet()) {
            parent = file.getParent();
            if (parent == null) continue;
            affected.add(parent);
        }
        for (FilePath path2 : this.myBeforePaths) {
            VirtualFile parentFile;
            parent = path2.getParentPath();
            if (parent == null || (parentFile = parent.getVirtualFile()) == null) continue;
            affected.add(parentFile);
        }
        return affected;
    }

    private static void addAllFilePath(Collection<? extends VirtualFile> files2, Collection<? super FilePath> paths) {
        for (VirtualFile virtualFile : files2) {
            paths.add((FilePath)VcsUtil.getFilePath(virtualFile));
        }
    }

    List<FilePatch> nonWriteActionPreCheck() {
        ArrayList failedMessages = new ArrayList();
        ArrayList<FilePatch> failedToApply = new ArrayList<FilePatch>();
        this.myDelayedPrecheckContext = new DelayedPrecheckContext(this.myProject);
        for (FilePatch filePatch : this.myPatches) {
            CheckPath checker = this.getChecker(filePatch);
            if (checker.canBeApplied(this.myDelayedPrecheckContext)) continue;
            ContainerUtil.addIfNotNull(failedMessages, (Object)checker.getErrorMessage());
            failedToApply.add(filePatch);
        }
        if (!failedMessages.isEmpty()) {
            PatchApplier.showError(this.myProject, StringUtil.join(failedMessages, (String)"\n"));
        }
        Collection<? extends FilePatch> skipped = this.myDelayedPrecheckContext.doDelayed();
        this.mySkipped.addAll(skipped);
        this.myPatches.removeAll(skipped);
        this.myPatches.removeAll(failedToApply);
        return failedToApply;
    }

    List<FilePatch> getSkipped() {
        return this.mySkipped;
    }

    @NotNull
    List<FilePatch> execute() {
        ArrayList failedMessages = new ArrayList();
        ArrayList<FilePatch> failedPatches = new ArrayList<FilePatch>();
        for (FilePatch filePatch : this.myPatches) {
            CheckPath checker = this.getChecker(filePatch);
            if (checker.check()) continue;
            ContainerUtil.addIfNotNull(failedMessages, (Object)checker.getErrorMessage());
            failedPatches.add(checker.getPatch());
        }
        if (!failedMessages.isEmpty()) {
            PatchApplier.showError(this.myProject, StringUtil.join(failedMessages, (String)"\n"));
        }
        this.myPatches.removeAll(failedPatches);
        ArrayList<FilePatch> arrayList = failedPatches;
        if (arrayList == null) {
            PathsVerifier.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private CheckPath getChecker(@NotNull FilePatch patch) {
        if (patch == null) {
            PathsVerifier.$$$reportNull$$$0(4);
        }
        String beforeFileName = patch.getBeforeName();
        String afterFileName = patch.getAfterName();
        if (beforeFileName == null || patch.isNewFile()) {
            return new CheckAdded(patch);
        }
        if (afterFileName == null || patch.isDeletedFile()) {
            return new CheckDeleted(patch);
        }
        if (!beforeFileName.equals(afterFileName)) {
            return new CheckMoved(patch);
        }
        return new CheckModified(patch);
    }

    public Collection<FilePath> getToBeAdded() {
        return this.myAddedPaths;
    }

    public Collection<FilePath> getToBeDeleted() {
        return this.myDeletedPaths;
    }

    @NotNull
    public Collection<FilePatch> filterBadFileTypePatches() {
        List failedTextPatches = ContainerUtil.findAll(this.myTextPatches, textPatch -> !this.isFileTypeOk(textPatch.getFile()));
        this.myTextPatches.removeAll(failedTextPatches);
        List list = ContainerUtil.map((Collection)failedTextPatches, patchInfo -> patchInfo.getApplyPatch().getPatch());
        if (list == null) {
            PathsVerifier.$$$reportNull$$$0(5);
        }
        return list;
    }

    private boolean isFileTypeOk(@NotNull VirtualFile file) {
        if (file == null) {
            PathsVerifier.$$$reportNull$$$0(6);
        }
        if (file.isDirectory()) {
            PatchApplier.showError(this.myProject, VcsBundle.message("patch.apply.file.type.directory.error", file.getPresentableName()));
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == FileTypes.UNKNOWN) {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().associate((FileType)FileTypes.PLAIN_TEXT, (FileNameMatcher)new ExactFileNameMatcher(file.getName())));
                return true;
            }
            fileType = FileTypeChooser.associateFileType((String)file.getName());
            if (fileType == null) {
                PatchApplier.showError(this.myProject, VcsBundle.message("patch.apply.file.type.undefined.error", file.getPresentableName()));
                return false;
            }
        }
        if (fileType.isBinary()) {
            PatchApplier.showError(this.myProject, VcsBundle.message("patch.apply.file.type.binary.error", file.getPresentableName()));
            return false;
        }
        return true;
    }

    private void addPatch(@NotNull FilePatch patch, @NotNull VirtualFile file) {
        if (patch == null) {
            PathsVerifier.$$$reportNull$$$0(7);
        }
        if (file == null) {
            PathsVerifier.$$$reportNull$$$0(8);
        }
        if (patch instanceof TextFilePatch) {
            this.myTextPatches.add(new PatchAndFile(file, ApplyFilePatchFactory.create((TextFilePatch)patch)));
        } else {
            this.myBinaryPatches.add(new PatchAndFile(file, ApplyFilePatchFactory.createGeneral(patch)));
        }
        this.myWritableFiles.add(file);
    }

    private static String cantCreateFileMessage(String path2, IOException e) {
        return VcsBundle.message("cannot.create.directory.for.patch", path2, e.getMessage());
    }

    private static String fileNotFoundMessage(String path2) {
        return VcsBundle.message("cannot.find.file.to.patch", path2);
    }

    private static String fileAlreadyExists(String path2) {
        return VcsBundle.message("cannot.apply.file.already.exists", path2);
    }

    private static VirtualFile createFile(VirtualFile parent, String name) throws IOException {
        return parent.createChildData(PatchApplier.class, name);
    }

    private static VirtualFile moveFile(VirtualFile file, VirtualFile newParent) throws IOException {
        file.move(FilePatch.class, newParent);
        return file;
    }

    @Nullable
    private VirtualFile makeSureParentPathExists(@NotNull String[] pieces) throws IOException {
        if (pieces == null) {
            PathsVerifier.$$$reportNull$$$0(9);
        }
        VirtualFile child = this.myBaseDirectory;
        int size = pieces.length - 1;
        for (int i = 0; i < size; ++i) {
            String piece = pieces[i];
            if (StringUtil.isEmptyOrSpaces((String)piece)) continue;
            if ("..".equals(piece)) {
                child = child.getParent();
                continue;
            }
            VirtualFile nextChild = child.findChild(piece);
            if (nextChild == null) {
                nextChild = VfsUtil.createDirectories((String)(child.getPath() + "/" + piece));
                if (nextChild == null) {
                    throw new IOException("Can't create directory: " + piece);
                }
                this.myCreatedDirectories.add(nextChild);
            }
            child = nextChild;
        }
        return child;
    }

    @NotNull
    public List<PatchAndFile> getTextPatches() {
        List<PatchAndFile> list = this.myTextPatches;
        if (list == null) {
            PathsVerifier.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<PatchAndFile> getBinaryPatches() {
        List<PatchAndFile> list = this.myBinaryPatches;
        if (list == null) {
            PathsVerifier.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getWritableFiles() {
        List<VirtualFile> list = this.myWritableFiles;
        if (list == null) {
            PathsVerifier.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void doMoveIfNeeded(VirtualFile file) throws IOException {
        MovedFileData movedFile = this.myMovedFiles.get(file);
        if (movedFile != null) {
            this.myBeforePaths.add(VcsUtil.getFilePath(file));
            ApplicationManager.getApplication().runWriteAction(() -> movedFile.doMove());
        }
    }

    public void setIgnoreContentRootsCheck(boolean ignoreContentRootsCheck) {
        this.myIgnoreContentRootsCheck = ignoreContentRootsCheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pieces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBadFileTypePatches";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPatches";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryPatches";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChecker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileTypeOk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeSureParentPathExists";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }

    private static final class DelayedPrecheckContext {
        private final Map<FilePath, FilePatch> mySkipDeleted;
        private final Map<FilePath, FilePatch> myOverrideExisting;
        private final List<FilePath> myOverridenPaths;
        private final Project myProject;

        private DelayedPrecheckContext(Project project2) {
            this.myProject = project2;
            this.myOverrideExisting = new HashMap<FilePath, FilePatch>();
            this.mySkipDeleted = new HashMap<FilePath, FilePatch>();
            this.myOverridenPaths = new ArrayList<FilePath>();
        }

        public void addSkip(FilePath path2, FilePatch filePatch) {
            this.mySkipDeleted.put(path2, filePatch);
        }

        public void addOverrideExisting(FilePatch patch, FilePath filePath) {
            if (!this.myOverrideExisting.containsKey(filePath)) {
                this.myOverrideExisting.put(filePath, patch);
            }
        }

        @NotNull
        public Collection<? extends FilePatch> doDelayed() {
            ArrayList<FilePatch> result2 = new ArrayList<FilePatch>();
            if (!this.myOverrideExisting.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title2 = VcsBundle.message("patch.apply.overwrite.existing.title", new Object[0]);
                    ArrayList<FilePath> files2 = new ArrayList<FilePath>(this.myOverrideExisting.keySet());
                    Collection<FilePath> selected = AbstractVcsHelper.getInstance(this.myProject).selectFilePathsToProcess(files2, title2, VcsBundle.message("patch.apply.overwrite.existing.files.prompt", new Object[0]), title2, VcsBundle.message("patch.apply.overwrite.existing.file.prompt", new Object[0]), VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION, CommonBundle.message((String)"button.overwrite", (Object[])new Object[0]), IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
                    if (selected != null) {
                        for (FilePath path2 : selected) {
                            this.myOverrideExisting.remove(path2);
                        }
                    }
                    result2.addAll(this.myOverrideExisting.values());
                    if (selected != null) {
                        this.myOverridenPaths.addAll(selected);
                    }
                });
            }
            result2.addAll(this.mySkipDeleted.values());
            ArrayList<FilePatch> arrayList = result2;
            if (arrayList == null) {
                DelayedPrecheckContext.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public List<FilePath> getOverridenPaths() {
            return this.myOverridenPaths;
        }

        public Collection<FilePath> getAlreadyDeletedPaths() {
            return this.mySkipDeleted.keySet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$DelayedPrecheckContext", "doDelayed"));
        }
    }

    private abstract class CheckPath {
        protected final String myBeforeName;
        protected final String myAfterName;
        protected final FilePatch myPatch;
        private String myErrorMessage;

        CheckPath(FilePatch path2) {
            if (path2 == null) {
                CheckPath.$$$reportNull$$$0(0);
            }
            this.myPatch = path2;
            this.myBeforeName = path2.getBeforeName();
            this.myAfterName = path2.getAfterName();
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean canBeApplied(DelayedPrecheckContext context) {
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            VirtualFile afterFile = this.getMappedFile(this.myAfterName);
            return this.precheck(beforeFile, afterFile, context);
        }

        protected abstract boolean precheck(VirtualFile var1, VirtualFile var2, DelayedPrecheckContext var3);

        protected abstract boolean check();

        @Contract(value="null, _ -> false")
        protected boolean checkExistsAndValid(@Nullable VirtualFile file, String name) {
            if (file == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(name));
                return false;
            }
            return this.checkModificationValid(file, name);
        }

        protected boolean checkModificationValid(@NotNull VirtualFile file, String name) {
            if (file == null) {
                CheckPath.$$$reportNull$$$0(1);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && PathsVerifier.this.myIgnoreContentRootsCheck) {
                return true;
            }
            if (!this.inContent(file) && PathsVerifier.this.myVcsManager.getVcsRootFor(file) == null) {
                this.setErrorMessage(VcsBundle.message("patch.apply.outside.content.root.message", name));
                return false;
            }
            return true;
        }

        @Nullable
        protected VirtualFile getMappedFile(String path2) {
            return PathMerger.getFile(PathsVerifier.this.myBaseDirectory, path2);
        }

        protected FilePath getMappedFilePath(String path2) {
            return PathMerger.getFile(VcsUtil.getFilePath(PathsVerifier.this.myBaseDirectory), path2);
        }

        private boolean inContent(VirtualFile file) {
            return PathsVerifier.this.myVcsManager.isFileInContent(file);
        }

        public FilePatch getPatch() {
            return this.myPatch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$CheckPath";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkModificationValid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CheckAdded
    extends CheckPath {
        private CheckAdded(FilePatch path2) {
            if (path2 == null) {
                CheckAdded.$$$reportNull$$$0(0);
            }
            super(path2);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (afterFile != null) {
                context.addOverrideExisting(this.myPatch, VcsUtil.getFilePath(afterFile));
            }
            return true;
        }

        @Override
        public boolean check() {
            VirtualFile file;
            VirtualFile parent;
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            try {
                parent = PathsVerifier.this.makeSureParentPathExists(pieces);
            }
            catch (IOException e) {
                this.setErrorMessage(PathsVerifier.cantCreateFileMessage(this.myAfterName, e));
                return false;
            }
            if (parent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            String name = pieces[pieces.length - 1];
            File afterFile = new File(parent.getPath(), name);
            try {
                file = PathsVerifier.this.myDelayedPrecheckContext.getOverridenPaths().contains(VcsUtil.getFilePath(afterFile)) ? parent.findChild(name) : PathsVerifier.createFile(parent, name);
            }
            catch (IOException e) {
                this.setErrorMessage(PathsVerifier.cantCreateFileMessage(this.myAfterName, e));
                return false;
            }
            if (file == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            PathsVerifier.this.myAddedPaths.add(VcsUtil.getFilePath(file));
            if (!this.checkExistsAndValid(file, this.myAfterName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, file);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$CheckAdded", "<init>"));
        }
    }

    private class CheckDeleted
    extends CheckPath {
        protected CheckDeleted(FilePatch path2) {
            super(path2);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                context.addSkip(this.getMappedFilePath(this.myBeforeName), this.myPatch);
            }
            return true;
        }

        @Override
        protected boolean check() {
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            FilePath filePath = VcsUtil.getFilePath(beforeFile.getParent(), beforeFile.getName(), beforeFile.isDirectory());
            if (this.myPatch.isDeletedFile() || this.myPatch.getAfterName() == null) {
                PathsVerifier.this.myDeletedPaths.add(filePath);
            }
            PathsVerifier.this.myBeforePaths.add(filePath);
            return true;
        }
    }

    private final class CheckMoved
    extends CheckPath {
        private CheckMoved(FilePatch path2) {
            super(path2);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myBeforeName));
            } else if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.fileAlreadyExists(afterFile.getPath()));
            }
            return beforeFile != null && afterFile == null;
        }

        @Override
        public boolean check() {
            VirtualFile afterFileParent;
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            try {
                afterFileParent = PathsVerifier.this.makeSureParentPathExists(pieces);
            }
            catch (IOException e) {
                this.setErrorMessage(PathsVerifier.cantCreateFileMessage(this.myAfterName, e));
                return false;
            }
            if (afterFileParent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.myMovedFiles.put(beforeFile, new MovedFileData(afterFileParent, beforeFile, this.myPatch.getAfterFileName()));
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            return true;
        }
    }

    private final class CheckModified
    extends CheckDeleted {
        private CheckModified(FilePatch path2) {
            super(path2);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myBeforeName));
            }
            return beforeFile != null;
        }
    }

    public static final class PatchAndFile {
        private final VirtualFile myFile;
        private final ApplyFilePatchBase<?> myPatch;

        public PatchAndFile(VirtualFile file, ApplyFilePatchBase<?> patch) {
            this.myFile = file;
            this.myPatch = patch;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public ApplyFilePatchBase<?> getApplyPatch() {
            return this.myPatch;
        }
    }

    private static final class MovedFileData {
        private final VirtualFile myNewParent;
        private final VirtualFile myCurrent;
        private final String myNewName;

        private MovedFileData(@NotNull VirtualFile newParent, @NotNull VirtualFile current, @NotNull String newName) {
            if (newParent == null) {
                MovedFileData.$$$reportNull$$$0(0);
            }
            if (current == null) {
                MovedFileData.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                MovedFileData.$$$reportNull$$$0(2);
            }
            this.myNewParent = newParent;
            this.myCurrent = current;
            this.myNewName = newName;
        }

        public VirtualFile getCurrent() {
            return this.myCurrent;
        }

        public VirtualFile getNewParent() {
            return this.myNewParent;
        }

        public String getNewName() {
            return this.myNewName;
        }

        public VirtualFile doMove() throws IOException {
            boolean needMove;
            VirtualFile oldParent = this.myCurrent.getParent();
            boolean needRename = !Objects.equals(this.myCurrent.getName(), this.myNewName);
            boolean bl = needMove = !this.myNewParent.equals(oldParent);
            if (needRename) {
                File oldParentFile;
                File targetAfterRenameFile;
                if (needMove && (targetAfterRenameFile = new File(oldParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)oldParent), this.myNewName)).exists() && this.myCurrent.exists()) {
                    this.performRenameWithConflicts(oldParentFile);
                    return this.myCurrent;
                }
                this.myCurrent.rename(PatchApplier.class, this.myNewName);
            }
            if (needMove) {
                this.myCurrent.move(PatchApplier.class, this.myNewParent);
            }
            return this.myCurrent;
        }

        private void performRenameWithConflicts(@NotNull File oldParent) throws IOException {
            if (oldParent == null) {
                MovedFileData.$$$reportNull$$$0(3);
            }
            File tmpFileWithUniqueName = FileUtil.createTempFile((File)oldParent, (String)"tempFileToMove", null, (boolean)false);
            File newParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewParent);
            File destFile = new File(newParentFile, tmpFileWithUniqueName.getName());
            while (destFile.exists()) {
                destFile = new File(newParentFile, FileUtil.createTempFile((File)oldParent, (String)FileUtilRt.getNameWithoutExtension((String)destFile.getName()), null, (boolean)false).getName());
            }
            this.myCurrent.rename(PatchApplier.class, destFile.getName());
            this.myCurrent.move(PatchApplier.class, this.myNewParent);
            this.myCurrent.rename(PatchApplier.class, this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performRenameWithConflicts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

