/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class JsonTypedHandler
extends TypedHandlerDelegate {
    private boolean myWhitespaceAdded;

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JsonTypedHandler.$$$reportNull$$$0(2);
        }
        if (file instanceof JsonFile) {
            JsonTypedHandler.processPairedBracesComma(c, editor, file);
            this.addWhiteSpaceAfterColonIfNeeded(c, editor, file);
            this.removeRedundantWhitespaceIfAfterColon(c, editor, file);
            JsonTypedHandler.handleMoveOutsideQuotes(c, editor, file);
        }
        TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
        if (result2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(3);
        }
        return result2;
    }

    private static void handleMoveOutsideQuotes(char c, Editor editor, PsiFile file) {
        JsonEditorOptions options = JsonEditorOptions.getInstance();
        if (c == ':' && options.COLON_MOVE_OUTSIDE_QUOTES || c == ',' && options.COMMA_MOVE_OUTSIDE_QUOTES) {
            CharSequence sequence;
            int length;
            int offset = editor.getCaretModel().getOffset();
            if (offset >= (length = (sequence = editor.getDocument().getCharsSequence()).length()) || offset < 0) {
                return;
            }
            char charAtOffset = sequence.charAt(offset);
            if (charAtOffset != '\"') {
                return;
            }
            if (offset + 1 < length && sequence.charAt(offset + 1) == c) {
                return;
            }
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                return;
            }
            if (!JsonTypedHandler.validatePositionToMoveOutOfQuotes(c, element)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            editor.getDocument().deleteString(offset - 1, offset);
            editor.getDocument().insertString(offset, (CharSequence)String.valueOf(c));
            CharSequence newSequence = editor.getDocument().getCharsSequence();
            int nextOffset = offset + 1;
            if (c == ':' && options.AUTO_WHITESPACE_AFTER_COLON) {
                char nextChar;
                char c2 = nextChar = nextOffset >= newSequence.length() ? (char)'a' : (char)newSequence.charAt(nextOffset);
                if (!Character.isWhitespace(nextChar) || nextChar == '\n') {
                    editor.getDocument().insertString(nextOffset, (CharSequence)" ");
                    ++nextOffset;
                }
            }
            editor.getCaretModel().moveToOffset(nextOffset);
        }
    }

    private static boolean validatePositionToMoveOutOfQuotes(char c, PsiElement element) {
        if (PsiUtilCore.getElementType((PsiElement)element) == JsonElementTypes.R_CURLY) {
            return c == ',' && element.getPrevSibling() instanceof JsonProperty;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == JsonElementTypes.R_BRACKET) {
            return c == ',' && element.getPrevSibling() instanceof JsonStringLiteral;
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiWhiteSpace && c == ',') {
            PsiElement sibling = element.getPrevSibling();
            return sibling instanceof JsonProperty || sibling instanceof JsonStringLiteral;
        }
        PsiElement grandParent = parent instanceof JsonStringLiteral ? parent.getParent() : null;
        return !(!(grandParent instanceof JsonProperty) || c == ':' && ((JsonProperty)grandParent).getNameElement() != parent || c == ',' && ((JsonProperty)grandParent).getValue() != parent);
    }

    private void removeRedundantWhitespaceIfAfterColon(char c, Editor editor, PsiFile file) {
        if (!this.myWhitespaceAdded || c != ' ' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ':') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            editor.getDocument().deleteString(offset - 1, offset);
        }
        this.myWhitespaceAdded = false;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JsonTypedHandler.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            JsonTypedHandler.$$$reportNull$$$0(7);
        }
        if (file instanceof JsonFile) {
            JsonTypedHandler.addPropertyNameQuotesIfNeeded(c, editor, file);
        }
        TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
        if (result2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(8);
        }
        return result2;
    }

    private void addWhiteSpaceAfterColonIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JsonTypedHandler.$$$reportNull$$$0(10);
        }
        if (c != ':' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ' ') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.skipWhitespacesBackward((PsiElement)file.findElementAt(offset)), JsonProperty.class, (boolean)false);
        if (element == null) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode[] children = element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.COLON}));
        if (children.length == 0) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode colon = children[0];
        ASTNode next = colon.getTreeNext();
        String text2 = next.getText();
        if (text2.length() == 0 || !StringUtil.isEmptyOrSpaces((String)text2) || StringUtil.isLineBreak((char)text2.charAt(0))) {
            int insOffset = colon.getStartOffset() + 1;
            editor.getDocument().insertString(insOffset, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(insOffset + 1);
            this.myWhitespaceAdded = true;
        } else {
            this.myWhitespaceAdded = false;
        }
    }

    private static void addPropertyNameQuotesIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JsonTypedHandler.$$$reportNull$$$0(12);
        }
        if (c != ':' || !JsonDialectUtil.isStandardJson((PsiElement)file) || !JsonEditorOptions.getInstance().AUTO_QUOTE_PROP_NAME) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file.findElementAt(offset));
        if (!(element instanceof JsonProperty)) {
            return;
        }
        JsonValue nameElement = ((JsonProperty)element).getNameElement();
        if (nameElement instanceof JsonReferenceExpression) {
            ((JsonProperty)element).setName(nameElement.getText());
            PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    public static void processPairedBracesComma(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            JsonTypedHandler.$$$reportNull$$$0(14);
        }
        if (!JsonEditorOptions.getInstance().COMMA_ON_MATCHING_BRACES) {
            return;
        }
        if (c != '[' && c != '{' && c != '\"' && c != '\'') {
            return;
        }
        SmartEnterProcessor.commitDocument((Editor)editor);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (((c == '[' && parent instanceof JsonArray || c == '{' && parent instanceof JsonObject) && codeInsightSettings.AUTOINSERT_PAIR_BRACKET || (c == '\"' || c == '\'') && parent instanceof JsonStringLiteral && codeInsightSettings.AUTOINSERT_PAIR_QUOTE) && JsonTypedHandler.shouldAddCommaInParentContainer((JsonValue)parent)) {
            editor.getDocument().insertString(parent.getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static boolean shouldAddCommaInParentContainer(@NotNull JsonValue item2) {
        PsiElement nextElement;
        PsiElement parent;
        if (item2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(15);
        }
        if (((parent = item2.getParent()) instanceof JsonArray || parent instanceof JsonProperty) && (nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)(parent instanceof JsonProperty ? parent : item2))) instanceof PsiErrorElement) {
            PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextElement);
            return parent instanceof JsonProperty ? forward instanceof JsonProperty : forward instanceof JsonValue;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonTypedHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addWhiteSpaceAfterColonIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyNameQuotesIfNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processPairedBracesComma";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddCommaInParentContainer";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 8 -> new IllegalStateException(string2);
        };
    }
}

